<?php

/**
 * 后台标签管理
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-23
 * @updateTime 2013-4-23
 */
class TagManageAction extends AdminBaseAction {

    protected $tagModel;

    function _initialize() {
        parent::_initialize();
        $this->tagModel = D('Tag');
    }

    /**
     * 显示标签列表
     */
    public function index() {
        $count = $this->tagModel->count();
        $page = page($count);
        $data = $this->tagModel->order('tag_id DESC')->limit($page->firstRow . ',' . $page->listRows)->select();
        $this->assign('tagList', $data);
        $this->assign('page', $page->show());
        $this->display();
    }

    /**
     * 编辑标签信息
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();
            $data = $this->tagModel->field('tag_id,tag,style,hit_count')->create($post);
            if ($data) {
                if (FALSE !== $this->tagModel->save($data)) {
                    $this->bpiAjaxReturn(true, '保存成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '保存失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                $this->bpiAjaxReturn(false, $this->tagModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            // 显示编辑表单
            $tagId = intval($this->_get('tag_id'));
            if ($tagId) {
                $tag = $this->tagModel->where(array('tag_id' => $tagId))->find();
                if (is_array($tag)) {
                    $this->assign('tag', $tag);
                    $this->display();
                    return;
                }
            }

            $this->error('内部错误');
        }
    }

    /**
     * 删除标签
     */
    public function delete() {
        $tagIds = $this->_param('tag_id');
        if (!is_array($tagIds)) {
            $tagIds = array($tagIds);
        }

        if ($this->tagModel->where(array('tag_id' => array('in', $tagIds)))->delete()) {
            $this->bpiAjaxReturn(true, '删除标签成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $this->bpiAjaxReturn(false, '删除标签失败', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 标签排序
     */
    public function sort() {
        parent::saveSort($this->tagModel, $this->_post('sort'), 'sort', true);
    }

}

?>