<?php

/**
 * 推送通知基类
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-14
 * @updateTime 2013-8-14
 */
class Push {

    const MODULE_VAR_NAME = 'Task'; //模块名称

    public function __construct() {
        
    }

    /**
     * 推送信息到苹果设备 
     * @param string $deviceToken  设备标识码 
     * @param string $message 	推送的信息
     * @param string $pemFile	相应证书	
     * @param bool   $isSandBox	 是否沙盒环境	
     * @param int    $badge	条目	
     * @param bool      $sound	是否有声音
     * @return void
     */
    public function push2Apple($deviceToken, $message, $badge = null, $sound = null) {
        // Construct the notification payload
        $pass = '123456';
        $isSandBox = BaseAction::getVar('config/app_is_sandbox');
        if ($isSandBox) {
            $pemFile = APP_PATH . '/Module/' . self::MODULE_VAR_NAME . '/ORG/Push/pem/ios/sandbox/apn.pem';
        } else {
            $pemFile = APP_PATH . '/Module/' . self::MODULE_VAR_NAME . '/ORG/Push/pem/ios/release/apn.pem';
        }
        $body = array();
        $body['aps'] = array('alert' => $message);
        if ($badge)
            $body['aps']['badge'] = intval($badge);
        if ($sound)
            $body['aps']['sound'] = $sound;
        /* End of Configurable Items */
        $ctx = stream_context_create();
        stream_context_set_option($ctx, 'ssl', 'local_cert', $pemFile);
        // assume the private key passphase was removed.
        stream_context_set_option($ctx, 'ssl', 'passphrase', $pass);
        // connect to apns
        if ($isSandBox) {
            $fp = stream_socket_client('ssl://gateway.sandbox.push.apple.com:2195', $err, $errstr, 60, STREAM_CLIENT_CONNECT, $ctx);
        } else {
            $fp = stream_socket_client('ssl://gateway.push.apple.com:2195', $err, $errstr, 60, STREAM_CLIENT_CONNECT, $ctx);
        }
        if (!$fp) {
//            echo("Failed to connect $err $errstr\n");
            return FALSE;
        }

        // send message
        $payload = json_encode($body);
        $msg = chr(0) . pack("n", 32) . pack('H*', str_replace(' ', '', $deviceToken)) . pack("n", strlen($payload)) . $payload;
        fwrite($fp, $msg);
        fclose($fp);
        return true;
    }

    /**
     * 推送消息到安卓设备(极光推送)
     * @param type $message
     * @return boolean
     */
    public function push2JPush($message) {
        $sendno = time();
        $receiverType = 4;
        $masterSecret = BaseAction::getVar('config/app_andriod_jpush_master_sercet');
        $receiverValue = '';
        $msgContent = json_encode(array('n_content' => $message));
        $appKey = BaseAction::getVar('config/app_andriod_jpush_app_key');
        $platForm = 'android';
        $msgType = 1;
        $verificationCode = md5($sendno . $receiverType . $receiverValue . $masterSecret);
        $postFields = array(
            'sendno' => $sendno,
            'app_key' => $appKey,
            'receiver_type' => $receiverType,
            'receiver_value' => $receiverValue,
            'verification_code' => $verificationCode,
            'msg_type' => $msgType,
            'msg_content' => $msgContent,
            'platform' => $platForm,
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.jpush.cn:443/sendmsg/v2/sendmsg');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postFields));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

        $result = curl_exec($ch);
        curl_close($ch);
        if (empty($result)) {
            return false;
        }
        $resultArray = json_decode($result, 1);
        if (empty($resultArray) || !empty($resultArray['errcode'])) {
            return false;
        }
        return true;
    }

    /**
     * 推送消息到百度设备
     * @param type $message
     * @return boolean
     */
    public function push2BaiduPush($title, $message) {
        $url = 'http://channel.api.duapp.com/rest/2.0/channel/channel';
        $apiKey = trim(BaseAction::getVar('config/app_andriod_baidupush_api_key'));
        $secretKey = trim(BaseAction::getVar('config/app_andriod_baidupush_sercet_key'));
        
        if (empty($apiKey) || empty($secretKey)) {
            return FALSE;
        }

        $postFields = array(
            'method' => 'push_msg',
            'apikey' => $apiKey,
            'push_type' => '3',
            'device_type' => '3',
            'message_type' => '1',
            'msg_keys' => time(),
            'timestamp' => time(),
            'messages' => json_encode(array(
                'title' => $title,
                'description' => $message
            )),
        );
        ksort($postFields);
        $signString = 'POST' . $url;
        foreach ($postFields as $key => $value) {
            $signString .= $key . '=' . $value;
        }
        $signString .= $secretKey;
        $sign = md5(urlencode($signString));
        $postFields['sign'] = $sign;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postFields));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

        $result = curl_exec($ch);
        curl_close($ch);
        if (empty($result)) {
            return false;
        }
        $resultArray = json_decode($result, 1);
        if (empty($resultArray) || !empty($resultArray['error_code'])) {
            return false;
        }
        return true;
    }

}

?>
