<?php

/**
 * 推送service
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2012-10-29
 * @updateTime 2012-10-29
 */
class PushService extends BaseService {

    protected $appModel;

    const MODULE_VAR_NAME = 'Task'; //模块名称

    public function __construct() {
        parent::__construct();
        $this->appModel = D('App');
    }

    /**
     * 推送信息(目前只支持苹果设备)
     * @param string $deviceToken  设备标识码 
     * @param string $message 	推送的信息
     * @param string $pemFile	相应证书	
     * @param bool   $isSandBox	 是否沙盒环境	
     * @param int    $badge	条目	
     * @param bool      $sound	是否有声音
     * @return void
     */
    public function push2Apple($deviceToken, $message, $badge = null, $sound = null) {
        $memcacheqStatus = BaseAction::getVar('config/memcacheq_status');
        if ($memcacheqStatus) {
            $memcacheqHost = BaseAction::getVar('config/memcacheq_host');
            $memcacheqPort = BaseAction::getVar('config/memcacheq_port');
        }
        if ($memcacheqStatus) {
            import('Memcacheq');
            $memcacheq = new Memcacheq($memcacheqHost, $memcacheqPort);
            $postData = array(
                'device_token' => $deviceToken,
                'message' => $message,
                'badge' => $badge,
                'sound' => $sound,
            );
            $url = SITE_URL . 'api/task.php?type=Push&action=push2apple';
            $result = $memcacheq->setUrl($url)->setPost($postData)->addQueue('_task_queue');
            if (!$result) {
                $this->setError('通知推送队列服务器失败');
            }
            return $result;
        } else {
            return $this->push2AppleNow($deviceToken, $message, $badge, $sound);
        }
    }

    /**
     * 实时推送
     * @param type $deviceToken
     * @param type $message
     * @param type $badge
     * @param type $sound
     * @return boolean
     */
    public function push2AppleNow($deviceToken, $message, $badge = null, $sound = null) {
        import('Push', APP_PATH . '/Module/' . self::MODULE_VAR_NAME . DS . 'ORG' . DS . 'Push' . DS);
        $pushClass = new Push();
        $status = $pushClass->push2Apple($deviceToken, $message, $badge, $sound);
        if (!$status) {
            $this->setError('苹果设备推送失败');
            return false;
        }
        return true;
    }

    /**
     * 实时推送到安卓
     * @param type $message
     * @return boolean 
     */
    public function push2AndroidNow($title, $message) {
        import('Push', APP_PATH . '/Module/' . self::MODULE_VAR_NAME . DS . 'ORG' . DS . 'Push' . DS);
        $pushClass = new Push();
        $status = $pushClass->push2BaiduPush($title, $message);
        if (!$status) {
            $this->setError('安卓设备推送失败');
            return false;
        }
        return true;
    }

}

?>
