<?php

/**
 * 模板风格管理Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-24
 * @updateTime 2013-4-24
 */
class StyleAction extends AdminBaseAction {

    function _initialize() {
        parent::_initialize();
    }

    /**
     * 显示文件目录
     */
    public function index() {
        // 过滤路径参数
        $dir = $this->_dirFilter($this->_get('dir'));
        $path = TEMPLATE_PATH . $dir;

        // 遍历目录
        $fileList = array();
        foreach (glob($path . DS . '*') as $filePath) {
            $pathInfo = pathinfo($filePath);
            if (is_dir($filePath)) {
                $type = 'dir';
            } else if ('html' === $pathInfo['extension']) {
                $type = 'html';
            } else {
                $type = 'default';
            }

            $file = array(
                'type' => $type,
                'name' => $pathInfo['basename'],
                'path' => $dir . DS . $pathInfo['basename'],
            );

            $fileList[] = $file;
        }

        $this->assign('dir', $dir);
        $this->assign('fileList', $fileList);
        $this->assign('templatePath', str_replace(SITE_PATH, '', TEMPLATE_PATH) . $dir);
        $this->display();
    }

    /**
     * 编辑文件
     */
    public function edit() {
        $isEdit = 'edit' === ACTION_NAME;
        $dir = $this->_dirFilter($this->_get('dir'));
        $filePath = TEMPLATE_PATH . $dir;

        // 新增时判断目录是否存在
        if (!$isEdit && !is_dir($filePath)) {
            $this->error('该目录不存在');
        }

        if (IS_POST) {
            // 判断文件是否存在
            if (!$isEdit) {
                $filePath .= DS . $this->_post('file_name') . '.html';
                if (is_file($filePath)) {
                    $this->bpiAjaxReturn(false, '文件已存在');
                }
            }

            // 判断后缀
            $pathInfo = pathinfo($filePath);
            if ('html' !== $pathInfo['extension']) {
                $this->bpiAjaxReturn(false, '只能操作html后缀的文件', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }

            $content = $this->_post('content', 'bpiHtmlspecialcharsDecode');
            if (FALSE !== file_put_contents($filePath, $content)) {
                $this->bpiAjaxReturn(true, '保存文件成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $this->bpiAjaxReturn(false, '保存文件失败，请检查模板文件权限是否设置为可写', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            if ($isEdit) {
                $content = file_get_contents($filePath);
                $this->assign('content', bpiHtmlspecialchars($content));
            }

            $this->assign('dir', $dir);
            $this->display('edit');
        }
    }

    /**
     * 新增文件
     */
    public function add() {
        // 调用edit方法
        $this->edit();
    }

    /**
     * 删除文件
     */
    public function delete() {
        $dir = $this->_dirFilter($this->_get('dir'));
        $filePath = TEMPLATE_PATH . $dir;

        if (!is_file($filePath)) {
            $this->bpiAjaxReturn(false, '文件不存在', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        if (@unlink($filePath)) {
            $this->bpiAjaxReturn(true, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $this->bpiAjaxReturn(false, '删除失败', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 安全过滤路径函数，保证路径不会列出上一层目录
     * @param type $dir 需要过滤的路径
     * @return type     返回已过滤的路径
     */
    private function _dirFilter($dir) {
        // 真实替换\/.，因为正则的转码需要替换为\\\/\.，又因为PHP原生的转码，需要替换为\\\\\/\\.
        $dir = preg_replace('/[\\\\\/\\.]{2,}/i', DS, $dir);
        return trim($dir, DS . '.');
    }

}

?>
