<?php

/**
 * 主题管理Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-16
 * @updateTime 2013-5-16
 */
class ThemeAction extends AdminBaseAction {

    public function _initialize() {
        parent::_initialize();
    }

    /**
     * 显示主题列表
     */
    public function index() {
        //模板数量
        $count = 0;
        //模板路径
        $themePath = glob(TEMPLATE_PATH . '*');
        //主题
        $themeList = array();
        foreach ($themePath as $key => $theme) {
            //判断该文件是不是目录
            if (!is_dir($theme)) {
                continue;
            }
            //模板名
            $themeList[$key]['name'] = basename($theme);
            if (is_file(TEMPLATE_PATH . $themeList[$key]['name'] . DS . 'preview.jpg')) {
                $themeList[$key]['preview'] = SITE_URL . str_replace(SITE_PATH . DS, '', TEMPLATE_PATH) . $themeList[$key]['name'] . '/preview.jpg';
            } else {
                $themeList[$key]['preview'] = SITE_STATIC_URL . 'Admin/Image/theme_nopic.jpg';
            }
            if (BaseAction::getVar('config/theme') == $themeList[$key]['name']) {
                $themeList[$key]['use'] = 1;
            }
            $count++;
        }
        $this->assign('themeList', $themeList);
        $this->assign('count', $count);
        $this->display();
    }

    /**
     * 更改主题 
     */
    public function changeTheme() {
        $theme = $this->_get('theme');
        //直接删除非法字符
        $filter = array('.', '\\', '/');
        foreach ($filter as $val) {
            $theme = str_replace($val, '', $theme);
        }

        if (empty($theme)) {
            $this->bpiAjaxReturn(false, '主题名称不能为空', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }

        if ($theme == BaseAction::getVar('config/theme')) {
            $this->bpiAjaxReturn(false, '当前主题即为此主题', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }

        if (!is_dir(TEMPLATE_PATH . $theme)) {
            $this->bpiAjaxReturn(false, '选择主题错误', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }

        $status = D('Config')->setConfig('theme', $theme);
        if ($status !== false) {
            $this->bpiAjaxReturn(true, '更新主题成功，请及时更新缓存', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
        } else {
            $this->bpiAjaxReturn(false, '更新主题失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }
    }

}

?>
