<?php

/**
 * Ucenter管理
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-7-6
 */
class UcenterManageAction extends AdminBaseAction {

    protected $setting;

    function _initialize() {
        parent::_initialize();
        $moduleCache = FData('Module');
        $module = $moduleCache[GROUP_NAME];
        if (empty($module)) {
            $this->error('内部错误');
        }

        $this->setting = unserialize($module['setting']);
        !defined('UC_API') && define('UC_API', '');
        require_cache(SITE_PATH . DS . 'api' . DS . 'uc_client' . DS . 'client.php');
    }

    /**
     * 显示uc安装/编辑页面
     */
    public function index() {
        if (!$this->setting['uc_appid']) {
            $this->redirect('install');
        } else {
            $this->redirect('edit');
        }
    }

    /**
     * 安装 
     */
    public function install() {
        if ($this->setting['uc_appid']) {
            $this->redirect('edit');
        }

        if (IS_POST) {
            $post = $this->_post();

            if (!isset($post['authkey']) || empty($post['authkey'])) {
                $this->bpiAjaxReturn(false, '请填写uc创始人密码!');
            }

            $post['uc_api'] = preg_replace("/\/$/", '', trim($post['uc_api']));

            if (empty($post['uc_api']) || !preg_match("/^(http:\/\/)/i", $post['uc_api'])) {
                $this->bpiAjaxReturn(false, '请填正确的服务端地址以http://开头!');
            } else {
                if (!$post['uc_ip']) {
                    $post['uc_ip'] = gethostbyname(@parse_url($post['uc_api'], PHP_URL_HOST));
                    if (!ip2long($post['uc_ip'])) {
                        $post['uc_ip'] = '127.0.0.1';
                    }
                }
            }

            $data = uc_fopen($post['uc_api'] . '/index.php?m=app&a=ucinfo', 500, '', '', 1, $post['uc_ip']);
            list($status, $ucVersion, $ucRelease, $ucCharset, $ucDbCharset, $appType) = explode('|', $data);

            if ($status !== 'UC_STATUS_OK') {
                $this->bpiAjaxReturn(false, 'uc服务端地址无效,请仔细检查您安装的uc服务端地址!');
            } else {
                if (version_compare(UC_CLIENT_VERSION, $ucVersion) !== 0) {
                    $this->bpiAjaxReturn(false, 'uc服务端版本不一致,您当前的uc客服端版本为:' . UC_CLIENT_VERSION . ',而服务端版本为:' . $ucVersion . '!');
                }

                if (version_compare(UC_CLIENT_RELEASE, $ucRelease) !== 0) {
                    $this->bpiAjaxReturn(false, 'uc服务端版本不一致,您当前的uc客服端版本为:' . UC_CLIENT_RELEASE . ',而服务端版本为:' . $ucRelease . '!');
                }

                if (strtolower(str_replace('-', '', $ucDbCharset)) !== 'utf8') {
                    $this->bpiAjaxReturn(false, 'uc服务端编码与BPICMS编码不一致!要求您的uc服务端编码为:utf8编码.');
                }

                //标签应用模板
                $params = array(
                    'm' => 'app',
                    'a' => 'add',
                    'ucfounder' => '',
                    'ucfounderpw' => $post['authkey'],
                    'apptype' => 'OTHER',
                    'appname' => BaseAction::getVar('config/site_name'),
                    'appurl' => rtrim(SITE_URL, '/'),
                    'appip' => $_SERVER['SERVER_ADDR'],
                    'appcharset' => 'utf8',
                    'appdbcharset' => 'utf8',
                    'release' => UC_CLIENT_RELEASE,
                    'apptagtemplates' => array(
                        'template' => '<a href="{url}" target="_blank">{title}</a>',
                        'fields' => array(
                            'title' => '标题',
                            'writer' => '作者',
                            'pubdate' => '时间',
                            'url' => '地址'
                        )
                    )
                );

                $data = uc_fopen($post['uc_api'] . '/index.php', 500, http_build_query($params), '', 1, $post['uc_ip']);

                if (FALSE !== strpos($data, '<?xml')) {
                    $data = array_shift(explode('<?xml', $data));
                }

                if (empty($data)) {
                    $this->bpiAjaxReturn(false, '请填写有效的配置信息!');
                } elseif ($data == -1) {
                    $this->bpiAjaxReturn(false, '创始人密码错误!');
                } else {
                    $explode = explode('|', $data);
                    if (empty($explode[0]) || empty($explode[1])) {
                        $this->bpiAjaxReturn(false, '数据获取失败!');
                    } else {
                        $data = array(
                            'uc_key' => $explode[0],
                            'uc_appid' => $explode[1],
                            'uc_dbhost' => $explode[2],
                            'uc_dbname' => $explode[3],
                            'uc_dbuser' => $explode[4],
                            'uc_dbpw' => $explode[5],
                            'uc_dbcharset' => $explode[6],
                            'uc_dbtablepre' => $explode[7],
                            'uc_charset' => $explode[8],
                            'uc_connect' => 'mysql',
                            'uc_api' => $post['uc_api'],
                            'uc_ip' => $post['uc_ip'],
                            'uc_use' => 1
                        );


                        if (FALSE !== D('Module')->where(array('module' => GROUP_NAME))->save(array('setting' => serialize($data)))) {
                            $this->bpiAjaxReturn(true, '安装成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Ucenter/UcenterManage/edit') . '"'));
                        } else {
                            $this->bpiAjaxReturn(false, '安装失败', array(), C('OPERATE_TYPE.OPERATE_ADD'));
                        }
                    }
                }
            }
        } else {
            $this->assign($this->setting);
            $this->display();
        }
    }

    /**
     * 编辑配置
     */
    public function edit() {
        if (!$this->setting['uc_appid']) {
            $this->redirect('install');
        }

        if (IS_POST) {
            $post = $this->_post();
            if (FALSE !== D('Module')->where(array('module' => GROUP_NAME))->save(array('setting' => serialize($post)))) {
                $this->bpiAjaxReturn(true, '修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $this->bpiAjaxReturn(false, '修改失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $this->assign($this->setting);
            $this->display();
        }
    }

}

?>
