/**
 * BPICMS后台JS代码整合
 */

/**
 * 更改父表单ACTION
 * @param {type} obj 含有属性值 data-action 的对象
 */
function changeFormAction(obj) {
    var data_action = $(obj).attr('data-action');
    $(obj).parents('form').attr('action', data_action);
}

/**
 * 图标上传统一方法
 * @param {type} callback       回调函数
 * @param {type} module         模块名
 * @param {type} category_id    
 */
function uploadIcon(callback, module, category_id) {
    /* 参数不可更改 */
    var args = {upload_allow_ext: 'jpg|jpeg|gif|bmp|png', queue_limit: 1, auth: BPI.UPLOADICON};
    flashUpload('图片上传', args, callback, module, category_id);
}

/**
 * 附件上传点击图库时加载图库
 */
function loadGallery() {
    var displayObj = $('#swfupload_gallery');
    var pageObj = $('#swfupload_gallery_page');
    ajaxLoadGallery(BPI.SITE_URL + "index.php?g=Attachment&m=AttachmentManage&a=gallery", '', displayObj, pageObj);
    ajaxLoadGalleryPage(displayObj, pageObj);
}

/**
 * 附件上传加载未处理文件列表
 */
function loadDispose() {
    var displayObj = $('#swfupload_dispose');
    var pageObj = $('#swfupload_dispose_page');
    ajaxLoadGallery(BPI.SITE_URL + "index.php?g=Attachment&m=AttachmentManage&a=dispose", '', displayObj, pageObj);
    ajaxLoadGalleryPage(displayObj, pageObj);
}

/**
 * 附件上传点击分页AJAX加载
 * @param {type} displayObj
 * @param {type} pageObj
 * @returns {undefined}
 */
function ajaxLoadGalleryPage(displayObj, pageObj) {
    pageObj.on('click', 'a', function() {
        ajaxLoadGallery($(this).attr('href'), '', displayObj, pageObj);
        return false;
    });
}

/**
 * 附件上传加载图库数据方法
 * @param {type} url        AJAX请求地址
 * @param {type} data       请求参数
 * @param {type} displayObj 回调显示容器
 * @param {type} pageObj    分页显示容器
 */
function ajaxLoadGallery(url, data, displayObj, pageObj) {
    displayObj.html('');
    $.getJSON(url, data, function(result) {
        $(result.gallery).each(function(index, element) {
            /* addImage函数在对应页面定义 */
            addImage(displayObj, element, false);
        });
        pageObj.html(result.pager);
    });
}

/**
 * 图库搜索
 * @param {type} form   表单对象 
 */
function attachmentSearch(form) {
    ajaxLoadGallery(BPI.SITE_URL + "index.php?g=Attachment&m=AttachmentManage&a=gallery", $(form).serialize(), $('#swfupload_gallery'), $('#swfupload_gallery_page'));
    return false;
}

/**
 * 附件上传即时删除函数
 * @param {type} obj    点击对象
 * @param {type} id     附件ID
 * @param {type} e      事件对象
 */
function removeSwfupload(obj, id, e) {
    /* 阻止事件冒泡 */
    if (e && e.stopPropagation) {
        e.stopPropagation();
    } else {
        window.event.cancelBubble = true;
    }
    if (!id) {
        return false;
    }
    dialogConfirm('确定删除附件吗？', function() {
        $.getJSON(BPI.SITE_URL + 'index.php?g=Attachment&m=AttachmentManage&a=delete', {attachment_id: id}, function(json) {
            if (json.status) {
                top.dialogAlert(json.info, false, '', false).time(1.5);
                $(obj).parents('.swfupload_image_box').remove();
            } else {
                top.dialogAlert(json.info);
            }
        });
    });

    return false;
}

/**
 * 推荐位中获取栏目列表
 * @param {type} modelId
 * @param {type} categoryId
 */
function positionGetCategoryList(modelId, categoryId) {
    var url = BPI.SITE_URL + 'index.php?g=Content&m=Position&a=public_categoryLoad&model_id=' + modelId;
    if (categoryId) {
        url += '&category_id=' + categoryId;
    }
    $.get(url, function(data) {
        $("#load_catid").html(data);
    });
}

/**
 * 推荐位下文章的信息管理弹窗方法
 * @param {type} obj
 * @returns {bool}
 */
function positionDataManage(obj) {
    dialogIframe($(obj).attr('url'), 'positionData', '信息管理', 800, 560, true, function() {
        var dialog = this;
        var iframe = dialog.iframe.contentWindow;
        var form = $('form.ajax_form', iframe.document);
        if (form.length) {
            ajaxSubmit(form.attr('action'), form.serialize(), form.attr('method'), function() {
                setTimeout(function() {
                    dialog.close();
                }, 500);
            });
            return false;
        } else {
            return true;
        }
    });
}

/**
 * RBAC角色授权节点点击处理
 * @param {type} obj    点击对象
 */
function checknode(obj) {
    var chk = $("input[type='checkbox']");
    var count = chk.length;
    var num = chk.index(obj);
    var levelTop = chk.eq(num).attr('level'), levelBottom = levelTop;
    /* 匹配当前节点以上的节点列表 */
    for (var i = num; i >= 0; i--) {
        var le = chk.eq(i).attr('level');
        if (le < levelTop) {
            chk.eq(i).prop("checked", true);
            levelTop = levelTop - 1;
        }
    }

    /* 匹配当前节点以下的节点列表 */
    for (var j = num + 1; j < count; j++) {
        var le = chk.eq(j).attr('level');
        if (le > levelBottom) {
            chk.eq(j).prop("checked", chk.eq(num).prop("checked") ? true : false);
        } else {
            break;
        }
    }
}

/**
 * 生成URL规则示例
 * @param {type} urlRule        URL规则
 * @param {type} isIndex        是否首页URL规则
 * @returns {unresolved}        URL示例
 */
function buildUrlRuleExample(urlRule, isIndex) {
    function rand(min, max) {
        return min + Math.round((max - min) * Math.random());
    }
    var arg = {
        '\\{\\$category_parent_dir\\}': 'Company',
        '\\{\\$category_dir\\}': 'BluePoint',
        '\\{\\$tag\\}': '标签',
        '\\{\\$category_id\\}': rand(1, 100),
        '\\{\\$year\\}': rand(2010, 2013),
        '\\{\\$month\\}': rand(1, 12),
        '\\{\\$day\\}': rand(1, 28),
        '\\{\\$id\\}': rand(1, 100),
        '\\{\\$page\\}': isIndex ? 1 : rand(1, 10)
    };

    $.each(arg, function(key, value) {
        urlRule = urlRule.replace(new RegExp(key, 'gm'), value);
    });
    return urlRule;
}

/**
 * 会员添加/编辑点击同步更改用户组处理
 * @param {type} obj        点击对象
 * @param {type} groupId    原用户组ID
 */
function chgMemberGroup(obj, groupId) {
    obj = $(obj);
    var pointObj = $('#memberPoint');
    var groupObj = $('#memberGroup');
    if (obj.prop('clicked')) {
        groupObj.val(groupId);
        obj.prop('clicked', false);
    } else {
        var url = BPI.SITE_URL + 'index.php?g=Member&m=MemberManage&a=public_getGroupByPoint';
        $.getJSON(url, {point: pointObj.val()}, function(json) {
            groupObj.val(json.groupId);
        });
        obj.prop('clicked', true);
    }
}

/**
 * 会员添加/编辑 更改会员模型处理
 * @param {type} modelId        模型ID
 * @param {type} userId         用户ID
 */
function getMemberModelField(modelId, userId) {
    var fieldObj = $('#member_model_field');
    var url = BPI.SITE_URL + 'index.php?g=Member&m=MemberManage&a=public_getMemberModelField';
    var string = '';
    $.getJSON(url, {model_id: modelId, user_id: userId}, function(json) {
        var data = json.data;
        for (var i in data) {
            string += '<tr><td class="tablehead"><span>' + data[i]['name'] + '</span></td><td>' + data[i]['form_module'] + '</td></tr>';
        }
        fieldObj.html(string);
    })
}

/**
 * 文本框双击可扩大/收缩
 */
function textareaFlexible() {
    $(document).on('dblclick', '.textareaFlexible', function() {
        var obj = $(this);
        if (!obj.prop('flexible')) {
            obj.css('width', '80%').prop('flexible', true);
        } else {
            obj.css('width', '').prop('flexible', false);
        }
    });
}

/**
 * 鼠标悬浮 table 时显示不同样式 
 */
function tableHover() {
    $('#contactsBody tr').hover(function() {
        $(this).addClass('selected');
    }, function() {
        $(this).removeClass('selected');
    });
}

/**
 * 点击含有样式ajax_submit的a标签AJAX提交数据
 */
function aAjaxSubmit() {
    $('a.ajax_submit').on('click', '', function() {
        var obj = $(this);
        var tips = obj.attr('tips') ? obj.attr('tips') : "确定删除此项吗？<br/>删除后不可恢复";
        var data = obj.attr('data') ? eval('({' + obj.attr('data') + '})') : {};
        var method = obj.attr('method') ? obj.attr('method') : 'GET';
        if (obj.hasClass('ajax_confirm')) {
            dialogConfirm(tips, function() {
                ajaxSubmit(obj.attr('href'), data, method, null, obj);
            });
            return false;
        }
        ajaxSubmit(obj.attr('href'), data, method, null, obj);
        return false;
    })
}

/**
 * 缓慢隐藏父对象后再删除父对象
 * @param {type} obj            点击对象
 * @param {type} parentLabel    父标签
 */
function hideTableTr(obj, parentLabel) {
    parentLabel = parentLabel || 'tr';
    var parent = obj.parents(parentLabel);
    parent.fadeOut(1000, function() {
        parent.remove();
    });
}

$(function() {
    textareaFlexible();
    tableHover();
    aAjaxSubmit();
});
