/* 内容添加/修改公用JS文件 */
/**
 * 检测输入框值长度
 * @param {type} obj        输入框对象
 * @param {type} checklen   提示框对象
 * @param {type} maxlen     最大输入长度
 * @returns {undefined}
 */
function strlen_verify(obj, checklen, maxlen) {
    maxlen = parseInt(maxlen);
    if (!maxlen) {
        return true;
    }
    var v = obj.value, curlen = maxlen, len = strlen(v);
    for (var i = 0; i < v.length; i++) {
        if (v.charCodeAt(i) < 0 || v.charCodeAt(i) > 255) {
            curlen -= BPI.CHARSET == 'utf-8' ? 2 : 1;
        }
    }
    if (curlen >= len) {
        $('#' + checklen).html(curlen - len);
    } else {
        obj.value = mb_cutstr(v, maxlen, true);
    }
}

/**
 * 截取字符串
 * @param {type} str    字符串
 * @param {type} maxlen 截取数
 * @param {type} dot    附加码
 * @returns {String}
 */
function mb_cutstr(str, maxlen, dot) {
    var len = 0;
    var ret = '';
    var dot = !dot ? '...' : '';
    maxlen = maxlen - dot.length;
    for (var i = 0; i < str.length; i++) {
        len += str.charCodeAt(i) < 0 || str.charCodeAt(i) > 255 ? (BPI.CHARSET == 'utf-8' ? 3 : 2) : 1;
        if (len > maxlen) {
            ret += dot;
            break;
        }
        ret += str.substr(i, 1);
    }
    return ret;
}

/**
 * 返回字符串长度
 * @param {type} str
 */
function strlen(str) {
    return (/msie/.test(navigator.userAgent.toLowerCase()) && str.indexOf('\n') != -1) ? str.replace(/\r?\n/g, '_').length : str.length;
}

/**
 * 清除标题检测提示
 * @returns {undefined}
 */
function clearError() {
    $('#available_title').hide();
}

/**
 * 检测标题是否重复
 * @param {type} categoryId 当前类别ID
 * @returns {undefined}
 */
function checkTitle(categoryId) {
    var title = $('#title').val();
    if (title.length > 0) {
        $.get('?g=Content&m=Content&a=public_checkTitle', {title: title, category_id: categoryId}, function(json) {
            if (json.status) {
                $('#available_title').show();
            }
        });
    }
}

/**
 * 验证文件最大限制数
 * @param {type} id    文件父容器ID
 * @param {type} length 最大值
 * @returns {Boolean}
 */
function checkAddFileLength(id, length) {
    var childLength = $('#' + id).children().length;
    if (childLength >= length) {
        dialogAlert('上传文件超过最大限制数');
        return false;
    }
    return true;
}

/*增加相关*/
function addRelation(id, title, parent, input) {
    parent = parent || $('#relation_list');
    input = input || $('#relation');
    var liClass = 'child_' + id;
    if ($('li.' + liClass, parent).length > 0) {
        return false;
    }
    var str = '<li class="' + liClass + '" data_id="' + id + '"><span>' + title + '</span><a href="javascript:;" onclick="removeRelation(' + id + ')">x</a></li>';
    parent.append(str);
    var value = input.val() ? input.val() + '|' + id : id;
    input.val(value);
}

/*删除相关*/
function removeRelation(id) {
    var parent = $('#relation_list');
    var input = $('#relation');
    var liClass = 'child_' + id;
    $('li.' + liClass, parent).remove();
    var value = input.val().replace(id + '|', '').replace('|' + id, '').replace(id, '');
    input.val(value);
}

/**
 * 点击填写更多相关操作
 * @param {type} obj    点击对象
 */
function writeMore(obj) {
    obj = $(obj);
    var trObj = $('#content_extend').children('.hidden');
    if (obj.prop('clicked')) {
        trObj.hide();
        obj.html('填写更多').prop('clicked', false);
    } else {
        trObj.show();
        obj.html('收起更多').prop('clicked', true);
    }
}