/**
 * 前后台公用JS代码
 */

/**
 * 设置cookie值
 * @param {type} name   cookie名
 * @param {type} value  cookie值
 * @param {type} expiry 有效天数，为0表示删除cookie
 */
function setCookie(name, value, expiry, path) {
    path = path || '/';
    var cookie = BPI.COOKIEPREFIX + name + '=' + encodeURIComponent(value) + '; path=' + path;
    if (typeof expiry === 'number') {
        cookie += '; max-age=' + (expiry * 60 * 60 * 24);
    }
    document.cookie = cookie;
}

// radio切换事件
function onRadioChange(selectors, target_selectors, callback) {
    $(selectors).change(function() {
        var index = Number($(selectors + ':checked').val());
        $(target_selectors).each(function(i) {
            var obj = $(this);
            index === i ? obj.show() : obj.hide();
            callback && callback(index, i, obj);
        });
    });
}

// checked全选与单选事件
function onCheckChange(parent_selectors, target_selectors) {
    var parents = $(parent_selectors);
    var targets = $(target_selectors);
    parents.change(function() {
        targets.prop('checked', $(this).prop('checked'));
    });

    targets.change(function() {
        parents.prop('checked', targets.length === targets.filter(':checked').length);
    });
}

// checkbox初始化函数
function checkboxInit(selectors, initVal) {
    var obj = $(selectors);
    obj.prop('checked', false);
    if (Boolean(initVal)) {
        obj.click();
    }
}

// radio初始化函数
function radioInit(selectors, initVal) {
    $(selectors).each(function() {
        var obj = $(this);
        var checked = (Number(obj.val()) === Number(initVal));
        obj.prop('checked', checked);
        checked && obj.change();
    });
}

// select初始化函数
function selectInit(selectors, initVal) {
    $(selectors).val(initVal).change();
}

//更换tab
function swapTab(object, callback) {
    var showClass = 'tab-hover';
    object = $(object);

    // 判断是否已经被显示
    if (object.hasClass(showClass)) {
        return;
    }

    // 分解字符串，0是tab，1是name，2是index
    var splitArray = object.attr('id').split('_');
    if (3 !== splitArray.length) {
        consolt.error('传入对象的id属性不符合规范 : ' + object.attr('id'));
        return;
    }

    // 获取 index
    var index = parseInt(splitArray[2]);

    // 找寻所有包含id的
    $('[id^="' + splitArray[0] + '_' + splitArray[1] + '_"]').each(function() {
        var splitArray = $(this).attr('id').split('_');
        if (3 !== splitArray.length) {
            consolt.error('遍历对象的id属性不符合规范 : ' + $(this).attr('id'));
            return;
        }

        // 转换id
        splitArray[0] = 'div';
        var divObject = $('#' + splitArray.join('_'));

        if (index === parseInt(splitArray[2])) {
            $(this).addClass(showClass);
            divObject.show();
        } else {
            $(this).removeClass(showClass);
            divObject.hide();

        }
    });

    if (callback && typeof (callback) === 'function') {
        splitArray[0] = 'div';
        callback(object, index, $('#' + splitArray.join('_')));
    }
}

/**
 * 执行一条语句
 * @param {type} str        执行的语句
 * @param {type} args       如果是函数，带有的参数
 * @returns {Boolean}       返回执行的结果
 */
function execute(str, args) {
    var result;
    if (typeof (window[str]) === 'function') {
        result = window[str].apply(this, args);
    } else if (typeof (str) === 'string') {
        try {
            result = eval(str);
        } catch (exception) {
            return false;
        }
    }
    // 无返回结果默认为继续执行下面流程，即'undefined' === true
    return !result && result !== 'undefined';
}

/**
 * AJAX 数据提交
 * @param {type} url        提交地址
 * @param {type} data       附加数据
 * @param {type} type       提交方式
 * @param {type} callback   回调函数
 * @param {type} obj        调用对象
 */
var formTimer = null;   //AJAX提交开关
function ajaxSubmit(url, data, type, callback, obj) {
    type = type || 'POST';
    /* 转换为AJAX操作 */

    var dialog = top.$.dialog();

    /* 是否重复提交*/
    if (formTimer) {
        return false;
    }

    formTimer = true;

    $.ajax({
        url: url,
        data: data,
        type: type,
        dataType: 'JSON',
        cache: false,
        success: function(json) {
            dialog.close();
            if (json.status > 0) {
                top.dialogAlert(json.info, false, '', false).time(1.5);
            } else {
                top.dialogAlert(json.info);
            }
            formTimer = null;
            switch (json.type) {
                case 'eval':
                    eval(json.data);
                    break;
                case 'function':
                    if ((typeof window[json.data]) === 'function') {
                        window[json.data].call(this, obj);
                    }
                    break;
                default:
                    break;
            }

            // 执行回调函数
            callback && typeof (callback) === 'function' && callback.apply(this, arguments);
        }
    });
    return false;
}

/**
 * 上传对话框调用方法
 * @param {type} title          对话框标题
 * @param {type} args           对话框参数，JSON格式
 * @param {type} callback       回调函数
 * @param {type} module         所属模块
 * @param {type} category_id    栏目ID
 * @returns {undefined}
 */
function flashUpload(title, args, callback, module, category_id) {
    //直接把参数传递给swfupload
    args = decodeURIComponent($.param(args));
    category_id = category_id || 0;
    if (args) {
        args = '&' + args;
    }
    var m = BPI.ADMIN ? 'AttachmentManage' : 'Attachment';
    var url = BPI.SITE_URL + 'index.php?g=Attachment&m=' + m + '&a=swfupload&module=' + module + '&category_id=' + category_id + args;
    dialogIframe(url, 'flashUpload', title, 650, 420, true, function() {
        // 回调swfupload.html中的事件，进行图库文件筛选
        var okFunction = this.iframe.contentWindow.swfuploadOnOK;
        if (typeof (okFunction) === 'function') {
            okFunction(callback);
        }
    }, {padding: '10px 6px 0'});
}

/**
 * 友好弹框
 * @param {type} content    弹框内容
 * @param {type} isError    是否错误提示
 * @param {type} title      标题
 * @param {type} isShowOk   是否显示确定按钮
 * @returns {undefined}
 */
function dialogAlert(content, isError, title, isShowOk) {
    if (!content) {
        return false;
    }
    isError = isError !== false ? true : false;
    title = title || (isError ? '错误提示' : '成功提示');
    var icon = isError ? 'error' : 'succeed';
    return $.dialog({
        title: title,
        icon: icon,
        okValue: '确定',
        ok: isShowOk !== false ? true : false,
        content: content
    });
}

/**
 * 友好确认框
 * @param {type} content         弹框内容
 * @param {type} okCallback      点击确定时回调函数
 * @param {type} cancelCallback  点击取消时回调函数
 */
function dialogConfirm(content, okCallback, cancelCallback) {
    top.$.dialog.confirm(content, function() {
        okCallback && okCallback();
    }, function() {
        cancelCallback && cancelCallback();
    });
}

/**
 * 图片预览
 * @param {type} srcObj    图片对象/其他含属性src的对象
 * @returns {Boolean}
 */
function previewImage(srcObj) {
    var obj = $(srcObj);
    var image = obj.attr('src');
    var dialog = $.dialog({
        title: '附件预览'
    });
    var imageObj = new Image();
    imageObj.src = image;
    imageObj.onerror = function() {
        return dialog.content('读取附件出错').time(1);
    };

    if (imageObj.complete) {
        var height = imageObj.height >= 300 ? 300 : imageObj.height;
        return dialog.content('<img src="' + image + '" height="' + height + '"/>');
    }
    imageObj.onload = function() {
        var height = imageObj.height >= 300 ? 300 : imageObj.height;
        return  dialog.content('<img src="' + image + '" height="' + height + '"/>');
    };
}

/**
 * dialog弹框框架
 * @param {type} url            弹框URL
 * @param {type} id             弹框ID 默认为dialogIframe
 * @param {type} title          弹框title
 * @param {type} width          弹出宽度（不设置将自动）
 * @param {type} height         弹出高度（不设置将自动）
 * @param {type} isShowCancel   是否显示取消按钮
 * @param {type} okFunction     确定回调函数
 * @param {type} args           弹出框其他参数
 */
function dialogIframe(url, id, title, width, height, isShowCancel, okFunction, args) {
    if (!url) {
        return false;
    }
    var option = {
        id: id || 'dialogIframe',
        title: title,
        padding: 0,
        okValue: '确定',
        ok: okFunction || true
    };
    if (width) {
        option['width'] = width;
    }
    if (height) {
        option['height'] = height;
    }
    if (isShowCancel) {
        option['cancelValue'] = '取消';
        option['cancel'] = true;
    }
    args = args || {};
    $.extend(option, args);
    return $.dialog.open(url, option);
}

//移除指定id内容
function remove_div(id) {
    $('#' + id).remove();
}

/**
 * 隐藏对象
 * @param {type} obj
 */
function hideObj(obj) {
    $(obj).hide();
}

/**
 * 显示对象
 * @param {type} obj
 */
function showObj(obj) {
    $(obj).show();
}

/**
 * 标签代替表单提交 
 */
function formAjaxSubmit() {
    $('form .save_btn a').click(function() {
        var obj = $(this);
        var tips = obj.attr('tips') ? obj.attr('tips') : "确定删除此项吗？<br/>删除后不可恢复";
        if (obj.hasClass('form_ajax_confirm')) {
            dialogConfirm(tips, function() {
                obj.parents('form').submit();
            });
            return false;
        }
        obj.parents('form').submit();
        return false;
    });
}

/**
 * 清空没有进行修改排序的name
 */
function clearSort() {
    $('form').submit(function() {
        $('[name^="sort"]', this).each(function() {
            var object = $(this);
            if (Number(object.val()) === Number(object.attr('origin'))) {
                object.removeAttr('name');
            }
        });
    });
}

/**
 * 表单AJAX提交处理函数
 */
function formSubmit() {
    $('form.ajax_form').submit(function() {
        var form = $(this);
        /* 执行提交前操作 */
        $("[callback='_before_submit'][type='hidden']", this).each(function() {
            if (!execute($(this).val())) {
                return false;
            }
        });
        /* 表单采用AJAX提交 */
        ajaxSubmit(form.attr('action'), form.serialize(), form.attr('method'), function() {
            var args = arguments;
            /* 执行提交后操作 */
            $("[callback='_after_submit'][type='hidden']", this).each(function() {
                execute($(this).val(), args);
            });
        });
        return false;
    });
}

$(function() {
    formAjaxSubmit();
    clearSort();
    formSubmit();
});