/* 文件上传队列处理函数 */
function fileQueueError(file, errorCode, message) {
    try {
        var errorName = "";
        switch (errorCode) {
            case SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED:
                var error = '您';
                if (this.settings.file_queue_limit != 0) {
                    error += '一次最多能选择' + this.settings.file_queue_limit + '个文件<br/>';
                }
                if (this.settings.file_upload_limit != 0) {
                    error += '总共能上传' + this.settings.file_upload_limit + '个文件';
                }
                dialogAlert(error);
                return false;
                break;
            case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
                errorName = "文件选择错误";
                break;
            case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
                errorName = "文件超过大小限制";
                break;
            case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
                errorName = "文件类型错误";
                break;
            default:
                errorName = "上传失败";
                break;
        }
        if (errorName !== "") {
            try {
                var progress = new FileProgress(file, this.customSettings.upload_target);
                progress.setCancelled();
                progress.setStatus(errorName);
                progress.toggleCancel(false);
            } catch (ex) {
                this.debug(ex);
            }
        }
    } catch (ex) {
        this.debug(ex);
    }

}

/* 选择文件框完成时处理函数 */
function fileDialogComplete(numFilesSelected, numFilesQueued) {
    try {
        if (numFilesQueued > 0) {
            this.startUpload();
        }
    } catch (ex) {
        this.debug(ex);
    }
}

/* 文件上传时处理函数 */
function uploadProgress(file, bytesLoaded) {
    try {
        var percent = Math.ceil((bytesLoaded / file.size) * 100);
        var progress = new FileProgress(file, this.customSettings.upload_target);
        progress.setProgress(percent);
        if (percent === 100) {
            progress.setStatus("文件即将上传完成...");
            progress.toggleCancel(false, this);
        } else {
            progress.setStatus("文件上传中...");
            progress.toggleCancel(true, this);
        }
    } catch (ex) {
        this.debug(ex);
    }
}

/* 文件上传成功处理函数 */
function uploadSuccess(file, serverData) {
    try {
        //        var progress = new FileProgress(file, this.customSettings.upload_target);
        var jsonObject = eval("(" + serverData + ")");
        if (jsonObject) {
            if (0 === parseInt(jsonObject.error_code)) {
                var progress = new FileProgress(file, this.customSettings.upload_target);
                progress.setComplete();
                progress.setStatus("文件上传成功");
                progress.toggleCancel(false);
                addImage(document.getElementById("swfupload_upload_gallery"), jsonObject.content, true, file.id);
            } else {
                try {
                    var progress = new FileProgress(file, this.customSettings.upload_target);
                    progress.setCancelled();
                    progress.setStatus(jsonObject.error);
                    progress.toggleCancel(false);
                } catch (ex) {
                    this.debug(ex);
                }
                this.debug('服务器错误，错误代码：' + jsonObject.error_code + '   错误信息：' + jsonObject.error);
            }
        }
    } catch (ex) {
        this.debug(ex);
    }
}

/* 文件上传完成处理函数 */
function uploadComplete(file) {
    try {
        /*  I want the next upload to continue automatically so I'll call startUpload here */
        if (this.getStats().files_queued > 0) {
            this.startUpload();
        }
    } catch (ex) {
        this.debug(ex);
    }
}

/* 文件上传错误处理函数 */
function uploadError(file, errorCode, message) {
    var progress;
    try {
        switch (errorCode) {
            case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
                try {
                    progress = new FileProgress(file, this.customSettings.upload_target);
                    progress.setCancelled();
                    progress.setStatus("文件被取消");
                    progress.toggleCancel(false);
                } catch (ex1) {
                    this.debug(ex1);
                }
                break;
            case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
                try {
                    progress = new FileProgress(file, this.customSettings.upload_target);
                    progress.setCancelled();
                    progress.setStatus("文件已停止");
                    progress.toggleCancel(true);
                } catch (ex2) {
                    this.debug(ex2);
                }
                break;
            case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
                try {
                    progress = new FileProgress(file, this.customSettings.upload_target);
                    progress.setCancelled();
                    progress.setStatus('文件大小超过限制');
                    progress.toggleCancel(true);
                } catch (ex3) {
                    this.debug(ex3);
                }
                break;
            default:
                try {
                    progress = new FileProgress(file, this.customSettings.upload_target);
                    progress.setCancelled();
                    progress.setStatus(message);
                    progress.toggleCancel(true);
                } catch (ex4) {
                    this.debug(ex4);
                }
                break;
        }
    } catch (ex3) {
        this.debug(ex3);
    }

}

/* 只是一个动画效果 */
function fadeIn(element, opacity) {
    var reduceOpacityBy = 5;
    var rate = 30; // 15 fps

    if (opacity < 100) {
        opacity += reduceOpacityBy;
        if (opacity > 100) {
            opacity = 100;
        }

        if (element.filters) {
            try {
                element.filters.item("DXImageTransform.Microsoft.Alpha").opacity = opacity;
            } catch (e) {
                // If it is not set initially, the browser will throw an error.  This will set it if it is not set yet.
                element.style.filter = 'progid:DXImageTransform.Microsoft.Alpha(opacity=' + opacity + ')';
            }
        } else {
            element.style.opacity = opacity / 100;
        }
    }

    if (opacity < 100) {
        setTimeout(function() {
            fadeIn(element, opacity);
        }, rate);
    }
}

/* ******************************************
 *	FileProgress Object
 *	Control object for displaying file info
 *	文件上传时信息回调显示UI处理
 * ****************************************** */

function FileProgress(file, targetID) {
    this.fileProgressID = file.id;

    this.fileProgressWrapper = document.getElementById(this.fileProgressID);
    if (!this.fileProgressWrapper) {
        this.fileProgressWrapper = document.createElement("div");
        this.fileProgressWrapper.className = "progressWrapper";
        this.fileProgressWrapper.id = this.fileProgressID;

        this.fileProgressElement = document.createElement("div");
        this.fileProgressElement.className = "progressContainer";

        var progressCancel = document.createElement("a");
        progressCancel.className = "progressCancel";
        progressCancel.href = "javascript:;";
        progressCancel.style.visibility = "hidden";
        progressCancel.appendChild(document.createTextNode(" "));

        var progressText = document.createElement("div");
        progressText.className = "progressName";
        progressText.appendChild(document.createTextNode(file.name));

        var progressBar = document.createElement("div");
        progressBar.className = "progressBarInProgress";

        var progressStatus = document.createElement("div");
        progressStatus.className = "progressBarStatus";
        progressStatus.innerHTML = "&nbsp;";

        this.fileProgressElement.appendChild(progressCancel);
        this.fileProgressElement.appendChild(progressText);
        this.fileProgressElement.appendChild(progressStatus);
        this.fileProgressElement.appendChild(progressBar);

        this.fileProgressWrapper.appendChild(this.fileProgressElement);

        document.getElementById(targetID).appendChild(this.fileProgressWrapper);
        fadeIn(this.fileProgressWrapper, 0);
    } else {
        this.fileProgressElement = this.fileProgressWrapper.firstChild;
        this.fileProgressElement.childNodes[1].firstChild.nodeValue = file.name;
    }

    this.height = this.fileProgressWrapper.offsetHeight;

}

FileProgress.prototype.setProgress = function(percentage) {
    this.fileProgressElement.className = "progressContainer green";
    this.fileProgressElement.childNodes[3].className = "progressBarInProgress";
    this.fileProgressElement.childNodes[3].style.width = percentage + "%";
};
FileProgress.prototype.setComplete = function() {
    this.fileProgressElement.className = "progressContainer blue";
    this.fileProgressElement.childNodes[3].className = "progressBarComplete";
    this.fileProgressElement.childNodes[3].style.width = "";

};
FileProgress.prototype.setError = function() {
    this.fileProgressElement.className = "progressContainer red";
    this.fileProgressElement.childNodes[3].className = "progressBarError";
    this.fileProgressElement.childNodes[3].style.width = "";

};
FileProgress.prototype.setCancelled = function() {
    this.fileProgressElement.className = "progressContainer red";
    this.fileProgressElement.childNodes[3].className = "progressBarError";
    this.fileProgressElement.childNodes[3].style.width = "";

};
FileProgress.prototype.setStatus = function(status) {
    this.fileProgressElement.childNodes[2].innerHTML = status;
};

FileProgress.prototype.toggleCancel = function(show, swfuploadInstance) {
    this.fileProgressElement.childNodes[0].style.visibility = show ? "visible" : "hidden";
    if (swfuploadInstance) {
        var fileID = this.fileProgressID;
        this.fileProgressElement.childNodes[0].onclick = function() {
            swfuploadInstance.cancelUpload(fileID);
            return false;
        };
    }
};