/**
 * market 主要JS函数
 */
/*
 * 添加到收藏夹
 */
function addToFav() {
    if (document.all) {
        try {
            window.external.addFavorite(location.href, document.title);
        } catch (e1) {
            try {
                window.external.addToFavoritesBar(location.href, document.title);
            } catch (e2) {
                alert('当前浏览器不支持此操作，请手动添加页面到收藏夹');
            }
        }
    } else if (window.sidebar) {
        try {
            window.sidebar.addPanel(document.title, location.href, "");
        } catch (e) {
            alert('当前浏览器不支持此操作，请手动添加页面到收藏夹');
        }
    } else {
        alert('当前浏览器不支持此操作，请手动添加页面到收藏夹');
    }
}

/*
 * 设为首页
 */
function setHomepage() {
    if (document.all) {
        document.body.style.behavior = "url(#default#homepage)";
        document.body.setHomePage(location.href);
    } else if (window.sidebar && window.netscape) {
        try {
            netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
        } catch (e) {
            alert('当前浏览器不支持此操作，请手动设置页面为首页');
            return;
        }
        var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
        prefs.setCharPref("browser.startup.homepage", location.href);
    } else {
        alert('当前浏览器不支持此操作，请手动设置页面为首页');
    }
}

/**
 * 关键字搜索
 */
function keywordSearch(object) {
    $(object).parent('form').submit();
}

/**
 * 为不支持placeholder添加相似事件
 */
function placeholderFunc() {
    var inputObject = document.createElement('input');
    var suppor = 'placeholder' in inputObject;
    if (!suppor) {
        var inputs = $(":text");
        $.each(inputs, function(i, n) {
            var input = inputs.eq(i);
            var placeValue = input.attr('placeholder');
            if (placeValue) {
                var color = input.css('color');
                var placeColor = '#888';
                if (!input.val()) {
                    input.val(placeValue).css('color', placeColor);
                }
                input.focus(function() {
                    if (!input.val() || input.val() === placeValue) {
                        input.val('').css('color', color);
                    }
                }).blur(function() {
                    if (!input.val()) {
                        input.val(placeValue).css('color', placeColor);
                    }
                });
            }
        });
    }
}

/**
 * 图像点击刷新验证码
 * @param {type} type  验证码类型
 * @param {type} event event事件兼容性问题
 */
function refreshVerCode(type, event) {
    var e = event || window.event;
    var object = e.target || e.srcElement;
    $(object).attr('src', BPI.SITE_URL + 'index.php?g=Public&m=Verify&a=verify&type=' + type + '&t=' + Math.random());
}

/**
 * 表单AJAX处理
 * @param {type} formObj    表单对象
 */
function formAjaxFunc(formObj) {
    var formObject = $(formObj), loadingObject = $('#form_loading', formObject), submitObject = $('.form_submit', formObject),
            errorObject = $('.form_error', formObject), successObject = $('.form_success', formObject);
    submitObject.attr('disabled', 'disabled');
    errorObject.hide();
    loadingObject.show();
    $.post(formObject.attr('action'), formObject.serialize(), function(json) {
        if (json.status > 0) {
            loadingObject.hide();
            successObject.show().html(json.info);
            setTimeout(function() {
                window.location.href = json.url;
            }, 500);
        } else {
            submitObject.removeAttr('disabled');
            loadingObject.hide();
            errorObject.show().html(json.info);
        }
    }, 'json');
    return false;
}

/**
 * 注册处理
 * @param {type} formObj   注册表单
 */
function registerFunc(formObj) {
    var formObject = $(formObj), loadingObject = $('#form_loading', formObject), submitObject = $('.form_submit', formObject),
            errorObject = $('.form_error', formObject), successObject = $('.form_success', formObject), data = formObject.serializeArray(), formData = {};
    $.each(data, function(i, n) {
        formData[n.name] = n.value;
    });
    if (!('accept' in formData)) {
        errorObject.show().html('请先同意协议');
        return false;
    }
    if (formData['password'] !== formData['password_confirm']) {
        errorObject.show().html('两次密码输入不一致');
        return false;
    }
    submitObject.attr('disabled', 'disabled');
    errorObject.hide();
    loadingObject.show();
    $.post(formObject.attr('action'), formData, function(json) {
        if (json.status > 0) {
            loadingObject.hide();
            successObject.show().html(json.info);
            setTimeout(function() {
                window.location.href = json.url;
            }, 500);
        } else {
            submitObject.removeAttr('disabled');
            loadingObject.hide();
            errorObject.show().html(json.info);
        }
    }, 'json');
    return false;
}

/**
 * 下载排行列表切换动画
 */
function downloadListFunc() {
    var downloadListObject = $('.download_list');
    var itemObject = $('li.app_item', downloadListObject);
    itemObject.mouseover(function() {
        $(this).addClass('current').siblings().removeClass('current');
    });
}

/*
 * 增加评论动画函数
 */
function addComment(object) {
    var form = $(object), submitObject = $('input[type="submit"]', form), isSubmiting = (submitObject.prop('data-submiting') === undefined) ? false : submitObject.prop('data-submiting');
    if (isSubmiting) {
        return false;
    }
    submitObject.prop('data-submiting', true);
    var commentAnimateArea = form.siblings('.comment_animate_area'), loadingObject = $('.submit_loading', commentAnimateArea),
            errorObject = $('.submit_error', commentAnimateArea), successObject = $('.submit_success', commentAnimateArea), postData = form.serialize();
    commentAnimateArea.show();
    loadingObject.show();
    errorObject.hide();
    successObject.hide();
    $.post(form.attr('action'), postData, function(json) {
        loadingObject.hide();
        if (json.status > 0) {
            var commentCountObject = $('.comment_count', form);
            commentCountObject.html(parseInt(commentCountObject.html()) + 1);
            successObject.show();
            if ((typeof loadCommentList) === 'function') {
                loadCommentList();
            }
        } else {
            errorObject.html(json.info);
            errorObject.show();
            submitObject.prop('data-submiting', false);
            var clear = setTimeout(function() {
                errorObject.hide();
                commentAnimateArea.fadeOut();
            }, 2000);
            commentAnimateArea.click(function() {
                clearTimeout(clear);
                errorObject.hide();
                commentAnimateArea.fadeOut();
            });
        }
    }, 'json');
    return false;
}

/**
 * 评论列表中翻页不跳转处理函数
 */
function commentPageTurn() {
    $('.comment_list').on('click', '.page a', function() {
        $('.comment_list').load(this.href);
        return false;
    });
}

/* 首页幻灯片展示 */
(function($) {
    $.fn.tktSlide = function() {
        return this.each(function() {
            var obj = $(this), ul = $('ul', obj), li = $('li', ul), length = li.length, width = li.outerWidth(true), timer = null, index = 0, tkt_time = 3000;
            if (length <= 1) {
                return false;
            }
            /* 创建按钮对象 */
            var btnHtml = '<div id="button"><a href="javascript:;" class="hover">1</a>';
            for (var i = 2; i <= length; i++) {
                btnHtml += '<a href="javascript:;">' + i + '</a>';
            }
            btnHtml += '</div>';
            obj.append(btnHtml);
            var btn = $('#button a', obj);

            ul.width(width * length);
            timer = setInterval(function() {
                slideInit();
            }, tkt_time);

            li.hover(function() {
                clearInterval(timer);
            }, function() {
                timer = setInterval(function() {
                    slideInit();
                }, tkt_time);
            });

            btn.hover(function() {
                index = $(this).prevAll().length;
                $(this).addClass('hover').siblings().removeClass('hover');
                ul.stop(true).animate({marginLeft: -width * index}, 250);
                clearInterval(timer);
            }, function() {
                timer = setInterval(function() {
                    slideInit();
                }, tkt_time);
            });

            function slideInit() {
                if (index > length - 1) {
                    index = 0;
                    ul.animate({marginLeft: 0}, 500);
                    btn.removeClass('hover').eq(index).addClass('hover');
                    index = 1;
                } else {
                    ul.animate({marginLeft: -width * index}, 500);
                    btn.removeClass('hover').eq(index).addClass('hover');
                    index++;
                }
            }
        });
    }
})(jQuery);

/**
 * APP详细信息图片列表
 */
(function($) {
    $.fn.tktImageSlip = function() {
        return this.each(function() {
            var obj = $(this), objWidth = obj.width(), ul = $('ul', obj), li = $('li', ul), length = li.length, width = li.outerWidth(true), outWidth = (width * length) - objWidth,
                    btnHtml = '<a id="left_act" class="tkt_image_ctrl" href="javascript:;">&lt;</a><a id="right_act" class="tkt_image_ctrl" href="javascript:;">&gt;</a>';
            if (outWidth <= 0) {
                return;
            }
            ul.width(width * length);
            obj.append(btnHtml);
            var leftAct = $('#left_act', obj);
            var rightAct = $('#right_act', obj);
            leftAct.click(function() {
                var marginLeft = parseInt(ul.css('marginLeft'));
                var left = marginLeft + width >= 0 ? 0 : marginLeft + width;
                ul.stop(true, true).animate({marginLeft: left}, 'fast');
            });

            rightAct.click(function() {
                var marginLeft = parseInt(ul.css('marginLeft'));
                var left = marginLeft - width <= -outWidth ? -outWidth : marginLeft - width;
                ul.stop(true, true).animate({marginLeft: left}, 'fast');
            });
        });
    };
})(jQuery);

/*
 * 切换不同标题时显示不同容器方法
 */
(function($) {
    $.fn.tktSwitchContainer = function(config) {
        var tkt = {
            title: '.switch_title',
            content_item: '.affiche_list_box',
            selected_css: 'selected',
        };
        var object = this;
        $.extend(tkt, config);
        $(tkt.title, object).mouseenter(function() {
            $(tkt.title, object).removeClass(tkt.selected_css);
            $(this).addClass(tkt.selected_css);
            var prevLength = $(this).prev(tkt.title).length;
            $(tkt.content_item, object).hide();
            $(tkt.content_item, object).eq(prevLength).show();
        });
    };
})(jQuery);

/**
 * 首页应用推荐动画函数
 */
function recommendFunc() {
    var recommendList = $('.recommend_app_list .app_item');
    recommendList.hover(function() {
        $(this).toggleClass('hover');
        $('.app_score, .app_btn', this).toggle();
    });
}

/**
 * 加载是否收藏/添加收藏/取消收藏相关信息
 * @param {type} applicationId
 */
function favoriteFunc(applicationId) {
    var checkUrl = BPI.SITE_URL + 'index.php?g=Favorite&m=ApplicationFavorite&a=isFavorite',
            addObj = $('#addFavorite'), cancelObj = $('#cancelFavorite'), loading = $('.favorite_loading'),
            postData = {application_id: applicationId};

    $.post(checkUrl, postData, function(json) {
        loading.hide();
        if (json.status > 0) {
            cancelObj.show();
        } else {
            addObj.show();
        }
    });
    var handleFunc = {
        timer: null,
        addUrl: BPI.SITE_URL + 'index.php?g=Favorite&m=ApplicationFavorite&a=addFavorite',
        cancelUrl: BPI.SITE_URL + 'index.php?g=Favorite&m=ApplicationFavorite&a=deleteFavorite',
        successObj: $('.favorite_success'),
        errorObj: $('.favorite_error'),
        addFavorite: function() {
            handleFunc.reset();
            loading.show();
            $.post(handleFunc.addUrl, postData, function(json) {
                loading.hide();
                if (json.status > 0) {
                    addObj.hide();
                    cancelObj.show();
                    handleFunc.success(json.info);
                } else {
                    handleFunc.error(json.info);
                }
            });
        },
        cancelFavorite: function() {
            handleFunc.reset();
            loading.show();
            $.post(handleFunc.cancelUrl, postData, function(json) {
                loading.hide();
                if (json.status > 0) {
                    addObj.show();
                    cancelObj.hide();
                    handleFunc.success(json.info);
                } else {
                    handleFunc.error(json.info);
                }
            });
        },
        reset: function() {
            handleFunc.successObj.css({top: 0, opacity: 0}).stop(true, true).hide();
            handleFunc.errorObj.css({top: 0, opacity: 0}).stop(true, true).hide();
            if (handleFunc.timer) {
                clearTimeout(handleFunc.timer);
            }
        },
        success: function(info) {
            handleFunc.successObj.html(info).animate({top: -20, opacity: 1}, 500).show();
            handleFunc.timer = setTimeout(function() {
                handleFunc.successObj.animate({top: 0, opacity: 0}, 500);
            }, 1500);
        },
        error: function(info) {
            handleFunc.errorObj.html(info).animate({top: -20, opacity: 1}, 500).show();
        }
    };
    addObj.click(handleFunc.addFavorite);
    cancelObj.click(handleFunc.cancelFavorite);
}

/**
 * 我的收藏列表取消收藏函数处理
 */
function removeFavorite(applicationId, object) {
    var url = BPI.SITE_URL + 'index.php?g=Favorite&m=ApplicationFavorite&a=deleteFavorite', postData = {application_id: applicationId}, appObejct = $(object).parents('.app_item');
    $.post(url, postData, function(json) {
        if (json.status > 0) {
            appObejct.fadeOut(200, function() {
                if (!appObejct.siblings('.app_item').length) {
                    window.location.reload();
                } else {
                    appObejct.remove();
                }
            });
        }
    }, 'json');
}

/**
 * 获取指定名字的COOKIE值
 * @param {type} cookieName 为空则获取全部
 * @returns {Document.cookie|Node.cookie|String}
 */
function getCookie(cookieName) {
    if (!cookieName) {
        return document.cookie;
    } else {
        cookieName = BPI.COOKIEPREFIX + cookieName + '=';
    }
    var cookie = document.cookie, cookieArray = cookie.split("; "), temp;
    for (var i = 0, j = cookieArray.length; i < j; i++) {
        temp = cookieArray[i];
        if (temp.indexOf(cookieName) === 0) {
            return decodeURIComponent(temp.substring(cookieName.length));
        }
    }
    return '';
}

/**
 * 设置cookie值
 * @param {type} name   cookie名
 * @param {type} value  cookie值
 * @param {type} expiry 有效天数，为0表示删除cookie
 */
function setCookie(name, value, expiry, path) {
    path = path || '/';
    var cookie = BPI.COOKIEPREFIX + name + '=' + encodeURIComponent(value) + '; path=' + path;
    if (typeof expiry === 'number') {
        cookie += '; max-age=' + (expiry * 60 * 60 * 24);
    }
    document.cookie = cookie;
}

/*
 * 清除全部搜索记录
 */
function clearAllSearchHistory() {
    setCookie('searchHistory', '', 0);
    $('.search_history_list').html('');
}

/**
 * 清除指定搜索记录
 * @param {type} object 点击对象
 * @param {type} value  搜索值
 */
function clearSearchHistory(object, value) {
    if (!value) {
        return true;
    }
    var cookie = getCookie('searchHistory'), separator = '&&', cookieArray = cookie.split(separator), newCookie = separator, parent = $(object).parent();
    for (var i in cookieArray) {
        if (cookieArray[i] && cookieArray[i] !== value) {
            newCookie += cookieArray[i] + separator;
        }
    }
    setCookie('searchHistory', newCookie, 7);
    if (parent.siblings().length === 0) {
        $('.clear_search_history').hide();
    }
    parent.remove();
}

$(function() {
    placeholderFunc();
    downloadListFunc();
});