<?php

/**
 * index.php EXCMS 项目入口
 * @copyright (C) 2013 http://www.zyxfeng.com
 * @license http://www.zyxfeng.com/license/
 */
//开启调试模式
define('APP_DEBUG', false);
//目录分隔符
define('DS', DIRECTORY_SEPARATOR);
//网站当前路径
define('SITE_PATH', getcwd());
//项目名称
define('APP_NAME', 'App');
//项目路径
define('APP_PATH', SITE_PATH . DS . APP_NAME . DS);
//定义缓存存放路径
define('RUNTIME_PATH', SITE_PATH . DS . 'Runtime' . DS);
//定义静态缓存路径
define('HTML_PATH', SITE_PATH . DS . 'Html' . DS);
//主题模板路径
define('TEMPLATE_PATH', SITE_PATH . DS .'Theme' . DS);
//版本号
define('BC_VERSION', '1.0.0.140926');

if (!file_exists(APP_PATH . 'Conf/dataconfig.php')) {
    header("Location: install/");
    exit;
}

// 针对ThinkPHP DEBUG模式关闭时，脚本文件名缓存异常进行特殊处理 by tp 2013年11月14日10:19:09
{
    $fileName = '';
    if (substr(PHP_SAPI, 0, 3) === 'cgi') {
        //CGI/FASTCGI模式下
        $_temp = explode('.php', $_SERVER['PHP_SELF']);
        $fileName = rtrim(str_replace($_SERVER['HTTP_HOST'], '', $_temp[0] . '.php'), '/');
    } else {
        $fileName = rtrim($_SERVER['SCRIPT_NAME'], '/');
    }
    define('_PHP_FILE_', str_replace(basename($fileName), 'index.php', $fileName));
}

//载入框架核心文件
require APP_PATH . 'Core' . DS . 'ThinkPHP.php';
?>