<?php

/**
 * 前台配置文件
 * 所有除开系统级别的前台配置
 */
return array(
    'TMPL_ACTION_ERROR'     =>  'Public:error', // 默认错误跳转对应的模板文件
    'TMPL_ACTION_SUCCESS'   =>  'Public:success', // 默认成功跳转对应的模板文件
    'TMPL_EXCEPTION_FILE'   =>  'Public:404',// 异常页面的模板文件
   // 预先加载的标签库
    'TAGLIB_PRE_LOAD'     =>    'OT\\TagLib\\Article,OT\\TagLib\\Member',
    'LOAD_EXT_CONFIG' => 'theme,url,route',     
    /* 数据缓存设置 */
    'DATA_CACHE_PREFIX' => 'zs_', // 缓存前缀
    'DATA_CACHE_TYPE'   => 'File', // 数据缓存类型
    'VIEW_PATH'=>'./Theme/',

    /* SESSION 和 COOKIE 配置 */
    'SESSION_PREFIX' => 'zs_home', //session前缀
    'COOKIE_PREFIX'  => 'zs_home_', // Cookie前缀 避免冲突
    'VAR_SESSION_ID' => 'session_id',	//修复uploadify插件无法传递session_id的bug
    /* 模板相关配置 */
    'TMPL_PARSE_STRING' => array(
        '__STATIC__' => __ROOT__ . '/Public/static',
        '__ADDONS__' => __ROOT__ . '/Theme/Addons',
        '__IMG__'    => __ROOT__ . '/Theme/images',
        '__CSS__'    => __ROOT__ . '/Theme/css',
        '__JS__'     => __ROOT__ . '/Theme/js',
        '__THEME__'     => __ROOT__ . '/Theme/',
    ),
     /* 图片上传相关配置 */
    'PICTURE_UPLOAD' => array(
		'mimes'    => '', //允许上传的文件MiMe类型
		'maxSize'  => 0, //上传的文件大小限制 (0-不做限制)
		'exts'     => 'jpg,gif,png,jpeg', //允许上传的文件后缀
		'autoSub'  => true, //自动子目录保存文件
		'subName'  => array('date', 'Y-m-d'), //子目录创建方式，[0]-函数名，[1]-参数，多个参数使用数组
		'rootPath' => './Uploads/Picture/', //保存根路径
		'savePath' => '', //保存路径
		'saveName' => array('uniqid', ''), //上传文件命名规则，[0]-函数名，[1]-参数，多个参数使用数组
		'saveExt'  => '', //文件保存后缀，空则使用原后缀
		'replace'  => false, //存在同名是否覆盖
		'hash'     => true, //是否生成hash编码
		'callback' => false, //检测文件是否存在回调函数，如果存在返回文件信息数组
    ), //图片上传相关配置（文件上传类配置）

    'PICTURE_UPLOAD_DRIVER'=>'local',
    //本地上传文件驱动配置
    'UPLOAD_LOCAL_CONFIG'=>array(),
    'UPLOAD_BCS_CONFIG'=>array(
        'AccessKey'=>'',
        'SecretKey'=>'',
        'bucket'=>'',
        'rename'=>false
    ),

);