<?php

namespace Home\Controller;
use Think\Upload;
/**
 * 文件控制器
 * 主要用于下载模型的文件上传和下载
 */
class FileController extends HomeController {

    /* 文件上传 */
    public function upload(){
		$return  = array('status' => 1, 'info' => '上传成功', 'data' => '');
		/* 调用文件上传组件上传文件 */
		$File = D('File');
		$file_driver = C('DOWNLOAD_UPLOAD_DRIVER');
		$info = $File->upload(
			$_FILES,
			C('DOWNLOAD_UPLOAD'),
			C('DOWNLOAD_UPLOAD_DRIVER'),
			C("UPLOAD_{$file_driver}_CONFIG")
		);

        /* 记录附件信息 */
        if($info){
            $return['data'] = think_encrypt(json_encode($info['download']));
            $return['info'] = $info['download']['name'];
        } else {
            $return['status'] = 0;
            $return['info']   = $File->getError();
        }

        /* 返回JSON数据 */
        $this->ajaxReturn($return,'JSON');
    }

    /* 下载文件 */
    public function download($id = null){
        if(empty($id) || !is_numeric($id)){
            $this->error('参数错误！');
        }

        $logic = D('Download', 'Logic');
        if(!$logic->download($id)){
            $this->error($logic->getError());
        }

    }
    
    /**
     * 上传图片
     * @author huajie <banhuajie@163.com>
     */
    public function uploadPicture(){
        //TODO: 用户登录检测

        /* 返回标准数据 */
        $return  = array('status' => 1, 'info' => '上传成功', 'data' => '');

        
       
        
        /* 调用文件上传组件上传文件 */
        $Picture = D('Picture');
        $pic_driver = C('PICTURE_UPLOAD_DRIVER');
        $info = $Picture->upload(
            $_FILES,
            C('PICTURE_UPLOAD'),
            C('PICTURE_UPLOAD_DRIVER'),
            C("UPLOAD_{$pic_driver}_CONFIG")
        ); //TODO:上传到远程服务器

        
        
        /* 记录图片信息 */
        if($info){
            $return['status'] = 1;
           
            $info['Picture']['path']=(is_ssl()?'https://':'http://').$_SERVER['HTTP_HOST'].'/'.C('WEB_DIR').$info['Picture']['path'];
            
           // $info['Picture']['path']=$GLOBALS['_root'].$info['Picture']['path'];
            $return = array_merge($info['Picture'], $return);
            $return['info'] =$info[0]['path'];
        } else {
            $return['status'] = 0;
            $return['info']   = $Picture->getError();
        }
        
        
      
     
        $this->ajaxReturn($return);
 
    }
}
