/*!
 * Bootstrap Colorpicker
 * http://mjolnic.github.io/bootstrap-colorpicker/
 *
 * Originally written by (c) 2012 Stefan Petre
 * Licensed under the Apache License v2.0
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * @todo Update DOCS
 */
(function(factory){if(typeof define==="function"&&define.amd){define(["jquery"],factory)}else{if(window.jQuery&&!window.jQuery.fn.colorpicker){factory(window.jQuery)}}}(function($){var Color=function(val){this.value={h:0,s:0,b:0,a:1};this.origFormat=null;if(val){if(val.toLowerCase!==undefined){this.setColor(val)}else{if(val.h!==undefined){this.value=val}}}};Color.prototype={constructor:Color,colors:{"aliceblue":"#f0f8ff","antiquewhite":"#faebd7","aqua":"#00ffff","aquamarine":"#7fffd4","azure":"#f0ffff","beige":"#f5f5dc","bisque":"#ffe4c4","black":"#000000","blanchedalmond":"#ffebcd","blue":"#0000ff","blueviolet":"#8a2be2","brown":"#a52a2a","burlywood":"#deb887","cadetblue":"#5f9ea0","chartreuse":"#7fff00","chocolate":"#d2691e","coral":"#ff7f50","cornflowerblue":"#6495ed","cornsilk":"#fff8dc","crimson":"#dc143c","cyan":"#00ffff","darkblue":"#00008b","darkcyan":"#008b8b","darkgoldenrod":"#b8860b","darkgray":"#a9a9a9","darkgreen":"#006400","darkkhaki":"#bdb76b","darkmagenta":"#8b008b","darkolivegreen":"#556b2f","darkorange":"#ff8c00","darkorchid":"#9932cc","darkred":"#8b0000","darksalmon":"#e9967a","darkseagreen":"#8fbc8f","darkslateblue":"#483d8b","darkslategray":"#2f4f4f","darkturquoise":"#00ced1","darkviolet":"#9400d3","deeppink":"#ff1493","deepskyblue":"#00bfff","dimgray":"#696969","dodgerblue":"#1e90ff","firebrick":"#b22222","floralwhite":"#fffaf0","forestgreen":"#228b22","fuchsia":"#ff00ff","gainsboro":"#dcdcdc","ghostwhite":"#f8f8ff","gold":"#ffd700","goldenrod":"#daa520","gray":"#808080","green":"#008000","greenyellow":"#adff2f","honeydew":"#f0fff0","hotpink":"#ff69b4","indianred ":"#cd5c5c","indigo ":"#4b0082","ivory":"#fffff0","khaki":"#f0e68c","lavender":"#e6e6fa","lavenderblush":"#fff0f5","lawngreen":"#7cfc00","lemonchiffon":"#fffacd","lightblue":"#add8e6","lightcoral":"#f08080","lightcyan":"#e0ffff","lightgoldenrodyellow":"#fafad2","lightgrey":"#d3d3d3","lightgreen":"#90ee90","lightpink":"#ffb6c1","lightsalmon":"#ffa07a","lightseagreen":"#20b2aa","lightskyblue":"#87cefa","lightslategray":"#778899","lightsteelblue":"#b0c4de","lightyellow":"#ffffe0","lime":"#00ff00","limegreen":"#32cd32","linen":"#faf0e6","magenta":"#ff00ff","maroon":"#800000","mediumaquamarine":"#66cdaa","mediumblue":"#0000cd","mediumorchid":"#ba55d3","mediumpurple":"#9370d8","mediumseagreen":"#3cb371","mediumslateblue":"#7b68ee","mediumspringgreen":"#00fa9a","mediumturquoise":"#48d1cc","mediumvioletred":"#c71585","midnightblue":"#191970","mintcream":"#f5fffa","mistyrose":"#ffe4e1","moccasin":"#ffe4b5","navajowhite":"#ffdead","navy":"#000080","oldlace":"#fdf5e6","olive":"#808000","olivedrab":"#6b8e23","orange":"#ffa500","orangered":"#ff4500","orchid":"#da70d6","palegoldenrod":"#eee8aa","palegreen":"#98fb98","paleturquoise":"#afeeee","palevioletred":"#d87093","papayawhip":"#ffefd5","peachpuff":"#ffdab9","peru":"#cd853f","pink":"#ffc0cb","plum":"#dda0dd","powderblue":"#b0e0e6","purple":"#800080","red":"#ff0000","rosybrown":"#bc8f8f","royalblue":"#4169e1","saddlebrown":"#8b4513","salmon":"#fa8072","sandybrown":"#f4a460","seagreen":"#2e8b57","seashell":"#fff5ee","sienna":"#a0522d","silver":"#c0c0c0","skyblue":"#87ceeb","slateblue":"#6a5acd","slategray":"#708090","snow":"#fffafa","springgreen":"#00ff7f","steelblue":"#4682b4","tan":"#d2b48c","teal":"#008080","thistle":"#d8bfd8","tomato":"#ff6347","turquoise":"#40e0d0","violet":"#ee82ee","wheat":"#f5deb3","white":"#ffffff","whitesmoke":"#f5f5f5","yellow":"#ffff00","yellowgreen":"#9acd32"},_sanitizeNumber:function(val){if(typeof val==="number"){return val
}if(isNaN(val)||(val===null)||(val==="")||(val===undefined)){return 1}if(val.toLowerCase!==undefined){return parseFloat(val)}return 1},setColor:function(strVal){strVal=strVal.toLowerCase();this.value=this.stringToHSB(strVal)||{h:0,s:0,b:0,a:1}},stringToHSB:function(strVal){strVal=strVal.toLowerCase();var that=this,result=false;$.each(this.stringParsers,function(i,parser){var match=parser.re.exec(strVal),values=match&&parser.parse.apply(that,[match]),format=parser.format||"rgba";if(values){if(format.match(/hsla?/)){result=that.RGBtoHSB.apply(that,that.HSLtoRGB.apply(that,values))}else{result=that.RGBtoHSB.apply(that,values)}that.origFormat=format;return false}return true});return result},setHue:function(h){this.value.h=1-h},setSaturation:function(s){this.value.s=s},setBrightness:function(b){this.value.b=1-b},setAlpha:function(a){this.value.a=parseInt((1-a)*100,10)/100},toRGB:function(h,s,v,a){h=h||this.value.h;s=s||this.value.s;v=v||this.value.b;a=a||this.value.a;var r,g,b,i,f,p,q,t;if(h&&s===undefined&&v===undefined){s=h.s,v=h.v,h=h.h}i=Math.floor(h*6);f=h*6-i;p=v*(1-s);q=v*(1-f*s);t=v*(1-(1-f)*s);switch(i%6){case 0:r=v,g=t,b=p;break;case 1:r=q,g=v,b=p;break;case 2:r=p,g=v,b=t;break;case 3:r=p,g=q,b=v;break;case 4:r=t,g=p,b=v;break;case 5:r=v,g=p,b=q;break}return{r:Math.floor(r*255),g:Math.floor(g*255),b:Math.floor(b*255),a:a}},toHex:function(h,s,b,a){var rgb=this.toRGB(h,s,b,a);return"#"+((1<<24)|(parseInt(rgb.r)<<16)|(parseInt(rgb.g)<<8)|parseInt(rgb.b)).toString(16).substr(1)},toHSL:function(h,s,b,a){h=h||this.value.h;s=s||this.value.s;b=b||this.value.b;a=a||this.value.a;var H=h,L=(2-s)*b,S=s*b;if(L>0&&L<=1){S/=L}else{S/=2-L}L/=2;if(S>1){S=1}return{h:isNaN(H)?0:H,s:isNaN(S)?0:S,l:isNaN(L)?0:L,a:isNaN(a)?0:a,}},toAlias:function(r,g,b,a){var rgb=this.toHex(r,g,b,a);for(var alias in this.colors){if(this.colors[alias]==rgb){return alias}}return false},RGBtoHSB:function(r,g,b,a){r/=255;g/=255;b/=255;var H,S,V,C;V=Math.max(r,g,b);C=V-Math.min(r,g,b);H=(C===0?null:V===r?(g-b)/C:V===g?(b-r)/C+2:(r-g)/C+4);
H=((H+360)%6)*60/360;S=C===0?0:C/V;return{h:this._sanitizeNumber(H),s:S,b:V,a:this._sanitizeNumber(a)}},HueToRGB:function(p,q,h){if(h<0){h+=1}else{if(h>1){h-=1}}if((h*6)<1){return p+(q-p)*h*6}else{if((h*2)<1){return q}else{if((h*3)<2){return p+(q-p)*((2/3)-h)*6}else{return p}}}},HSLtoRGB:function(h,s,l,a){if(s<0){s=0}var q;if(l<=0.5){q=l*(1+s)}else{q=l+s-(l*s)}var p=2*l-q;var tr=h+(1/3);var tg=h;var tb=h-(1/3);var r=Math.round(this.HueToRGB(p,q,tr)*255);var g=Math.round(this.HueToRGB(p,q,tg)*255);var b=Math.round(this.HueToRGB(p,q,tb)*255);return[r,g,b,this._sanitizeNumber(a)]},toString:function(format){format=format||"rgba";switch(format){case"rgb":var rgb=this.toRGB();return"rgb("+rgb.r+","+rgb.g+","+rgb.b+")";break;case"rgba":var rgb=this.toRGB();return"rgba("+rgb.r+","+rgb.g+","+rgb.b+","+rgb.a+")";break;case"hsl":var hsl=this.toHSL();return"hsl("+Math.round(hsl.h*360)+","+Math.round(hsl.s*100)+"%,"+Math.round(hsl.l*100)+"%)";break;case"hsla":var hsl=this.toHSL();return"hsla("+Math.round(hsl.h*360)+","+Math.round(hsl.s*100)+"%,"+Math.round(hsl.l*100)+"%,"+hsl.a+")";break;case"hex":return this.toHex();break;case"alias":return this.toAlias()||this.toHex();default:return false;break}},stringParsers:[{re:/#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/,format:"hex",parse:function(execResult){return[parseInt(execResult[1],16),parseInt(execResult[2],16),parseInt(execResult[3],16),1]}},{re:/#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/,format:"hex",parse:function(execResult){return[parseInt(execResult[1]+execResult[1],16),parseInt(execResult[2]+execResult[2],16),parseInt(execResult[3]+execResult[3],16),1]}},{re:/rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*?\)/,format:"rgb",parse:function(execResult){return[execResult[1],execResult[2],execResult[3],1]}},{re:/rgb\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*?\)/,format:"rgb",parse:function(execResult){return[2.55*execResult[1],2.55*execResult[2],2.55*execResult[3],1]}},{re:/rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(execResult){return[execResult[1],execResult[2],execResult[3],execResult[4]]
}},{re:/rgba\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(execResult){return[2.55*execResult[1],2.55*execResult[2],2.55*execResult[3],execResult[4]]}},{re:/hsl\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*?\)/,format:"hsl",parse:function(execResult){return[execResult[1]/360,execResult[2]/100,execResult[3]/100,execResult[4]]}},{re:/hsla\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"hsla",parse:function(execResult){return[execResult[1]/360,execResult[2]/100,execResult[3]/100,execResult[4]]}},{re:/^([a-z]{3,})$/,format:"alias",parse:function(execResult){var hexval=this.colorNameToHex(execResult[0])||"#000000";var match=this.stringParsers[0].re.exec(hexval),values=match&&this.stringParsers[0].parse.apply(this,[match]);return values}}],colorNameToHex:function(name){if(typeof this.colors[name.toLowerCase()]!=="undefined"){return this.colors[name.toLowerCase()]}return false}};var defaults={horizontal:false,inline:false,color:false,format:false,input:"input",container:false,component:".add-on, .input-group-addon",sliders:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:0,maxTop:100,callLeft:false,callTop:"setHue"},alpha:{maxLeft:0,maxTop:100,callLeft:false,callTop:"setAlpha"}},slidersHorz:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:100,maxTop:0,callLeft:"setHue",callTop:false},alpha:{maxLeft:100,maxTop:0,callLeft:"setAlpha",callTop:false}},template:'<div class="colorpicker dropdown-menu">'+'<div class="colorpicker-saturation"><i><b></b></i></div>'+'<div class="colorpicker-hue"><i></i></div>'+'<div class="colorpicker-alpha"><i></i></div>'+'<div class="colorpicker-color"><div /></div>'+"</div>"};var Colorpicker=function(element,options){this.element=$(element).addClass("colorpicker-element");this.options=$.extend({},defaults,this.element.data(),options);
this.component=this.options.component;this.component=(this.component!==false)?this.element.find(this.component):false;if(this.component&&(this.component.length===0)){this.component=false}this.container=(this.options.container===true)?this.element:this.options.container;this.container=(this.container!==false)?$(this.container):false;this.input=this.element.is("input")?this.element:(this.options.input?this.element.find(this.options.input):false);if(this.input&&(this.input.length===0)){this.input=false}this.color=new Color(this.options.color!==false?this.options.color:this.getValue());this.format=this.options.format!==false?this.options.format:this.color.origFormat;this.picker=$(this.options.template);if(this.options.inline){this.picker.addClass("colorpicker-inline colorpicker-visible")}else{this.picker.addClass("colorpicker-hidden")}if(this.options.horizontal){this.picker.addClass("colorpicker-horizontal")}if(this.format==="rgba"||this.format==="hsla"){this.picker.addClass("colorpicker-with-alpha")}this.picker.on("mousedown.colorpicker",$.proxy(this.mousedown,this));this.picker.appendTo(this.container?this.container:$("body"));if(this.input!==false){this.input.on({"keyup.colorpicker":$.proxy(this.keyup,this)});if(this.component===false){this.element.on({"focus.colorpicker":$.proxy(this.show,this)})}if(this.options.inline===false){this.element.on({"focusout.colorpicker":$.proxy(this.hide,this)})}}if(this.component!==false){this.component.on({"click.colorpicker":$.proxy(this.show,this)})}if((this.input===false)&&(this.component===false)){this.element.on({"click.colorpicker":$.proxy(this.show,this)})}this.update();$($.proxy(function(){this.element.trigger("create")},this))};Colorpicker.version="2.0.0-beta";Colorpicker.Color=Color;Colorpicker.prototype={constructor:Colorpicker,destroy:function(){this.picker.remove();this.element.removeData("colorpicker").off(".colorpicker");if(this.input!==false){this.input.off(".colorpicker")}if(this.component!==false){this.component.off(".colorpicker")
}this.element.removeClass("colorpicker-element");this.element.trigger({type:"destroy"})},reposition:function(){if(this.options.inline!==false){return false}var type=this.container&&this.container[0]!==document.body?"position":"offset";var offset=this.component?this.component[type]():this.element[type]();this.picker.css({top:offset.top+(this.component?this.component.outerHeight():this.element.outerHeight()),left:offset.left})},show:function(e){if(this.isDisabled()){return false}this.picker.addClass("colorpicker-visible").removeClass("colorpicker-hidden");this.reposition();$(window).on("resize.colorpicker",$.proxy(this.reposition,this));if(!this.hasInput()&&e){if(e.stopPropagation&&e.preventDefault){e.stopPropagation();e.preventDefault()}}if(this.options.inline===false){$(window.document).on({"mousedown.colorpicker":$.proxy(this.hide,this)})}this.element.trigger({type:"showPicker",color:this.color})},hide:function(){this.picker.addClass("colorpicker-hidden").removeClass("colorpicker-visible");$(window).off("resize.colorpicker",this.reposition);$(document).off({"mousedown.colorpicker":this.hide});this.update();this.element.trigger({type:"hidePicker",color:this.color})},updateData:function(val){val=val||this.color.toString(this.format);this.element.data("color",val);return val},updateInput:function(val){val=val||this.color.toString(this.format);if(this.input!==false){this.input.prop("value",val)}return val},updatePicker:function(val){if(val!==undefined){this.color=new Color(val)}var sl=(this.options.horizontal===false)?this.options.sliders:this.options.slidersHorz;var icns=this.picker.find("i");if(icns.length===0){return}if(this.options.horizontal===false){sl=this.options.sliders;icns.eq(1).css("top",sl.hue.maxTop*(1-this.color.value.h)).end().eq(2).css("top",sl.alpha.maxTop*(1-this.color.value.a))}else{sl=this.options.slidersHorz;icns.eq(1).css("left",sl.hue.maxLeft*(1-this.color.value.h)).end().eq(2).css("left",sl.alpha.maxLeft*(1-this.color.value.a))}icns.eq(0).css({"top":sl.saturation.maxTop-this.color.value.b*sl.saturation.maxTop,"left":this.color.value.s*sl.saturation.maxLeft});
this.picker.find(".colorpicker-saturation").css("backgroundColor",this.color.toHex(this.color.value.h,1,1,1));this.picker.find(".colorpicker-alpha").css("backgroundColor",this.color.toHex());this.picker.find(".colorpicker-color, .colorpicker-color div").css("backgroundColor",this.color.toString(this.format));return val},updateComponent:function(val){val=val||this.color.toString(this.format);if(this.component!==false){var icn=this.component.find("i").eq(0);if(icn.length>0){icn.css({"backgroundColor":val})}else{this.component.css({"backgroundColor":val})}}return val},update:function(force){var val=this.updateComponent();if((this.getValue(false)!==false)||(force===true)){this.updateInput(val);this.updateData(val)}this.updatePicker();return val},setValue:function(val){this.color=new Color(val);this.update();this.element.trigger({type:"changeColor",color:this.color,value:val})},getValue:function(defaultValue){defaultValue=(defaultValue===undefined)?"#000000":defaultValue;var val;if(this.hasInput()){val=this.input.val()}else{val=this.element.data("color")}if((val===undefined)||(val==="")||(val===null)){val=defaultValue}return val},hasInput:function(){return(this.input!==false)},isDisabled:function(){if(this.hasInput()){return(this.input.prop("disabled")===true)}return false},disable:function(){if(this.hasInput()){this.input.prop("disabled",true);return true}return false},enable:function(){if(this.hasInput()){this.input.prop("disabled",false);return true}return false},currentSlider:null,mousePointer:{left:0,top:0},mousedown:function(e){e.stopPropagation();e.preventDefault();var target=$(e.target);var zone=target.closest("div");var sl=this.options.horizontal?this.options.slidersHorz:this.options.sliders;if(!zone.is(".colorpicker")){if(zone.is(".colorpicker-saturation")){this.currentSlider=$.extend({},sl.saturation)}else{if(zone.is(".colorpicker-hue")){this.currentSlider=$.extend({},sl.hue)}else{if(zone.is(".colorpicker-alpha")){this.currentSlider=$.extend({},sl.alpha)}else{return false
}}}var offset=zone.offset();this.currentSlider.guide=zone.find("i")[0].style;this.currentSlider.left=e.pageX-offset.left;this.currentSlider.top=e.pageY-offset.top;this.mousePointer={left:e.pageX,top:e.pageY};$(document).on({"mousemove.colorpicker":$.proxy(this.mousemove,this),"mouseup.colorpicker":$.proxy(this.mouseup,this)}).trigger("mousemove")}return false},mousemove:function(e){e.stopPropagation();e.preventDefault();var left=Math.max(0,Math.min(this.currentSlider.maxLeft,this.currentSlider.left+((e.pageX||this.mousePointer.left)-this.mousePointer.left)));var top=Math.max(0,Math.min(this.currentSlider.maxTop,this.currentSlider.top+((e.pageY||this.mousePointer.top)-this.mousePointer.top)));this.currentSlider.guide.left=left+"px";this.currentSlider.guide.top=top+"px";if(this.currentSlider.callLeft){this.color[this.currentSlider.callLeft].call(this.color,left/100)}if(this.currentSlider.callTop){this.color[this.currentSlider.callTop].call(this.color,top/100)}this.update(true);this.element.trigger({type:"changeColor",color:this.color});return false},mouseup:function(e){e.stopPropagation();e.preventDefault();$(document).off({"mousemove.colorpicker":this.mousemove,"mouseup.colorpicker":this.mouseup});return false},keyup:function(e){if((e.keyCode===38)){if(this.color.value.a<1){this.color.value.a=Math.round((this.color.value.a+0.01)*100)/100}this.update(true)}else{if((e.keyCode===40)){if(this.color.value.a>0){this.color.value.a=Math.round((this.color.value.a-0.01)*100)/100}this.update(true)}else{var val=this.input.val();this.color=new Color(val);if(this.getValue(false)!==false){this.updateData();this.updateComponent();this.updatePicker()}}}this.element.trigger({type:"changeColor",color:this.color,value:val})}};$.colorpicker=Colorpicker;$.fn.colorpicker=function(option){var pickerArgs=arguments;return this.each(function(){var $this=$(this),inst=$this.data("colorpicker"),options=((typeof option==="object")?option:{});if((!inst)&&(typeof option!=="string")){$this.data("colorpicker",new Colorpicker(this,options))
}else{if(typeof option==="string"){inst[option].apply(inst,Array.prototype.slice.call(pickerArgs,1))}}})};$.fn.colorpicker.constructor=Colorpicker}));
(function(e){var z=!1,E=!1,L=5000,M=2000,y=0,N=function(){var e=document.getElementsByTagName("script"),e=e[e.length-1].src.split("?")[0];return 0<e.split("/").length?e.split("/").slice(0,-1).join("/")+"/":""}(),H=["ms","moz","webkit","o"],v=window.requestAnimationFrame||!1,w=window.cancelAnimationFrame||!1;if(!v){for(var O in H){var F=H[O];v||(v=window[F+"RequestAnimationFrame"]);w||(w=window[F+"CancelAnimationFrame"]||window[F+"CancelRequestAnimationFrame"])}}var A=window.MutationObserver||window.WebKitMutationObserver||!1,I={zindex:"auto",cursoropacitymin:0,cursoropacitymax:1,cursorcolor:"#424242",cursorwidth:"5px",cursorborder:"1px solid #fff",cursorborderradius:"5px",scrollspeed:60,mousescrollstep:24,touchbehavior:!1,hwacceleration:!0,usetransition:!0,boxzoom:!1,dblclickzoom:!0,gesturezoom:!0,grabcursorenabled:!0,autohidemode:!0,background:"",iframeautoresize:!0,cursorminheight:32,preservenativescrolling:!0,railoffset:!1,bouncescroll:!0,spacebarenabled:!0,railpadding:{top:0,right:0,left:0,bottom:0},disableoutline:!0,horizrailenabled:!0,railalign:"right",railvalign:"bottom",enabletranslate3d:!0,enablemousewheel:!0,enablekeyboard:!0,smoothscroll:!0,sensitiverail:!0,enablemouselockapi:!0,cursorfixedheight:!1,directionlockdeadzone:6,hidecursordelay:400,nativeparentscrolling:!0,enablescrollonselection:!0,overflowx:!0,overflowy:!0,cursordragspeed:0.3,rtlmode:!1,cursordragontouch:!1,oneaxismousemode:"auto"},G=!1,P=function(){if(G){return G}var e=document.createElement("DIV"),c={haspointerlock:"pointerLockElement" in document||"mozPointerLockElement" in document||"webkitPointerLockElement" in document};c.isopera="opera" in window;c.isopera12=c.isopera&&"getUserMedia" in navigator;c.isoperamini="[object OperaMini]"===Object.prototype.toString.call(window.operamini);c.isie="all" in document&&"attachEvent" in e&&!c.isopera;c.isieold=c.isie&&!("msInterpolationMode" in e.style);c.isie7=c.isie&&!c.isieold&&(!("documentMode" in document)||7==document.documentMode);c.isie8=c.isie&&"documentMode" in document&&8==document.documentMode;
c.isie9=c.isie&&"performance" in window&&9<=document.documentMode;c.isie10=c.isie&&"performance" in window&&10<=document.documentMode;c.isie9mobile=/iemobile.9/i.test(navigator.userAgent);c.isie9mobile&&(c.isie9=!1);c.isie7mobile=!c.isie9mobile&&c.isie7&&/iemobile/i.test(navigator.userAgent);c.ismozilla="MozAppearance" in e.style;c.iswebkit="WebkitAppearance" in e.style;c.ischrome="chrome" in window;c.ischrome22=c.ischrome&&c.haspointerlock;c.ischrome26=c.ischrome&&"transition" in e.style;c.cantouch="ontouchstart" in document.documentElement||"ontouchstart" in window;c.hasmstouch=window.navigator.msPointerEnabled||!1;c.ismac=/^mac$/i.test(navigator.platform);c.isios=c.cantouch&&/iphone|ipad|ipod/i.test(navigator.platform);c.isios4=c.isios&&!("seal" in Object);c.isandroid=/android/i.test(navigator.userAgent);c.trstyle=!1;c.hastransform=!1;c.hastranslate3d=!1;c.transitionstyle=!1;c.hastransition=!1;c.transitionend=!1;for(var k=["transform","msTransform","webkitTransform","MozTransform","OTransform"],l=0;l<k.length;l++){if("undefined"!=typeof e.style[k[l]]){c.trstyle=k[l];break}}c.hastransform=!1!=c.trstyle;c.hastransform&&(e.style[c.trstyle]="translate3d(1px,2px,3px)",c.hastranslate3d=/translate3d/.test(e.style[c.trstyle]));c.transitionstyle=!1;c.prefixstyle="";c.transitionend=!1;for(var k="transition webkitTransition MozTransition OTransition OTransition msTransition KhtmlTransition".split(" "),q=" -webkit- -moz- -o- -o -ms- -khtml-".split(" "),t="transitionend webkitTransitionEnd transitionend otransitionend oTransitionEnd msTransitionEnd KhtmlTransitionEnd".split(" "),l=0;l<k.length;l++){if(k[l] in e.style){c.transitionstyle=k[l];c.prefixstyle=q[l];c.transitionend=t[l];break}}c.ischrome26&&(c.prefixstyle=q[1]);c.hastransition=c.transitionstyle;a:{k=["-moz-grab","-webkit-grab","grab"];if(c.ischrome&&!c.ischrome22||c.isie){k=[]}for(l=0;l<k.length;l++){if(q=k[l],e.style.cursor=q,e.style.cursor==q){k=q;break a}}k="url(http://www.google.com/intl/en_ALL/mapfiles/openhand.cur),n-resize"
}c.cursorgrabvalue=k;c.hasmousecapture="setCapture" in e;c.hasMutationObserver=!1!==A;return G=c},Q=function(h,c){function k(){var d=b.win;if("zIndex" in d){return d.zIndex()}for(;0<d.length&&9!=d[0].nodeType;){var c=d.css("zIndex");if(!isNaN(c)&&0!=c){return parseInt(c)}d=d.parent()}return !1}function l(d,c,f){c=d.css(c);d=parseFloat(c);return isNaN(d)?(d=u[c]||0,f=3==d?f?b.win.outerHeight()-b.win.innerHeight():b.win.outerWidth()-b.win.innerWidth():1,b.isie8&&d&&(d+=1),f?d:0):d}function q(d,c,f,g){b._bind(d,c,function(b){b=b?b:window.event;var g={original:b,target:b.target||b.srcElement,type:"wheel",deltaMode:"MozMousePixelScroll"==b.type?0:1,deltaX:0,deltaZ:0,preventDefault:function(){b.preventDefault?b.preventDefault():b.returnValue=!1;return !1},stopImmediatePropagation:function(){b.stopImmediatePropagation?b.stopImmediatePropagation():b.cancelBubble=!0}};"mousewheel"==c?(g.deltaY=-0.025*b.wheelDelta,b.wheelDeltaX&&(g.deltaX=-0.025*b.wheelDeltaX)):g.deltaY=b.detail;return f.call(d,g)},g)}function t(d,c,f){var g,e;0==d.deltaMode?(g=-Math.floor(d.deltaX*(b.opt.mousescrollstep/54)),e=-Math.floor(d.deltaY*(b.opt.mousescrollstep/54))):1==d.deltaMode&&(g=-Math.floor(d.deltaX*b.opt.mousescrollstep),e=-Math.floor(d.deltaY*b.opt.mousescrollstep));c&&(b.opt.oneaxismousemode&&0==g&&e)&&(g=e,e=0);g&&(b.scrollmom&&b.scrollmom.stop(),b.lastdeltax+=g,b.debounced("mousewheelx",function(){var d=b.lastdeltax;b.lastdeltax=0;b.rail.drag||b.doScrollLeftBy(d)},120));if(e){if(b.opt.nativeparentscrolling&&f&&!b.ispage&&!b.zoomactive){if(0>e){if(b.getScrollTop()>=b.page.maxh){return !0}}else{if(0>=b.getScrollTop()){return !0}}}b.scrollmom&&b.scrollmom.stop();b.lastdeltay+=e;b.debounced("mousewheely",function(){var d=b.lastdeltay;b.lastdeltay=0;b.rail.drag||b.doScrollBy(d)},120)}d.stopImmediatePropagation();return d.preventDefault()}var b=this;this.version="3.5.0";this.name="nicescroll";this.me=c;this.opt={doc:e("body"),win:!1};e.extend(this.opt,I);this.opt.snapbackspeed=80;if(h){for(var p in b.opt){"undefined"!=typeof h[p]&&(b.opt[p]=h[p])
}}this.iddoc=(this.doc=b.opt.doc)&&this.doc[0]?this.doc[0].id||"":"";this.ispage=/BODY|HTML/.test(b.opt.win?b.opt.win[0].nodeName:this.doc[0].nodeName);this.haswrapper=!1!==b.opt.win;this.win=b.opt.win||(this.ispage?e(window):this.doc);this.docscroll=this.ispage&&!this.haswrapper?e(window):this.win;this.body=e("body");this.iframe=this.isfixed=this.viewport=!1;this.isiframe="IFRAME"==this.doc[0].nodeName&&"IFRAME"==this.win[0].nodeName;this.istextarea="TEXTAREA"==this.win[0].nodeName;this.forcescreen=!1;this.canshowonmouseevent="scroll"!=b.opt.autohidemode;this.page=this.view=this.onzoomout=this.onzoomin=this.onscrollcancel=this.onscrollend=this.onscrollstart=this.onclick=this.ongesturezoom=this.onkeypress=this.onmousewheel=this.onmousemove=this.onmouseup=this.onmousedown=!1;this.scroll={x:0,y:0};this.scrollratio={x:0,y:0};this.cursorheight=20;this.scrollvaluemax=0;this.observerremover=this.observer=this.scrollmom=this.scrollrunning=this.checkrtlmode=!1;do{this.id="ascrail"+M++}while(document.getElementById(this.id));this.hasmousefocus=this.hasfocus=this.zoomactive=this.zoom=this.selectiondrag=this.cursorfreezed=this.cursor=this.rail=!1;this.visibility=!0;this.hidden=this.locked=!1;this.cursoractive=!0;this.overflowx=b.opt.overflowx;this.overflowy=b.opt.overflowy;this.nativescrollingarea=!1;this.checkarea=0;this.events=[];this.saved={};this.delaylist={};this.synclist={};this.lastdeltay=this.lastdeltax=0;this.detected=P();var g=e.extend({},this.detected);this.ishwscroll=(this.canhwscroll=g.hastransform&&b.opt.hwacceleration)&&b.haswrapper;this.istouchcapable=!1;g.cantouch&&(g.ischrome&&!g.isios&&!g.isandroid)&&(this.istouchcapable=!0,g.cantouch=!1);g.cantouch&&(g.ismozilla&&!g.isios&&!g.isandroid)&&(this.istouchcapable=!0,g.cantouch=!1);b.opt.enablemouselockapi||(g.hasmousecapture=!1,g.haspointerlock=!1);this.delayed=function(d,c,f,g){var e=b.delaylist[d],k=(new Date).getTime();if(!g&&e&&e.tt){return !1}e&&e.tt&&clearTimeout(e.tt);if(e&&e.last+f>k&&!e.tt){b.delaylist[d]={last:k+f,tt:setTimeout(function(){b.delaylist[d].tt=0;
c.call()},f)}}else{if(!e||!e.tt){b.delaylist[d]={last:k,tt:0},setTimeout(function(){c.call()},0)}}};this.debounced=function(d,c,f){var g=b.delaylist[d];(new Date).getTime();b.delaylist[d]=c;g||setTimeout(function(){var c=b.delaylist[d];b.delaylist[d]=!1;c.call()},f)};this.synched=function(d,c){b.synclist[d]=c;(function(){b.onsync||(v(function(){b.onsync=!1;for(d in b.synclist){var c=b.synclist[d];c&&c.call(b);b.synclist[d]=!1}}),b.onsync=!0)})();return d};this.unsynched=function(d){b.synclist[d]&&(b.synclist[d]=!1)};this.css=function(d,c){for(var f in c){b.saved.css.push([d,f,d.css(f)]),d.css(f,c[f])}};this.scrollTop=function(d){return"undefined"==typeof d?b.getScrollTop():b.setScrollTop(d)};this.scrollLeft=function(d){return"undefined"==typeof d?b.getScrollLeft():b.setScrollLeft(d)};BezierClass=function(b,c,f,g,e,k,l){this.st=b;this.ed=c;this.spd=f;this.p1=g||0;this.p2=e||1;this.p3=k||0;this.p4=l||1;this.ts=(new Date).getTime();this.df=this.ed-this.st};BezierClass.prototype={B2:function(b){return 3*b*b*(1-b)},B3:function(b){return 3*b*(1-b)*(1-b)},B4:function(b){return(1-b)*(1-b)*(1-b)},getNow:function(){var b=1-((new Date).getTime()-this.ts)/this.spd,c=this.B2(b)+this.B3(b)+this.B4(b);return 0>b?this.ed:this.st+Math.round(this.df*c)},update:function(b,c){this.st=this.getNow();this.ed=b;this.spd=c;this.ts=(new Date).getTime();this.df=this.ed-this.st;return this}};if(this.ishwscroll){this.doc.translate={x:0,y:0,tx:"0px",ty:"0px"};g.hastranslate3d&&g.isios&&this.doc.css("-webkit-backface-visibility","hidden");var s=function(){var d=b.doc.css(g.trstyle);return d&&"matrix"==d.substr(0,6)?d.replace(/^.*\((.*)\)$/g,"$1").replace(/px/g,"").split(/, +/):!1};this.getScrollTop=function(d){if(!d){if(d=s()){return 16==d.length?-d[13]:-d[5]}if(b.timerscroll&&b.timerscroll.bz){return b.timerscroll.bz.getNow()}}return b.doc.translate.y};this.getScrollLeft=function(d){if(!d){if(d=s()){return 16==d.length?-d[12]:-d[4]}if(b.timerscroll&&b.timerscroll.bh){return b.timerscroll.bh.getNow()
}}return b.doc.translate.x};this.notifyScrollEvent=document.createEvent?function(b){var c=document.createEvent("UIEvents");c.initUIEvent("scroll",!1,!0,window,1);b.dispatchEvent(c)}:document.fireEvent?function(b){var c=document.createEventObject();b.fireEvent("onscroll");c.cancelBubble=!0}:function(b,c){};g.hastranslate3d&&b.opt.enabletranslate3d?(this.setScrollTop=function(d,c){b.doc.translate.y=d;b.doc.translate.ty=-1*d+"px";b.doc.css(g.trstyle,"translate3d("+b.doc.translate.tx+","+b.doc.translate.ty+",0px)");c||b.notifyScrollEvent(b.win[0])},this.setScrollLeft=function(d,c){b.doc.translate.x=d;b.doc.translate.tx=-1*d+"px";b.doc.css(g.trstyle,"translate3d("+b.doc.translate.tx+","+b.doc.translate.ty+",0px)");c||b.notifyScrollEvent(b.win[0])}):(this.setScrollTop=function(d,c){b.doc.translate.y=d;b.doc.translate.ty=-1*d+"px";b.doc.css(g.trstyle,"translate("+b.doc.translate.tx+","+b.doc.translate.ty+")");c||b.notifyScrollEvent(b.win[0])},this.setScrollLeft=function(d,c){b.doc.translate.x=d;b.doc.translate.tx=-1*d+"px";b.doc.css(g.trstyle,"translate("+b.doc.translate.tx+","+b.doc.translate.ty+")");c||b.notifyScrollEvent(b.win[0])})}else{this.getScrollTop=function(){return b.docscroll.scrollTop()},this.setScrollTop=function(d){return b.docscroll.scrollTop(d)},this.getScrollLeft=function(){return b.docscroll.scrollLeft()},this.setScrollLeft=function(d){return b.docscroll.scrollLeft(d)}}this.getTarget=function(b){return !b?!1:b.target?b.target:b.srcElement?b.srcElement:!1};this.hasParent=function(b,c){if(!b){return !1}for(var f=b.target||b.srcElement||b||!1;f&&f.id!=c;){f=f.parentNode||!1}return !1!==f};var u={thin:1,medium:3,thick:5};this.getOffset=function(){if(b.isfixed){return{top:parseFloat(b.win.css("top")),left:parseFloat(b.win.css("left"))}}if(!b.viewport){return b.win.offset()}var d=b.win.offset(),c=b.viewport.offset();return{top:d.top-c.top+b.viewport.scrollTop(),left:d.left-c.left+b.viewport.scrollLeft()}};this.updateScrollBar=function(d){if(b.ishwscroll){b.rail.css({height:b.win.innerHeight()}),b.railh&&b.railh.css({width:b.win.innerWidth()})
}else{var c=b.getOffset(),f=c.top,g=c.left,f=f+l(b.win,"border-top-width",!0);b.win.outerWidth();b.win.innerWidth();var g=g+(b.rail.align?b.win.outerWidth()-l(b.win,"border-right-width")-b.rail.width:l(b.win,"border-left-width")),e=b.opt.railoffset;e&&(e.top&&(f+=e.top),b.rail.align&&e.left&&(g+=e.left));b.locked||b.rail.css({top:f,left:g,height:d?d.h:b.win.innerHeight()});b.zoom&&b.zoom.css({top:f+1,left:1==b.rail.align?g-20:g+b.rail.width+4});b.railh&&!b.locked&&(f=c.top,g=c.left,d=b.railh.align?f+l(b.win,"border-top-width",!0)+b.win.innerHeight()-b.railh.height:f+l(b.win,"border-top-width",!0),g+=l(b.win,"border-left-width"),b.railh.css({top:d,left:g,width:b.railh.width}))}};this.doRailClick=function(d,c,f){var g;b.locked||(b.cancelEvent(d),c?(c=f?b.doScrollLeft:b.doScrollTop,g=f?(d.pageX-b.railh.offset().left-b.cursorwidth/2)*b.scrollratio.x:(d.pageY-b.rail.offset().top-b.cursorheight/2)*b.scrollratio.y,c(g)):(c=f?b.doScrollLeftBy:b.doScrollBy,g=f?b.scroll.x:b.scroll.y,d=f?d.pageX-b.railh.offset().left:d.pageY-b.rail.offset().top,f=f?b.view.w:b.view.h,g>=d?c(f):c(-f)))};b.hasanimationframe=v;b.hascancelanimationframe=w;b.hasanimationframe?b.hascancelanimationframe||(w=function(){b.cancelAnimationFrame=!0}):(v=function(b){return setTimeout(b,15-Math.floor(+new Date/1000)%16)},w=clearInterval);this.init=function(){b.saved.css=[];if(g.isie7mobile||g.isoperamini){return !0}g.hasmstouch&&b.css(b.ispage?e("html"):b.win,{"-ms-touch-action":"none"});b.zindex="auto";b.zindex=!b.ispage&&"auto"==b.opt.zindex?k()||"auto":b.opt.zindex;!b.ispage&&"auto"!=b.zindex&&b.zindex>y&&(y=b.zindex);b.isie&&(0==b.zindex&&"auto"==b.opt.zindex)&&(b.zindex="auto");if(!b.ispage||!g.cantouch&&!g.isieold&&!g.isie9mobile){var d=b.docscroll;b.ispage&&(d=b.haswrapper?b.win:b.doc);g.isie9mobile||b.css(d,{"overflow-y":"hidden"});b.ispage&&g.isie7&&("BODY"==b.doc[0].nodeName?b.css(e("html"),{"overflow-y":"hidden"}):"HTML"==b.doc[0].nodeName&&b.css(e("body"),{"overflow-y":"hidden"}));g.isios&&(!b.ispage&&!b.haswrapper)&&b.css(e("body"),{"-webkit-overflow-scrolling":"touch"});
var c=e(document.createElement("div"));c.css({position:"relative",top:0,"float":"right",width:b.opt.cursorwidth,height:"0px","background-color":b.opt.cursorcolor,border:b.opt.cursorborder,"background-clip":"padding-box","-webkit-border-radius":b.opt.cursorborderradius,"-moz-border-radius":b.opt.cursorborderradius,"border-radius":b.opt.cursorborderradius});c.hborder=parseFloat(c.outerHeight()-c.innerHeight());b.cursor=c;var f=e(document.createElement("div"));f.attr("id",b.id);f.addClass("nicescroll-rails");var l,h,x=["left","right"],q;for(q in x){h=x[q],(l=b.opt.railpadding[h])?f.css("padding-"+h,l+"px"):b.opt.railpadding[h]=0}f.append(c);f.width=Math.max(parseFloat(b.opt.cursorwidth),c.outerWidth())+b.opt.railpadding.left+b.opt.railpadding.right;f.css({width:f.width+"px",zIndex:b.zindex,background:b.opt.background,cursor:"default"});f.visibility=!0;f.scrollable=!0;f.align="left"==b.opt.railalign?0:1;b.rail=f;c=b.rail.drag=!1;b.opt.boxzoom&&(!b.ispage&&!g.isieold)&&(c=document.createElement("div"),b.bind(c,"click",b.doZoom),b.zoom=e(c),b.zoom.css({cursor:"pointer","z-index":b.zindex,backgroundImage:"url("+N+"zoomico.png)",height:18,width:18,backgroundPosition:"0px 0px"}),b.opt.dblclickzoom&&b.bind(b.win,"dblclick",b.doZoom),g.cantouch&&b.opt.gesturezoom&&(b.ongesturezoom=function(d){1.5<d.scale&&b.doZoomIn(d);0.8>d.scale&&b.doZoomOut(d);return b.cancelEvent(d)},b.bind(b.win,"gestureend",b.ongesturezoom)));b.railh=!1;if(b.opt.horizrailenabled){b.css(d,{"overflow-x":"hidden"});c=e(document.createElement("div"));c.css({position:"relative",top:0,height:b.opt.cursorwidth,width:"0px","background-color":b.opt.cursorcolor,border:b.opt.cursorborder,"background-clip":"padding-box","-webkit-border-radius":b.opt.cursorborderradius,"-moz-border-radius":b.opt.cursorborderradius,"border-radius":b.opt.cursorborderradius});c.wborder=parseFloat(c.outerWidth()-c.innerWidth());b.cursorh=c;var m=e(document.createElement("div"));m.attr("id",b.id+"-hr");m.addClass("nicescroll-rails");m.height=Math.max(parseFloat(b.opt.cursorwidth),c.outerHeight());
m.css({height:m.height+"px",zIndex:b.zindex,background:b.opt.background});m.append(c);m.visibility=!0;m.scrollable=!0;m.align="top"==b.opt.railvalign?0:1;b.railh=m;b.railh.drag=!1}b.ispage?(f.css({position:"fixed",top:"0px",height:"100%"}),f.align?f.css({right:"0px"}):f.css({left:"0px"}),b.body.append(f),b.railh&&(m.css({position:"fixed",left:"0px",width:"100%"}),m.align?m.css({bottom:"0px"}):m.css({top:"0px"}),b.body.append(m))):(b.ishwscroll?("static"==b.win.css("position")&&b.css(b.win,{position:"relative"}),d="HTML"==b.win[0].nodeName?b.body:b.win,b.zoom&&(b.zoom.css({position:"absolute",top:1,right:0,"margin-right":f.width+4}),d.append(b.zoom)),f.css({position:"absolute",top:0}),f.align?f.css({right:0}):f.css({left:0}),d.append(f),m&&(m.css({position:"absolute",left:0,bottom:0}),m.align?m.css({bottom:0}):m.css({top:0}),d.append(m))):(b.isfixed="fixed"==b.win.css("position"),d=b.isfixed?"fixed":"absolute",b.isfixed||(b.viewport=b.getViewport(b.win[0])),b.viewport&&(b.body=b.viewport,!1==/fixed|relative|absolute/.test(b.viewport.css("position"))&&b.css(b.viewport,{position:"relative"})),f.css({position:d}),b.zoom&&b.zoom.css({position:d}),b.updateScrollBar(),b.body.append(f),b.zoom&&b.body.append(b.zoom),b.railh&&(m.css({position:d}),b.body.append(m))),g.isios&&b.css(b.win,{"-webkit-tap-highlight-color":"rgba(0,0,0,0)","-webkit-touch-callout":"none"}),g.isie&&b.opt.disableoutline&&b.win.attr("hideFocus","true"),g.iswebkit&&b.opt.disableoutline&&b.win.css({outline:"none"}));!1===b.opt.autohidemode?(b.autohidedom=!1,b.rail.css({opacity:b.opt.cursoropacitymax}),b.railh&&b.railh.css({opacity:b.opt.cursoropacitymax})):!0===b.opt.autohidemode||"leave"===b.opt.autohidemode?(b.autohidedom=e().add(b.rail),g.isie8&&(b.autohidedom=b.autohidedom.add(b.cursor)),b.railh&&(b.autohidedom=b.autohidedom.add(b.railh)),b.railh&&g.isie8&&(b.autohidedom=b.autohidedom.add(b.cursorh))):"scroll"==b.opt.autohidemode?(b.autohidedom=e().add(b.rail),b.railh&&(b.autohidedom=b.autohidedom.add(b.railh))):"cursor"==b.opt.autohidemode?(b.autohidedom=e().add(b.cursor),b.railh&&(b.autohidedom=b.autohidedom.add(b.cursorh))):"hidden"==b.opt.autohidemode&&(b.autohidedom=!1,b.hide(),b.locked=!1);
if(g.isie9mobile){b.scrollmom=new J(b),b.onmangotouch=function(d){d=b.getScrollTop();var c=b.getScrollLeft();if(d==b.scrollmom.lastscrolly&&c==b.scrollmom.lastscrollx){return !0}var f=d-b.mangotouch.sy,g=c-b.mangotouch.sx;if(0!=Math.round(Math.sqrt(Math.pow(g,2)+Math.pow(f,2)))){var n=0>f?-1:1,e=0>g?-1:1,k=+new Date;b.mangotouch.lazy&&clearTimeout(b.mangotouch.lazy);80<k-b.mangotouch.tm||b.mangotouch.dry!=n||b.mangotouch.drx!=e?(b.scrollmom.stop(),b.scrollmom.reset(c,d),b.mangotouch.sy=d,b.mangotouch.ly=d,b.mangotouch.sx=c,b.mangotouch.lx=c,b.mangotouch.dry=n,b.mangotouch.drx=e,b.mangotouch.tm=k):(b.scrollmom.stop(),b.scrollmom.update(b.mangotouch.sx-g,b.mangotouch.sy-f),b.mangotouch.tm=k,f=Math.max(Math.abs(b.mangotouch.ly-d),Math.abs(b.mangotouch.lx-c)),b.mangotouch.ly=d,b.mangotouch.lx=c,2<f&&(b.mangotouch.lazy=setTimeout(function(){b.mangotouch.lazy=!1;b.mangotouch.dry=0;b.mangotouch.drx=0;b.mangotouch.tm=0;b.scrollmom.doMomentum(30)},100)))}},f=b.getScrollTop(),m=b.getScrollLeft(),b.mangotouch={sy:f,ly:f,dry:0,sx:m,lx:m,drx:0,lazy:!1,tm:0},b.bind(b.docscroll,"scroll",b.onmangotouch)}else{if(g.cantouch||b.istouchcapable||b.opt.touchbehavior||g.hasmstouch){b.scrollmom=new J(b);b.ontouchstart=function(d){if(d.pointerType&&2!=d.pointerType){return !1}if(!b.locked){if(g.hasmstouch){for(var c=d.target?d.target:!1;c;){var f=e(c).getNiceScroll();if(0<f.length&&f[0].me==b.me){break}if(0<f.length){return !1}if("DIV"==c.nodeName&&c.id==b.id){break}c=c.parentNode?c.parentNode:!1}}b.cancelScroll();if((c=b.getTarget(d))&&/INPUT/i.test(c.nodeName)&&/range/i.test(c.type)){return b.stopPropagation(d)}!("clientX" in d)&&"changedTouches" in d&&(d.clientX=d.changedTouches[0].clientX,d.clientY=d.changedTouches[0].clientY);b.forcescreen&&(f=d,d={original:d.original?d.original:d},d.clientX=f.screenX,d.clientY=f.screenY);b.rail.drag={x:d.clientX,y:d.clientY,sx:b.scroll.x,sy:b.scroll.y,st:b.getScrollTop(),sl:b.getScrollLeft(),pt:2,dl:!1};if(b.ispage||!b.opt.directionlockdeadzone){b.rail.drag.dl="f"
}else{var f=e(window).width(),n=e(window).height(),k=Math.max(document.body.scrollWidth,document.documentElement.scrollWidth),l=Math.max(document.body.scrollHeight,document.documentElement.scrollHeight),n=Math.max(0,l-n),f=Math.max(0,k-f);b.rail.drag.ck=!b.rail.scrollable&&b.railh.scrollable?0<n?"v":!1:b.rail.scrollable&&!b.railh.scrollable?0<f?"h":!1:!1;b.rail.drag.ck||(b.rail.drag.dl="f")}b.opt.touchbehavior&&(b.isiframe&&g.isie)&&(f=b.win.position(),b.rail.drag.x+=f.left,b.rail.drag.y+=f.top);b.hasmoving=!1;b.lastmouseup=!1;b.scrollmom.reset(d.clientX,d.clientY);if(!g.cantouch&&!this.istouchcapable&&!g.hasmstouch){if(!c||!/INPUT|SELECT|TEXTAREA/i.test(c.nodeName)){return !b.ispage&&g.hasmousecapture&&c.setCapture(),b.opt.touchbehavior?b.cancelEvent(d):b.stopPropagation(d)}/SUBMIT|CANCEL|BUTTON/i.test(e(c).attr("type"))&&(pc={tg:c,click:!1},b.preventclick=pc)}}};b.ontouchend=function(d){if(d.pointerType&&2!=d.pointerType){return !1}if(b.rail.drag&&2==b.rail.drag.pt&&(b.scrollmom.doMomentum(),b.rail.drag=!1,b.hasmoving&&(b.hasmoving=!1,b.lastmouseup=!0,b.hideCursor(),g.hasmousecapture&&document.releaseCapture(),!g.cantouch))){return b.cancelEvent(d)}};var t=b.opt.touchbehavior&&b.isiframe&&!g.hasmousecapture;b.ontouchmove=function(d,c){if(d.pointerType&&2!=d.pointerType){return !1}if(b.rail.drag&&2==b.rail.drag.pt){if(g.cantouch&&"undefined"==typeof d.original){return !0}b.hasmoving=!0;b.preventclick&&!b.preventclick.click&&(b.preventclick.click=b.preventclick.tg.onclick||!1,b.preventclick.tg.onclick=b.onpreventclick);d=e.extend({original:d},d);"changedTouches" in d&&(d.clientX=d.changedTouches[0].clientX,d.clientY=d.changedTouches[0].clientY);if(b.forcescreen){var f=d;d={original:d.original?d.original:d};d.clientX=f.screenX;d.clientY=f.screenY}f=ofy=0;if(t&&!c){var n=b.win.position(),f=-n.left;ofy=-n.top}var k=d.clientY+ofy,n=k-b.rail.drag.y,l=d.clientX+f,h=l-b.rail.drag.x,r=b.rail.drag.st-n;b.ishwscroll&&b.opt.bouncescroll?0>r?r=Math.round(r/2):r>b.page.maxh&&(r=b.page.maxh+Math.round((r-b.page.maxh)/2)):(0>r&&(k=r=0),r>b.page.maxh&&(r=b.page.maxh,k=0));
if(b.railh&&b.railh.scrollable){var m=b.rail.drag.sl-h;b.ishwscroll&&b.opt.bouncescroll?0>m?m=Math.round(m/2):m>b.page.maxw&&(m=b.page.maxw+Math.round((m-b.page.maxw)/2)):(0>m&&(l=m=0),m>b.page.maxw&&(m=b.page.maxw,l=0))}f=!1;if(b.rail.drag.dl){f=!0,"v"==b.rail.drag.dl?m=b.rail.drag.sl:"h"==b.rail.drag.dl&&(r=b.rail.drag.st)}else{var n=Math.abs(n),h=Math.abs(h),x=b.opt.directionlockdeadzone;if("v"==b.rail.drag.ck){if(n>x&&h<=0.3*n){return b.rail.drag=!1,!0}h>x&&(b.rail.drag.dl="f",e("body").scrollTop(e("body").scrollTop()))}else{if("h"==b.rail.drag.ck){if(h>x&&n<=0.3*h){return b.rail.drag=!1,!0}n>x&&(b.rail.drag.dl="f",e("body").scrollLeft(e("body").scrollLeft()))}}}b.synched("touchmove",function(){b.rail.drag&&2==b.rail.drag.pt&&(b.prepareTransition&&b.prepareTransition(0),b.rail.scrollable&&b.setScrollTop(r),b.scrollmom.update(l,k),b.railh&&b.railh.scrollable?(b.setScrollLeft(m),b.showCursor(r,m)):b.showCursor(r),g.isie10&&document.selection.clear())});g.ischrome&&b.istouchcapable&&(f=!1);if(f){return b.cancelEvent(d)}}}}b.onmousedown=function(d,c){if(!(b.rail.drag&&1!=b.rail.drag.pt)){if(b.locked){return b.cancelEvent(d)}b.cancelScroll();b.rail.drag={x:d.clientX,y:d.clientY,sx:b.scroll.x,sy:b.scroll.y,pt:1,hr:!!c};var f=b.getTarget(d);!b.ispage&&g.hasmousecapture&&f.setCapture();b.isiframe&&!g.hasmousecapture&&(b.saved.csspointerevents=b.doc.css("pointer-events"),b.css(b.doc,{"pointer-events":"none"}));return b.cancelEvent(d)}};b.onmouseup=function(d){if(b.rail.drag&&(g.hasmousecapture&&document.releaseCapture(),b.isiframe&&!g.hasmousecapture&&b.doc.css("pointer-events",b.saved.csspointerevents),1==b.rail.drag.pt)){return b.rail.drag=!1,b.cancelEvent(d)}};b.onmousemove=function(d){if(b.rail.drag&&1==b.rail.drag.pt){if(g.ischrome&&0==d.which){return b.onmouseup(d)}b.cursorfreezed=!0;if(b.rail.drag.hr){b.scroll.x=b.rail.drag.sx+(d.clientX-b.rail.drag.x);0>b.scroll.x&&(b.scroll.x=0);var c=b.scrollvaluemaxw;b.scroll.x>c&&(b.scroll.x=c)}else{b.scroll.y=b.rail.drag.sy+(d.clientY-b.rail.drag.y),0>b.scroll.y&&(b.scroll.y=0),c=b.scrollvaluemax,b.scroll.y>c&&(b.scroll.y=c)
}b.synched("mousemove",function(){b.rail.drag&&1==b.rail.drag.pt&&(b.showCursor(),b.rail.drag.hr?b.doScrollLeft(Math.round(b.scroll.x*b.scrollratio.x),b.opt.cursordragspeed):b.doScrollTop(Math.round(b.scroll.y*b.scrollratio.y),b.opt.cursordragspeed))});return b.cancelEvent(d)}};if(g.cantouch||b.opt.touchbehavior){b.onpreventclick=function(d){if(b.preventclick){return b.preventclick.tg.onclick=b.preventclick.click,b.preventclick=!1,b.cancelEvent(d)}},b.bind(b.win,"mousedown",b.ontouchstart),b.onclick=g.isios?!1:function(d){return b.lastmouseup?(b.lastmouseup=!1,b.cancelEvent(d)):!0},b.opt.grabcursorenabled&&g.cursorgrabvalue&&(b.css(b.ispage?b.doc:b.win,{cursor:g.cursorgrabvalue}),b.css(b.rail,{cursor:g.cursorgrabvalue}))}else{var p=function(d){if(b.selectiondrag){if(d){var c=b.win.outerHeight();d=d.pageY-b.selectiondrag.top;0<d&&d<c&&(d=0);d>=c&&(d-=c);b.selectiondrag.df=d}0!=b.selectiondrag.df&&(b.doScrollBy(2*-Math.floor(b.selectiondrag.df/6)),b.debounced("doselectionscroll",function(){p()},50))}};b.hasTextSelected="getSelection" in document?function(){return 0<document.getSelection().rangeCount}:"selection" in document?function(){return"None"!=document.selection.type}:function(){return !1};b.onselectionstart=function(d){b.ispage||(b.selectiondrag=b.win.offset())};b.onselectionend=function(d){b.selectiondrag=!1};b.onselectiondrag=function(d){b.selectiondrag&&b.hasTextSelected()&&b.debounced("selectionscroll",function(){p(d)},250)}}g.hasmstouch&&(b.css(b.rail,{"-ms-touch-action":"none"}),b.css(b.cursor,{"-ms-touch-action":"none"}),b.bind(b.win,"MSPointerDown",b.ontouchstart),b.bind(document,"MSPointerUp",b.ontouchend),b.bind(document,"MSPointerMove",b.ontouchmove),b.bind(b.cursor,"MSGestureHold",function(b){b.preventDefault()}),b.bind(b.cursor,"contextmenu",function(b){b.preventDefault()}));this.istouchcapable&&(b.bind(b.win,"touchstart",b.ontouchstart),b.bind(document,"touchend",b.ontouchend),b.bind(document,"touchcancel",b.ontouchend),b.bind(document,"touchmove",b.ontouchmove));
b.bind(b.cursor,"mousedown",b.onmousedown);b.bind(b.cursor,"mouseup",b.onmouseup);b.railh&&(b.bind(b.cursorh,"mousedown",function(d){b.onmousedown(d,!0)}),b.bind(b.cursorh,"mouseup",function(d){if(!(b.rail.drag&&2==b.rail.drag.pt)){return b.rail.drag=!1,b.hasmoving=!1,b.hideCursor(),g.hasmousecapture&&document.releaseCapture(),b.cancelEvent(d)}}));if(b.opt.cursordragontouch||!g.cantouch&&!b.opt.touchbehavior){b.rail.css({cursor:"default"}),b.railh&&b.railh.css({cursor:"default"}),b.jqbind(b.rail,"mouseenter",function(){b.canshowonmouseevent&&b.showCursor();b.rail.active=!0}),b.jqbind(b.rail,"mouseleave",function(){b.rail.active=!1;b.rail.drag||b.hideCursor()}),b.opt.sensitiverail&&(b.bind(b.rail,"click",function(d){b.doRailClick(d,!1,!1)}),b.bind(b.rail,"dblclick",function(d){b.doRailClick(d,!0,!1)}),b.bind(b.cursor,"click",function(d){b.cancelEvent(d)}),b.bind(b.cursor,"dblclick",function(d){b.cancelEvent(d)})),b.railh&&(b.jqbind(b.railh,"mouseenter",function(){b.canshowonmouseevent&&b.showCursor();b.rail.active=!0}),b.jqbind(b.railh,"mouseleave",function(){b.rail.active=!1;b.rail.drag||b.hideCursor()}),b.opt.sensitiverail&&(b.bind(b.railh,"click",function(d){b.doRailClick(d,!1,!0)}),b.bind(b.railh,"dblclick",function(d){b.doRailClick(d,!0,!0)}),b.bind(b.cursorh,"click",function(d){b.cancelEvent(d)}),b.bind(b.cursorh,"dblclick",function(d){b.cancelEvent(d)})))}!g.cantouch&&!b.opt.touchbehavior?(b.bind(g.hasmousecapture?b.win:document,"mouseup",b.onmouseup),b.bind(document,"mousemove",b.onmousemove),b.onclick&&b.bind(document,"click",b.onclick),!b.ispage&&b.opt.enablescrollonselection&&(b.bind(b.win[0],"mousedown",b.onselectionstart),b.bind(document,"mouseup",b.onselectionend),b.bind(b.cursor,"mouseup",b.onselectionend),b.cursorh&&b.bind(b.cursorh,"mouseup",b.onselectionend),b.bind(document,"mousemove",b.onselectiondrag)),b.zoom&&(b.jqbind(b.zoom,"mouseenter",function(){b.canshowonmouseevent&&b.showCursor();b.rail.active=!0}),b.jqbind(b.zoom,"mouseleave",function(){b.rail.active=!1;
b.rail.drag||b.hideCursor()}))):(b.bind(g.hasmousecapture?b.win:document,"mouseup",b.ontouchend),b.bind(document,"mousemove",b.ontouchmove),b.onclick&&b.bind(document,"click",b.onclick),b.opt.cursordragontouch&&(b.bind(b.cursor,"mousedown",b.onmousedown),b.bind(b.cursor,"mousemove",b.onmousemove),b.cursorh&&b.bind(b.cursorh,"mousedown",function(d){b.onmousedown(d,!0)}),b.cursorh&&b.bind(b.cursorh,"mousemove",b.onmousemove)));b.opt.enablemousewheel&&(b.isiframe||b.bind(g.isie&&b.ispage?document:b.win,"mousewheel",b.onmousewheel),b.bind(b.rail,"mousewheel",b.onmousewheel),b.railh&&b.bind(b.railh,"mousewheel",b.onmousewheelhr));!b.ispage&&(!g.cantouch&&!/HTML|BODY/.test(b.win[0].nodeName))&&(b.win.attr("tabindex")||b.win.attr({tabindex:L++}),b.jqbind(b.win,"focus",function(d){z=b.getTarget(d).id||!0;b.hasfocus=!0;b.canshowonmouseevent&&b.noticeCursor()}),b.jqbind(b.win,"blur",function(d){z=!1;b.hasfocus=!1}),b.jqbind(b.win,"mouseenter",function(d){E=b.getTarget(d).id||!0;b.hasmousefocus=!0;b.canshowonmouseevent&&b.noticeCursor()}),b.jqbind(b.win,"mouseleave",function(){E=!1;b.hasmousefocus=!1;b.rail.drag||b.hideCursor()}))}b.onkeypress=function(d){if(b.locked&&0==b.page.maxh){return !0}d=d?d:window.e;var c=b.getTarget(d);if(c&&/INPUT|TEXTAREA|SELECT|OPTION/.test(c.nodeName)&&(!c.getAttribute("type")&&!c.type||!/submit|button|cancel/i.tp)){return !0}if(b.hasfocus||b.hasmousefocus&&!z||b.ispage&&!z&&!E){c=d.keyCode;if(b.locked&&27!=c){return b.cancelEvent(d)}var f=d.ctrlKey||!1,n=d.shiftKey||!1,g=!1;switch(c){case 38:case 63233:b.doScrollBy(72);g=!0;break;case 40:case 63235:b.doScrollBy(-72);g=!0;break;case 37:case 63232:b.railh&&(f?b.doScrollLeft(0):b.doScrollLeftBy(72),g=!0);break;case 39:case 63234:b.railh&&(f?b.doScrollLeft(b.page.maxw):b.doScrollLeftBy(-72),g=!0);break;case 33:case 63276:b.doScrollBy(b.view.h);g=!0;break;case 34:case 63277:b.doScrollBy(-b.view.h);g=!0;break;case 36:case 63273:b.railh&&f?b.doScrollPos(0,0):b.doScrollTo(0);g=!0;break;case 35:case 63275:b.railh&&f?b.doScrollPos(b.page.maxw,b.page.maxh):b.doScrollTo(b.page.maxh);
g=!0;break;case 32:b.opt.spacebarenabled&&(n?b.doScrollBy(b.view.h):b.doScrollBy(-b.view.h),g=!0);break;case 27:b.zoomactive&&(b.doZoom(),g=!0)}if(g){return b.cancelEvent(d)}}};b.opt.enablekeyboard&&b.bind(document,g.isopera&&!g.isopera12?"keypress":"keydown",b.onkeypress);b.bind(window,"resize",b.lazyResize);b.bind(window,"orientationchange",b.lazyResize);b.bind(window,"load",b.lazyResize);if(g.ischrome&&!b.ispage&&!b.haswrapper){var s=b.win.attr("style"),f=parseFloat(b.win.css("width"))+1;b.win.css("width",f);b.synched("chromefix",function(){b.win.attr("style",s)})}b.onAttributeChange=function(d){b.lazyResize(250)};!b.ispage&&!b.haswrapper&&(!1!==A?(b.observer=new A(function(d){d.forEach(b.onAttributeChange)}),b.observer.observe(b.win[0],{childList:!0,characterData:!1,attributes:!0,subtree:!1}),b.observerremover=new A(function(d){d.forEach(function(d){if(0<d.removedNodes.length){for(var c in d.removedNodes){if(d.removedNodes[c]==b.win[0]){return b.remove()}}}})}),b.observerremover.observe(b.win[0].parentNode,{childList:!0,characterData:!1,attributes:!1,subtree:!1})):(b.bind(b.win,g.isie&&!g.isie9?"propertychange":"DOMAttrModified",b.onAttributeChange),g.isie9&&b.win[0].attachEvent("onpropertychange",b.onAttributeChange),b.bind(b.win,"DOMNodeRemoved",function(d){d.target==b.win[0]&&b.remove()})));!b.ispage&&b.opt.boxzoom&&b.bind(window,"resize",b.resizeZoom);b.istextarea&&b.bind(b.win,"mouseup",b.lazyResize);b.checkrtlmode=!0;b.lazyResize(30)}if("IFRAME"==this.doc[0].nodeName){var K=function(d){b.iframexd=!1;try{var c="contentDocument" in this?this.contentDocument:this.contentWindow.document}catch(f){b.iframexd=!0,c=!1}if(b.iframexd){return"console" in window&&console.log("NiceScroll error: policy restriced iframe"),!0}b.forcescreen=!0;b.isiframe&&(b.iframe={doc:e(c),html:b.doc.contents().find("html")[0],body:b.doc.contents().find("body")[0]},b.getContentSize=function(){return{w:Math.max(b.iframe.html.scrollWidth,b.iframe.body.scrollWidth),h:Math.max(b.iframe.html.scrollHeight,b.iframe.body.scrollHeight)}
},b.docscroll=e(b.iframe.body));!g.isios&&(b.opt.iframeautoresize&&!b.isiframe)&&(b.win.scrollTop(0),b.doc.height(""),d=Math.max(c.getElementsByTagName("html")[0].scrollHeight,c.body.scrollHeight),b.doc.height(d));b.lazyResize(30);g.isie7&&b.css(e(b.iframe.html),{"overflow-y":"hidden"});b.css(e(b.iframe.body),{"overflow-y":"hidden"});g.isios&&b.haswrapper&&b.css(e(c.body),{"-webkit-transform":"translate3d(0,0,0)"});"contentWindow" in this?b.bind(this.contentWindow,"scroll",b.onscroll):b.bind(c,"scroll",b.onscroll);b.opt.enablemousewheel&&b.bind(c,"mousewheel",b.onmousewheel);b.opt.enablekeyboard&&b.bind(c,g.isopera?"keypress":"keydown",b.onkeypress);if(g.cantouch||b.opt.touchbehavior){b.bind(c,"mousedown",b.ontouchstart),b.bind(c,"mousemove",function(d){b.ontouchmove(d,!0)}),b.opt.grabcursorenabled&&g.cursorgrabvalue&&b.css(e(c.body),{cursor:g.cursorgrabvalue})}b.bind(c,"mouseup",b.ontouchend);b.zoom&&(b.opt.dblclickzoom&&b.bind(c,"dblclick",b.doZoom),b.ongesturezoom&&b.bind(c,"gestureend",b.ongesturezoom))};this.doc[0].readyState&&"complete"==this.doc[0].readyState&&setTimeout(function(){K.call(b.doc[0],!1)},500);b.bind(this.doc,"load",K)}};this.showCursor=function(d,c){b.cursortimeout&&(clearTimeout(b.cursortimeout),b.cursortimeout=0);if(b.rail){b.autohidedom&&(b.autohidedom.stop().css({opacity:b.opt.cursoropacitymax}),b.cursoractive=!0);if(!b.rail.drag||1!=b.rail.drag.pt){"undefined"!=typeof d&&!1!==d&&(b.scroll.y=Math.round(1*d/b.scrollratio.y)),"undefined"!=typeof c&&(b.scroll.x=Math.round(1*c/b.scrollratio.x))}b.cursor.css({height:b.cursorheight,top:b.scroll.y});b.cursorh&&(!b.rail.align&&b.rail.visibility?b.cursorh.css({width:b.cursorwidth,left:b.scroll.x+b.rail.width}):b.cursorh.css({width:b.cursorwidth,left:b.scroll.x}),b.cursoractive=!0);b.zoom&&b.zoom.stop().css({opacity:b.opt.cursoropacitymax})}};this.hideCursor=function(d){!b.cursortimeout&&(b.rail&&b.autohidedom&&!(b.hasmousefocus&&"leave"==b.opt.autohidemode))&&(b.cursortimeout=setTimeout(function(){if(!b.rail.active||!b.showonmouseevent){b.autohidedom.stop().animate({opacity:b.opt.cursoropacitymin}),b.zoom&&b.zoom.stop().animate({opacity:b.opt.cursoropacitymin}),b.cursoractive=!1
}b.cursortimeout=0},d||b.opt.hidecursordelay))};this.noticeCursor=function(d,c,f){b.showCursor(c,f);b.rail.active||b.hideCursor(d)};this.getContentSize=b.ispage?function(){return{w:Math.max(document.body.scrollWidth,document.documentElement.scrollWidth),h:Math.max(document.body.scrollHeight,document.documentElement.scrollHeight)}}:b.haswrapper?function(){return{w:b.doc.outerWidth()+parseInt(b.win.css("paddingLeft"))+parseInt(b.win.css("paddingRight")),h:b.doc.outerHeight()+parseInt(b.win.css("paddingTop"))+parseInt(b.win.css("paddingBottom"))}}:function(){return{w:b.docscroll[0].scrollWidth,h:b.docscroll[0].scrollHeight}};this.onResize=function(d,c){if(!b.win){return !1}if(!b.haswrapper&&!b.ispage){if("none"==b.win.css("display")){return b.visibility&&b.hideRail().hideRailHr(),!1}!b.hidden&&!b.visibility&&b.showRail().showRailHr()}var f=b.page.maxh,g=b.page.maxw,e=b.view.w;b.view={w:b.ispage?b.win.width():parseInt(b.win[0].clientWidth),h:b.ispage?b.win.height():parseInt(b.win[0].clientHeight)};b.page=c?c:b.getContentSize();b.page.maxh=Math.max(0,b.page.h-b.view.h);b.page.maxw=Math.max(0,b.page.w-b.view.w);if(b.page.maxh==f&&b.page.maxw==g&&b.view.w==e){if(b.ispage){return b}f=b.win.offset();if(b.lastposition&&(g=b.lastposition,g.top==f.top&&g.left==f.left)){return b}b.lastposition=f}0==b.page.maxh?(b.hideRail(),b.scrollvaluemax=0,b.scroll.y=0,b.scrollratio.y=0,b.cursorheight=0,b.setScrollTop(0),b.rail.scrollable=!1):b.rail.scrollable=!0;0==b.page.maxw?(b.hideRailHr(),b.scrollvaluemaxw=0,b.scroll.x=0,b.scrollratio.x=0,b.cursorwidth=0,b.setScrollLeft(0),b.railh.scrollable=!1):b.railh.scrollable=!0;b.locked=0==b.page.maxh&&0==b.page.maxw;if(b.locked){return b.ispage||b.updateScrollBar(b.view),!1}!b.hidden&&!b.visibility?b.showRail().showRailHr():!b.hidden&&!b.railh.visibility&&b.showRailHr();b.istextarea&&(b.win.css("resize")&&"none"!=b.win.css("resize"))&&(b.view.h-=20);b.cursorheight=Math.min(b.view.h,Math.round(b.view.h*(b.view.h/b.page.h)));b.cursorheight=b.opt.cursorfixedheight?b.opt.cursorfixedheight:Math.max(b.opt.cursorminheight,b.cursorheight);
b.cursorwidth=Math.min(b.view.w,Math.round(b.view.w*(b.view.w/b.page.w)));b.cursorwidth=b.opt.cursorfixedheight?b.opt.cursorfixedheight:Math.max(b.opt.cursorminheight,b.cursorwidth);b.scrollvaluemax=b.view.h-b.cursorheight-b.cursor.hborder;b.railh&&(b.railh.width=0<b.page.maxh?b.view.w-b.rail.width:b.view.w,b.scrollvaluemaxw=b.railh.width-b.cursorwidth-b.cursorh.wborder);b.checkrtlmode&&b.railh&&(b.checkrtlmode=!1,b.opt.rtlmode&&0==b.scroll.x&&b.setScrollLeft(b.page.maxw));b.ispage||b.updateScrollBar(b.view);b.scrollratio={x:b.page.maxw/b.scrollvaluemaxw,y:b.page.maxh/b.scrollvaluemax};b.getScrollTop()>b.page.maxh?b.doScrollTop(b.page.maxh):(b.scroll.y=Math.round(b.getScrollTop()*(1/b.scrollratio.y)),b.scroll.x=Math.round(b.getScrollLeft()*(1/b.scrollratio.x)),b.cursoractive&&b.noticeCursor());b.scroll.y&&0==b.getScrollTop()&&b.doScrollTo(Math.floor(b.scroll.y*b.scrollratio.y));return b};this.resize=b.onResize;this.lazyResize=function(d){d=isNaN(d)?30:d;b.delayed("resize",b.resize,d);return b};this._bind=function(d,c,f,g){b.events.push({e:d,n:c,f:f,b:g,q:!1});d.addEventListener?d.addEventListener(c,f,g||!1):d.attachEvent?d.attachEvent("on"+c,f):d["on"+c]=f};this.jqbind=function(d,c,f){b.events.push({e:d,n:c,f:f,q:!0});e(d).bind(c,f)};this.bind=function(d,c,f,e){var k="jquery" in d?d[0]:d;"mousewheel"==c?"onwheel" in b.win?b._bind(k,"wheel",f,e||!1):(d="undefined"!=typeof document.onmousewheel?"mousewheel":"DOMMouseScroll",q(k,d,f,e||!1),"DOMMouseScroll"==d&&q(k,"MozMousePixelScroll",f,e||!1)):k.addEventListener?(g.cantouch&&/mouseup|mousedown|mousemove/.test(c)&&b._bind(k,"mousedown"==c?"touchstart":"mouseup"==c?"touchend":"touchmove",function(b){if(b.touches){if(2>b.touches.length){var d=b.touches.length?b.touches[0]:b;d.original=b;f.call(this,d)}}else{b.changedTouches&&(d=b.changedTouches[0],d.original=b,f.call(this,d))}},e||!1),b._bind(k,c,f,e||!1),g.cantouch&&"mouseup"==c&&b._bind(k,"touchcancel",f,e||!1)):b._bind(k,c,function(d){if((d=d||window.event||!1)&&d.srcElement){d.target=d.srcElement
}"pageY" in d||(d.pageX=d.clientX+document.documentElement.scrollLeft,d.pageY=d.clientY+document.documentElement.scrollTop);return !1===f.call(k,d)||!1===e?b.cancelEvent(d):!0})};this._unbind=function(b,c,f,g){b.removeEventListener?b.removeEventListener(c,f,g):b.detachEvent?b.detachEvent("on"+c,f):b["on"+c]=!1};this.unbindAll=function(){for(var d=0;d<b.events.length;d++){var c=b.events[d];c.q?c.e.unbind(c.n,c.f):b._unbind(c.e,c.n,c.f,c.b)}};this.cancelEvent=function(b){b=b.original?b.original:b?b:window.event||!1;if(!b){return !1}b.preventDefault&&b.preventDefault();b.stopPropagation&&b.stopPropagation();b.preventManipulation&&b.preventManipulation();b.cancelBubble=!0;b.cancel=!0;return b.returnValue=!1};this.stopPropagation=function(b){b=b.original?b.original:b?b:window.event||!1;if(!b){return !1}if(b.stopPropagation){return b.stopPropagation()}b.cancelBubble&&(b.cancelBubble=!0);return !1};this.showRail=function(){if(0!=b.page.maxh&&(b.ispage||"none"!=b.win.css("display"))){b.visibility=!0,b.rail.visibility=!0,b.rail.css("display","block")}return b};this.showRailHr=function(){if(!b.railh){return b}if(0!=b.page.maxw&&(b.ispage||"none"!=b.win.css("display"))){b.railh.visibility=!0,b.railh.css("display","block")}return b};this.hideRail=function(){b.visibility=!1;b.rail.visibility=!1;b.rail.css("display","none");return b};this.hideRailHr=function(){if(!b.railh){return b}b.railh.visibility=!1;b.railh.css("display","none");return b};this.show=function(){b.hidden=!1;b.locked=!1;return b.showRail().showRailHr()};this.hide=function(){b.hidden=!0;b.locked=!0;return b.hideRail().hideRailHr()};this.toggle=function(){return b.hidden?b.show():b.hide()};this.remove=function(){b.stop();b.cursortimeout&&clearTimeout(b.cursortimeout);b.doZoomOut();b.unbindAll();g.isie9&&b.win[0].detachEvent("onpropertychange",b.onAttributeChange);!1!==b.observer&&b.observer.disconnect();!1!==b.observerremover&&b.observerremover.disconnect();b.events=null;b.cursor&&b.cursor.remove();b.cursorh&&b.cursorh.remove();
b.rail&&b.rail.remove();b.railh&&b.railh.remove();b.zoom&&b.zoom.remove();for(var d=0;d<b.saved.css.length;d++){var c=b.saved.css[d];c[0].css(c[1],"undefined"==typeof c[2]?"":c[2])}b.saved=!1;b.me.data("__nicescroll","");var f=e.nicescroll;f.each(function(d){if(this&&this.id===b.id){delete f[d];for(var c=++d;c<f.length;c++,d++){f[d]=f[c]}f.length--;f.length&&delete f[f.length]}});for(var k in b){b[k]=null,delete b[k]}b=null};this.scrollstart=function(d){this.onscrollstart=d;return b};this.scrollend=function(d){this.onscrollend=d;return b};this.scrollcancel=function(d){this.onscrollcancel=d;return b};this.zoomin=function(d){this.onzoomin=d;return b};this.zoomout=function(d){this.onzoomout=d;return b};this.isScrollable=function(b){b=b.target?b.target:b;if("OPTION"==b.nodeName){return !0}for(;b&&1==b.nodeType&&!/BODY|HTML/.test(b.nodeName);){var c=e(b),c=c.css("overflowY")||c.css("overflowX")||c.css("overflow")||"";if(/scroll|auto/.test(c)){return b.clientHeight!=b.scrollHeight}b=b.parentNode?b.parentNode:!1}return !1};this.getViewport=function(b){for(b=b&&b.parentNode?b.parentNode:!1;b&&1==b.nodeType&&!/BODY|HTML/.test(b.nodeName);){var c=e(b);if(/fixed|absolute/.test(c.css("position"))){return c}var f=c.css("overflowY")||c.css("overflowX")||c.css("overflow")||"";if(/scroll|auto/.test(f)&&b.clientHeight!=b.scrollHeight||0<c.getNiceScroll().length){return c}b=b.parentNode?b.parentNode:!1}return !1};this.onmousewheel=function(d){if(b.locked){return b.debounced("checkunlock",b.resize,250),!0}if(b.rail.drag){return b.cancelEvent(d)}"auto"==b.opt.oneaxismousemode&&0!=d.deltaX&&(b.opt.oneaxismousemode=!1);if(b.opt.oneaxismousemode&&0==d.deltaX&&!b.rail.scrollable){return b.railh&&b.railh.scrollable?b.onmousewheelhr(d):!0}var c=+new Date,f=!1;b.opt.preservenativescrolling&&b.checkarea+600<c&&(b.nativescrollingarea=b.isScrollable(d),f=!0);b.checkarea=c;if(b.nativescrollingarea){return !0}if(d=t(d,!1,f)){b.checkarea=0}return d};this.onmousewheelhr=function(d){if(b.locked||!b.railh.scrollable){return !0
}if(b.rail.drag){return b.cancelEvent(d)}var c=+new Date,f=!1;b.opt.preservenativescrolling&&b.checkarea+600<c&&(b.nativescrollingarea=b.isScrollable(d),f=!0);b.checkarea=c;return b.nativescrollingarea?!0:b.locked?b.cancelEvent(d):t(d,!0,f)};this.stop=function(){b.cancelScroll();b.scrollmon&&b.scrollmon.stop();b.cursorfreezed=!1;b.scroll.y=Math.round(b.getScrollTop()*(1/b.scrollratio.y));b.noticeCursor();return b};this.getTransitionSpeed=function(d){var c=Math.round(10*b.opt.scrollspeed);d=Math.min(c,Math.round(d/20*b.opt.scrollspeed));return 20<d?d:0};b.opt.smoothscroll?b.ishwscroll&&g.hastransition&&b.opt.usetransition?(this.prepareTransition=function(d,c){var f=c?20<d?d:0:b.getTransitionSpeed(d),e=f?g.prefixstyle+"transform "+f+"ms ease-out":"";if(!b.lasttransitionstyle||b.lasttransitionstyle!=e){b.lasttransitionstyle=e,b.doc.css(g.transitionstyle,e)}return f},this.doScrollLeft=function(c,g){var f=b.scrollrunning?b.newscrolly:b.getScrollTop();b.doScrollPos(c,f,g)},this.doScrollTop=function(c,g){var f=b.scrollrunning?b.newscrollx:b.getScrollLeft();b.doScrollPos(f,c,g)},this.doScrollPos=function(c,e,f){var k=b.getScrollTop(),l=b.getScrollLeft();(0>(b.newscrolly-k)*(e-k)||0>(b.newscrollx-l)*(c-l))&&b.cancelScroll();!1==b.opt.bouncescroll&&(0>e?e=0:e>b.page.maxh&&(e=b.page.maxh),0>c?c=0:c>b.page.maxw&&(c=b.page.maxw));if(b.scrollrunning&&c==b.newscrollx&&e==b.newscrolly){return !1}b.newscrolly=e;b.newscrollx=c;b.newscrollspeed=f||!1;if(b.timer){return !1}b.timer=setTimeout(function(){var f=b.getScrollTop(),k=b.getScrollLeft(),l,h;l=c-k;h=e-f;l=Math.round(Math.sqrt(Math.pow(l,2)+Math.pow(h,2)));l=b.newscrollspeed&&1<b.newscrollspeed?b.newscrollspeed:b.getTransitionSpeed(l);b.newscrollspeed&&1>=b.newscrollspeed&&(l*=b.newscrollspeed);b.prepareTransition(l,!0);b.timerscroll&&b.timerscroll.tm&&clearInterval(b.timerscroll.tm);0<l&&(!b.scrollrunning&&b.onscrollstart&&b.onscrollstart.call(b,{type:"scrollstart",current:{x:k,y:f},request:{x:c,y:e},end:{x:b.newscrollx,y:b.newscrolly},speed:l}),g.transitionend?b.scrollendtrapped||(b.scrollendtrapped=!0,b.bind(b.doc,g.transitionend,b.onScrollEnd,!1)):(b.scrollendtrapped&&clearTimeout(b.scrollendtrapped),b.scrollendtrapped=setTimeout(b.onScrollEnd,l)),b.timerscroll={bz:new BezierClass(f,b.newscrolly,l,0,0,0.58,1),bh:new BezierClass(k,b.newscrollx,l,0,0,0.58,1)},b.cursorfreezed||(b.timerscroll.tm=setInterval(function(){b.showCursor(b.getScrollTop(),b.getScrollLeft())
},60)));b.synched("doScroll-set",function(){b.timer=0;b.scrollendtrapped&&(b.scrollrunning=!0);b.setScrollTop(b.newscrolly);b.setScrollLeft(b.newscrollx);if(!b.scrollendtrapped){b.onScrollEnd()}})},50)},this.cancelScroll=function(){if(!b.scrollendtrapped){return !0}var c=b.getScrollTop(),e=b.getScrollLeft();b.scrollrunning=!1;g.transitionend||clearTimeout(g.transitionend);b.scrollendtrapped=!1;b._unbind(b.doc,g.transitionend,b.onScrollEnd);b.prepareTransition(0);b.setScrollTop(c);b.railh&&b.setScrollLeft(e);b.timerscroll&&b.timerscroll.tm&&clearInterval(b.timerscroll.tm);b.timerscroll=!1;b.cursorfreezed=!1;b.showCursor(c,e);return b},this.onScrollEnd=function(){b.scrollendtrapped&&b._unbind(b.doc,g.transitionend,b.onScrollEnd);b.scrollendtrapped=!1;b.prepareTransition(0);b.timerscroll&&b.timerscroll.tm&&clearInterval(b.timerscroll.tm);b.timerscroll=!1;var c=b.getScrollTop(),e=b.getScrollLeft();b.setScrollTop(c);b.railh&&b.setScrollLeft(e);b.noticeCursor(!1,c,e);b.cursorfreezed=!1;0>c?c=0:c>b.page.maxh&&(c=b.page.maxh);0>e?e=0:e>b.page.maxw&&(e=b.page.maxw);if(c!=b.newscrolly||e!=b.newscrollx){return b.doScrollPos(e,c,b.opt.snapbackspeed)}b.onscrollend&&b.scrollrunning&&b.onscrollend.call(b,{type:"scrollend",current:{x:e,y:c},end:{x:b.newscrollx,y:b.newscrolly}});b.scrollrunning=!1}):(this.doScrollLeft=function(c,g){var f=b.scrollrunning?b.newscrolly:b.getScrollTop();b.doScrollPos(c,f,g)},this.doScrollTop=function(c,g){var f=b.scrollrunning?b.newscrollx:b.getScrollLeft();b.doScrollPos(f,c,g)},this.doScrollPos=function(c,g,f){function e(){if(b.cancelAnimationFrame){return !0}b.scrollrunning=!0;if(p=1-p){return b.timer=v(e)||1}var c=0,d=sy=b.getScrollTop();if(b.dst.ay){var d=b.bzscroll?b.dst.py+b.bzscroll.getNow()*b.dst.ay:b.newscrolly,f=d-sy;if(0>f&&d<b.newscrolly||0<f&&d>b.newscrolly){d=b.newscrolly}b.setScrollTop(d);d==b.newscrolly&&(c=1)}else{c=1}var g=sx=b.getScrollLeft();if(b.dst.ax){g=b.bzscroll?b.dst.px+b.bzscroll.getNow()*b.dst.ax:b.newscrollx;f=g-sx;if(0>f&&g<b.newscrollx||0<f&&g>b.newscrollx){g=b.newscrollx
}b.setScrollLeft(g);g==b.newscrollx&&(c+=1)}else{c+=1}2==c?(b.timer=0,b.cursorfreezed=!1,b.bzscroll=!1,b.scrollrunning=!1,0>d?d=0:d>b.page.maxh&&(d=b.page.maxh),0>g?g=0:g>b.page.maxw&&(g=b.page.maxw),g!=b.newscrollx||d!=b.newscrolly?b.doScrollPos(g,d):b.onscrollend&&b.onscrollend.call(b,{type:"scrollend",current:{x:sx,y:sy},end:{x:b.newscrollx,y:b.newscrolly}})):b.timer=v(e)||1}g="undefined"==typeof g||!1===g?b.getScrollTop(!0):g;if(b.timer&&b.newscrolly==g&&b.newscrollx==c){return !0}b.timer&&w(b.timer);b.timer=0;var k=b.getScrollTop(),l=b.getScrollLeft();(0>(b.newscrolly-k)*(g-k)||0>(b.newscrollx-l)*(c-l))&&b.cancelScroll();b.newscrolly=g;b.newscrollx=c;if(!b.bouncescroll||!b.rail.visibility){0>b.newscrolly?b.newscrolly=0:b.newscrolly>b.page.maxh&&(b.newscrolly=b.page.maxh)}if(!b.bouncescroll||!b.railh.visibility){0>b.newscrollx?b.newscrollx=0:b.newscrollx>b.page.maxw&&(b.newscrollx=b.page.maxw)}b.dst={};b.dst.x=c-l;b.dst.y=g-k;b.dst.px=l;b.dst.py=k;var h=Math.round(Math.sqrt(Math.pow(b.dst.x,2)+Math.pow(b.dst.y,2)));b.dst.ax=b.dst.x/h;b.dst.ay=b.dst.y/h;var m=0,q=h;0==b.dst.x?(m=k,q=g,b.dst.ay=1,b.dst.py=0):0==b.dst.y&&(m=l,q=c,b.dst.ax=1,b.dst.px=0);h=b.getTransitionSpeed(h);f&&1>=f&&(h*=f);b.bzscroll=0<h?b.bzscroll?b.bzscroll.update(q,h):new BezierClass(m,q,h,0,1,0,1):!1;if(!b.timer){(k==b.page.maxh&&g>=b.page.maxh||l==b.page.maxw&&c>=b.page.maxw)&&b.checkContentSize();var p=1;b.cancelAnimationFrame=!1;b.timer=1;b.onscrollstart&&!b.scrollrunning&&b.onscrollstart.call(b,{type:"scrollstart",current:{x:l,y:k},request:{x:c,y:g},end:{x:b.newscrollx,y:b.newscrolly},speed:h});e();(k==b.page.maxh&&g>=k||l==b.page.maxw&&c>=l)&&b.checkContentSize();b.noticeCursor()}},this.cancelScroll=function(){b.timer&&w(b.timer);b.timer=0;b.bzscroll=!1;b.scrollrunning=!1;return b}):(this.doScrollLeft=function(c,g){var f=b.getScrollTop();b.doScrollPos(c,f,g)},this.doScrollTop=function(c,g){var f=b.getScrollLeft();b.doScrollPos(f,c,g)},this.doScrollPos=function(c,g,f){var e=c>b.page.maxw?b.page.maxw:c;
0>e&&(e=0);var k=g>b.page.maxh?b.page.maxh:g;0>k&&(k=0);b.synched("scroll",function(){b.setScrollTop(k);b.setScrollLeft(e)})},this.cancelScroll=function(){});this.doScrollBy=function(c,g){var f=0,f=g?Math.floor((b.scroll.y-c)*b.scrollratio.y):(b.timer?b.newscrolly:b.getScrollTop(!0))-c;if(b.bouncescroll){var e=Math.round(b.view.h/2);f<-e?f=-e:f>b.page.maxh+e&&(f=b.page.maxh+e)}b.cursorfreezed=!1;py=b.getScrollTop(!0);if(0>f&&0>=py){return b.noticeCursor()}if(f>b.page.maxh&&py>=b.page.maxh){return b.checkContentSize(),b.noticeCursor()}b.doScrollTop(f)};this.doScrollLeftBy=function(c,g){var f=0,f=g?Math.floor((b.scroll.x-c)*b.scrollratio.x):(b.timer?b.newscrollx:b.getScrollLeft(!0))-c;if(b.bouncescroll){var e=Math.round(b.view.w/2);f<-e?f=-e:f>b.page.maxw+e&&(f=b.page.maxw+e)}b.cursorfreezed=!1;px=b.getScrollLeft(!0);if(0>f&&0>=px||f>b.page.maxw&&px>=b.page.maxw){return b.noticeCursor()}b.doScrollLeft(f)};this.doScrollTo=function(c,g){g&&Math.round(c*b.scrollratio.y);b.cursorfreezed=!1;b.doScrollTop(c)};this.checkContentSize=function(){var c=b.getContentSize();(c.h!=b.page.h||c.w!=b.page.w)&&b.resize(!1,c)};b.onscroll=function(c){b.rail.drag||b.cursorfreezed||b.synched("scroll",function(){b.scroll.y=Math.round(b.getScrollTop()*(1/b.scrollratio.y));b.railh&&(b.scroll.x=Math.round(b.getScrollLeft()*(1/b.scrollratio.x)));b.noticeCursor()})};b.bind(b.docscroll,"scroll",b.onscroll);this.doZoomIn=function(c){if(!b.zoomactive){b.zoomactive=!0;b.zoomrestore={style:{}};var k="position top left zIndex backgroundColor marginTop marginBottom marginLeft marginRight".split(" "),f=b.win[0].style,l;for(l in k){var h=k[l];b.zoomrestore.style[h]="undefined"!=typeof f[h]?f[h]:""}b.zoomrestore.style.width=b.win.css("width");b.zoomrestore.style.height=b.win.css("height");b.zoomrestore.padding={w:b.win.outerWidth()-b.win.width(),h:b.win.outerHeight()-b.win.height()};g.isios4&&(b.zoomrestore.scrollTop=e(window).scrollTop(),e(window).scrollTop(0));b.win.css({position:g.isios4?"absolute":"fixed",top:0,left:0,"z-index":y+100,margin:"0px"});
k=b.win.css("backgroundColor");(""==k||/transparent|rgba\(0, 0, 0, 0\)|rgba\(0,0,0,0\)/.test(k))&&b.win.css("backgroundColor","#fff");b.rail.css({"z-index":y+101});b.zoom.css({"z-index":y+102});b.zoom.css("backgroundPosition","0px -18px");b.resizeZoom();b.onzoomin&&b.onzoomin.call(b);return b.cancelEvent(c)}};this.doZoomOut=function(c){if(b.zoomactive){return b.zoomactive=!1,b.win.css("margin",""),b.win.css(b.zoomrestore.style),g.isios4&&e(window).scrollTop(b.zoomrestore.scrollTop),b.rail.css({"z-index":b.zindex}),b.zoom.css({"z-index":b.zindex}),b.zoomrestore=!1,b.zoom.css("backgroundPosition","0px 0px"),b.onResize(),b.onzoomout&&b.onzoomout.call(b),b.cancelEvent(c)}};this.doZoom=function(c){return b.zoomactive?b.doZoomOut(c):b.doZoomIn(c)};this.resizeZoom=function(){if(b.zoomactive){var c=b.getScrollTop();b.win.css({width:e(window).width()-b.zoomrestore.padding.w+"px",height:e(window).height()-b.zoomrestore.padding.h+"px"});b.onResize();b.setScrollTop(Math.min(b.page.maxh,c))}};this.init();e.nicescroll.push(this)},J=function(e){var c=this;this.nc=e;this.steptime=this.lasttime=this.speedy=this.speedx=this.lasty=this.lastx=0;this.snapy=this.snapx=!1;this.demuly=this.demulx=0;this.lastscrolly=this.lastscrollx=-1;this.timer=this.chky=this.chkx=0;this.time=function(){return +new Date};this.reset=function(e,l){c.stop();var h=c.time();c.steptime=0;c.lasttime=h;c.speedx=0;c.speedy=0;c.lastx=e;c.lasty=l;c.lastscrollx=-1;c.lastscrolly=-1};this.update=function(e,l){var h=c.time();c.steptime=h-c.lasttime;c.lasttime=h;var h=l-c.lasty,t=e-c.lastx,b=c.nc.getScrollTop(),p=c.nc.getScrollLeft(),b=b+h,p=p+t;c.snapx=0>p||p>c.nc.page.maxw;c.snapy=0>b||b>c.nc.page.maxh;c.speedx=t;c.speedy=h;c.lastx=e;c.lasty=l};this.stop=function(){c.nc.unsynched("domomentum2d");c.timer&&clearTimeout(c.timer);c.timer=0;c.lastscrollx=-1;c.lastscrolly=-1};this.doSnapy=function(e,l){var h=!1;0>l?(l=0,h=!0):l>c.nc.page.maxh&&(l=c.nc.page.maxh,h=!0);0>e?(e=0,h=!0):e>c.nc.page.maxw&&(e=c.nc.page.maxw,h=!0);h&&c.nc.doScrollPos(e,l,c.nc.opt.snapbackspeed)
};this.doMomentum=function(e){var l=c.time(),h=e?l+e:c.lasttime;e=c.nc.getScrollLeft();var t=c.nc.getScrollTop(),b=c.nc.page.maxh,p=c.nc.page.maxw;c.speedx=0<p?Math.min(60,c.speedx):0;c.speedy=0<b?Math.min(60,c.speedy):0;h=h&&60>=l-h;if(0>t||t>b||0>e||e>p){h=!1}e=c.speedx&&h?c.speedx:!1;if(c.speedy&&h&&c.speedy||e){var g=Math.max(16,c.steptime);50<g&&(e=g/50,c.speedx*=e,c.speedy*=e,g=50);c.demulxy=0;c.lastscrollx=c.nc.getScrollLeft();c.chkx=c.lastscrollx;c.lastscrolly=c.nc.getScrollTop();c.chky=c.lastscrolly;var s=c.lastscrollx,u=c.lastscrolly,d=function(){var e=600<c.time()-l?0.04:0.02;if(c.speedx&&(s=Math.floor(c.lastscrollx-c.speedx*(1-c.demulxy)),c.lastscrollx=s,0>s||s>p)){e=0.1}if(c.speedy&&(u=Math.floor(c.lastscrolly-c.speedy*(1-c.demulxy)),c.lastscrolly=u,0>u||u>b)){e=0.1}c.demulxy=Math.min(1,c.demulxy+e);c.nc.synched("domomentum2d",function(){c.speedx&&(c.nc.getScrollLeft()!=c.chkx&&c.stop(),c.chkx=s,c.nc.setScrollLeft(s));c.speedy&&(c.nc.getScrollTop()!=c.chky&&c.stop(),c.chky=u,c.nc.setScrollTop(u));c.timer||(c.nc.hideCursor(),c.doSnapy(s,u))});1>c.demulxy?c.timer=setTimeout(d,g):(c.stop(),c.nc.hideCursor(),c.doSnapy(s,u))};d()}else{c.doSnapy(c.nc.getScrollLeft(),c.nc.getScrollTop())}}},B=e.fn.scrollTop;e.cssHooks.pageYOffset={get:function(h,c,k){return(c=e.data(h,"__nicescroll")||!1)&&c.ishwscroll?c.getScrollTop():B.call(h)},set:function(h,c){var k=e.data(h,"__nicescroll")||!1;k&&k.ishwscroll?k.setScrollTop(parseInt(c)):B.call(h,c);return this}};e.fn.scrollTop=function(h){if("undefined"==typeof h){var c=this[0]?e.data(this[0],"__nicescroll")||!1:!1;return c&&c.ishwscroll?c.getScrollTop():B.call(this)}return this.each(function(){var c=e.data(this,"__nicescroll")||!1;c&&c.ishwscroll?c.setScrollTop(parseInt(h)):B.call(e(this),h)})};var C=e.fn.scrollLeft;e.cssHooks.pageXOffset={get:function(h,c,k){return(c=e.data(h,"__nicescroll")||!1)&&c.ishwscroll?c.getScrollLeft():C.call(h)},set:function(h,c){var k=e.data(h,"__nicescroll")||!1;k&&k.ishwscroll?k.setScrollLeft(parseInt(c)):C.call(h,c);
return this}};e.fn.scrollLeft=function(h){if("undefined"==typeof h){var c=this[0]?e.data(this[0],"__nicescroll")||!1:!1;return c&&c.ishwscroll?c.getScrollLeft():C.call(this)}return this.each(function(){var c=e.data(this,"__nicescroll")||!1;c&&c.ishwscroll?c.setScrollLeft(parseInt(h)):C.call(e(this),h)})};var D=function(h){var c=this;this.length=0;this.name="nicescrollarray";this.each=function(e){for(var h=0,k=0;h<c.length;h++){e.call(c[h],k++)}return c};this.push=function(e){c[c.length]=e;c.length++};this.eq=function(e){return c[e]};if(h){for(a=0;a<h.length;a++){var k=e.data(h[a],"__nicescroll")||!1;k&&(this[this.length]=k,this.length++)}}return this};(function(e,c,k){for(var l=0;l<c.length;l++){k(e,c[l])}})(D.prototype,"show hide toggle onResize resize remove stop doScrollPos".split(" "),function(e,c){e[c]=function(){var e=arguments;return this.each(function(){this[c].apply(this,e)})}});e.fn.getNiceScroll=function(h){return"undefined"==typeof h?new D(this):this[h]&&e.data(this[h],"__nicescroll")||!1};e.extend(e.expr[":"],{nicescroll:function(h){return e.data(h,"__nicescroll")?!0:!1}});e.fn.niceScroll=function(h,c){"undefined"==typeof c&&("object"==typeof h&&!("jquery" in h))&&(c=h,h=!1);var k=new D;"undefined"==typeof c&&(c={});h&&(c.doc=e(h),c.win=e(this));var l=!("doc" in c);!l&&!("win" in c)&&(c.win=e(this));this.each(function(){var h=e(this).data("__nicescroll")||!1;h||(c.doc=l?e(this):c.doc,h=new Q(c,e(this)),e(this).data("__nicescroll",h));k.push(h)});return 1==k.length?k[0]:k};window.NiceScroll={getjQuery:function(){return e}};e.nicescroll||(e.nicescroll=new D,e.nicescroll.options=I)})(jQuery);
(function($){$.fn.dragsort=function(options){if(options=="destroy"){var $selector=($(this.selector).length)?$(this.selector):$(this);$selector.trigger("dragsort-uninit");return}var opts=$.extend({},$.fn.dragsort.defaults,options);var lists=[];var list=null,lastPos=null;this.each(function(i,cont){if($(cont).is("table")&&$(cont).children().size()==1&&$(cont).children().is("tbody")){cont=$(cont).children().get(0)}var newList={draggedItem:null,placeHolderItem:null,pos:null,offset:null,offsetLimit:null,scroll:null,container:cont,init:function(){var tagName=$(this.container).children().size()==0?"li":$(this.container).children(":first").get(0).tagName.toLowerCase();if(opts.itemSelector==""){opts.itemSelector=tagName}if(opts.dragSelector==""){opts.dragSelector=tagName}if(opts.placeHolderTemplate==""){opts.placeHolderTemplate="<"+tagName+">&nbsp;</"+tagName+">"}$(this.container).attr("data-listidx",i).mousedown(this.grabItem).bind("dragsort-uninit",this.uninit);this.styleDragHandlers(true)},uninit:function(){var list=lists[$(this).attr("data-listidx")];$(list.container).unbind("mousedown",list.grabItem).unbind("dragsort-uninit");list.styleDragHandlers(false)},getItems:function(){return $(this.container).children(opts.itemSelector)},styleDragHandlers:function(cursor){this.getItems().map(function(){return $(this).is(opts.dragSelector)?this:$(this).find(opts.dragSelector).get()}).css("cursor",cursor?"pointer":"")},grabItem:function(e){if(e.which!=1||$(e.target).is(opts.dragSelectorExclude)||$(e.target).closest(opts.dragSelectorExclude).size()>0||$(e.target).closest(opts.itemSelector).size()==0){return}e.preventDefault();var dragHandle=e.target;while(!$(dragHandle).is(opts.dragSelector)){if(dragHandle==this){return}dragHandle=dragHandle.parentNode}$(dragHandle).attr("data-cursor",$(dragHandle).css("cursor"));$(dragHandle).css("cursor","move");var list=lists[$(this).attr("data-listidx")];var item=this;var trigger=function(){list.dragStart.call(item,e);$(list.container).unbind("mousemove",trigger)
};$(list.container).mousemove(trigger).mouseup(function(){$(list.container).unbind("mousemove",trigger);$(dragHandle).css("cursor",$(dragHandle).attr("data-cursor"))})},dragStart:function(e){if(list!=null&&list.draggedItem!=null){list.dropItem()}list=lists[$(this).attr("data-listidx")];list.draggedItem=$(e.target).closest(opts.itemSelector);list.draggedItem.attr("data-origpos",$(this).attr("data-listidx")+"-"+list.getItems().index(list.draggedItem));var mt=parseInt(list.draggedItem.css("marginTop"));var ml=parseInt(list.draggedItem.css("marginLeft"));list.offset=list.draggedItem.offset();list.offset.top=e.pageY-list.offset.top+(isNaN(mt)?0:mt)-1;list.offset.left=e.pageX-list.offset.left+(isNaN(ml)?0:ml)-1;if(!opts.dragBetween){var containerHeight=$(list.container).outerHeight()==0?Math.max(1,Math.round(0.5+list.getItems().size()*list.draggedItem.outerWidth()/$(list.container).outerWidth()))*list.draggedItem.outerHeight():$(list.container).outerHeight();list.offsetLimit=$(list.container).offset();list.offsetLimit.right=list.offsetLimit.left+$(list.container).outerWidth()-list.draggedItem.outerWidth();list.offsetLimit.bottom=list.offsetLimit.top+containerHeight-list.draggedItem.outerHeight()}var h=list.draggedItem.height();var w=list.draggedItem.width();if(opts.itemSelector=="tr"){list.draggedItem.children().each(function(){$(this).width($(this).width())});list.placeHolderItem=list.draggedItem.clone().attr("data-placeholder",true);list.draggedItem.after(list.placeHolderItem);list.placeHolderItem.children().each(function(){$(this).css({borderWidth:0,width:$(this).width()+1,height:$(this).height()+1}).html("&nbsp;")})}else{list.draggedItem.after(opts.placeHolderTemplate);list.placeHolderItem=list.draggedItem.next().css({height:h,width:w}).attr("data-placeholder",true)}if(opts.itemSelector=="td"){var listTable=list.draggedItem.closest("table").get(0);$("<table id='"+listTable.id+"' style='border-width: 0px;' class='dragSortItem "+listTable.className+"'><tr></tr></table>").appendTo("body").children().append(list.draggedItem)
}var orig=list.draggedItem.attr("style");list.draggedItem.attr("data-origstyle",orig?orig:"");list.draggedItem.css({position:"absolute",opacity:0.8,"z-index":999,height:h,width:w});list.scroll={moveX:0,moveY:0,maxX:$(document).width()-$(window).width(),maxY:$(document).height()-$(window).height()};list.scroll.scrollY=window.setInterval(function(){if(opts.scrollContainer!=window){$(opts.scrollContainer).scrollTop($(opts.scrollContainer).scrollTop()+list.scroll.moveY);return}var t=$(opts.scrollContainer).scrollTop();if(list.scroll.moveY>0&&t<list.scroll.maxY||list.scroll.moveY<0&&t>0){$(opts.scrollContainer).scrollTop(t+list.scroll.moveY);list.draggedItem.css("top",list.draggedItem.offset().top+list.scroll.moveY+1)}},10);list.scroll.scrollX=window.setInterval(function(){if(opts.scrollContainer!=window){$(opts.scrollContainer).scrollLeft($(opts.scrollContainer).scrollLeft()+list.scroll.moveX);return}var l=$(opts.scrollContainer).scrollLeft();if(list.scroll.moveX>0&&l<list.scroll.maxX||list.scroll.moveX<0&&l>0){$(opts.scrollContainer).scrollLeft(l+list.scroll.moveX);list.draggedItem.css("left",list.draggedItem.offset().left+list.scroll.moveX+1)}},10);$(lists).each(function(i,l){l.createDropTargets();l.buildPositionTable()});list.setPos(e.pageX,e.pageY);$(document).bind("mousemove",list.swapItems);$(document).bind("mouseup",list.dropItem);if(opts.scrollContainer!=window){$(window).bind("DOMMouseScroll mousewheel",list.wheel)}},setPos:function(x,y){var top=y-this.offset.top;var left=x-this.offset.left;if(!opts.dragBetween){top=Math.min(this.offsetLimit.bottom,Math.max(top,this.offsetLimit.top));left=Math.min(this.offsetLimit.right,Math.max(left,this.offsetLimit.left))}this.draggedItem.parents().each(function(){if($(this).css("position")!="static"&&(userBrowser()!="Firefox"||$(this).css("display")!="table")){var offset=$(this).offset();top-=offset.top;left-=offset.left;return false}});if(opts.scrollContainer==window){y-=$(window).scrollTop();x-=$(window).scrollLeft();y=Math.max(0,y-$(window).height()+5)+Math.min(0,y-5);
x=Math.max(0,x-$(window).width()+5)+Math.min(0,x-5)}else{var cont=$(opts.scrollContainer);var offset=cont.offset();y=Math.max(0,y-cont.height()-offset.top)+Math.min(0,y-offset.top);x=Math.max(0,x-cont.width()-offset.left)+Math.min(0,x-offset.left)}list.scroll.moveX=x==0?0:x*opts.scrollSpeed/Math.abs(x);list.scroll.moveY=y==0?0:y*opts.scrollSpeed/Math.abs(y);this.draggedItem.css({top:top,left:left})},wheel:function(e){if((userBrowser()=="Safari"||userBrowser()=="Firefox")&&list&&opts.scrollContainer!=window){var cont=$(opts.scrollContainer);var offset=cont.offset();if(e.pageX>offset.left&&e.pageX<offset.left+cont.width()&&e.pageY>offset.top&&e.pageY<offset.top+cont.height()){var delta=e.detail?e.detail*5:e.wheelDelta/-2;cont.scrollTop(cont.scrollTop()+delta);e.preventDefault()}}},buildPositionTable:function(){var pos=[];this.getItems().not([list.draggedItem[0],list.placeHolderItem[0]]).each(function(i){var loc=$(this).offset();loc.right=loc.left+$(this).outerWidth();loc.bottom=loc.top+$(this).outerHeight();loc.elm=this;pos[i]=loc});this.pos=pos},dropItem:function(){if(list.draggedItem==null){return}var orig=list.draggedItem.attr("data-origstyle");list.draggedItem.attr("style",orig);if(orig==""){list.draggedItem.removeAttr("style")}list.draggedItem.removeAttr("data-origstyle");list.styleDragHandlers(true);list.placeHolderItem.before(list.draggedItem);list.placeHolderItem.remove();$("[data-droptarget], .dragSortItem").remove();window.clearInterval(list.scroll.scrollY);window.clearInterval(list.scroll.scrollX);if(list.draggedItem.attr("data-origpos")!=$(lists).index(list)+"-"+list.getItems().index(list.draggedItem)){opts.dragEnd.apply(list.draggedItem)}list.draggedItem.removeAttr("data-origpos");list.draggedItem=null;$(document).unbind("mousemove",list.swapItems);$(document).unbind("mouseup",list.dropItem);if(opts.scrollContainer!=window){$(window).unbind("DOMMouseScroll mousewheel",list.wheel)}return false},swapItems:function(e){if(list.draggedItem==null){return false}list.setPos(e.pageX,e.pageY);
var ei=list.findPos(e.pageX,e.pageY);var nlist=list;for(var i=0;ei==-1&&opts.dragBetween&&i<lists.length;i++){ei=lists[i].findPos(e.pageX,e.pageY);nlist=lists[i]}if(ei==-1){return false}var children=function(){return $(nlist.container).children().not(nlist.draggedItem)};var fixed=children().not(opts.itemSelector).each(function(i){this.idx=children().index(this)});if(lastPos==null||lastPos.top>list.draggedItem.offset().top||lastPos.left>list.draggedItem.offset().left){$(nlist.pos[ei].elm).before(list.placeHolderItem)}else{$(nlist.pos[ei].elm).after(list.placeHolderItem)}fixed.each(function(){var elm=children().eq(this.idx).get(0);if(this!=elm&&children().index(this)<this.idx){$(this).insertAfter(elm)}else{if(this!=elm){$(this).insertBefore(elm)}}});$(lists).each(function(i,l){l.createDropTargets();l.buildPositionTable()});lastPos=list.draggedItem.offset();return false},findPos:function(x,y){for(var i=0;i<this.pos.length;i++){if(this.pos[i].left<x&&this.pos[i].right>x&&this.pos[i].top<y&&this.pos[i].bottom>y){return i}}return -1},createDropTargets:function(){if(!opts.dragBetween){return}$(lists).each(function(){var ph=$(this.container).find("[data-placeholder]");var dt=$(this.container).find("[data-droptarget]");if(ph.size()>0&&dt.size()>0){dt.remove()}else{if(ph.size()==0&&dt.size()==0){if(opts.itemSelector=="td"){$(opts.placeHolderTemplate).attr("data-droptarget",true).appendTo(this.container)}else{$(this.container).append(list.placeHolderItem.removeAttr("data-placeholder").clone().attr("data-droptarget",true))}list.placeHolderItem.attr("data-placeholder",true)}}})}};newList.init();lists.push(newList)});return this};$.fn.dragsort.defaults={itemSelector:"",dragSelector:"",dragSelectorExclude:"input, textarea",dragEnd:function(){},dragBetween:false,placeHolderTemplate:"",scrollContainer:window,scrollSpeed:5}})(jQuery);
(function($){$.fn.dcAccordion=function(options){var defaults={classParent:"dcjq-parent",classActive:"active",classArrow:"dcjq-icon",classCount:"dcjq-count",classExpand:"dcjq-current-parent",eventType:"click",hoverDelay:300,menuClose:true,autoClose:true,autoExpand:false,speed:"slow",saveState:true,disableLink:true,showCount:false,};var options=$.extend(defaults,options);this.each(function(options){var obj=this;setUpAccordion();if(defaults.autoExpand==true){$("li."+defaults.classExpand+" > a").addClass(defaults.classActive)}resetAccordion();if(defaults.eventType=="hover"){var config={sensitivity:2,interval:defaults.hoverDelay,over:linkOver,timeout:defaults.hoverDelay,out:linkOut};$("li a",obj).hoverIntent(config);var configMenu={sensitivity:2,interval:1000,over:menuOver,timeout:1000,out:menuOut};$(obj).hoverIntent(configMenu);if(defaults.disableLink==true){$("li a",obj).click(function(e){if($(this).siblings("ul").length>0){e.preventDefault()}})}}else{$("li a",obj).click(function(e){$activeLi=$(this).parent("li");$parentsLi=$activeLi.parents("li");$parentsUl=$activeLi.parents("ul");if(defaults.disableLink==true){if($(this).siblings("ul").length>0){e.preventDefault()}}if(defaults.autoClose==true){autoCloseAccordion($parentsLi,$parentsUl)}if($("> ul",$activeLi).is(":visible")){$("ul",$activeLi).slideUp(defaults.speed);$("a",$activeLi).removeClass(defaults.classActive)}else{$(this).siblings("ul").slideToggle(defaults.speed);$("> a",$activeLi).addClass(defaults.classActive)}})}function setUpAccordion(){$arrow='<span class="'+defaults.classArrow+'"></span>';var classParentLi=defaults.classParent+"-li";$("> ul",obj).show();$("li",obj).each(function(){if($("> ul",this).length>0){$(this).addClass(classParentLi);$("> a",this).addClass(defaults.classParent).append($arrow)}});$("> ul",obj).hide();if(defaults.showCount==true){$("li."+classParentLi,obj).each(function(){if(defaults.disableLink==true){var getCount=parseInt($("ul a:not(."+defaults.classParent+")",this).length)}else{var getCount=parseInt($("ul a",this).length)
}$("> a",this).append(' <span class="'+defaults.classCount+'">'+getCount+"</span>")})}}function linkOver(){$activeLi=$(this).parent("li");$parentsLi=$activeLi.parents("li");$parentsUl=$activeLi.parents("ul");if(defaults.autoClose==true){autoCloseAccordion($parentsLi,$parentsUl)}if($("> ul",$activeLi).is(":visible")){$("ul",$activeLi).slideUp(defaults.speed);$("a",$activeLi).removeClass(defaults.classActive)}else{$(this).siblings("ul").slideToggle(defaults.speed);$("> a",$activeLi).addClass(defaults.classActive)}if(defaults.saveState==true){createCookie(defaults.cookie,obj)}}function linkOut(){}function menuOver(){}function menuOut(){if(defaults.menuClose==true){$("ul",obj).slideUp(defaults.speed);$("a",obj).removeClass(defaults.classActive);createCookie(defaults.cookie,obj)}}function autoCloseAccordion($parentsLi,$parentsUl){$("ul",obj).not($parentsUl).slideUp(defaults.speed);$("a",obj).removeClass(defaults.classActive);$("> a",$parentsLi).addClass(defaults.classActive)}function resetAccordion(){$("ul",obj).hide();$allActiveLi=$("a."+defaults.classActive,obj);$allActiveLi.siblings("ul").show()}})}})(jQuery);
(function($){var methods={init:function(options){var form=this;if(!form.data("jqv")||form.data("jqv")==null){options=methods._saveOptions(form,options);$(document).on("click",".formError",function(){$(this).fadeOut(150,function(){$(this).parent(".formErrorOuter").remove();$(this).remove()})})}return this},attach:function(userOptions){var form=this;var options;if(userOptions){options=methods._saveOptions(form,userOptions)}else{options=form.data("jqv")}options.validateAttribute=(form.find("[data-validation-engine*=validate]").length)?"data-validation-engine":"class";if(options.binded){form.on(options.validationEventTrigger,"["+options.validateAttribute+"*=validate]:not([type=checkbox]):not([type=radio]):not(.datepicker):not([readonly])",methods._onFieldEvent);form.on("click","["+options.validateAttribute+"*=validate][type=checkbox],["+options.validateAttribute+"*=validate][type=radio]",methods._onFieldEvent);form.on("ifChecked","["+options.validateAttribute+"*=validate][type=checkbox],["+options.validateAttribute+"*=validate][type=radio]",methods._onFieldEvent);form.on(options.validationEventTrigger,"["+options.validateAttribute+"*=validate][class*=datepicker]",{"delay":300},methods._onFieldEvent)}if(options.autoPositionUpdate){$(window).bind("resize",{"noAnimation":true,"formElem":form},methods.updatePromptsPosition)}form.on("click","a[data-validation-engine-skip], a[class*='validate-skip'], button[data-validation-engine-skip], button[class*='validate-skip'], input[data-validation-engine-skip], input[class*='validate-skip']",methods._submitButtonClick);form.removeData("jqv_submitButton");form.on("submit",methods._onSubmitEvent);return this},detach:function(){var form=this;var options=form.data("jqv");form.off(options.validationEventTrigger,"["+options.validateAttribute+"*=validate]:not([type=checkbox]):not([type=radio]):not(.datepicker)",methods._onFieldEvent);form.off("click","["+options.validateAttribute+"*=validate][type=checkbox],["+options.validateAttribute+"*=validate][type=radio]",methods._onFieldEvent);
form.off("ifChecked","["+options.validateAttribute+"*=validate][type=checkbox],["+options.validateAttribute+"*=validate][type=radio]",methods._onFieldEvent);form.off(options.validationEventTrigger,"["+options.validateAttribute+"*=validate][class*=datepicker]",methods._onFieldEvent);form.off("submit",methods._onSubmitEvent);form.removeData("jqv");form.off("click","a[data-validation-engine-skip], a[class*='validate-skip'], button[data-validation-engine-skip], button[class*='validate-skip'], input[data-validation-engine-skip], input[class*='validate-skip']",methods._submitButtonClick);form.removeData("jqv_submitButton");if(options.autoPositionUpdate){$(window).off("resize",methods.updatePromptsPosition)}return this},validate:function(){var element=$(this);var valid=null;if(element.is("form")||element.hasClass("validationEngineContainer")){if(element.hasClass("validating")){return false}else{element.addClass("validating");var options=element.data("jqv");var valid=methods._validateFields(this);setTimeout(function(){element.removeClass("validating")},100);if(valid&&options.onSuccess){options.onSuccess()}else{if(!valid&&options.onFailure){options.onFailure()}}}}else{if(element.is("form")||element.hasClass("validationEngineContainer")){element.removeClass("validating")}else{var form=element.closest("form, .validationEngineContainer"),options=(form.data("jqv"))?form.data("jqv"):$.validationEngine.defaults,valid=methods._validateField(element,options);if(valid&&options.onFieldSuccess){options.onFieldSuccess()}else{if(options.onFieldFailure&&options.InvalidFields.length>0){options.onFieldFailure()}}}}if(options.onValidationComplete){return !!options.onValidationComplete(form,valid)}return valid},updatePromptsPosition:function(event){if(event&&this==window){var form=event.data.formElem;var noAnimation=event.data.noAnimation}else{var form=$(this.closest("form, .validationEngineContainer"))}var options=form.data("jqv");form.find("["+options.validateAttribute+"*=validate]").not(":disabled").each(function(){var field=$(this);
if(options.prettySelect&&field.is(":hidden")){field=form.find("#"+options.usePrefix+field.attr("id")+options.useSuffix)}var prompt=methods._getPrompt(field);var promptText=$(prompt).find(".formErrorContent").html();if(prompt){methods._updatePrompt(field,$(prompt),promptText,undefined,false,options,noAnimation)}});return this},showPrompt:function(promptText,type,promptPosition,showArrow){var form=this.closest("form, .validationEngineContainer");var options=form.data("jqv");if(!options){options=methods._saveOptions(this,options)}if(promptPosition){options.promptPosition=promptPosition}options.showArrow=showArrow==true;methods._showPrompt(this,promptText,type,false,options);return this},hide:function(){var form=$(this).closest("form, .validationEngineContainer");var options=form.data("jqv");var fadeDuration=(options&&options.fadeDuration)?options.fadeDuration:0.3;var closingtag;if($(this).is("form")||$(this).hasClass("validationEngineContainer")){closingtag="parentForm"+methods._getClassName($(this).attr("id"))}else{closingtag=methods._getClassName($(this).attr("id"))+"formError"}$("."+closingtag).fadeTo(fadeDuration,0.3,function(){$(this).parent(".formErrorOuter").remove();$(this).remove()});return this},hideAll:function(){var form=this;var options=form.data("jqv");var duration=options?options.fadeDuration:300;$(".formError").fadeTo(duration,300,function(){$(this).parent(".formErrorOuter").remove();$(this).remove()});return this},_onFieldEvent:function(event){var field=$(this);var form=field.closest("form, .validationEngineContainer");var options=form.data("jqv");options.eventTrigger="field";window.setTimeout(function(){methods._validateField(field,options);if(options.InvalidFields.length==0&&options.onFieldSuccess){options.onFieldSuccess()}else{if(options.InvalidFields.length>0&&options.onFieldFailure){options.onFieldFailure()}}},(event.data)?event.data.delay:0)},_onSubmitEvent:function(){var form=$(this);var options=form.data("jqv");if(form.data("jqv_submitButton")){var submitButton=$("#"+form.data("jqv_submitButton"));
if(submitButton){if(submitButton.length>0){if(submitButton.hasClass("validate-skip")||submitButton.attr("data-validation-engine-skip")=="true"){return true}}}}options.eventTrigger="submit";var r=methods._validateFields(form);if(r&&options.ajaxFormValidation){methods._validateFormWithAjax(form,options);return false}if(options.onValidationComplete){return !!options.onValidationComplete(form,r)}return r},_checkAjaxStatus:function(options){var status=true;$.each(options.ajaxValidCache,function(key,value){if(!value){status=false;return false}});return status},_checkAjaxFieldStatus:function(fieldid,options){return options.ajaxValidCache[fieldid]==true},_validateFields:function(form){var options=form.data("jqv");var errorFound=false;form.trigger("jqv.form.validating");var first_err=null;form.find("["+options.validateAttribute+"*=validate]").not(":disabled").each(function(){var field=$(this);var names=[];if($.inArray(field.attr("name"),names)<0){errorFound|=methods._validateField(field,options);if(errorFound&&first_err==null){if(field.is(":hidden")&&options.prettySelect){first_err=field=form.find("#"+options.usePrefix+methods._jqSelector(field.attr("id"))+options.useSuffix)}else{if(field.data("jqv-prompt-at") instanceof jQuery){field=field.data("jqv-prompt-at")}else{if(field.data("jqv-prompt-at")){field=$(field.data("jqv-prompt-at"))}}first_err=field}}if(options.doNotShowAllErrosOnSubmit){return false}names.push(field.attr("name"));if(options.showOneMessage==true&&errorFound){return false}}});form.trigger("jqv.form.result",[errorFound]);if(errorFound){if(options.scroll){var destination=0,fixleft=0;var offsetParent=first_err.offsetParent();if(!offsetParent.length){destination=first_err.offset().top;fixleft=first_err.offset().left}else{destination=first_err.position().top;fixleft=first_err.position().left}var positionType=options.promptPosition;if(typeof(positionType)=="string"&&positionType.indexOf(":")!=-1){positionType=positionType.substring(0,positionType.indexOf(":"))}if(positionType!="bottomRight"&&positionType!="bottomLeft"){var prompt_err=methods._getPrompt(first_err);
if(prompt_err){if(!offsetParent.length){destination=prompt_err.offset().top}else{destination=prompt_err.position().top}}}if(options.scrollOffset){destination-=options.scrollOffset}if(options.isOverflown){var overflowDIV=first_err.closest(options.overflowDIV);if(!overflowDIV.length){return false}overflowDIV.animate({scrollTop:destination},1100,function(){if(options.focusFirstField){first_err.focus()}})}else{$("html, body").animate({scrollTop:destination},1100,function(){if(options.focusFirstField){first_err.focus()}})}}else{if(options.focusFirstField){first_err.focus()}}return false}return true},_validateFormWithAjax:function(form,options){var data=form.serialize();var type=(options.ajaxFormValidationMethod)?options.ajaxFormValidationMethod:"GET";var url=(options.ajaxFormValidationURL)?options.ajaxFormValidationURL:form.attr("action");var dataType=(options.dataType)?options.dataType:"json";$.ajax({type:type,url:url,cache:false,dataType:dataType,data:data,form:form,methods:methods,options:options,beforeSend:function(){return options.onBeforeAjaxFormValidation(form,options)},error:function(data,transport){if(options.onFailure){options.onFailure(data,transport)}else{methods._ajaxError(data,transport)}},success:function(json){if((dataType=="json")&&(json!==true)){var errorInForm=false;for(var i=0;i<json.length;i++){var value=json[i];var errorFieldId=value[0];var errorField=$($("#"+errorFieldId)[0]);if(errorField.length==1){var msg=value[2];if(value[1]==true){if(msg==""||!msg){methods._closePrompt(errorField)}else{if(options.allrules[msg]){var txt=options.allrules[msg].alertTextOk;if(txt){msg=txt}}if(options.showPrompts){methods._showPrompt(errorField,msg,"pass",false,options,true)}}}else{errorInForm|=true;if(options.allrules[msg]){var txt=options.allrules[msg].alertText;if(txt){msg=txt}}if(options.showPrompts){methods._showPrompt(errorField,msg,"",false,options,true)}}}}options.onAjaxFormComplete(!errorInForm,form,json,options)}else{options.onAjaxFormComplete(true,form,json,options)
}}})},_validateField:function(field,options,skipAjaxValidation){if(!field.attr("id")){field.attr("id","form-validation-field-"+$.validationEngine.fieldIdCounter);++$.validationEngine.fieldIdCounter}if(!options.validateNonVisibleFields&&(field.is(":hidden")&&!options.prettySelect||field.parent().is(":hidden"))){return false}var rulesParsing=field.attr(options.validateAttribute);var getRules=/validate\[(.*)\]/.exec(rulesParsing);if(!getRules){return false}var str=getRules[1];var rules=str.split(/\[|,|\]/);var isAjaxValidator=false;var fieldName=field.attr("name");var promptText="";var promptType="";var required=false;var limitErrors=false;options.isError=false;options.showArrow=true;if(options.maxErrorsPerField>0){limitErrors=true}var form=$(field.closest("form, .validationEngineContainer"));for(var i=0;i<rules.length;i++){rules[i]=rules[i].replace(" ","");if(rules[i]===""){delete rules[i]}}for(var i=0,field_errors=0;i<rules.length;i++){if(limitErrors&&field_errors>=options.maxErrorsPerField){if(!required){var have_required=$.inArray("required",rules);required=(have_required!=-1&&have_required>=i)}break}var errorMsg=undefined;switch(rules[i]){case"required":required=true;errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._required);break;case"custom":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._custom);break;case"groupRequired":var classGroup="["+options.validateAttribute+"*="+rules[i+1]+"]";var firstOfGroup=form.find(classGroup).eq(0);if(firstOfGroup[0]!=field[0]){methods._validateField(firstOfGroup,options,skipAjaxValidation);options.showArrow=true}errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._groupRequired);if(errorMsg){required=true}options.showArrow=false;break;case"ajax":errorMsg=methods._ajax(field,rules,i,options);if(errorMsg){promptType="load"}break;case"minSize":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._minSize);break;case"maxSize":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._maxSize);
break;case"min":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._min);break;case"max":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._max);break;case"past":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._past);break;case"future":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._future);break;case"dateRange":var classGroup="["+options.validateAttribute+"*="+rules[i+1]+"]";options.firstOfGroup=form.find(classGroup).eq(0);options.secondOfGroup=form.find(classGroup).eq(1);if(options.firstOfGroup[0].value||options.secondOfGroup[0].value){errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._dateRange)}if(errorMsg){required=true}options.showArrow=false;break;case"dateTimeRange":var classGroup="["+options.validateAttribute+"*="+rules[i+1]+"]";options.firstOfGroup=form.find(classGroup).eq(0);options.secondOfGroup=form.find(classGroup).eq(1);if(options.firstOfGroup[0].value||options.secondOfGroup[0].value){errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._dateTimeRange)}if(errorMsg){required=true}options.showArrow=false;break;case"maxCheckbox":field=$(form.find("input[name='"+fieldName+"']"));errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._maxCheckbox);break;case"minCheckbox":field=$(form.find("input[name='"+fieldName+"']"));errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._minCheckbox);break;case"equals":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._equals);break;case"funcCall":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._funcCall);break;case"creditCard":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._creditCard);break;case"condRequired":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._condRequired);if(errorMsg!==undefined){required=true
}break;case"minTag":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._minTag);break;case"maxTag":errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._maxTag);break;default:}var end_validation=false;if(typeof errorMsg=="object"){switch(errorMsg.status){case"_break":end_validation=true;break;case"_error":errorMsg=errorMsg.message;break;case"_error_no_prompt":return true;break;default:break}}if(end_validation){break}if(typeof errorMsg=="string"){promptText+="["+errorMsg+"]";options.isError=true;field_errors++}}if(!required&&!(field.val())&&field.val().length<1&&$.inArray("equals",rules)<0){options.isError=false}var fieldType=field.prop("type");var positionType=field.data("promptPosition")||options.promptPosition;if((fieldType=="radio"||fieldType=="checkbox")&&form.find("input[name='"+fieldName+"']").size()>1){if(positionType==="inline"){field=$(form.find("input[name='"+fieldName+"'][type!=hidden]:last"))}else{field=$(form.find("input[name='"+fieldName+"'][type!=hidden]:first"))}options.showArrow=options.showArrowOnRadioAndCheckbox}if(field.is(":hidden")&&options.prettySelect){field=form.find("#"+options.usePrefix+methods._jqSelector(field.attr("id"))+options.useSuffix)}if(options.isError&&options.showPrompts){methods._showPrompt(field,promptText,promptType,false,options)}else{if(!isAjaxValidator){methods._closePrompt(field)}}if(!isAjaxValidator){field.trigger("jqv.field.result",[field,options.isError,promptText])}var errindex=$.inArray(field[0],options.InvalidFields);if(errindex==-1){if(options.isError){options.InvalidFields.push(field[0])}}else{if(!options.isError){options.InvalidFields.splice(errindex,1)}}methods._handleStatusCssClasses(field,options);if(options.isError&&options.onFieldFailure){options.onFieldFailure(field)}if(!options.isError&&options.onFieldSuccess){options.onFieldSuccess(field)}return options.isError},_handleStatusCssClasses:function(field,options){if(options.addSuccessCssClassToField){field.removeClass(options.addSuccessCssClassToField)
}if(options.addFailureCssClassToField){field.removeClass(options.addFailureCssClassToField)}if(options.addSuccessCssClassToField&&!options.isError){field.addClass(options.addSuccessCssClassToField)}if(options.addFailureCssClassToField&&options.isError){field.addClass(options.addFailureCssClassToField)}},_getErrorMessage:function(form,field,rule,rules,i,options,originalValidationMethod){var rule_index=jQuery.inArray(rule,rules);if(rule==="custom"||rule==="funcCall"){var custom_validation_type=rules[rule_index+1];rule=rule+"["+custom_validation_type+"]";delete (rules[rule_index])}var alteredRule=rule;var element_classes=(field.attr("data-validation-engine"))?field.attr("data-validation-engine"):field.attr("class");var element_classes_array=element_classes.split(" ");var errorMsg;if(rule=="future"||rule=="past"||rule=="maxCheckbox"||rule=="minCheckbox"){errorMsg=originalValidationMethod(form,field,rules,i,options)}else{errorMsg=originalValidationMethod(field,rules,i,options)}if(errorMsg!=undefined){var custom_message=methods._getCustomErrorMessage($(field),element_classes_array,alteredRule,options);if(custom_message){errorMsg=custom_message}}return errorMsg},_getCustomErrorMessage:function(field,classes,rule,options){var custom_message=false;var validityProp=/^custom\[.*\]$/.test(rule)?methods._validityProp["custom"]:methods._validityProp[rule];if(validityProp!=undefined){custom_message=field.attr("data-errormessage-"+validityProp);if(custom_message!=undefined){return custom_message}}custom_message=field.attr("data-errormessage");if(custom_message!=undefined){return custom_message}var id="#"+field.attr("id");if(typeof options.custom_error_messages[id]!="undefined"&&typeof options.custom_error_messages[id][rule]!="undefined"){custom_message=options.custom_error_messages[id][rule]["message"]}else{if(classes.length>0){for(var i=0;i<classes.length&&classes.length>0;i++){var element_class="."+classes[i];if(typeof options.custom_error_messages[element_class]!="undefined"&&typeof options.custom_error_messages[element_class][rule]!="undefined"){custom_message=options.custom_error_messages[element_class][rule]["message"];
break}}}}if(!custom_message&&typeof options.custom_error_messages[rule]!="undefined"&&typeof options.custom_error_messages[rule]["message"]!="undefined"){custom_message=options.custom_error_messages[rule]["message"]}return custom_message},_validityProp:{"required":"value-missing","custom":"custom-error","groupRequired":"value-missing","ajax":"custom-error","minSize":"range-underflow","maxSize":"range-overflow","min":"range-underflow","max":"range-overflow","past":"type-mismatch","future":"type-mismatch","dateRange":"type-mismatch","dateTimeRange":"type-mismatch","maxCheckbox":"range-overflow","minCheckbox":"range-underflow","equals":"pattern-mismatch","funcCall":"custom-error","creditCard":"pattern-mismatch","condRequired":"value-missing","minTag":"range-underflow","maxTag":"range-overflow"},_required:function(field,rules,i,options,condRequired){switch(field.prop("type")){case"text":case"password":case"textarea":case"file":case"select-one":case"select-multiple":default:var field_val=$.trim(field.val());var dv_placeholder=$.trim(field.attr("data-validation-placeholder"));var placeholder=$.trim(field.attr("placeholder"));if(field.hasClass("tags-control")){var field_val=$.trim(field.find(":hidden").val());var dv_placeholder=$.trim(field.attr("data-validation-placeholder"));var placeholder=$.trim(field.attr("placeholder"));if((!field_val)||(dv_placeholder&&field_val==dv_placeholder)||(placeholder&&field_val==placeholder)){return options.allrules[rules[i]].alertText}}else{if((!field_val)||(dv_placeholder&&field_val==dv_placeholder)||(placeholder&&field_val==placeholder)){return options.allrules[rules[i]].alertText}}break;case"radio":case"checkbox":if(condRequired){if(!field.attr("checked")){return options.allrules[rules[i]].alertTextCheckboxMultiple}break}var form=field.closest("form, .validationEngineContainer");var name=field.attr("name");if(form.find("input[name='"+name+"']:checked").size()==0){if(form.find("input[name='"+name+"']:visible").size()==1){return options.allrules[rules[i]].alertTextCheckboxe
}else{return options.allrules[rules[i]].alertTextCheckboxMultiple}}break;case"button":var field_val=$.trim(field.parent().prev().val());var dv_placeholder=$.trim(field.attr("data-validation-placeholder"));var placeholder=$.trim(field.attr("placeholder"));if((!field_val)||(dv_placeholder&&field_val==dv_placeholder)||(placeholder&&field_val==placeholder)){return options.allrules[rules[i]].alertText}break}},_groupRequired:function(field,rules,i,options){var classGroup="["+options.validateAttribute+"*="+rules[i+1]+"]";var isValid=false;field.closest("form, .validationEngineContainer").find(classGroup).each(function(){if(!methods._required($(this),rules,i,options)){isValid=true;return false}});if(!isValid){return options.allrules[rules[i]].alertText}},_custom:function(field,rules,i,options){var customRule=rules[i+1];var rule=options.allrules[customRule];var fn;if(!rule){alert("jqv:custom rule not found - "+customRule);return}if(rule["regex"]){var ex=rule.regex;if(!ex){alert("jqv:custom regex not found - "+customRule);return}var pattern=new RegExp(ex);if(!pattern.test(field.val())){return options.allrules[customRule].alertText}}else{if(rule["func"]){fn=rule["func"];if(typeof(fn)!=="function"){alert("jqv:custom parameter 'function' is no function - "+customRule);return}if(!fn(field,rules,i,options)){return options.allrules[customRule].alertText}}else{alert("jqv:custom type not allowed "+customRule);return}}},_funcCall:function(field,rules,i,options){var functionName=rules[i+1];var fn;if(functionName.indexOf(".")>-1){var namespaces=functionName.split(".");var scope=window;while(namespaces.length){scope=scope[namespaces.shift()]}fn=scope}else{fn=window[functionName]||options.customFunctions[functionName]}if(typeof(fn)=="function"){return fn(field,rules,i,options)}},_equals:function(field,rules,i,options){var equalsField=rules[i+1];if(field.val()!=$("#"+equalsField).val()){return options.allrules.equals.alertText}},_maxSize:function(field,rules,i,options){var max=rules[i+1];var len=field.val().length;
if(len>max){var rule=options.allrules.maxSize;return rule.alertText+max+rule.alertText2}},_minSize:function(field,rules,i,options){var min=rules[i+1];var len=field.val().length;if(len<min){var rule=options.allrules.minSize;return rule.alertText+min+rule.alertText2}},_maxTag:function(field,rules,i,options){var max=rules[i+1];var len=field.find(":hidden").length;if(len>max){var rule=options.allrules.maxTag;return rule.alertText+max+rule.alertText2}},_minTag:function(field,rules,i,options){var min=rules[i+1];var len=field.find(":hidden").length;if(len<min){var rule=options.allrules.minTag;return rule.alertText+min+rule.alertText2}},_min:function(field,rules,i,options){var min=parseFloat(rules[i+1]);var len=parseFloat(field.val());if(len<min){var rule=options.allrules.min;if(rule.alertText2){return rule.alertText+min+rule.alertText2}return rule.alertText+min}},_max:function(field,rules,i,options){var max=parseFloat(rules[i+1]);var len=parseFloat(field.val());if(len>max){var rule=options.allrules.max;if(rule.alertText2){return rule.alertText+max+rule.alertText2}return rule.alertText+max}},_past:function(form,field,rules,i,options){var p=rules[i+1];var fieldAlt=$(form.find("*[name='"+p.replace(/^#+/,"")+"']"));var pdate;if(p.toLowerCase()=="now"){pdate=new Date()}else{if(undefined!=fieldAlt.val()){if(fieldAlt.is(":disabled")){return}pdate=methods._parseDate(fieldAlt.val())}else{pdate=methods._parseDate(p)}}var vdate=methods._parseDate(field.val());if(vdate>pdate){var rule=options.allrules.past;if(rule.alertText2){return rule.alertText+methods._dateToString(pdate)+rule.alertText2}return rule.alertText+methods._dateToString(pdate)}},_future:function(form,field,rules,i,options){var p=rules[i+1];var fieldAlt=$(form.find("*[name='"+p.replace(/^#+/,"")+"']"));var pdate;if(p.toLowerCase()=="now"){pdate=new Date()}else{if(undefined!=fieldAlt.val()){if(fieldAlt.is(":disabled")){return}pdate=methods._parseDate(fieldAlt.val())}else{pdate=methods._parseDate(p)}}var vdate=methods._parseDate(field.val());
if(vdate<pdate){var rule=options.allrules.future;if(rule.alertText2){return rule.alertText+methods._dateToString(pdate)+rule.alertText2}return rule.alertText+methods._dateToString(pdate)}},_isDate:function(value){var dateRegEx=new RegExp(/^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(?:(?:0?[1-9]|1[0-2])(\/|-)(?:0?[1-9]|1\d|2[0-8]))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(0?2(\/|-)29)(\/|-)(?:(?:0[48]00|[13579][26]00|[2468][048]00)|(?:\d\d)?(?:0[48]|[2468][048]|[13579][26]))$/);return dateRegEx.test(value)},_isDateTime:function(value){var dateTimeRegEx=new RegExp(/^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1}$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^((1[012]|0?[1-9]){1}\/(0?[1-9]|[12][0-9]|3[01]){1}\/\d{2,4}\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1})$/);return dateTimeRegEx.test(value)},_dateCompare:function(start,end){return(new Date(start.toString())<new Date(end.toString()))},_dateRange:function(field,rules,i,options){if((!options.firstOfGroup[0].value&&options.secondOfGroup[0].value)||(options.firstOfGroup[0].value&&!options.secondOfGroup[0].value)){return options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2}if(!methods._isDate(options.firstOfGroup[0].value)||!methods._isDate(options.secondOfGroup[0].value)){return options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2}if(!methods._dateCompare(options.firstOfGroup[0].value,options.secondOfGroup[0].value)){return options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2}},_dateTimeRange:function(field,rules,i,options){if((!options.firstOfGroup[0].value&&options.secondOfGroup[0].value)||(options.firstOfGroup[0].value&&!options.secondOfGroup[0].value)){return options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2
}if(!methods._isDateTime(options.firstOfGroup[0].value)||!methods._isDateTime(options.secondOfGroup[0].value)){return options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2}if(!methods._dateCompare(options.firstOfGroup[0].value,options.secondOfGroup[0].value)){return options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2}},_maxCheckbox:function(form,field,rules,i,options){var nbCheck=rules[i+1];var groupname=field.attr("name");var groupSize=form.find("input[name='"+groupname+"']:checked").size();if(groupSize>nbCheck){options.showArrow=false;if(options.allrules.maxCheckbox.alertText2){return options.allrules.maxCheckbox.alertText+" "+nbCheck+" "+options.allrules.maxCheckbox.alertText2}return options.allrules.maxCheckbox.alertText}},_minCheckbox:function(form,field,rules,i,options){var nbCheck=rules[i+1];var groupname=field.attr("name");var groupSize=form.find("input[name='"+groupname+"']:checked").size();if(groupSize<nbCheck){options.showArrow=false;return options.allrules.minCheckbox.alertText+" "+nbCheck+" "+options.allrules.minCheckbox.alertText2}},_creditCard:function(field,rules,i,options){var valid=false,cardNumber=field.val().replace(/ +/g,"").replace(/-+/g,"");var numDigits=cardNumber.length;if(numDigits>=14&&numDigits<=16&&parseInt(cardNumber)>0){var sum=0,i=numDigits-1,pos=1,digit,luhn=new String();do{digit=parseInt(cardNumber.charAt(i));luhn+=(pos++%2==0)?digit*2:digit}while(--i>=0);for(i=0;i<luhn.length;i++){sum+=parseInt(luhn.charAt(i))}valid=sum%10==0}if(!valid){return options.allrules.creditCard.alertText}},_ajax:function(field,rules,i,options){var errorSelector=rules[i+1];var rule=options.allrules[errorSelector];var extraData=rule.extraData;var extraDataDynamic=rule.extraDataDynamic;var data={"fieldId":field.attr("id"),"fieldValue":field.val()};if(typeof extraData==="object"){$.extend(data,extraData)}else{if(typeof extraData==="string"){var tempData=extraData.split("&");for(var i=0;i<tempData.length;i++){var values=tempData[i].split("=");
if(values[0]&&values[0]){data[values[0]]=values[1]}}}}if(extraDataDynamic){var tmpData=[];var domIds=String(extraDataDynamic).split(",");for(var i=0;i<domIds.length;i++){var id=domIds[i];if($(id).length){var inputValue=field.closest("form, .validationEngineContainer").find(id).val();var keyValue=id.replace("#","")+"="+escape(inputValue);data[id.replace("#","")]=inputValue}}}if(options.eventTrigger=="field"){delete (options.ajaxValidCache[field.attr("id")])}if(!options.isError&&!methods._checkAjaxFieldStatus(field.attr("id"),options)){$.ajax({type:options.ajaxFormValidationMethod,url:rule.url,cache:false,dataType:"json",data:data,field:field,rule:rule,methods:methods,options:options,beforeSend:function(){},error:function(data,transport){if(options.onFailure){options.onFailure(data,transport)}else{methods._ajaxError(data,transport)}},success:function(json){var errorFieldId=json[0];var errorField=$("#"+errorFieldId).eq(0);if(errorField.length==1){var status=json[1];var msg=json[2];if(!status){options.ajaxValidCache[errorFieldId]=false;options.isError=true;if(msg){if(options.allrules[msg]){var txt=options.allrules[msg].alertText;if(txt){msg=txt}}}else{msg=rule.alertText}if(options.showPrompts){methods._showPrompt(errorField,msg,"",true,options)}}else{options.ajaxValidCache[errorFieldId]=true;if(msg){if(options.allrules[msg]){var txt=options.allrules[msg].alertTextOk;if(txt){msg=txt}}}else{msg=rule.alertTextOk}if(options.showPrompts){if(msg){methods._showPrompt(errorField,msg,"pass",true,options)}else{methods._closePrompt(errorField)}}if(options.eventTrigger=="submit"){field.closest("form").submit()}}}errorField.trigger("jqv.field.result",[errorField,options.isError,msg])}});return rule.alertTextLoad}},_ajaxError:function(data,transport){if(data.status==0&&transport==null){alert("The page is not served from a server! ajax call failed")}else{if(typeof console!="undefined"){console.log("Ajax error: "+data.status+" "+transport)}}},_dateToString:function(date){return date.getFullYear()+"-"+(date.getMonth()+1)+"-"+date.getDate()
},_parseDate:function(d){var dateParts=d.split("-");if(dateParts==d){dateParts=d.split("/")}if(dateParts==d){dateParts=d.split(".");return new Date(dateParts[2],(dateParts[1]-1),dateParts[0])}return new Date(dateParts[0],(dateParts[1]-1),dateParts[2])},_showPrompt:function(field,promptText,type,ajaxed,options,ajaxform){if(field.data("jqv-prompt-at") instanceof jQuery){field=field.data("jqv-prompt-at")}else{if(field.data("jqv-prompt-at")){field=$(field.data("jqv-prompt-at"))}}var prompt=methods._getPrompt(field);if(ajaxform){prompt=false}if($.trim(promptText)){if(prompt){methods._updatePrompt(field,prompt,promptText,type,ajaxed,options)}else{methods._buildPrompt(field,promptText,type,ajaxed,options)}}},_buildPrompt:function(field,promptText,type,ajaxed,options){var prompt=$("<div>");prompt.addClass(methods._getClassName(field.attr("id"))+"formError");prompt.addClass("parentForm"+methods._getClassName(field.closest("form, .validationEngineContainer").attr("id")));prompt.addClass("formError");switch(type){case"pass":prompt.addClass("greenPopup");break;case"load":prompt.addClass("blackPopup");break;default:}if(ajaxed){prompt.addClass("ajaxed")}var promptContent=$("<div>").addClass("formErrorContent").html(promptText).appendTo(prompt);var positionType=field.data("promptPosition")||options.promptPosition;if(options.showArrow){var arrow=$("<div>").addClass("formErrorArrow");if(typeof(positionType)=="string"){var pos=positionType.indexOf(":");if(pos!=-1){positionType=positionType.substring(0,pos)}}switch(positionType){case"bottomLeft":case"bottomRight":prompt.find(".formErrorContent").before(arrow);arrow.addClass("formErrorArrowBottom").html('<div class="line1"><!-- --></div><div class="line2"><!-- --></div><div class="line3"><!-- --></div><div class="line4"><!-- --></div><div class="line5"><!-- --></div><div class="line6"><!-- --></div><div class="line7"><!-- --></div><div class="line8"><!-- --></div><div class="line9"><!-- --></div><div class="line10"><!-- --></div>');break;
case"Right":prompt.find(".formErrorContent").before(arrow);prompt.find(".formErrorContent").before('<div class="tooltip-arrow"></div>');break;case"topLeft":case"topRight":arrow.html('<div class="line10"><!-- --></div><div class="line9"><!-- --></div><div class="line8"><!-- --></div><div class="line7"><!-- --></div><div class="line6"><!-- --></div><div class="line5"><!-- --></div><div class="line4"><!-- --></div><div class="line3"><!-- --></div><div class="line2"><!-- --></div><div class="line1"><!-- --></div>');prompt.append(arrow);break}}if(options.addPromptClass){prompt.addClass(options.addPromptClass)}var requiredOverride=field.attr("data-required-class");if(requiredOverride!==undefined){prompt.addClass(requiredOverride)}else{if(options.prettySelect){if($("#"+field.attr("id")).next().is("select")){var prettyOverrideClass=$("#"+field.attr("id").substr(options.usePrefix.length).substring(options.useSuffix.length)).attr("data-required-class");if(prettyOverrideClass!==undefined){prompt.addClass(prettyOverrideClass)}}}}prompt.css({"opacity":0});if(positionType==="inline"){prompt.addClass("inline");if(typeof field.attr("data-prompt-target")!=="undefined"&&$("#"+field.attr("data-prompt-target")).length>0){prompt.appendTo($("#"+field.attr("data-prompt-target")))}else{field.after(prompt)}}else{if(positionType==="Right"){prompt.appendTo($("body"))}else{field.before(prompt)}}var pos=methods._calculatePosition(field,prompt,options);prompt.css({"position":positionType==="inline"?"relative":"absolute","top":pos.callerTopPosition,"left":pos.callerleftPosition,"marginTop":pos.marginTopSize,"opacity":0}).data("callerField",field);if(options.autoHidePrompt){setTimeout(function(){prompt.animate({"opacity":0},function(){prompt.closest(".formErrorOuter").remove();prompt.remove()})},options.autoHideDelay)}return prompt.animate({"opacity":0.87})},_updatePrompt:function(field,prompt,promptText,type,ajaxed,options,noAnimation){if(prompt){if(typeof type!=="undefined"){if(type=="pass"){prompt.addClass("greenPopup")
}else{prompt.removeClass("greenPopup")}if(type=="load"){prompt.addClass("blackPopup")}else{prompt.removeClass("blackPopup")}}if(ajaxed){prompt.addClass("ajaxed")}else{prompt.removeClass("ajaxed")}prompt.find(".formErrorContent").html(promptText);var pos=methods._calculatePosition(field,prompt,options);var css={"top":pos.callerTopPosition,"left":pos.callerleftPosition,"marginTop":pos.marginTopSize};if(noAnimation){prompt.css(css)}else{prompt.animate(css)}}},_closePrompt:function(field){var prompt=methods._getPrompt(field);if(prompt){prompt.fadeTo("fast",0,function(){prompt.parent(".formErrorOuter").remove();prompt.remove()})}},closePrompt:function(field){return methods._closePrompt(field)},_getPrompt:function(field){var formId=$(field).closest("form, .validationEngineContainer").attr("id");var className=methods._getClassName(field.attr("id"))+"formError";var match=$("."+methods._escapeExpression(className)+".parentForm"+methods._getClassName(formId))[0];if(match){return $(match)}},_escapeExpression:function(selector){return selector.replace(/([#;&,\.\+\*\~':"\!\^$\[\]\(\)=>\|])/g,"\\$1")},isRTL:function(field){var $document=$(document);var $body=$("body");var rtl=(field&&field.hasClass("rtl"))||(field&&(field.attr("dir")||"").toLowerCase()==="rtl")||$document.hasClass("rtl")||($document.attr("dir")||"").toLowerCase()==="rtl"||$body.hasClass("rtl")||($body.attr("dir")||"").toLowerCase()==="rtl";return Boolean(rtl)},_calculatePosition:function(field,promptElmt,options){var parent=$(field).offsetParent();var promptTopPosition,promptleftPosition,marginTopSize;var fieldWidth=field.width();var fieldLeft=field.position().left;var fieldTop=field.position().top+parent.scrollTop();var fieldHeight=field.height();var promptHeight=promptElmt.height();var promptWidth=promptElmt.width();promptTopPosition=promptleftPosition=0;marginTopSize=-promptHeight;var parentTop=parent.offset().top;var parentLeft=parent.offset().left;var positionType=field.data("promptPosition")||options.promptPosition;
var shift1="";var shift2="";var shiftX=0;var shiftY=0;if(typeof(positionType)=="string"){if(positionType.indexOf(":")!=-1){shift1=positionType.substring(positionType.indexOf(":")+1);positionType=positionType.substring(0,positionType.indexOf(":"));if(shift1.indexOf(",")!=-1){shift2=shift1.substring(shift1.indexOf(",")+1);shift1=shift1.substring(0,shift1.indexOf(","));shiftY=parseInt(shift2);if(isNaN(shiftY)){shiftY=0}}shiftX=parseInt(shift1);if(isNaN(shift1)){shift1=0}}}switch(positionType){default:case"topRight":promptleftPosition+=fieldLeft+fieldWidth-27;promptTopPosition+=fieldTop;break;case"topLeft":promptTopPosition+=fieldTop;promptleftPosition+=fieldLeft;break;case"Right":promptTopPosition+=parentTop+fieldTop+promptHeight;promptleftPosition+=parentLeft+fieldWidth+fieldLeft+60;break;case"centerRight":promptTopPosition=fieldTop+3;marginTopSize=0;promptleftPosition=fieldWidth-promptElmt.width();break;case"centerLeft":promptleftPosition=fieldLeft-(promptElmt.width()+2);promptTopPosition=fieldTop+4;marginTopSize=0;break;case"bottomLeft":promptTopPosition=fieldTop+field.height()+5;marginTopSize=0;promptleftPosition=fieldLeft;break;case"bottomRight":if(fieldWidth>105){promptleftPosition=fieldLeft+fieldWidth-105}else{promptleftPosition=fieldLeft+Math.round(fieldWidth/2)}promptTopPosition=fieldTop+field.height()+(field.attr("errTop")?parseInt(field.attr("errTop")):4);marginTopSize=0;break;case"inline":promptleftPosition=0;promptTopPosition=0;marginTopSize=0}promptleftPosition+=shiftX;promptTopPosition+=shiftY;return{"callerTopPosition":promptTopPosition+"px","callerleftPosition":promptleftPosition+"px","marginTopSize":marginTopSize+"px"}},_saveOptions:function(form,options){if($.validationEngineLanguage){var allRules=$.validationEngineLanguage.allRules}else{$.error("jQuery.validationEngine rules are not loaded, plz add localization files to the page")}$.validationEngine.defaults.allrules=allRules;var userOptions=$.extend(true,{},$.validationEngine.defaults,options);form.data("jqv",userOptions);
return userOptions},_getClassName:function(className){if(className){return className.replace(/:/g,"_").replace(/\./g,"_")}},_jqSelector:function(str){return str.replace(/([;&,\.\+\*\~':"\!\^#$%@\[\]\(\)=>\|])/g,"\\$1")},_condRequired:function(field,rules,i,options){var idx,dependingField;for(idx=(i+1);idx<rules.length;idx++){dependingField=jQuery("#"+rules[idx]).first();if(dependingField.length&&methods._required(dependingField,["required"],0,options,true)==undefined){return methods._required(field,["required"],0,options)}}},_submitButtonClick:function(event){var button=$(this);var form=button.closest("form, .validationEngineContainer");form.data("jqv_submitButton",button.attr("id"))}};$.fn.validationEngine=function(method){var form=$(this);if(!form[0]){return form}if(typeof(method)=="string"&&method.charAt(0)!="_"&&methods[method]){if(method!="showPrompt"&&method!="hide"&&method!="hideAll"){methods.init.apply(form)}return methods[method].apply(form,Array.prototype.slice.call(arguments,1))}else{if(typeof method=="object"||!method){methods.init.apply(form,arguments);return methods.attach.apply(form)}else{$.error("Method "+method+" does not exist in jQuery.validationEngine")}}};$.validationEngine={fieldIdCounter:0,defaults:{validationEventTrigger:"blur",scroll:true,focusFirstField:true,showPrompts:true,validateNonVisibleFields:false,promptPosition:"topRight",bindMethod:"bind",inlineAjax:false,ajaxFormValidation:false,ajaxFormValidationURL:false,ajaxFormValidationMethod:"get",onAjaxFormComplete:$.noop,onBeforeAjaxFormValidation:$.noop,onValidationComplete:false,doNotShowAllErrosOnSubmit:false,custom_error_messages:{},binded:true,showArrow:true,showArrowOnRadioAndCheckbox:false,isError:false,maxErrorsPerField:false,ajaxValidCache:{},autoPositionUpdate:false,InvalidFields:[],onFieldSuccess:false,onFieldFailure:false,onSuccess:false,onFailure:false,validateAttribute:"class",addSuccessCssClassToField:"",addFailureCssClassToField:"",autoHidePrompt:false,autoHideDelay:10000,fadeDuration:0.3,prettySelect:false,addPromptClass:"",usePrefix:"",useSuffix:"",showOneMessage:false}};
$(function(){$.validationEngine.defaults.promptPosition=methods.isRTL()?"topLeft":"topRight"})})(jQuery);
/*!
Autosize v1.18.1 - 2013-11-05
Automatically adjust textarea height based on user input.
(c) 2013 Jack Moore - http://www.jacklmoore.com/autosize
license: http://www.opensource.org/licenses/mit-license.php
*/
(function(e){var t,o={className:"autosizejs",append:"",callback:!1,resizeDelay:10},i='<textarea tabindex="-1" style="position:absolute; top:-999px; left:0; right:auto; bottom:auto; border:0; padding: 0; -moz-box-sizing:content-box; -webkit-box-sizing:content-box; box-sizing:content-box; word-wrap:break-word; height:0 !important; min-height:0 !important; overflow:hidden; transition:none; -webkit-transition:none; -moz-transition:none;"/>',n=["fontFamily","fontSize","fontWeight","fontStyle","letterSpacing","textTransform","wordSpacing","textIndent"],s=e(i).data("autosize",!0)[0];s.style.lineHeight="99px","99px"===e(s).css("lineHeight")&&n.push("lineHeight"),s.style.lineHeight="",e.fn.autosize=function(i){return this.length?(i=e.extend({},o,i||{}),s.parentNode!==document.body&&e(document.body).append(s),this.each(function(){function o(){var t,o;"getComputedStyle" in window?(t=window.getComputedStyle(u,null),o=u.getBoundingClientRect().width,e.each(["paddingLeft","paddingRight","borderLeftWidth","borderRightWidth"],function(e,i){o-=parseInt(t[i],10)}),s.style.width=o+"px"):s.style.width=Math.max(p.width(),0)+"px"}function a(){var a={};if(t=u,s.className=i.className,d=parseInt(p.css("maxHeight"),10),e.each(n,function(e,t){a[t]=p.css(t)}),e(s).css(a),o(),window.chrome){var r=u.style.width;u.style.width="0px",u.offsetWidth,u.style.width=r}}function r(){var e,n;t!==u?a():o(),s.value=u.value+i.append,s.style.overflowY=u.style.overflowY,n=parseInt(u.style.height,10),s.scrollTop=0,s.scrollTop=90000,e=s.scrollTop,d&&e>d?(u.style.overflowY="scroll",e=d):(u.style.overflowY="hidden",c>e&&(e=c)),e+=w,n!==e&&(u.style.height=e+"px",f&&i.callback.call(u,u))}function l(){clearTimeout(h),h=setTimeout(function(){var e=p.width();e!==g&&(g=e,r())},parseInt(i.resizeDelay,10))}var d,c,h,u=this,p=e(u),w=0,f=e.isFunction(i.callback),z={height:u.style.height,overflow:u.style.overflow,overflowY:u.style.overflowY,wordWrap:u.style.wordWrap,resize:u.style.resize},g=p.width();
p.data("autosize")||(p.data("autosize",!0),("border-box"===p.css("box-sizing")||"border-box"===p.css("-moz-box-sizing")||"border-box"===p.css("-webkit-box-sizing"))&&(w=p.outerHeight()-p.height()),c=Math.max(parseInt(p.css("minHeight"),10)-w||0,p.height()),p.css({overflow:"hidden",overflowY:"hidden",wordWrap:"break-word",resize:"none"===p.css("resize")||"vertical"===p.css("resize")?"none":"horizontal"}),"onpropertychange" in u?"oninput" in u?p.on("input.autosize keyup.autosize",r):p.on("propertychange.autosize",function(){"value"===event.propertyName&&r()}):p.on("input.autosize",r),i.resizeDelay!==!1&&e(window).on("resize.autosize",l),p.on("autosize.resize",r),p.on("autosize.resizeIncludeStyle",function(){t=null,r()}),p.on("autosize.destroy",function(){t=null,clearTimeout(h),e(window).off("resize",l),p.off("autosize").off(".autosize").css(z).removeData("autosize")}),r())})):this}})(window.jQuery||window.$);
var swfobject=function(){var aq="undefined",aD="object",ab="Shockwave Flash",X="ShockwaveFlash.ShockwaveFlash",aE="application/x-shockwave-flash",ac="SWFObjectExprInst",ax="onreadystatechange",af=window,aL=document,aB=navigator,aa=false,Z=[aN],aG=[],ag=[],al=[],aJ,ad,ap,at,ak=false,aU=false,aH,an,aI=true,ah=function(){var a=typeof aL.getElementById!=aq&&typeof aL.getElementsByTagName!=aq&&typeof aL.createElement!=aq,e=aB.userAgent.toLowerCase(),c=aB.platform.toLowerCase(),h=c?/win/.test(c):/win/.test(e),j=c?/mac/.test(c):/mac/.test(e),g=/webkit/.test(e)?parseFloat(e.replace(/^.*webkit\/(\d+(\.\d+)?).*$/,"$1")):false,d=!+"\v1",f=[0,0,0],k=null;if(typeof aB.plugins!=aq&&typeof aB.plugins[ab]==aD){k=aB.plugins[ab].description;if(k&&!(typeof aB.mimeTypes!=aq&&aB.mimeTypes[aE]&&!aB.mimeTypes[aE].enabledPlugin)){aa=true;d=false;k=k.replace(/^.*\s+(\S+\s+\S+$)/,"$1");f[0]=parseInt(k.replace(/^(.*)\..*$/,"$1"),10);f[1]=parseInt(k.replace(/^.*\.(.*)\s.*$/,"$1"),10);f[2]=/[a-zA-Z]/.test(k)?parseInt(k.replace(/^.*[a-zA-Z]+(.*)$/,"$1"),10):0}}else{if(typeof af.ActiveXObject!=aq){try{var i=new ActiveXObject(X);if(i){k=i.GetVariable("$version");if(k){d=true;k=k.split(" ")[1].split(",");f=[parseInt(k[0],10),parseInt(k[1],10),parseInt(k[2],10)]}}}catch(b){}}}return{w3:a,pv:f,wk:g,ie:d,win:h,mac:j}}(),aK=function(){if(!ah.w3){return}if((typeof aL.readyState!=aq&&aL.readyState=="complete")||(typeof aL.readyState==aq&&(aL.getElementsByTagName("body")[0]||aL.body))){aP()}if(!ak){if(typeof aL.addEventListener!=aq){aL.addEventListener("DOMContentLoaded",aP,false)}if(ah.ie&&ah.win){aL.attachEvent(ax,function(){if(aL.readyState=="complete"){aL.detachEvent(ax,arguments.callee);aP()}});if(af==top){(function(){if(ak){return}try{aL.documentElement.doScroll("left")}catch(a){setTimeout(arguments.callee,0);return}aP()})()}}if(ah.wk){(function(){if(ak){return}if(!/loaded|complete/.test(aL.readyState)){setTimeout(arguments.callee,0);return}aP()})()}aC(aP)}}();function aP(){if(ak){return}try{var b=aL.getElementsByTagName("body")[0].appendChild(ar("span"));
b.parentNode.removeChild(b)}catch(a){return}ak=true;var d=Z.length;for(var c=0;c<d;c++){Z[c]()}}function aj(a){if(ak){a()}else{Z[Z.length]=a}}function aC(a){if(typeof af.addEventListener!=aq){af.addEventListener("load",a,false)}else{if(typeof aL.addEventListener!=aq){aL.addEventListener("load",a,false)}else{if(typeof af.attachEvent!=aq){aM(af,"onload",a)}else{if(typeof af.onload=="function"){var b=af.onload;af.onload=function(){b();a()}}else{af.onload=a}}}}}function aN(){if(aa){Y()}else{am()}}function Y(){var d=aL.getElementsByTagName("body")[0];var b=ar(aD);b.setAttribute("type",aE);var a=d.appendChild(b);if(a){var c=0;(function(){if(typeof a.GetVariable!=aq){var e=a.GetVariable("$version");if(e){e=e.split(" ")[1].split(",");ah.pv=[parseInt(e[0],10),parseInt(e[1],10),parseInt(e[2],10)]}}else{if(c<10){c++;setTimeout(arguments.callee,10);return}}d.removeChild(b);a=null;am()})()}else{am()}}function am(){var g=aG.length;if(g>0){for(var h=0;h<g;h++){var c=aG[h].id;var l=aG[h].callbackFn;var a={success:false,id:c};if(ah.pv[0]>0){var i=aS(c);if(i){if(ao(aG[h].swfVersion)&&!(ah.wk&&ah.wk<312)){ay(c,true);if(l){a.success=true;a.ref=av(c);l(a)}}else{if(aG[h].expressInstall&&au()){var e={};e.data=aG[h].expressInstall;e.width=i.getAttribute("width")||"0";e.height=i.getAttribute("height")||"0";if(i.getAttribute("class")){e.styleclass=i.getAttribute("class")}if(i.getAttribute("align")){e.align=i.getAttribute("align")}var f={};var d=i.getElementsByTagName("param");var k=d.length;for(var j=0;j<k;j++){if(d[j].getAttribute("name").toLowerCase()!="movie"){f[d[j].getAttribute("name")]=d[j].getAttribute("value")}}ae(e,f,c,l)}else{aF(i);if(l){l(a)}}}}}else{ay(c,true);if(l){var b=av(c);if(b&&typeof b.SetVariable!=aq){a.success=true;a.ref=b}l(a)}}}}}function av(b){var d=null;var c=aS(b);if(c&&c.nodeName=="OBJECT"){if(typeof c.SetVariable!=aq){d=c}else{var a=c.getElementsByTagName(aD)[0];if(a){d=a}}}return d}function au(){return !aU&&ao("6.0.65")&&(ah.win||ah.mac)&&!(ah.wk&&ah.wk<312)}function ae(f,d,h,e){aU=true;
ap=e||null;at={success:false,id:h};var a=aS(h);if(a){if(a.nodeName=="OBJECT"){aJ=aO(a);ad=null}else{aJ=a;ad=h}f.id=ac;if(typeof f.width==aq||(!/%$/.test(f.width)&&parseInt(f.width,10)<310)){f.width="310"}if(typeof f.height==aq||(!/%$/.test(f.height)&&parseInt(f.height,10)<137)){f.height="137"}aL.title=aL.title.slice(0,47)+" - Flash Player Installation";var b=ah.ie&&ah.win?"ActiveX":"PlugIn",c="MMredirectURL="+af.location.toString().replace(/&/g,"%26")+"&MMplayerType="+b+"&MMdoctitle="+aL.title;if(typeof d.flashvars!=aq){d.flashvars+="&"+c}else{d.flashvars=c}if(ah.ie&&ah.win&&a.readyState!=4){var g=ar("div");h+="SWFObjectNew";g.setAttribute("id",h);a.parentNode.insertBefore(g,a);a.style.display="none";(function(){if(a.readyState==4){a.parentNode.removeChild(a)}else{setTimeout(arguments.callee,10)}})()}aA(f,d,h)}}function aF(a){if(ah.ie&&ah.win&&a.readyState!=4){var b=ar("div");a.parentNode.insertBefore(b,a);b.parentNode.replaceChild(aO(a),b);a.style.display="none";(function(){if(a.readyState==4){a.parentNode.removeChild(a)}else{setTimeout(arguments.callee,10)}})()}else{a.parentNode.replaceChild(aO(a),a)}}function aO(b){var d=ar("div");if(ah.win&&ah.ie){d.innerHTML=b.innerHTML}else{var e=b.getElementsByTagName(aD)[0];if(e){var a=e.childNodes;if(a){var f=a.length;for(var c=0;c<f;c++){if(!(a[c].nodeType==1&&a[c].nodeName=="PARAM")&&!(a[c].nodeType==8)){d.appendChild(a[c].cloneNode(true))}}}}}return d}function aA(e,g,c){var d,a=aS(c);if(ah.wk&&ah.wk<312){return d}if(a){if(typeof e.id==aq){e.id=c}if(ah.ie&&ah.win){var f="";for(var i in e){if(e[i]!=Object.prototype[i]){if(i.toLowerCase()=="data"){g.movie=e[i]}else{if(i.toLowerCase()=="styleclass"){f+=' class="'+e[i]+'"'}else{if(i.toLowerCase()!="classid"){f+=" "+i+'="'+e[i]+'"'}}}}}var h="";for(var j in g){if(g[j]!=Object.prototype[j]){h+='<param name="'+j+'" value="'+g[j]+'" />'}}a.outerHTML='<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"'+f+">"+h+"</object>";ag[ag.length]=e.id;d=aS(e.id)}else{var b=ar(aD);b.setAttribute("type",aE);
for(var k in e){if(e[k]!=Object.prototype[k]){if(k.toLowerCase()=="styleclass"){b.setAttribute("class",e[k])}else{if(k.toLowerCase()!="classid"){b.setAttribute(k,e[k])}}}}for(var l in g){if(g[l]!=Object.prototype[l]&&l.toLowerCase()!="movie"){aQ(b,l,g[l])}}a.parentNode.replaceChild(b,a);d=b}}return d}function aQ(b,d,c){var a=ar("param");a.setAttribute("name",d);a.setAttribute("value",c);b.appendChild(a)}function aw(a){var b=aS(a);if(b&&b.nodeName=="OBJECT"){if(ah.ie&&ah.win){b.style.display="none";(function(){if(b.readyState==4){aT(a)}else{setTimeout(arguments.callee,10)}})()}else{b.parentNode.removeChild(b)}}}function aT(a){var b=aS(a);if(b){for(var c in b){if(typeof b[c]=="function"){b[c]=null}}b.parentNode.removeChild(b)}}function aS(a){var c=null;try{c=aL.getElementById(a)}catch(b){}return c}function ar(a){return aL.createElement(a)}function aM(a,c,b){a.attachEvent(c,b);al[al.length]=[a,c,b]}function ao(a){var b=ah.pv,c=a.split(".");c[0]=parseInt(c[0],10);c[1]=parseInt(c[1],10)||0;c[2]=parseInt(c[2],10)||0;return(b[0]>c[0]||(b[0]==c[0]&&b[1]>c[1])||(b[0]==c[0]&&b[1]==c[1]&&b[2]>=c[2]))?true:false}function az(b,f,a,c){if(ah.ie&&ah.mac){return}var e=aL.getElementsByTagName("head")[0];if(!e){return}var g=(a&&typeof a=="string")?a:"screen";if(c){aH=null;an=null}if(!aH||an!=g){var d=ar("style");d.setAttribute("type","text/css");d.setAttribute("media",g);aH=e.appendChild(d);if(ah.ie&&ah.win&&typeof aL.styleSheets!=aq&&aL.styleSheets.length>0){aH=aL.styleSheets[aL.styleSheets.length-1]}an=g}if(ah.ie&&ah.win){if(aH&&typeof aH.addRule==aD){aH.addRule(b,f)}}else{if(aH&&typeof aL.createTextNode!=aq){aH.appendChild(aL.createTextNode(b+" {"+f+"}"))}}}function ay(a,c){if(!aI){return}var b=c?"visible":"hidden";if(ak&&aS(a)){aS(a).style.visibility=b}else{az("#"+a,"visibility:"+b)}}function ai(b){var a=/[\\\"<>\.;]/;var c=a.exec(b)!=null;return c&&typeof encodeURIComponent!=aq?encodeURIComponent(b):b}var aR=function(){if(ah.ie&&ah.win){window.attachEvent("onunload",function(){var a=al.length;
for(var b=0;b<a;b++){al[b][0].detachEvent(al[b][1],al[b][2])}var d=ag.length;for(var c=0;c<d;c++){aw(ag[c])}for(var e in ah){ah[e]=null}ah=null;for(var f in swfobject){swfobject[f]=null}swfobject=null})}}();return{registerObject:function(a,e,c,b){if(ah.w3&&a&&e){var d={};d.id=a;d.swfVersion=e;d.expressInstall=c;d.callbackFn=b;aG[aG.length]=d;ay(a,false)}else{if(b){b({success:false,id:a})}}},getObjectById:function(a){if(ah.w3){return av(a)}},embedSWF:function(k,e,h,f,c,a,b,i,g,j){var d={success:false,id:e};if(ah.w3&&!(ah.wk&&ah.wk<312)&&k&&e&&h&&f&&c){ay(e,false);aj(function(){h+="";f+="";var q={};if(g&&typeof g===aD){for(var o in g){q[o]=g[o]}}q.data=k;q.width=h;q.height=f;var n={};if(i&&typeof i===aD){for(var p in i){n[p]=i[p]}}if(b&&typeof b===aD){for(var l in b){if(typeof n.flashvars!=aq){n.flashvars+="&"+l+"="+b[l]}else{n.flashvars=l+"="+b[l]}}}if(ao(c)){var m=aA(q,n,e);if(q.id==e){ay(e,true)}d.success=true;d.ref=m}else{if(a&&au()){q.data=a;ae(q,n,e,j);return}else{ay(e,true)}}if(j){j(d)}})}else{if(j){j(d)}}},switchOffAutoHideShow:function(){aI=false},ua:ah,getFlashPlayerVersion:function(){return{major:ah.pv[0],minor:ah.pv[1],release:ah.pv[2]}},hasFlashPlayerVersion:ao,createSWF:function(a,b,c){if(ah.w3){return aA(a,b,c)}else{return undefined}},showExpressInstall:function(b,a,d,c){if(ah.w3&&au()){ae(b,a,d,c)}},removeSWF:function(a){if(ah.w3){aw(a)}},createCSS:function(b,a,c,d){if(ah.w3){az(b,a,c,d)}},addDomLoadEvent:aj,addLoadEvent:aC,getQueryParamValue:function(b){var a=aL.location.search||aL.location.hash;if(a){if(/\?/.test(a)){a=a.split("?")[1]}if(b==null){return ai(a)}var c=a.split("&");for(var d=0;d<c.length;d++){if(c[d].substring(0,c[d].indexOf("="))==b){return ai(c[d].substring((c[d].indexOf("=")+1)))}}}return""},expressInstallCallback:function(){if(aU){var a=aS(ac);if(a&&aJ){a.parentNode.replaceChild(aJ,a);if(ad){ay(ad,true);if(ah.ie&&ah.win){aJ.style.display="block"}}if(ap){ap(at)}}aU=false}}}}();var SWFUpload;if(SWFUpload==undefined){SWFUpload=function(b){this.initSWFUpload(b)
}}SWFUpload.prototype.initSWFUpload=function(c){try{this.customSettings={};this.settings=c;this.eventQueue=[];this.movieName="SWFUpload_"+SWFUpload.movieCount++;this.movieElement=null;SWFUpload.instances[this.movieName]=this;this.initSettings();this.loadFlash();this.displayDebugInfo()}catch(d){delete SWFUpload.instances[this.movieName];throw d}};SWFUpload.instances={};SWFUpload.movieCount=0;SWFUpload.version="2.2.0 2009-03-25";SWFUpload.QUEUE_ERROR={QUEUE_LIMIT_EXCEEDED:-100,FILE_EXCEEDS_SIZE_LIMIT:-110,ZERO_BYTE_FILE:-120,INVALID_FILETYPE:-130};SWFUpload.UPLOAD_ERROR={HTTP_ERROR:-200,MISSING_UPLOAD_URL:-210,IO_ERROR:-220,SECURITY_ERROR:-230,UPLOAD_LIMIT_EXCEEDED:-240,UPLOAD_FAILED:-250,SPECIFIED_FILE_ID_NOT_FOUND:-260,FILE_VALIDATION_FAILED:-270,FILE_CANCELLED:-280,UPLOAD_STOPPED:-290};SWFUpload.FILE_STATUS={QUEUED:-1,IN_PROGRESS:-2,ERROR:-3,COMPLETE:-4,CANCELLED:-5};SWFUpload.BUTTON_ACTION={SELECT_FILE:-100,SELECT_FILES:-110,START_UPLOAD:-120};SWFUpload.CURSOR={ARROW:-1,HAND:-2};SWFUpload.WINDOW_MODE={WINDOW:"window",TRANSPARENT:"transparent",OPAQUE:"opaque"};SWFUpload.completeURL=function(e){if(typeof(e)!=="string"||e.match(/^https?:\/\//i)||e.match(/^\//)){return e}var f=window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:"");var d=window.location.pathname.lastIndexOf("/");if(d<=0){path="/"}else{path=window.location.pathname.substr(0,d)+"/"}return path+e};SWFUpload.prototype.initSettings=function(){this.ensureDefault=function(c,d){this.settings[c]=(this.settings[c]==undefined)?d:this.settings[c]};this.ensureDefault("upload_url","");this.ensureDefault("preserve_relative_urls",false);this.ensureDefault("file_post_name","Filedata");this.ensureDefault("post_params",{});this.ensureDefault("use_query_string",false);this.ensureDefault("requeue_on_error",false);this.ensureDefault("http_success",[]);this.ensureDefault("assume_success_timeout",0);this.ensureDefault("file_types","*.*");this.ensureDefault("file_types_description","All Files");
this.ensureDefault("file_size_limit",0);this.ensureDefault("file_upload_limit",0);this.ensureDefault("file_queue_limit",0);this.ensureDefault("flash_url","swfupload.swf");this.ensureDefault("prevent_swf_caching",true);this.ensureDefault("button_image_url","");this.ensureDefault("button_width",1);this.ensureDefault("button_height",1);this.ensureDefault("button_text","");this.ensureDefault("button_text_style","color: #000000; font-size: 16pt;");this.ensureDefault("button_text_top_padding",0);this.ensureDefault("button_text_left_padding",0);this.ensureDefault("button_action",SWFUpload.BUTTON_ACTION.SELECT_FILES);this.ensureDefault("button_disabled",false);this.ensureDefault("button_placeholder_id","");this.ensureDefault("button_placeholder",null);this.ensureDefault("button_cursor",SWFUpload.CURSOR.ARROW);this.ensureDefault("button_window_mode",SWFUpload.WINDOW_MODE.WINDOW);this.ensureDefault("debug",false);this.settings.debug_enabled=this.settings.debug;this.settings.return_upload_start_handler=this.returnUploadStart;this.ensureDefault("swfupload_loaded_handler",null);this.ensureDefault("file_dialog_start_handler",null);this.ensureDefault("file_queued_handler",null);this.ensureDefault("file_queue_error_handler",null);this.ensureDefault("file_dialog_complete_handler",null);this.ensureDefault("upload_start_handler",null);this.ensureDefault("upload_progress_handler",null);this.ensureDefault("upload_error_handler",null);this.ensureDefault("upload_success_handler",null);this.ensureDefault("upload_complete_handler",null);this.ensureDefault("debug_handler",this.debugMessage);this.ensureDefault("custom_settings",{});this.customSettings=this.settings.custom_settings;if(!!this.settings.prevent_swf_caching){this.settings.flash_url=this.settings.flash_url+(this.settings.flash_url.indexOf("?")<0?"?":"&")+"preventswfcaching="+new Date().getTime()}if(!this.settings.preserve_relative_urls){this.settings.upload_url=SWFUpload.completeURL(this.settings.upload_url);this.settings.button_image_url=SWFUpload.completeURL(this.settings.button_image_url)
}delete this.ensureDefault};SWFUpload.prototype.loadFlash=function(){var d,c;if(document.getElementById(this.movieName)!==null){throw"ID "+this.movieName+" is already in use. The Flash Object could not be added"}d=document.getElementById(this.settings.button_placeholder_id)||this.settings.button_placeholder;if(d==undefined){throw"Could not find the placeholder element: "+this.settings.button_placeholder_id}c=document.createElement("div");c.innerHTML=this.getFlashHTML();d.parentNode.replaceChild(c.firstChild,d);if(window[this.movieName]==undefined){window[this.movieName]=this.getMovieElement()}};SWFUpload.prototype.getFlashHTML=function(){return['<object id="',this.movieName,'" type="application/x-shockwave-flash" data="',this.settings.flash_url,'" width="',this.settings.button_width,'" height="',this.settings.button_height,'" class="swfupload">','<param name="wmode" value="',this.settings.button_window_mode,'" />','<param name="movie" value="',this.settings.flash_url,'" />','<param name="quality" value="high" />','<param name="menu" value="false" />','<param name="allowScriptAccess" value="always" />','<param name="flashvars" value="'+this.getFlashVars()+'" />',"</object>"].join("")};SWFUpload.prototype.getFlashVars=function(){var c=this.buildParamString();var d=this.settings.http_success.join(",");return["movieName=",encodeURIComponent(this.movieName),"&amp;uploadURL=",encodeURIComponent(this.settings.upload_url),"&amp;useQueryString=",encodeURIComponent(this.settings.use_query_string),"&amp;requeueOnError=",encodeURIComponent(this.settings.requeue_on_error),"&amp;httpSuccess=",encodeURIComponent(d),"&amp;assumeSuccessTimeout=",encodeURIComponent(this.settings.assume_success_timeout),"&amp;params=",encodeURIComponent(c),"&amp;filePostName=",encodeURIComponent(this.settings.file_post_name),"&amp;fileTypes=",encodeURIComponent(this.settings.file_types),"&amp;fileTypesDescription=",encodeURIComponent(this.settings.file_types_description),"&amp;fileSizeLimit=",encodeURIComponent(this.settings.file_size_limit),"&amp;fileUploadLimit=",encodeURIComponent(this.settings.file_upload_limit),"&amp;fileQueueLimit=",encodeURIComponent(this.settings.file_queue_limit),"&amp;debugEnabled=",encodeURIComponent(this.settings.debug_enabled),"&amp;buttonImageURL=",encodeURIComponent(this.settings.button_image_url),"&amp;buttonWidth=",encodeURIComponent(this.settings.button_width),"&amp;buttonHeight=",encodeURIComponent(this.settings.button_height),"&amp;buttonText=",encodeURIComponent(this.settings.button_text),"&amp;buttonTextTopPadding=",encodeURIComponent(this.settings.button_text_top_padding),"&amp;buttonTextLeftPadding=",encodeURIComponent(this.settings.button_text_left_padding),"&amp;buttonTextStyle=",encodeURIComponent(this.settings.button_text_style),"&amp;buttonAction=",encodeURIComponent(this.settings.button_action),"&amp;buttonDisabled=",encodeURIComponent(this.settings.button_disabled),"&amp;buttonCursor=",encodeURIComponent(this.settings.button_cursor)].join("")
};SWFUpload.prototype.getMovieElement=function(){if(this.movieElement==undefined){this.movieElement=document.getElementById(this.movieName)}if(this.movieElement===null){throw"Could not find Flash element"}return this.movieElement};SWFUpload.prototype.buildParamString=function(){var f=this.settings.post_params;var d=[];if(typeof(f)==="object"){for(var e in f){if(f.hasOwnProperty(e)){d.push(encodeURIComponent(e.toString())+"="+encodeURIComponent(f[e].toString()))}}}return d.join("&amp;")};SWFUpload.prototype.destroy=function(){try{this.cancelUpload(null,false);var g=null;g=this.getMovieElement();if(g&&typeof(g.CallFunction)==="unknown"){for(var j in g){try{if(typeof(g[j])==="function"){g[j]=null}}catch(h){}}try{g.parentNode.removeChild(g)}catch(f){}}window[this.movieName]=null;SWFUpload.instances[this.movieName]=null;delete SWFUpload.instances[this.movieName];this.movieElement=null;this.settings=null;this.customSettings=null;this.eventQueue=null;this.movieName=null;return true}catch(i){return false}};SWFUpload.prototype.displayDebugInfo=function(){this.debug(["---SWFUpload Instance Info---\n","Version: ",SWFUpload.version,"\n","Movie Name: ",this.movieName,"\n","Settings:\n","\t","upload_url:               ",this.settings.upload_url,"\n","\t","flash_url:                ",this.settings.flash_url,"\n","\t","use_query_string:         ",this.settings.use_query_string.toString(),"\n","\t","requeue_on_error:         ",this.settings.requeue_on_error.toString(),"\n","\t","http_success:             ",this.settings.http_success.join(", "),"\n","\t","assume_success_timeout:   ",this.settings.assume_success_timeout,"\n","\t","file_post_name:           ",this.settings.file_post_name,"\n","\t","post_params:              ",this.settings.post_params.toString(),"\n","\t","file_types:               ",this.settings.file_types,"\n","\t","file_types_description:   ",this.settings.file_types_description,"\n","\t","file_size_limit:          ",this.settings.file_size_limit,"\n","\t","file_upload_limit:        ",this.settings.file_upload_limit,"\n","\t","file_queue_limit:         ",this.settings.file_queue_limit,"\n","\t","debug:                    ",this.settings.debug.toString(),"\n","\t","prevent_swf_caching:      ",this.settings.prevent_swf_caching.toString(),"\n","\t","button_placeholder_id:    ",this.settings.button_placeholder_id.toString(),"\n","\t","button_placeholder:       ",(this.settings.button_placeholder?"Set":"Not Set"),"\n","\t","button_image_url:         ",this.settings.button_image_url.toString(),"\n","\t","button_width:             ",this.settings.button_width.toString(),"\n","\t","button_height:            ",this.settings.button_height.toString(),"\n","\t","button_text:              ",this.settings.button_text.toString(),"\n","\t","button_text_style:        ",this.settings.button_text_style.toString(),"\n","\t","button_text_top_padding:  ",this.settings.button_text_top_padding.toString(),"\n","\t","button_text_left_padding: ",this.settings.button_text_left_padding.toString(),"\n","\t","button_action:            ",this.settings.button_action.toString(),"\n","\t","button_disabled:          ",this.settings.button_disabled.toString(),"\n","\t","custom_settings:          ",this.settings.custom_settings.toString(),"\n","Event Handlers:\n","\t","swfupload_loaded_handler assigned:  ",(typeof this.settings.swfupload_loaded_handler==="function").toString(),"\n","\t","file_dialog_start_handler assigned: ",(typeof this.settings.file_dialog_start_handler==="function").toString(),"\n","\t","file_queued_handler assigned:       ",(typeof this.settings.file_queued_handler==="function").toString(),"\n","\t","file_queue_error_handler assigned:  ",(typeof this.settings.file_queue_error_handler==="function").toString(),"\n","\t","upload_start_handler assigned:      ",(typeof this.settings.upload_start_handler==="function").toString(),"\n","\t","upload_progress_handler assigned:   ",(typeof this.settings.upload_progress_handler==="function").toString(),"\n","\t","upload_error_handler assigned:      ",(typeof this.settings.upload_error_handler==="function").toString(),"\n","\t","upload_success_handler assigned:    ",(typeof this.settings.upload_success_handler==="function").toString(),"\n","\t","upload_complete_handler assigned:   ",(typeof this.settings.upload_complete_handler==="function").toString(),"\n","\t","debug_handler assigned:             ",(typeof this.settings.debug_handler==="function").toString(),"\n"].join(""))
};SWFUpload.prototype.addSetting=function(d,f,e){if(f==undefined){return(this.settings[d]=e)}else{return(this.settings[d]=f)}};SWFUpload.prototype.getSetting=function(b){if(this.settings[b]!=undefined){return this.settings[b]}return""};SWFUpload.prototype.callFlash=function(functionName,argumentArray){argumentArray=argumentArray||[];var movieElement=this.getMovieElement();var returnValue,returnString;try{returnString=movieElement.CallFunction('<invoke name="'+functionName+'" returntype="javascript">'+__flash__argumentsToXML(argumentArray,0)+"</invoke>");returnValue=eval(returnString)}catch(ex){throw"Call to "+functionName+" failed"}if(returnValue!=undefined&&typeof returnValue.post==="object"){returnValue=this.unescapeFilePostParams(returnValue)}return returnValue};SWFUpload.prototype.selectFile=function(){this.callFlash("SelectFile")};SWFUpload.prototype.selectFiles=function(){this.callFlash("SelectFiles")};SWFUpload.prototype.startUpload=function(b){this.callFlash("StartUpload",[b])};SWFUpload.prototype.cancelUpload=function(d,c){if(c!==false){c=true}this.callFlash("CancelUpload",[d,c])};SWFUpload.prototype.stopUpload=function(){this.callFlash("StopUpload")};SWFUpload.prototype.getStats=function(){return this.callFlash("GetStats")};SWFUpload.prototype.setStats=function(b){this.callFlash("SetStats",[b])};SWFUpload.prototype.getFile=function(b){if(typeof(b)==="number"){return this.callFlash("GetFileByIndex",[b])}else{return this.callFlash("GetFile",[b])}};SWFUpload.prototype.addFileParam=function(e,d,f){return this.callFlash("AddFileParam",[e,d,f])};SWFUpload.prototype.removeFileParam=function(d,c){this.callFlash("RemoveFileParam",[d,c])};SWFUpload.prototype.setUploadURL=function(b){this.settings.upload_url=b.toString();this.callFlash("SetUploadURL",[b])};SWFUpload.prototype.setPostParams=function(b){this.settings.post_params=b;this.callFlash("SetPostParams",[b])};SWFUpload.prototype.addPostParam=function(d,c){this.settings.post_params[d]=c;this.callFlash("SetPostParams",[this.settings.post_params])
};SWFUpload.prototype.removePostParam=function(b){delete this.settings.post_params[b];this.callFlash("SetPostParams",[this.settings.post_params])};SWFUpload.prototype.setFileTypes=function(d,c){this.settings.file_types=d;this.settings.file_types_description=c;this.callFlash("SetFileTypes",[d,c])};SWFUpload.prototype.setFileSizeLimit=function(b){this.settings.file_size_limit=b;this.callFlash("SetFileSizeLimit",[b])};SWFUpload.prototype.setFileUploadLimit=function(b){this.settings.file_upload_limit=b;this.callFlash("SetFileUploadLimit",[b])};SWFUpload.prototype.setFileQueueLimit=function(b){this.settings.file_queue_limit=b;this.callFlash("SetFileQueueLimit",[b])};SWFUpload.prototype.setFilePostName=function(b){this.settings.file_post_name=b;this.callFlash("SetFilePostName",[b])};SWFUpload.prototype.setUseQueryString=function(b){this.settings.use_query_string=b;this.callFlash("SetUseQueryString",[b])};SWFUpload.prototype.setRequeueOnError=function(b){this.settings.requeue_on_error=b;this.callFlash("SetRequeueOnError",[b])};SWFUpload.prototype.setHTTPSuccess=function(b){if(typeof b==="string"){b=b.replace(" ","").split(",")}this.settings.http_success=b;this.callFlash("SetHTTPSuccess",[b])};SWFUpload.prototype.setAssumeSuccessTimeout=function(b){this.settings.assume_success_timeout=b;this.callFlash("SetAssumeSuccessTimeout",[b])};SWFUpload.prototype.setDebugEnabled=function(b){this.settings.debug_enabled=b;this.callFlash("SetDebugEnabled",[b])};SWFUpload.prototype.setButtonImageURL=function(b){if(b==undefined){b=""}this.settings.button_image_url=b;this.callFlash("SetButtonImageURL",[b])};SWFUpload.prototype.setButtonDimensions=function(f,e){this.settings.button_width=f;this.settings.button_height=e;var d=this.getMovieElement();if(d!=undefined){d.style.width=f+"px";d.style.height=e+"px"}this.callFlash("SetButtonDimensions",[f,e])};SWFUpload.prototype.setButtonText=function(b){this.settings.button_text=b;this.callFlash("SetButtonText",[b])};SWFUpload.prototype.setButtonTextPadding=function(c,d){this.settings.button_text_top_padding=d;
this.settings.button_text_left_padding=c;this.callFlash("SetButtonTextPadding",[c,d])};SWFUpload.prototype.setButtonTextStyle=function(b){this.settings.button_text_style=b;this.callFlash("SetButtonTextStyle",[b])};SWFUpload.prototype.setButtonDisabled=function(b){this.settings.button_disabled=b;this.callFlash("SetButtonDisabled",[b])};SWFUpload.prototype.setButtonAction=function(b){this.settings.button_action=b;this.callFlash("SetButtonAction",[b])};SWFUpload.prototype.setButtonCursor=function(b){this.settings.button_cursor=b;this.callFlash("SetButtonCursor",[b])};SWFUpload.prototype.queueEvent=function(d,f){if(f==undefined){f=[]}else{if(!(f instanceof Array)){f=[f]}}var e=this;if(typeof this.settings[d]==="function"){this.eventQueue.push(function(){this.settings[d].apply(this,f)});setTimeout(function(){e.executeNextEvent()},0)}else{if(this.settings[d]!==null){throw"Event handler "+d+" is unknown or is not a function"}}};SWFUpload.prototype.executeNextEvent=function(){var b=this.eventQueue?this.eventQueue.shift():null;if(typeof(b)==="function"){b.apply(this)}};SWFUpload.prototype.unescapeFilePostParams=function(l){var j=/[$]([0-9a-f]{4})/i;var i={};var k;if(l!=undefined){for(var h in l.post){if(l.post.hasOwnProperty(h)){k=h;var g;while((g=j.exec(k))!==null){k=k.replace(g[0],String.fromCharCode(parseInt("0x"+g[1],16)))}i[k]=l.post[h]}}l.post=i}return l};SWFUpload.prototype.testExternalInterface=function(){try{return this.callFlash("TestExternalInterface")}catch(b){return false}};SWFUpload.prototype.flashReady=function(){var b=this.getMovieElement();if(!b){this.debug("Flash called back ready but the flash movie can't be found.");return}this.cleanUp(b);this.queueEvent("swfupload_loaded_handler")};SWFUpload.prototype.cleanUp=function(f){try{if(this.movieElement&&typeof(f.CallFunction)==="unknown"){this.debug("Removing Flash functions hooks (this should only run in IE and should prevent memory leaks)");for(var h in f){try{if(typeof(f[h])==="function"){f[h]=null}}catch(e){}}}}catch(g){}window.__flash__removeCallback=function(c,b){try{if(c){c[b]=null
}}catch(a){}}};SWFUpload.prototype.fileDialogStart=function(){this.queueEvent("file_dialog_start_handler")};SWFUpload.prototype.fileQueued=function(b){b=this.unescapeFilePostParams(b);this.queueEvent("file_queued_handler",b)};SWFUpload.prototype.fileQueueError=function(e,f,d){e=this.unescapeFilePostParams(e);this.queueEvent("file_queue_error_handler",[e,f,d])};SWFUpload.prototype.fileDialogComplete=function(d,f,e){this.queueEvent("file_dialog_complete_handler",[d,f,e])};SWFUpload.prototype.uploadStart=function(b){b=this.unescapeFilePostParams(b);this.queueEvent("return_upload_start_handler",b)};SWFUpload.prototype.returnUploadStart=function(d){var c;if(typeof this.settings.upload_start_handler==="function"){d=this.unescapeFilePostParams(d);c=this.settings.upload_start_handler.call(this,d)}else{if(this.settings.upload_start_handler!=undefined){throw"upload_start_handler must be a function"}}if(c===undefined){c=true}c=!!c;this.callFlash("ReturnUploadStart",[c])};SWFUpload.prototype.uploadProgress=function(e,f,d){e=this.unescapeFilePostParams(e);this.queueEvent("upload_progress_handler",[e,f,d])};SWFUpload.prototype.uploadError=function(e,f,d){e=this.unescapeFilePostParams(e);this.queueEvent("upload_error_handler",[e,f,d])};SWFUpload.prototype.uploadSuccess=function(d,e,f){d=this.unescapeFilePostParams(d);this.queueEvent("upload_success_handler",[d,e,f])};SWFUpload.prototype.uploadComplete=function(b){b=this.unescapeFilePostParams(b);this.queueEvent("upload_complete_handler",b)};SWFUpload.prototype.debug=function(b){this.queueEvent("debug_handler",b)};SWFUpload.prototype.debugMessage=function(h){if(this.settings.debug){var f,g=[];if(typeof h==="object"&&typeof h.name==="string"&&typeof h.message==="string"){for(var e in h){if(h.hasOwnProperty(e)){g.push(e+": "+h[e])}}f=g.join("\n")||"";g=f.split("\n");f="EXCEPTION: "+g.join("\nEXCEPTION: ");SWFUpload.Console.writeLine(f)}else{SWFUpload.Console.writeLine(h)}}};SWFUpload.Console={};SWFUpload.Console.writeLine=function(g){var e,f;
try{e=document.getElementById("SWFUpload_Console");if(!e){f=document.createElement("form");document.getElementsByTagName("body")[0].appendChild(f);e=document.createElement("textarea");e.id="SWFUpload_Console";e.style.fontFamily="monospace";e.setAttribute("wrap","off");e.wrap="off";e.style.overflow="auto";e.style.width="700px";e.style.height="350px";e.style.margin="5px";f.appendChild(e)}e.value+=g+"\n";e.scrollTop=e.scrollHeight-e.clientHeight}catch(h){alert("Exception: "+h.name+" Message: "+h.message)}};(function(c){var b={init:function(d,e){return this.each(function(){var n=c(this);var m=n.clone();var j=c.extend({id:n.attr("id"),swf:"uploadify.swf",uploader:"uploadify.php",auto:true,buttonClass:"",buttonCursor:"hand",buttonImage:null,buttonText:"SELECT FILES",checkExisting:false,debug:false,fileObjName:"Filedata",fileSizeLimit:0,fileTypeDesc:"All Files",fileTypeExts:"*.*",height:30,itemTemplate:false,method:"post",multi:true,formData:{},preventCaching:true,progressData:"percentage",queueID:false,queueSizeLimit:999,removeCompleted:true,removeTimeout:3,requeueErrors:false,successTimeout:30,uploadLimit:0,width:120,overrideEvents:[]},d);var g={assume_success_timeout:j.successTimeout,button_placeholder_id:j.id,button_width:j.width,button_height:j.height,button_text:null,button_text_style:null,button_text_top_padding:0,button_text_left_padding:0,button_action:(j.multi?SWFUpload.BUTTON_ACTION.SELECT_FILES:SWFUpload.BUTTON_ACTION.SELECT_FILE),button_disabled:false,button_cursor:(j.buttonCursor=="arrow"?SWFUpload.CURSOR.ARROW:SWFUpload.CURSOR.HAND),button_window_mode:SWFUpload.WINDOW_MODE.TRANSPARENT,debug:j.debug,requeue_on_error:j.requeueErrors,file_post_name:j.fileObjName,file_size_limit:j.fileSizeLimit,file_types:j.fileTypeExts,file_types_description:j.fileTypeDesc,file_queue_limit:j.queueSizeLimit,file_upload_limit:j.uploadLimit,flash_url:j.swf,prevent_swf_caching:j.preventCaching,post_params:j.formData,upload_url:j.uploader,use_query_string:(j.method=="get"),file_dialog_complete_handler:a.onDialogClose,file_dialog_start_handler:a.onDialogOpen,file_queued_handler:a.onSelect,file_queue_error_handler:a.onSelectError,swfupload_loaded_handler:j.onSWFReady,upload_complete_handler:a.onUploadComplete,upload_error_handler:a.onUploadError,upload_progress_handler:a.onUploadProgress,upload_start_handler:a.onUploadStart,upload_success_handler:a.onUploadSuccess};
if(e){g=c.extend(g,e)}g=c.extend(g,j);var o=swfobject.getFlashPlayerVersion();var h=(o.major>=9);if(h){window["uploadify_"+j.id]=new SWFUpload(g);var i=window["uploadify_"+j.id];n.data("uploadify",i);var l=c("<div />",{id:j.id,"class":"uploadify",css:{height:j.height+"px",width:j.width+"px"}});c("#"+i.movieName).wrap(l);l=c("#"+j.id);l.data("uploadify",i);var f=c("<div />",{id:j.id+"-button","class":"btn btn-danger "+j.buttonClass});if(j.buttonImage){f.css({"background-image":"url('"+j.buttonImage+"')","text-indent":"-9999px"})}f.html('<span class="uploadify-button-text">'+j.buttonText+"</span>");l.append(f);c("#"+i.movieName).css({position:"absolute","z-index":1});if(!j.queueID){var k=c("<div />",{id:j.id+"-queue","class":"uploadify-queue"});l.after(k);i.settings.queueID=j.id+"-queue";i.settings.defaultQueue=true}i.queueData={files:{},filesSelected:0,filesQueued:0,filesReplaced:0,filesCancelled:0,filesErrored:0,uploadsSuccessful:0,uploadsErrored:0,averageSpeed:0,queueLength:0,queueSize:0,uploadSize:0,queueBytesUploaded:0,uploadQueue:[],errorMsg:"Some files were not added to the queue:"};i.original=m;i.wrapper=l;i.button=f;i.queue=k;if(j.onInit){j.onInit.call(n,i)}}else{if(j.onFallback){j.onFallback.call(n)}}})},cancel:function(d,f){var e=arguments;this.each(function(){var l=c(this),i=l.data("uploadify"),j=i.settings,h=-1;if(e[0]){if(e[0]=="*"){var g=i.queueData.queueLength;c("#"+j.queueID).find(".uploadify-queue-item").each(function(){h++;if(e[1]===true){i.cancelUpload(c(this).attr("id"),false)}else{i.cancelUpload(c(this).attr("id"))}c(this).find(".data").removeClass("data").html(" - Cancelled");c(this).find(".uploadify-progress-bar").remove();c(this).delay(1000+100*h).fadeOut(500,function(){c(this).remove()})});i.queueData.queueSize=0;i.queueData.queueLength=0;if(j.onClearQueue){j.onClearQueue.call(l,g)}}else{for(var m=0;m<e.length;m++){i.cancelUpload(e[m]);c("#"+e[m]).find(".data").removeClass("data").html(" - Cancelled");c("#"+e[m]).find(".uploadify-progress-bar").remove();
c("#"+e[m]).delay(1000+100*m).fadeOut(500,function(){c(this).remove()})}}}else{var k=c("#"+j.queueID).find(".uploadify-queue-item").get(0);$item=c(k);i.cancelUpload($item.attr("id"));$item.find(".data").removeClass("data").html(" - Cancelled");$item.find(".uploadify-progress-bar").remove();$item.delay(1000).fadeOut(500,function(){c(this).remove()})}})},destroy:function(){this.each(function(){var f=c(this),d=f.data("uploadify"),e=d.settings;d.destroy();if(e.defaultQueue){c("#"+e.queueID).remove()}c("#"+e.id).replaceWith(d.original);if(e.onDestroy){e.onDestroy.call(this)}delete d})},disable:function(d){this.each(function(){var g=c(this),e=g.data("uploadify"),f=e.settings;if(d){e.button.addClass("disabled");if(f.onDisable){f.onDisable.call(this)}}else{e.button.removeClass("disabled");if(f.onEnable){f.onEnable.call(this)}}e.setButtonDisabled(d)})},settings:function(e,g,h){var d=arguments;var f=g;this.each(function(){var k=c(this),i=k.data("uploadify"),j=i.settings;if(typeof(d[0])=="object"){for(var l in g){setData(l,g[l])}}if(d.length===1){f=j[e]}else{switch(e){case"uploader":i.setUploadURL(g);break;case"formData":if(!h){g=c.extend(j.formData,g)}i.setPostParams(j.formData);break;case"method":if(g=="get"){i.setUseQueryString(true)}else{i.setUseQueryString(false)}break;case"fileObjName":i.setFilePostName(g);break;case"fileTypeExts":i.setFileTypes(g,j.fileTypeDesc);break;case"fileTypeDesc":i.setFileTypes(j.fileTypeExts,g);break;case"fileSizeLimit":i.setFileSizeLimit(g);break;case"uploadLimit":i.setFileUploadLimit(g);break;case"queueSizeLimit":i.setFileQueueLimit(g);break;case"buttonImage":i.button.css("background-image",settingValue);break;case"buttonCursor":if(g=="arrow"){i.setButtonCursor(SWFUpload.CURSOR.ARROW)}else{i.setButtonCursor(SWFUpload.CURSOR.HAND)}break;case"buttonText":c("#"+j.id+"-button").find(".uploadify-button-text").html(g);break;case"width":i.setButtonDimensions(g,j.height);break;case"height":i.setButtonDimensions(j.width,g);break;case"multi":if(g){i.setButtonAction(SWFUpload.BUTTON_ACTION.SELECT_FILES)
}else{i.setButtonAction(SWFUpload.BUTTON_ACTION.SELECT_FILE)}break}j[e]=g}});if(d.length===1){return f}},stop:function(){this.each(function(){var e=c(this),d=e.data("uploadify");d.queueData.averageSpeed=0;d.queueData.uploadSize=0;d.queueData.bytesUploaded=0;d.queueData.uploadQueue=[];d.stopUpload()})},upload:function(){var d=arguments;this.each(function(){var f=c(this),e=f.data("uploadify");e.queueData.averageSpeed=0;e.queueData.uploadSize=0;e.queueData.bytesUploaded=0;e.queueData.uploadQueue=[];if(d[0]){if(d[0]=="*"){e.queueData.uploadSize=e.queueData.queueSize;e.queueData.uploadQueue.push("*");e.startUpload()}else{for(var g=0;g<d.length;g++){e.queueData.uploadSize+=e.queueData.files[d[g]].size;e.queueData.uploadQueue.push(d[g])}e.startUpload(e.queueData.uploadQueue.shift())}}else{e.startUpload()}})}};var a={onDialogOpen:function(){var d=this.settings;this.queueData.errorMsg="Some files were not added to the queue:";this.queueData.filesReplaced=0;this.queueData.filesCancelled=0;if(d.onDialogOpen){d.onDialogOpen.call(this)}},onDialogClose:function(d,f,g){var e=this.settings;this.queueData.filesErrored=d-f;this.queueData.filesSelected=d;this.queueData.filesQueued=f-this.queueData.filesCancelled;this.queueData.queueLength=g;if(c.inArray("onDialogClose",e.overrideEvents)<0){if(this.queueData.filesErrored>0){alert(this.queueData.errorMsg)}}if(e.onDialogClose){e.onDialogClose.call(this,this.queueData)}if(e.auto){c("#"+e.id).uploadify("upload","*")}},onSelect:function(h){var i=this.settings;var f={};for(var g in this.queueData.files){f=this.queueData.files[g];if(f.uploaded!=true&&f.name==h.name){var e=confirm('The file named "'+h.name+'" is already in the queue.\nDo you want to replace the existing item in the queue?');if(!e){this.cancelUpload(h.id);this.queueData.filesCancelled++;return false}else{c("#"+f.id).remove();this.cancelUpload(f.id);this.queueData.filesReplaced++}}}var j=Math.round(h.size/1024);var o="KB";if(j>1000){j=Math.round(j/1000);o="MB"}var l=j.toString().split(".");
j=l[0];if(l.length>1){j+="."+l[1].substr(0,2)}j+=o;var k=h.name;if(k.length>25){k=k.substr(0,25)+"..."}itemData={fileID:h.id,instanceID:i.id,fileName:k,fileSize:j};if(i.itemTemplate==false){i.itemTemplate='<div id="${fileID}" class="uploadify-queue-item">					<div class="cancel">						<a href="javascript:$(\'#${instanceID}\').uploadify(\'cancel\', \'${fileID}\')">X</a>					</div>					<span class="fileName">${fileName} (${fileSize})</span><span class="data"></span>					<div class="uploadify-progress">						<div class="uploadify-progress-bar"><!--Progress Bar--></div>					</div>				</div>'}if(c.inArray("onSelect",i.overrideEvents)<0){itemHTML=i.itemTemplate;for(var m in itemData){itemHTML=itemHTML.replace(new RegExp("\\$\\{"+m+"\\}","g"),itemData[m])}c("#"+i.queueID).append(itemHTML)}this.queueData.queueSize+=h.size;this.queueData.files[h.id]=h;if(i.onSelect){i.onSelect.apply(this,arguments)}},onSelectError:function(d,g,f){var e=this.settings;if(c.inArray("onSelectError",e.overrideEvents)<0){switch(g){case SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED:if(e.queueSizeLimit>f){this.queueData.errorMsg+="\nThe number of files selected exceeds the remaining upload limit ("+f+")."}else{this.queueData.errorMsg+="\nThe number of files selected exceeds the queue size limit ("+e.queueSizeLimit+")."}break;case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:this.queueData.errorMsg+='\nThe file "'+d.name+'" exceeds the size limit ('+e.fileSizeLimit+").";break;case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:this.queueData.errorMsg+='\nThe file "'+d.name+'" is empty.';break;case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:this.queueData.errorMsg+='\nThe file "'+d.name+'" is not an accepted file type ('+e.fileTypeDesc+").";break}}if(g!=SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED){delete this.queueData.files[d.id]}if(e.onSelectError){e.onSelectError.apply(this,arguments)}},onQueueComplete:function(){if(this.settings.onQueueComplete){this.settings.onQueueComplete.call(this,this.settings.queueData)
}},onUploadComplete:function(f){var g=this.settings,d=this;var e=this.getStats();this.queueData.queueLength=e.files_queued;if(this.queueData.uploadQueue[0]=="*"){if(this.queueData.queueLength>0){this.startUpload()}else{this.queueData.uploadQueue=[];if(g.onQueueComplete){g.onQueueComplete.call(this,this.queueData)}}}else{if(this.queueData.uploadQueue.length>0){this.startUpload(this.queueData.uploadQueue.shift())}else{this.queueData.uploadQueue=[];if(g.onQueueComplete){g.onQueueComplete.call(this,this.queueData)}}}if(c.inArray("onUploadComplete",g.overrideEvents)<0){if(g.removeCompleted){switch(f.filestatus){case SWFUpload.FILE_STATUS.COMPLETE:setTimeout(function(){if(c("#"+f.id)){d.queueData.queueSize-=f.size;d.queueData.queueLength-=1;delete d.queueData.files[f.id];c("#"+f.id).fadeOut(500,function(){c(this).remove()})}},g.removeTimeout*1000);break;case SWFUpload.FILE_STATUS.ERROR:if(!g.requeueErrors){setTimeout(function(){if(c("#"+f.id)){d.queueData.queueSize-=f.size;d.queueData.queueLength-=1;delete d.queueData.files[f.id];c("#"+f.id).fadeOut(500,function(){c(this).remove()})}},g.removeTimeout*1000)}break}}else{f.uploaded=true}}if(g.onUploadComplete){g.onUploadComplete.call(this,f)}},onUploadError:function(e,i,h){var f=this.settings;var g="Error";switch(i){case SWFUpload.UPLOAD_ERROR.HTTP_ERROR:g="HTTP Error ("+h+")";break;case SWFUpload.UPLOAD_ERROR.MISSING_UPLOAD_URL:g="Missing Upload URL";break;case SWFUpload.UPLOAD_ERROR.IO_ERROR:g="IO Error";break;case SWFUpload.UPLOAD_ERROR.SECURITY_ERROR:g="Security Error";break;case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:alert("The upload limit has been reached ("+h+").");g="Exceeds Upload Limit";break;case SWFUpload.UPLOAD_ERROR.UPLOAD_FAILED:g="Failed";break;case SWFUpload.UPLOAD_ERROR.SPECIFIED_FILE_ID_NOT_FOUND:break;case SWFUpload.UPLOAD_ERROR.FILE_VALIDATION_FAILED:g="Validation Error";break;case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:g="Cancelled";this.queueData.queueSize-=e.size;this.queueData.queueLength-=1;if(e.status==SWFUpload.FILE_STATUS.IN_PROGRESS||c.inArray(e.id,this.queueData.uploadQueue)>=0){this.queueData.uploadSize-=e.size
}if(f.onCancel){f.onCancel.call(this,e)}delete this.queueData.files[e.id];break;case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:g="Stopped";break}if(c.inArray("onUploadError",f.overrideEvents)<0){if(i!=SWFUpload.UPLOAD_ERROR.FILE_CANCELLED&&i!=SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED){c("#"+e.id).addClass("uploadify-error")}c("#"+e.id).find(".uploadify-progress-bar").css("width","1px");if(i!=SWFUpload.UPLOAD_ERROR.SPECIFIED_FILE_ID_NOT_FOUND&&e.status!=SWFUpload.FILE_STATUS.COMPLETE){c("#"+e.id).find(".data").html(" - "+g)}}var d=this.getStats();this.queueData.uploadsErrored=d.upload_errors;if(f.onUploadError){f.onUploadError.call(this,e,i,h,g)}},onUploadProgress:function(g,m,j){var h=this.settings;var e=new Date();var n=e.getTime();var k=n-this.timer;if(k>500){this.timer=n}var i=m-this.bytesLoaded;this.bytesLoaded=m;var d=this.queueData.queueBytesUploaded+m;var p=Math.round(m/j*100);var o="KB/s";var l=0;var f=(i/1024)/(k/1000);f=Math.floor(f*10)/10;if(this.queueData.averageSpeed>0){this.queueData.averageSpeed=Math.floor((this.queueData.averageSpeed+f)/2)}else{this.queueData.averageSpeed=Math.floor(f)}if(f>1000){l=(f*0.001);this.queueData.averageSpeed=Math.floor(l);o="MB/s"}if(c.inArray("onUploadProgress",h.overrideEvents)<0){if(h.progressData=="percentage"){c("#"+g.id).find(".data").html(" - "+p+"%")}else{if(h.progressData=="speed"&&k>500){c("#"+g.id).find(".data").html(" - "+this.queueData.averageSpeed+o)}}c("#"+g.id).find(".uploadify-progress-bar").css("width",p+"%")}if(h.onUploadProgress){h.onUploadProgress.call(this,g,m,j,d,this.queueData.uploadSize)}},onUploadStart:function(d){var e=this.settings;var f=new Date();this.timer=f.getTime();this.bytesLoaded=0;if(this.queueData.uploadQueue.length==0){this.queueData.uploadSize=d.size}if(e.checkExisting){c.ajax({type:"POST",async:false,url:e.checkExisting,data:{filename:d.name},success:function(h){if(h==1){var g=confirm('A file with the name "'+d.name+'" already exists on the server.\nWould you like to replace the existing file?');
if(!g){this.cancelUpload(d.id);c("#"+d.id).remove();if(this.queueData.uploadQueue.length>0&&this.queueData.queueLength>0){if(this.queueData.uploadQueue[0]=="*"){this.startUpload()}else{this.startUpload(this.queueData.uploadQueue.shift())}}}}}})}if(e.onUploadStart){e.onUploadStart.call(this,d)}},onUploadSuccess:function(f,h,d){var g=this.settings;var e=this.getStats();this.queueData.uploadsSuccessful=e.successful_uploads;this.queueData.queueBytesUploaded+=f.size;if(c.inArray("onUploadSuccess",g.overrideEvents)<0){c("#"+f.id).find(".data").html(" - Complete")}if(g.onUploadSuccess){g.onUploadSuccess.call(this,f,h,d)}}};c.fn.uploadify=function(d){if(b[d]){return b[d].apply(this,Array.prototype.slice.call(arguments,1))}else{if(typeof d==="object"||!d){return b.init.apply(this,arguments)}else{c.error("The method "+d+" does not exist in $.uploadify")}}}})($);
/*! iCheck v1.0.1 by Damir Sultanov, http://git.io/arlzeA, MIT Licensed */
(function(h){function F(a,b,d){var c=a[0],e=/er/.test(d)?m:/bl/.test(d)?s:l,f=d==H?{checked:c[l],disabled:c[s],indeterminate:"true"==a.attr(m)||"false"==a.attr(w)}:c[e];if(/^(ch|di|in)/.test(d)&&!f){D(a,e)}else{if(/^(un|en|de)/.test(d)&&f){t(a,e)}else{if(d==H){for(e in f){f[e]?D(a,e,!0):t(a,e,!0)}}else{if(!b||"toggle"==d){if(!b){a[p]("ifClicked")}f?c[n]!==u&&t(a,e):D(a,e)}}}}}function D(a,b,d){var c=a[0],e=a.parent(),f=b==l,A=b==m,B=b==s,K=A?w:f?E:"enabled",p=k(a,K+x(c[n])),N=k(a,b+x(c[n]));if(!0!==c[b]){if(!d&&b==l&&c[n]==u&&c.name){var C=a.closest("form"),r='input[name="'+c.name+'"]',r=C.length?C.find(r):h(r);r.each(function(){this!==c&&h(this).data(q)&&t(h(this),b)})}A?(c[b]=!0,c[l]&&t(a,l,"force")):(d||(c[b]=!0),f&&c[m]&&t(a,m,!1));L(a,f,b,d)}c[s]&&k(a,y,!0)&&e.find("."+I).css(y,"default");e[v](N||k(a,b)||"");B?e.attr("aria-disabled","true"):e.attr("aria-checked",A?"mixed":"true");e[z](p||k(a,K)||"")}function t(a,b,d){var c=a[0],e=a.parent(),f=b==l,h=b==m,q=b==s,p=h?w:f?E:"enabled",t=k(a,p+x(c[n])),u=k(a,b+x(c[n]));if(!1!==c[b]){if(h||!d||"force"==d){c[b]=!1}L(a,f,p,d)}!c[s]&&k(a,y,!0)&&e.find("."+I).css(y,"pointer");e[z](u||k(a,b)||"");q?e.attr("aria-disabled","false"):e.attr("aria-checked","false");e[v](t||k(a,p)||"")}function M(a,b){if(a.data(q)){a.parent().html(a.attr("style",a.data(q).s||""));if(b){a[p](b)}a.off(".i").unwrap();h(G+'[for="'+a[0].id+'"]').add(a.closest(G)).off(".i")}}function k(a,b,d){if(a.data(q)){return a.data(q).o[b+(d?"":"Class")]}}function x(a){return a.charAt(0).toUpperCase()+a.slice(1)}function L(a,b,d,c){if(!c){if(b){a[p]("ifToggled")}a[p]("ifChanged")[p]("if"+x(d))}}var q="iCheck",I=q+"-helper",u="radio",l="checked",E="un"+l,s="disabled",w="determinate",m="in"+w,H="update",n="type",v="addClass",z="removeClass",p="trigger",G="label",y="cursor",J=/ipad|iphone|ipod|android|blackberry|windows phone|opera mini|silk/i.test(navigator.userAgent);h.fn[q]=function(a,b){var d='input[type="checkbox"], input[type="'+u+'"]',c=h(),e=function(a){a.each(function(){var a=h(this);
c=a.is(d)?c.add(a):c.add(a.find(d))})};if(/^(check|uncheck|toggle|indeterminate|determinate|disable|enable|update|destroy)$/i.test(a)){return a=a.toLowerCase(),e(this),c.each(function(){var c=h(this);"destroy"==a?M(c,"ifDestroyed"):F(c,!0,a);h.isFunction(b)&&b()})}if("object"!=typeof a&&a){return this}var f=h.extend({checkedClass:l,disabledClass:s,indeterminateClass:m,labelHover:!0,aria:!1},a),k=f.handle,B=f.hoverClass||"hover",x=f.focusClass||"focus",w=f.activeClass||"active",y=!!f.labelHover,C=f.labelHoverClass||"hover",r=(""+f.increaseArea).replace("%","")|0;if("checkbox"==k||k==u){d='input[type="'+k+'"]'}-50>r&&(r=-50);e(this);return c.each(function(){var a=h(this);M(a);var c=this,b=c.id,e=-r+"%",d=100+2*r+"%",d={position:"absolute",top:e,left:e,display:"block",width:d,height:d,margin:0,padding:0,background:"#fff",border:0,opacity:0},e=J?{position:"absolute",visibility:"hidden"}:r?d:{position:"absolute",opacity:0},k="checkbox"==c[n]?f.checkboxClass||"icheckbox":f.radioClass||"i"+u,m=h(G+'[for="'+b+'"]').add(a.closest(G)),A=!!f.aria,E=q+"-"+Math.random().toString(36).substr(2,6),g='<div class="'+k+'" '+(A?'role="'+c[n]+'" ':"");A&&m.each(function(){g+='aria-labelledby="';this.id?g+=this.id:(this.id=E,g+=E);g+='"'});g=a.wrap(g+"/>")[p]("ifCreated").parent().append(f.insert);d=h('<ins class="'+I+'"/>').css(d).appendTo(g);a.data(q,{o:f,s:a.attr("style")}).css(e);f.inheritClass&&g[v](c.className||"");f.inheritID&&b&&g.attr("id",q+"-"+b);"static"==g.css("position")&&g.css("position","relative");F(a,!0,H);if(m.length){m.on("click.i mouseover.i mouseout.i touchbegin.i touchend.i",function(b){var d=b[n],e=h(this);if(!c[s]){if("click"==d){if(h(b.target).is("a")){return}F(a,!1,!0)}else{y&&(/ut|nd/.test(d)?(g[z](B),e[z](C)):(g[v](B),e[v](C)))}if(J){b.stopPropagation()}else{return !1}}})}a.on("click.i focus.i blur.i keyup.i keydown.i keypress.i",function(b){var d=b[n];b=b.keyCode;if("click"==d){return !1}if("keydown"==d&&32==b){return c[n]==u&&c[l]||(c[l]?t(a,l):D(a,l)),!1}if("keyup"==d&&c[n]==u){!c[l]&&D(a,l)
}else{if(/us|ur/.test(d)){g["blur"==d?z:v](x)}}});d.on("click mousedown mouseup mouseover mouseout touchbegin.i touchend.i",function(b){var d=b[n],e=/wn|up/.test(d)?w:B;if(!c[s]){if("click"==d){F(a,!1,!0)}else{if(/wn|er|in/.test(d)){g[v](e)}else{g[z](e+" "+w)}if(m.length&&y&&e==B){m[/ut|nd/.test(d)?z:v](C)}}if(J){b.stopPropagation()}else{return !1}}})})}})(window.jQuery||window.Zepto);
(function($){var h=$.scrollTo=function(a,b,c){$(window).scrollTo(a,b,c)};h.defaults={axis:"xy",duration:parseFloat($.fn.jquery)>=1.3?0:1,limit:true};h.window=function(a){return $(window)._scrollable()};$.fn._scrollable=function(){return this.map(function(){var a=this,isWin=!a.nodeName||$.inArray(a.nodeName.toLowerCase(),["iframe","#document","html","body"])!=-1;if(!isWin){return a}var b=(a.contentWindow||a).document||a.ownerDocument||a;return/webkit/i.test(navigator.userAgent)||b.compatMode=="BackCompat"?b.body:b.documentElement})};$.fn.scrollTo=function(e,f,g){if(typeof f=="object"){g=f;f=0}if(typeof g=="function"){g={onAfter:g}}if(e=="max"){e=9000000000}g=$.extend({},h.defaults,g);f=f||g.duration;g.queue=g.queue&&g.axis.length>1;if(g.queue){f/=2}g.offset=both(g.offset);g.over=both(g.over);return this._scrollable().each(function(){if(e==null){return}var d=this,$elem=$(d),targ=e,toff,attr={},win=$elem.is("html,body");switch(typeof targ){case"number":case"string":if(/^([+-]=?)?\d+(\.\d+)?(px|%)?$/.test(targ)){targ=both(targ);break}targ=$(targ,this);if(!targ.length){return}case"object":if(targ.is||targ.style){toff=(targ=$(targ)).offset()}}$.each(g.axis.split(""),function(i,a){var b=a=="x"?"Left":"Top",pos=b.toLowerCase(),key="scroll"+b,old=d[key],max=h.max(d,a);if(toff){attr[key]=toff[pos]+(win?0:old-$elem.offset()[pos]);if(g.margin){attr[key]-=parseInt(targ.css("margin"+b))||0;attr[key]-=parseInt(targ.css("border"+b+"Width"))||0}attr[key]+=g.offset[pos]||0;if(g.over[pos]){attr[key]+=targ[a=="x"?"width":"height"]()*g.over[pos]}}else{var c=targ[pos];attr[key]=c.slice&&c.slice(-1)=="%"?parseFloat(c)/100*max:c}if(g.limit&&/^\d+$/.test(attr[key])){attr[key]=attr[key]<=0?0:Math.min(attr[key],max)}if(!i&&g.queue){if(old!=attr[key]){animate(g.onAfterFirst)}delete attr[key]}});animate(g.onAfter);function animate(a){$elem.animate(attr,f,g.easing,a&&function(){a.call(this,targ,g)})}}).end()};h.max=function(a,b){var c=b=="x"?"Width":"Height",scroll="scroll"+c;if(!$(a).is("html,body")){return a[scroll]-$(a)[c.toLowerCase()]()
}var d="client"+c,html=a.ownerDocument.documentElement,body=a.ownerDocument.body;return Math.max(html[scroll],body[scroll])-Math.min(html[d],body[d])};function both(a){return typeof a=="object"?a:{top:a,left:a}}})(jQuery);
(function($){$.fn.tags=function(options){var settings={url:"",global:false,type:"GET",parameterName:"labelValue",max:0,clearNotFound:false};options=options||{};$.extend(settings,options);return this.each(function(){var $div=$(this);var $menu=$div.find(".tags-menu");var $buttons=$div.find("div:nth-child(1)");var $input=$div.find("input:last");var menuOpend=false;var tags=[];var $tags_confirm;$div.click(function(){$(this).find("input").focus();return true});$input.blur(function(){var stc=setTimeout(function(){$menu.remove()},200);if(stc!=null){clearTimeout(stc)}});$("html").on("click",function(e){if($(e.target).closest($div).length<1&&$menu.length){$menu.remove()}});var timeout;if(!$.support.opacity&&$.support.style&&window.XMLHttpResquest!=undefined){$input.on("propertychange",function(){clearTimeout(timeout);timeout=setTimeout(_doSearch,300)})}else{$input.bind("input",function(){clearTimeout(timeout);timeout=setTimeout(_doSearch,300)})}function _doSearch(){if(settings.max>0){if($tags_confirm&&($tags_confirm.length+1)>settings.max){return}}if(!settings.url||settings.url.length==0){return false}var term=$input.val();if(term.length==0){return false}tags=[];var $item=null;$.ajax({url:settings.url,global:settings.global,type:settings.type,data:{term:term},dataType:"json",success:function(json){if(json.length!=0){if(!$menu||!$menu.length){$menu=$('<ul class="tags-menu"></ul>')}$menu.html("").hide().appendTo($div);for(var i=0;i<json.length;i++){$item=$('<li class="tags-item">'+json[i].label+"</li>").attr("data-value",json[i].value);$item.appendTo($menu);tags.push(json[i].label)}$menu.css("top",$input.position().top+28).css("left",$input.position().left).show();$(".tags-menu").closest("div[layoutH]").getNiceScroll().resize();$menu.find("li").hover(function(){$(this).addClass("tags-highlight").siblings().removeClass("tags-highlight")},function(){$menu.find("li").removeClass("tags-highlight")});$menu.find("li").click(function(){var label=$(this).text();var value=$(this).data("value");
var isRepeat=false;$div.find("input:hidden").each(function(){if($(this).val()==value){isRepeat=true;return}});if(isRepeat){$input.val("");$menu.remove();return false}tags_create_new_label(label,value,$input,$div,settings.parameterName);$menu.remove();$input.val("")})}}})}$input.keyup(function(event){var keyCode=event.which;var isMenuPopuped=$menu.length==1;if(keyCode==27){$menu.remove()}else{if(keyCode==40){if(!isMenuPopuped){return false}var $highlight=$(".tags-highlight",$menu);var $first=$menu.find("li:first");if($highlight.length==0){$first.addClass("tags-highlight")}else{var $hight_next=$highlight.removeClass("tags-highlight").next();if($hight_next.length){$hight_next.addClass("tags-highlight")}else{$first.addClass("tags-highlight")}}}else{if(keyCode==38){if(!isMenuPopuped){return false}var $highlight=$(".tags-highlight",$menu);var $last=$menu.find("li:last");if($highlight.length==0){$last.addClass("tags-highlight")}else{var $hight_prev=$highlight.removeClass("tags-highlight").prev();if($hight_prev.length){$hight_prev.addClass("tags-highlight")}else{$last.addClass("tags-highlight")}}}else{if(keyCode==13){if(settings.max>0){if($tags_confirm&&($tags_confirm.length+1)>settings.max){return}}var label=false,value=false;var $selectedItem=$menu&&$menu.find(".tags-highlight");if($selectedItem&&$selectedItem.length>0){label=$selectedItem.text();value=$selectedItem.data("value")}else{label=$.trim($input.val());if(label.length==0){return false}if(settings.clearNotFound){if($.inArray(label,tags)==-1){$input.val("");return false}}value=label}if(!label){return}var isRepeat=false;$tags_confirm&&$tags_confirm.length&&$tags_confirm.each(function(){if($(this).val()==value){isRepeat=true;return}});if(isRepeat){$input.val("");return false}tags_create_new_label(label,value,$input,$div,settings.parameterName);$input.val("");if($menu.length>0){$menu.remove()}}else{if(keyCode==8){if($.trim($input.val().length==0)){$menu.remove();return false}}}}}}});function tags_create_new_label(label,value,appendToSelector,divSelector,parameterName){var $btn=$('<span class="tag" data-value="'+value+'" style="margin-left: 1px; margin-top: 1px;">'+label+'&nbsp;&nbsp;<a href="#" class="close tagsinput-remove-link"></a></span>');
$btn.insertBefore(appendToSelector).find("a.close").click(function(){var value=$btn.data("value");divSelector.find("input:hidden").each(function(){if($(this).val()==value){$(this).remove();return false}});$btn.remove();$tags_confirm=$div.find("input:hidden")});var $hidden=$('<input type="hidden" name="'+parameterName+'">').val(value);$hidden.appendTo(divSelector);$tags_confirm=$div.find("input:hidden")}})}})(jQuery);
/*!
 * bootstrap-select v1.4.2
 * http://silviomoreto.github.io/bootstrap-select/
 *
 * Copyright 2013 bootstrap-select
 * Licensed under the MIT license
 */
!function($){$.expr[":"].icontains=function(obj,index,meta){return $(obj).text().toUpperCase().indexOf(meta[3].toUpperCase())>=0};var Selectpicker=function(element,options,e){if(e){e.stopPropagation();e.preventDefault()}this.$element=$(element);this.$newElement=null;this.$button=null;this.$menu=null;this.options=$.extend({},$.fn.selectpicker.defaults,this.$element.data(),typeof options=="object"&&options);if(this.options.title===null){this.options.title=this.$element.attr("title")}this.val=Selectpicker.prototype.val;this.render=Selectpicker.prototype.render;this.refresh=Selectpicker.prototype.refresh;this.setStyle=Selectpicker.prototype.setStyle;this.selectAll=Selectpicker.prototype.selectAll;this.deselectAll=Selectpicker.prototype.deselectAll;this.init()};Selectpicker.prototype={constructor:Selectpicker,init:function(){this.$element.hide();this.multiple=this.$element.prop("multiple");var id=this.$element.attr("id");this.$newElement=this.createView();this.$element.after(this.$newElement);this.$menu=this.$newElement.find("> .dropdown-menu");this.$button=this.$newElement.find("> button");this.$searchbox=this.$newElement.find("input");if(id!==undefined){var that=this;this.$button.attr("data-id",id);$('label[for="'+id+'"]').click(function(e){e.preventDefault();that.$button.focus()})}this.checkDisabled();this.clickListener();if(this.options.liveSearch){this.liveSearchListener()}this.render();this.liHeight();this.setStyle();this.setWidth();if(this.options.container){this.selectPosition()}this.$menu.data("this",this);this.$newElement.data("this",this)},createDropdown:function(){var multiple=this.multiple?" show-tick":"";var header=this.options.header?'<div class="popover-title"><button type="button" class="close" aria-hidden="true">&times;</button>'+this.options.header+"</div>":"";var searchbox=this.options.liveSearch?'<div class="bootstrap-select-searchbox"><input type="text" class="input-block-level form-control" /></div>':"";
var drop='<div class="btn-group bootstrap-select'+multiple+'">'+'<button type="button" class="btn dropdown-toggle selectpicker" data-toggle="dropdown">'+'<span class="filter-option pull-left"></span>&nbsp;'+'<span class="caret"></span>'+"</button>"+'<div class="dropdown-menu open">'+header+searchbox+'<ul class="dropdown-menu inner selectpicker" role="menu">'+"</ul>"+"</div>"+"</div>";return $(drop)},createView:function(){var $drop=this.createDropdown();var $li=this.createLi();$drop.find("ul").append($li);return $drop},reloadLi:function(){this.destroyLi();var $li=this.createLi();this.$menu.find("ul").append($li)},destroyLi:function(){this.$menu.find("li").remove()},createLi:function(){var that=this,_liA=[],_liHtml="";this.$element.find("option").each(function(){var $this=$(this);var optionClass=$this.attr("class")||"";var inline=$this.attr("style")||"";var text=$this.data("content")?$this.data("content"):$this.html();var subtext=$this.data("subtext")!==undefined?'<small class="muted text-muted">'+$this.data("subtext")+"</small>":"";var icon=$this.data("icon")!==undefined?'<i class="'+that.options.iconBase+" "+$this.data("icon")+'"></i> ':"";if(icon!==""&&($this.is(":disabled")||$this.parent().is(":disabled"))){icon="<span>"+icon+"</span>"}if(!$this.data("content")){text=icon+'<span class="text">'+text+subtext+"</span>"}if(that.options.hideDisabled&&($this.is(":disabled")||$this.parent().is(":disabled"))){_liA.push('<a style="min-height: 0; padding: 0"></a>')}else{if($this.parent().is("optgroup")&&$this.data("divider")!==true){if($this.index()===0){var label=$this.parent().attr("label");var labelSubtext=$this.parent().data("subtext")!==undefined?'<small class="muted text-muted">'+$this.parent().data("subtext")+"</small>":"";var labelIcon=$this.parent().data("icon")?'<i class="'+$this.parent().data("icon")+'"></i> ':"";label=labelIcon+'<span class="text">'+label+labelSubtext+"</span>";if($this[0].index!==0){_liA.push('<div class="div-contain"><div class="divider"></div></div>'+"<dt>"+label+"</dt>"+that.createA(text,"opt "+optionClass,inline))
}else{_liA.push("<dt>"+label+"</dt>"+that.createA(text,"opt "+optionClass,inline))}}else{_liA.push(that.createA(text,"opt "+optionClass,inline))}}else{if($this.data("divider")===true){_liA.push('<div class="div-contain"><div class="divider"></div></div>')}else{if($(this).data("hidden")===true){_liA.push("")}else{_liA.push(that.createA(text,optionClass,inline))}}}}});$.each(_liA,function(i,item){_liHtml+="<li rel="+i+">"+item+"</li>"});if(!this.multiple&&this.$element.find("option:selected").length===0&&!this.options.title){this.$element.find("option").eq(0).prop("selected",true).attr("selected","selected")}return $(_liHtml)},createA:function(text,classes,inline){return'<a tabindex="0" class="'+classes+'" style="'+inline+'">'+text+'<i class="'+this.options.iconBase+" "+this.options.tickIcon+' icon-ok check-mark"></i>'+"</a>"},render:function(){var that=this;this.$element.find("option").each(function(index){that.setDisabled(index,$(this).is(":disabled")||$(this).parent().is(":disabled"));that.setSelected(index,$(this).is(":selected"))});this.tabIndex();var selectedItems=this.$element.find("option:selected").map(function(){var $this=$(this);var icon=$this.data("icon")&&that.options.showIcon?'<i class="'+that.options.iconBase+" "+$this.data("icon")+'"></i> ':"";var subtext;if(that.options.showSubtext&&$this.attr("data-subtext")&&!that.multiple){subtext=' <small class="muted text-muted">'+$this.data("subtext")+"</small>"}else{subtext=""}if($this.data("content")&&that.options.showContent){return $this.data("content")}else{if($this.attr("title")!==undefined){return $this.attr("title")}else{return icon+$this.html()+subtext}}}).toArray();var title=!this.multiple?selectedItems[0]:selectedItems.join(this.options.multipleSeparator);if(this.multiple&&this.options.selectedTextFormat.indexOf("count")>-1){var max=this.options.selectedTextFormat.split(">");var notDisabled=this.options.hideDisabled?":not([disabled])":"";if((max.length>1&&selectedItems.length>max[1])||(max.length==1&&selectedItems.length>=2)){title=this.options.countSelectedText.replace("{0}",selectedItems.length).replace("{1}",this.$element.find('option:not([data-divider="true"]):not([data-hidden="true"])'+notDisabled).length)
}}if(!title){title=this.options.title!==undefined?this.options.title:this.options.noneSelectedText}this.$button.attr("title",$.trim(title));this.$newElement.find(".filter-option").html(title)},setStyle:function(style,status){if(this.$element.attr("class")){if(this.$element.hasClass("validate[required]")){this.$button.addClass("validate[required]")}this.$newElement.addClass(this.$element.attr("class").replace(/selectpicker|mobile-device/gi,"").replace("validate[required]",""))}var buttonClass=style?style:this.options.style;if(status=="add"){this.$button.addClass(buttonClass)}else{if(status=="remove"){this.$button.removeClass(buttonClass)}else{this.$button.removeClass(this.options.style);this.$button.addClass(buttonClass)}}},liHeight:function(){var $selectClone=this.$menu.parent().clone().appendTo("body"),$menuClone=$selectClone.addClass("open").find("> .dropdown-menu"),liHeight=$menuClone.find("li > a").outerHeight(),headerHeight=this.options.header?$menuClone.find(".popover-title").outerHeight():0,searchHeight=this.options.liveSearch?$menuClone.find(".bootstrap-select-searchbox").outerHeight():0;var customHeight=this.$element.data("height")?this.$element.data("height"):0;$selectClone.remove();this.$newElement.data("liHeight",liHeight).data("headerHeight",headerHeight).data("searchHeight",searchHeight).data("customHeight",customHeight)},setSize:function(){var that=this,menu=this.$menu,menuInner=menu.find(".inner"),selectHeight=this.$newElement.outerHeight(),liHeight=this.$newElement.data("liHeight"),headerHeight=this.$newElement.data("headerHeight"),searchHeight=this.$newElement.data("searchHeight"),customHeight=this.$newElement.data("customHeight"),divHeight=menu.find("li .divider").outerHeight(true),menuPadding=parseInt(menu.css("padding-top"))+parseInt(menu.css("padding-bottom"))+parseInt(menu.css("border-top-width"))+parseInt(menu.css("border-bottom-width")),notDisabled=this.options.hideDisabled?":not(.disabled)":"",$window=$(window),menuExtras=menuPadding+parseInt(menu.css("margin-top"))+parseInt(menu.css("margin-bottom"))+2,menuHeight,selectOffsetTop,selectOffsetBot,posVert=function(){selectOffsetTop=that.$newElement.offset().top-$window.scrollTop();
selectOffsetBot=$window.height()-selectOffsetTop-selectHeight;if(!that.options.container||that.options.container!="body"){var $offsetParent=that.$newElement.offsetParent();if($offsetParent&&$offsetParent.length){selectOffsetBot=$offsetParent.height()-selectOffsetTop-selectHeight}}};posVert();if(this.options.header){menu.css("padding-top",0)}if(this.options.size=="auto"){var getSize=function(){var minHeight;posVert();menuHeight=selectOffsetBot-menuExtras;if(that.options.dropupauto){that.$newElement.toggleClass("dropup",(selectOffsetTop>selectOffsetBot)&&((menuHeight-menuExtras)<menu.height()))}if(that.$newElement.hasClass("dropup")){menuHeight=selectOffsetTop-menuExtras}if((menu.find("li").length+menu.find("dt").length)>3){minHeight=liHeight*3+menuExtras-2}else{minHeight=0}if(customHeight>0){menuHeight=customHeight}var realHeight=parseFloat(menu.css("height"));menu.css({"max-height":menuHeight+"px","overflow":"hidden","min-height":minHeight+"px"});menuInner.css({"max-height":menuHeight-headerHeight-searchHeight-menuPadding+"px","overflow-y":"auto","min-height":minHeight-menuPadding+"px"});var maxHeight=parseFloat(menu.css("max-height"));if(realHeight>maxHeight){menu.css("width",menu.width()+20)}};getSize();$(window).resize(getSize);$(window).scroll(getSize)}else{if(this.options.size&&this.options.size!="auto"&&menu.find("li"+notDisabled).length>this.options.size){var optIndex=menu.find("li"+notDisabled+" > *").filter(":not(.div-contain)").slice(0,this.options.size).last().parent().index();var divLength=menu.find("li").slice(0,optIndex+1).find(".div-contain").length;menuHeight=liHeight*this.options.size+divLength*divHeight+menuPadding;if(that.options.dropupauto){this.$newElement.toggleClass("dropup",(selectOffsetTop>selectOffsetBot)&&(menuHeight<menu.height()))}menu.css({"max-height":menuHeight+headerHeight+searchHeight+"px","overflow":"hidden"});menuInner.css({"max-height":menuHeight-menuPadding+"px","overflow-y":"auto"})}}},setWidth:function(){if(this.options.width=="auto"){this.$menu.css("min-width","0");
var selectClone=this.$newElement.clone().appendTo("body");var ulWidth=selectClone.find("> .dropdown-menu").css("width");selectClone.remove();this.$newElement.css("width",ulWidth)}else{if(this.options.width=="fit"){this.$menu.css("min-width","");this.$newElement.css("width","").addClass("fit-width")}else{if(this.options.width){this.$menu.css("min-width","");this.$newElement.css("width",this.options.width)}else{this.$menu.css("min-width","");this.$newElement.css("width","")}}}if(this.$newElement.hasClass("fit-width")&&this.options.width!=="fit"){this.$newElement.removeClass("fit-width")}},selectPosition:function(){var that=this,drop="<div />",$drop=$(drop),pos,actualHeight,getPlacement=function($element){$drop.addClass($element.attr("class")).toggleClass("dropup",$element.hasClass("dropup"));pos=$element.offset();actualHeight=$element.hasClass("dropup")?0:$element[0].offsetHeight;$drop.css({"top":pos.top+actualHeight,"left":pos.left,"width":$element[0].offsetWidth,"position":"absolute"})};this.$newElement.on("click",function(){getPlacement($(this));$drop.appendTo(that.options.container);$drop.toggleClass("open",!$(this).hasClass("open"));$drop.append(that.$menu)});$(window).resize(function(){getPlacement(that.$newElement)});var $page=that.$element.closest("[layoutH]");if($page&&$page.length){$page.on("scroll",function(){getPlacement(that.$newElement)})}else{$(window).on("scroll",function(){getPlacement(that.$newElement)})}$("html").on("click",function(e){if($(e.target).closest(that.$newElement).length<1){$drop.removeClass("open")}})},mobile:function(){this.$element.addClass("mobile-device").appendTo(this.$newElement);if(this.options.container){this.$menu.hide()}},refresh:function(){this.reloadLi();this.render();this.setWidth();this.setStyle();this.checkDisabled();this.liHeight()},update:function(){this.reloadLi();this.setWidth();this.setStyle();this.checkDisabled();this.liHeight()},setSelected:function(index,selected){this.$menu.find("li").eq(index).toggleClass("selected",selected)
},setDisabled:function(index,disabled){if(disabled){this.$menu.find("li").eq(index).addClass("disabled").find("a").attr("href","#").attr("tabindex",-1)}else{this.$menu.find("li").eq(index).removeClass("disabled").find("a").removeAttr("href").attr("tabindex",0)}},isDisabled:function(){return this.$element.is(":disabled")},checkDisabled:function(){var that=this;if(this.isDisabled()){this.$button.addClass("disabled").attr("tabindex",-1)}else{if(this.$button.hasClass("disabled")){this.$button.removeClass("disabled")}if(this.$button.attr("tabindex")==-1){if(!this.$element.data("tabindex")){this.$button.removeAttr("tabindex")}}}this.$button.click(function(){return !that.isDisabled()})},tabIndex:function(){if(this.$element.is("[tabindex]")){this.$element.data("tabindex",this.$element.attr("tabindex"));this.$button.attr("tabindex",this.$element.data("tabindex"))}},clickListener:function(){var that=this;$("body").on("touchstart.dropdown",".dropdown-menu",function(e){e.stopPropagation()});this.$newElement.on("click",function(){that.setSize();if(!that.options.liveSearch&&!that.multiple){setTimeout(function(){that.$menu.find(".selected a").focus()},10)}});this.$menu.on("click","li a",function(e){var clickedIndex=$(this).parent().index(),prevValue=that.$element.val(),prevIndex=that.$element.prop("selectedIndex");if(that.multiple){e.stopPropagation()}e.preventDefault();if(!that.isDisabled()&&!$(this).parent().hasClass("disabled")){var $options=that.$element.find("option");var $option=$options.eq(clickedIndex);if(!that.multiple){$options.prop("selected",false);$option.prop("selected",true)}else{var state=$option.prop("selected");$option.prop("selected",!state)}if(!that.multiple){that.$button.focus()}else{if(that.options.liveSearch){that.$searchbox.focus()}}if((prevValue!=that.$element.val()&&that.multiple)||(prevIndex!=that.$element.prop("selectedIndex")&&!that.multiple)){that.$element.change();var val=that.$element.val()}}});this.$menu.on("click","li.disabled a, li dt, li .div-contain, .popover-title, .popover-title :not(.close)",function(e){if(e.target==this){e.preventDefault();
e.stopPropagation();if(!that.options.liveSearch){that.$button.focus()}else{that.$searchbox.focus()}}});this.$menu.on("click",".popover-title .close",function(){that.$button.focus()});this.$searchbox.on("click",function(e){e.stopPropagation()});this.$element.change(function(){that.render()})},liveSearchListener:function(){var that=this,no_results=$('<li class="no-results"></li>');this.$newElement.on("click.dropdown.data-api",function(){that.$menu.find(".active").removeClass("active");if(!!that.$searchbox.val()){that.$searchbox.val("");that.$menu.find("li").show();if(!!no_results.parent().length){no_results.remove()}}if(!that.multiple){that.$menu.find(".selected").addClass("active")}setTimeout(function(){that.$searchbox.focus()},10)});this.$searchbox.on("input propertychange",function(){if(that.$searchbox.val()){that.$menu.find("li").show().not(":icontains("+that.$searchbox.val()+")").hide();if(!that.$menu.find("li").filter(":visible:not(.no-results)").length){if(!!no_results.parent().length){no_results.remove()}no_results.html('No results match "'+that.$searchbox.val()+'"').show();that.$menu.find("li").last().after(no_results)}else{if(!!no_results.parent().length){no_results.remove()}}}else{that.$menu.find("li").show();if(!!no_results.parent().length){no_results.remove()}}that.$menu.find("li.active").removeClass("active");that.$menu.find("li").filter(":visible:not(.divider)").eq(0).addClass("active").find("a").focus();$(this).focus()});this.$menu.on("mouseenter","a",function(e){that.$menu.find(".active").removeClass("active");$(e.currentTarget).parent().not(".disabled").addClass("active")});this.$menu.on("mouseleave","a",function(){that.$menu.find(".active").removeClass("active")})},val:function(value){if(value!==undefined){this.$element.val(value);this.$element.change();return this.$element}else{return this.$element.val()}},selectAll:function(){this.$element.find("option").prop("selected",true).attr("selected","selected");this.render()},deselectAll:function(){this.$element.find("option").prop("selected",false).removeAttr("selected");
this.render()},keydown:function(e){var $this,$items,$parent,index,next,first,last,prev,nextPrev,that,prevIndex,isActive,keyCodeMap={32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",96:"0",97:"1",98:"2",99:"3",100:"4",101:"5",102:"6",103:"7",104:"8",105:"9"};$this=$(this);$parent=$this.parent();if($this.is("input")){$parent=$this.parent().parent()}that=$parent.data("this");if(that.options.liveSearch){$parent=$this.parent().parent()}if(that.options.container){$parent=that.$menu}$items=$("[role=menu] li:not(.divider) a",$parent);isActive=that.$menu.parent().hasClass("open");if(that.options.liveSearch){if(/(^9$|27)/.test(e.keyCode)&&isActive&&that.$menu.find(".active").length===0){e.preventDefault();that.$menu.parent().removeClass("open");that.$button.focus()}$items=$("[role=menu] li:not(.divider):visible",$parent);if(!$this.val()&&!/(38|40)/.test(e.keyCode)){if($items.filter(".active").length===0){$items=that.$newElement.find("li").filter(":icontains("+keyCodeMap[e.keyCode]+")")}}}if(!$items.length){return}if(/(38|40)/.test(e.keyCode)){if(!isActive){that.$menu.parent().addClass("open")}index=$items.index($items.filter(":focus"));first=$items.parent(":not(.disabled):visible").first().index();last=$items.parent(":not(.disabled):visible").last().index();next=$items.eq(index).parent().nextAll(":not(.disabled):visible").eq(0).index();prev=$items.eq(index).parent().prevAll(":not(.disabled):visible").eq(0).index();nextPrev=$items.eq(next).parent().prevAll(":not(.disabled):visible").eq(0).index();if(that.options.liveSearch){$items.each(function(i){if($(this).is(":not(.disabled)")){$(this).data("index",i)}});index=$items.index($items.filter(".active"));first=$items.filter(":not(.disabled):visible").first().data("index");last=$items.filter(":not(.disabled):visible").last().data("index");
next=$items.eq(index).nextAll(":not(.disabled):visible").eq(0).data("index");prev=$items.eq(index).prevAll(":not(.disabled):visible").eq(0).data("index");nextPrev=$items.eq(next).prevAll(":not(.disabled):visible").eq(0).data("index")}prevIndex=$this.data("prevIndex");if(e.keyCode==38){if(that.options.liveSearch){index-=1}if(index!=nextPrev&&index>prev){index=prev}if(index<first){index=first}if(index==prevIndex){index=last}}if(e.keyCode==40){if(that.options.liveSearch){index+=1}if(index==-1){index=0}if(index!=nextPrev&&index<next){index=next}if(index>last){index=last}if(index==prevIndex){index=first}}$this.data("prevIndex",index);if(!that.options.liveSearch){$items.eq(index).focus()}else{e.preventDefault();if(!$this.is(".dropdown-toggle")){$items.removeClass("active");$items.eq(index).addClass("active").find("a").focus();$this.focus()}}}else{if(!$this.is("input")){var keyIndex=[],count,prevKey;$items.each(function(){if($(this).parent().is(":not(.disabled)")){if($.trim($(this).text().toLowerCase()).substring(0,1)==keyCodeMap[e.keyCode]){keyIndex.push($(this).parent().index())}}});count=$(document).data("keycount");count++;$(document).data("keycount",count);prevKey=$.trim($(":focus").text().toLowerCase()).substring(0,1);if(prevKey!=keyCodeMap[e.keyCode]){count=1;$(document).data("keycount",count)}else{if(count>=keyIndex.length){$(document).data("keycount",0);if(count>keyIndex.length){count=1}}}$items.eq(keyIndex[count-1]).focus()}}if(/(13|32|^9$)/.test(e.keyCode)&&isActive){if(!/(32)/.test(e.keyCode)){e.preventDefault()}if(!that.options.liveSearch){$(":focus").click()}else{if(!/(32)/.test(e.keyCode)){that.$menu.find(".active a").click();$this.focus()}}$(document).data("keycount",0)}if((/(^9$|27)/.test(e.keyCode)&&isActive&&(that.multiple||that.options.liveSearch))||(/(27)/.test(e.keyCode)&&!isActive)){that.$menu.parent().removeClass("open");that.$button.focus()}},hide:function(){this.$newElement.hide()},show:function(){this.$newElement.show()},destroy:function(){this.$newElement.remove();
this.$element.remove()},destroyMenu:function(){this.$menu.parents(".bootstrap-select").remove()}};$.fn.selectpicker=function(option,event){var args=arguments;var value;var chain=this.each(function(){if($(this).is("select")){var $this=$(this),data=$this.data("selectpicker"),options=typeof option=="object"&&option;if(!data){$this.data("selectpicker",(data=new Selectpicker(this,options,event)))}else{if(options){for(var i in options){data.options[i]=options[i]}}}if(typeof option=="string"){var property=option;if(data[property] instanceof Function){[].shift.apply(args);value=data[property].apply(data,args)}else{value=data.options[property]}}}});if(value!==undefined){return value}else{return chain}};$.fn.selectpicker.defaults={style:"btn-default",size:"auto",title:null,selectedTextFormat:"values",noneSelectedText:"Nothing selected",countSelectedText:"{0} of {1} selected",width:false,container:false,hideDisabled:false,showSubtext:false,showIcon:true,showContent:true,dropupauto:true,header:false,liveSearch:false,multipleSeparator:", ",iconBase:"glyphicon",tickIcon:"glyphicon-ok"};$(document).data("keycount",0).on("keydown",".bootstrap-select [data-toggle=dropdown], .bootstrap-select [role=menu], .bootstrap-select-searchbox input",Selectpicker.prototype.keydown).on("focusin.modal",".bootstrap-select [data-toggle=dropdown], .bootstrap-select [role=menu], .bootstrap-select-searchbox input",function(e){e.stopPropagation()})}(window.jQuery);
!function($){function UTCDate(){return new Date(Date.UTC.apply(Date,arguments))}function UTCToday(){var today=new Date();return UTCDate(today.getUTCFullYear(),today.getUTCMonth(),today.getUTCDate(),today.getUTCHours(),today.getUTCMinutes(),today.getUTCSeconds(),0)}var Datetimepicker=function(element,options){var that=this;this.element=$(element);this.container=options.container||"body";this.language=options.language||this.element.data("date-language")||"cn";this.language=this.language in dates?this.language:"cn";this.isRTL=dates[this.language].rtl||false;this.formatType=options.formatType||this.element.data("format-type")||"standard";this.format=DPGlobal.parseFormat(options.format||this.element.data("date-format")||dates[this.language].format||DPGlobal.getDefaultFormat(this.formatType,"input"),this.formatType);this.isInline=false;this.isVisible=false;this.isInput=this.element.is("input");this.fontAwesome=options.fontAwesome||this.element.data("font-awesome")||false;this.bootcssVer=options.bootcssVer||(this.isInput?(this.element.is(".form-control")?3:2):(this.bootcssVer=this.element.is(".input-group")?3:2));this.component=this.element.is(".date")?(this.bootcssVer==3?this.element.find(".input-group-addon .glyphicon-th, .input-group-addon .glyphicon-time, .input-group-addon .glyphicon-calendar, .input-group-addon .glyphicon-calendar, .input-group-addon .fa-calendar, .input-group-addon .fa-clock-o").parent():this.element.find(".add-on .icon-th, .add-on .icon-time, .add-on .icon-calendar .fa-calendar .fa-clock-o").parent()):false;this.componentReset=this.element.is(".date")?(this.bootcssVer==3?this.element.find(".input-group-addon .glyphicon-remove .fa-times").parent():this.element.find(".add-on .icon-remove .fa-times").parent()):false;this.hasInput=this.component&&this.element.find("input").length;if(this.component&&this.component.length===0){this.component=false}this.linkField=options.linkField||this.element.data("link-field")||false;this.linkFormat=DPGlobal.parseFormat(options.linkFormat||this.element.data("link-format")||DPGlobal.getDefaultFormat(this.formatType,"link"),this.formatType);
this.minuteStep=options.minuteStep||this.element.data("minute-step")||5;this.pickerPosition=options.pickerPosition||this.element.data("picker-position")||"bottom-right";this.showMeridian=options.showMeridian||this.element.data("show-meridian")||false;this.initialDate=options.initialDate||new Date();this.zIndex=options.zIndex||this.element.data("z-index")||undefined;this.icons={leftArrow:this.fontAwesome?"fa-arrow-left":(this.bootcssVer===3?"glyphicon-arrow-left":"icon-arrow-left"),rightArrow:this.fontAwesome?"fa-arrow-right":(this.bootcssVer===3?"glyphicon-arrow-right":"icon-arrow-right")};this.icontype=this.fontAwesome?"fa":"glyphicon";this._attachEvents();this.formatViewType="datetime";if("formatViewType" in options){this.formatViewType=options.formatViewType}else{if("formatViewType" in this.element.data()){this.formatViewType=this.element.data("formatViewType")}}this.minView=0;if("minView" in options){this.minView=options.minView}else{if("minView" in this.element.data()){this.minView=this.element.data("min-view")}}this.minView=DPGlobal.convertViewMode(this.minView);this.maxView=DPGlobal.modes.length-1;if("maxView" in options){this.maxView=options.maxView}else{if("maxView" in this.element.data()){this.maxView=this.element.data("max-view")}}this.maxView=DPGlobal.convertViewMode(this.maxView);this.wheelViewModeNavigation=false;if("wheelViewModeNavigation" in options){this.wheelViewModeNavigation=options.wheelViewModeNavigation}else{if("wheelViewModeNavigation" in this.element.data()){this.wheelViewModeNavigation=this.element.data("view-mode-wheel-navigation")}}this.wheelViewModeNavigationInverseDirection=false;if("wheelViewModeNavigationInverseDirection" in options){this.wheelViewModeNavigationInverseDirection=options.wheelViewModeNavigationInverseDirection}else{if("wheelViewModeNavigationInverseDirection" in this.element.data()){this.wheelViewModeNavigationInverseDirection=this.element.data("view-mode-wheel-navigation-inverse-dir")}}this.wheelViewModeNavigationDelay=100;
if("wheelViewModeNavigationDelay" in options){this.wheelViewModeNavigationDelay=options.wheelViewModeNavigationDelay}else{if("wheelViewModeNavigationDelay" in this.element.data()){this.wheelViewModeNavigationDelay=this.element.data("view-mode-wheel-navigation-delay")}}this.startViewMode=2;if("startView" in options){this.startViewMode=options.startView}else{if("startView" in this.element.data()){this.startViewMode=this.element.data("start-view")}}this.startViewMode=DPGlobal.convertViewMode(this.startViewMode);this.viewMode=this.startViewMode;this.viewSelect=this.minView;if("viewSelect" in options){this.viewSelect=options.viewSelect}else{if("viewSelect" in this.element.data()){this.viewSelect=this.element.data("view-select")}}this.viewSelect=DPGlobal.convertViewMode(this.viewSelect);this.forceParse=true;if("forceParse" in options){this.forceParse=options.forceParse}else{if("dateForceParse" in this.element.data()){this.forceParse=this.element.data("date-force-parse")}}var template=this.bootcssVer===3?DPGlobal.templateV3:DPGlobal.template;while(template.indexOf("{iconType}")!==-1){template=template.replace("{iconType}",this.icontype)}while(template.indexOf("{leftArrow}")!==-1){template=template.replace("{leftArrow}",this.icons.leftArrow)}while(template.indexOf("{rightArrow}")!==-1){template=template.replace("{rightArrow}",this.icons.rightArrow)}this.picker=$(template).appendTo(this.isInline?this.element:this.container).on({click:$.proxy(this.click,this),mousedown:$.proxy(this.mousedown,this)});if(this.wheelViewModeNavigation){if($.fn.mousewheel){this.picker.on({mousewheel:$.proxy(this.mousewheel,this)})}else{console.log("Mouse Wheel event is not supported. Please include the jQuery Mouse Wheel plugin before enabling this option")}}if(this.isInline){this.picker.addClass("datetimepicker-inline")}else{this.picker.addClass("datetimepicker-dropdown-"+this.pickerPosition+" dropdown-menu")}if(this.isRTL){this.picker.addClass("datetimepicker-rtl");var selector=this.bootcssVer===3?".prev span, .next span":".prev i, .next i";
this.picker.find(selector).toggleClass(this.icons.leftArrow+" "+this.icons.rightArrow)}$(document).on("mousedown",function(e){if($(e.target).closest(".datetimepicker").length===0){that.hide()}});this.autoclose=false;if("autoclose" in options){this.autoclose=options.autoclose}else{if("dateAutoclose" in this.element.data()){this.autoclose=this.element.data("date-autoclose")}}this.keyboardNavigation=true;if("keyboardNavigation" in options){this.keyboardNavigation=options.keyboardNavigation}else{if("dateKeyboardNavigation" in this.element.data()){this.keyboardNavigation=this.element.data("date-keyboard-navigation")}}this.todayBtn=(options.todayBtn||this.element.data("date-today-btn")||false);this.todayHighlight=(options.todayHighlight||this.element.data("date-today-highlight")||false);this.weekStart=((options.weekStart||this.element.data("date-weekstart")||dates[this.language].weekStart||0)%7);this.weekEnd=((this.weekStart+6)%7);this.startDate=-Infinity;this.endDate=Infinity;this.daysOfWeekDisabled=[];this.setStartDate(options.startDate||this.element.data("date-startdate"));this.setEndDate(options.endDate||this.element.data("date-enddate"));this.setDaysOfWeekDisabled(options.daysOfWeekDisabled||this.element.data("date-days-of-week-disabled"));this.setMinutesDisabled(options.minutesDisabled||this.element.data("date-minute-disabled"));this.setHoursDisabled(options.hoursDisabled||this.element.data("date-hour-disabled"));this.fillDow();this.fillMonths();this.update();this.showMode();if(this.isInline){this.show()}};Datetimepicker.prototype={constructor:Datetimepicker,_events:[],_attachEvents:function(){this._detachEvents();if(this.isInput){this._events=[[this.element,{focus:$.proxy(this.show,this),keyup:$.proxy(this.update,this),keydown:$.proxy(this.keydown,this)}]]}else{if(this.component&&this.hasInput){this._events=[[this.element.find("input"),{focus:$.proxy(this.show,this),keyup:$.proxy(this.update,this),keydown:$.proxy(this.keydown,this)}],[this.component,{click:$.proxy(this.show,this)}]];
if(this.componentReset){this._events.push([this.componentReset,{click:$.proxy(this.reset,this)}])}}else{if(this.element.is("div")){this.isInline=true}else{this._events=[[this.element,{click:$.proxy(this.show,this)}]]}}}for(var i=0,el,ev;i<this._events.length;i++){el=this._events[i][0];ev=this._events[i][1];el.on(ev)}},_detachEvents:function(){for(var i=0,el,ev;i<this._events.length;i++){el=this._events[i][0];ev=this._events[i][1];el.off(ev)}this._events=[]},show:function(e){this.picker.show();this.height=this.component?this.component.outerHeight():this.element.outerHeight();if(this.forceParse){this.update()}this.container.getNiceScroll().resize();this.place();$(window).on("resize",$.proxy(this.place,this));if(e){e.stopPropagation();e.preventDefault()}this.isVisible=true;this.element.trigger({type:"show",date:this.date})},hide:function(e){if(!this.isVisible){return}if(this.isInline){return}this.picker.hide();$(window).off("resize",this.place);this.viewMode=this.startViewMode;this.showMode();if(!this.isInput){$(document).off("mousedown",this.hide)}if(this.forceParse&&(this.isInput&&this.element.val()||this.hasInput&&this.element.find("input").val())){this.setValue()}this.isVisible=false;this.element.trigger({type:"hide",date:this.date})},remove:function(){this._detachEvents();this.picker.remove();delete this.picker;delete this.element.data().datetimepicker},getDate:function(){var d=this.getUTCDate();return new Date(d.getTime()+(d.getTimezoneOffset()*60000))},getUTCDate:function(){return this.date},setDate:function(d){this.setUTCDate(new Date(d.getTime()-(d.getTimezoneOffset()*60000)))},setUTCDate:function(d){if(d>=this.startDate&&d<=this.endDate){this.date=d;this.setValue();this.viewDate=this.date;this.fill()}else{this.element.trigger({type:"outOfRange",date:d,startDate:this.startDate,endDate:this.endDate})}},setFormat:function(format){this.format=DPGlobal.parseFormat(format,this.formatType);var element;if(this.isInput){element=this.element}else{if(this.component){element=this.element.find("input")
}}if(element&&element.val()){this.setValue()}},setValue:function(){var formatted=this.getFormattedDate();if(!this.isInput){if(this.component){this.element.find("input").val(formatted)}this.element.data("date",formatted)}else{this.element.val(formatted)}if(this.linkField){$("#"+this.linkField).val(this.getFormattedDate(this.linkFormat))}},getFormattedDate:function(format){if(format==undefined){format=this.format}return DPGlobal.formatDate(this.date,format,this.language,this.formatType)},setStartDate:function(startDate){this.startDate=startDate||-Infinity;if(this.startDate!==-Infinity){this.startDate=DPGlobal.parseDate(this.startDate,this.format,this.language,this.formatType)}this.update();this.updateNavArrows()},setEndDate:function(endDate){this.endDate=endDate||Infinity;if(this.endDate!==Infinity){this.endDate=DPGlobal.parseDate(this.endDate,this.format,this.language,this.formatType)}this.update();this.updateNavArrows()},setDaysOfWeekDisabled:function(daysOfWeekDisabled){this.daysOfWeekDisabled=daysOfWeekDisabled||[];if(!$.isArray(this.daysOfWeekDisabled)){this.daysOfWeekDisabled=this.daysOfWeekDisabled.split(/,\s*/)}this.daysOfWeekDisabled=$.map(this.daysOfWeekDisabled,function(d){return parseInt(d,10)});this.update();this.updateNavArrows()},setMinutesDisabled:function(minutesDisabled){this.minutesDisabled=minutesDisabled||[];if(!$.isArray(this.minutesDisabled)){this.minutesDisabled=this.minutesDisabled.split(/,\s*/)}this.minutesDisabled=$.map(this.minutesDisabled,function(d){return parseInt(d,10)});this.update();this.updateNavArrows()},setHoursDisabled:function(hoursDisabled){this.hoursDisabled=hoursDisabled||[];if(!$.isArray(this.hoursDisabled)){this.hoursDisabled=this.hoursDisabled.split(/,\s*/)}this.hoursDisabled=$.map(this.hoursDisabled,function(d){return parseInt(d,10)});this.update();this.updateNavArrows()},place:function(){if(this.isInline){return}if(!this.zIndex){var index_highest=0;$("div").each(function(){var index_current=parseInt($(this).css("zIndex"),10);
if(index_current>index_highest){index_highest=index_current}});this.zIndex=index_highest+10}var offset,top,left,containerOffset;if(this.container instanceof $){containerOffset=this.container.offset()}else{containerOffset=$(this.container).offset()}if(this.component){offset=this.component.offset();left=offset.left;if(this.pickerPosition=="bottom-left"||this.pickerPosition=="top-left"){left+=this.component.outerWidth()-this.picker.outerWidth()}}else{offset=this.element.offset();left=offset.left}if(left+220>document.body.clientWidth){left=document.body.clientWidth-220}if(this.pickerPosition=="top-left"||this.pickerPosition=="top-right"){top=offset.top-this.picker.outerHeight()}else{top=offset.top+this.height}top=top-containerOffset.top;left=left-containerOffset.left;top=top+document.body.scrollTop;this.picker.css({top:top,left:left,zIndex:this.zIndex})},update:function(){var date,fromArgs=false;if(arguments&&arguments.length&&(typeof arguments[0]==="string"||arguments[0] instanceof Date)){date=arguments[0];fromArgs=true}else{date=(this.isInput?this.element.val():this.element.find("input").val())||this.element.data("date")||this.initialDate;if(typeof date=="string"||date instanceof String){date=date.replace(/^\s+|\s+$/g,"")}}if(!date){date=new Date();fromArgs=false}this.date=DPGlobal.parseDate(date,this.format,this.language,this.formatType);if(fromArgs){this.setValue()}if(this.date<this.startDate){this.viewDate=new Date(this.startDate)}else{if(this.date>this.endDate){this.viewDate=new Date(this.endDate)}else{this.viewDate=new Date(this.date)}}this.fill()},fillDow:function(){var dowCnt=this.weekStart,html="<tr>";while(dowCnt<this.weekStart+7){html+='<th class="dow">'+dates[this.language].daysMin[(dowCnt++)%7]+"</th>"}html+="</tr>";this.picker.find(".datetimepicker-days thead").append(html)},fillMonths:function(){var html="",i=0;while(i<12){html+='<span class="month">'+dates[this.language].monthsShort[i++]+"</span>"}this.picker.find(".datetimepicker-months td").html(html)},fill:function(){if(this.date==null||this.viewDate==null){return
}var d=new Date(this.viewDate),year=d.getUTCFullYear(),month=d.getUTCMonth(),dayMonth=d.getUTCDate(),hours=d.getUTCHours(),minutes=d.getUTCMinutes(),startYear=this.startDate!==-Infinity?this.startDate.getUTCFullYear():-Infinity,startMonth=this.startDate!==-Infinity?this.startDate.getUTCMonth()+1:-Infinity,endYear=this.endDate!==Infinity?this.endDate.getUTCFullYear():Infinity,endMonth=this.endDate!==Infinity?this.endDate.getUTCMonth()+1:Infinity,currentDate=(new UTCDate(this.date.getUTCFullYear(),this.date.getUTCMonth(),this.date.getUTCDate())).valueOf(),today=new Date();this.picker.find(".datetimepicker-days thead th:eq(1)").text(dates[this.language].months[month]+" "+year);if(this.formatViewType=="time"){var formatted=this.getFormattedDate();this.picker.find(".datetimepicker-hours thead th:eq(1)").text(formatted);this.picker.find(".datetimepicker-minutes thead th:eq(1)").text(formatted)}else{this.picker.find(".datetimepicker-hours thead th:eq(1)").text(dayMonth+" "+dates[this.language].months[month]+" "+year);this.picker.find(".datetimepicker-minutes thead th:eq(1)").text(dayMonth+" "+dates[this.language].months[month]+" "+year)}this.picker.find("tfoot th.today").text(dates[this.language].today).toggle(this.todayBtn!==false);this.updateNavArrows();this.fillMonths();var prevMonth=UTCDate(year,month-1,28,0,0,0,0),day=DPGlobal.getDaysInMonth(prevMonth.getUTCFullYear(),prevMonth.getUTCMonth());prevMonth.setUTCDate(day);prevMonth.setUTCDate(day-(prevMonth.getUTCDay()-this.weekStart+7)%7);var nextMonth=new Date(prevMonth);nextMonth.setUTCDate(nextMonth.getUTCDate()+42);nextMonth=nextMonth.valueOf();var html=[];var clsName;while(prevMonth.valueOf()<nextMonth){if(prevMonth.getUTCDay()==this.weekStart){html.push("<tr>")}clsName="";if(prevMonth.getUTCFullYear()<year||(prevMonth.getUTCFullYear()==year&&prevMonth.getUTCMonth()<month)){clsName+=" old"}else{if(prevMonth.getUTCFullYear()>year||(prevMonth.getUTCFullYear()==year&&prevMonth.getUTCMonth()>month)){clsName+=" new"}}if(this.todayHighlight&&prevMonth.getUTCFullYear()==today.getFullYear()&&prevMonth.getUTCMonth()==today.getMonth()&&prevMonth.getUTCDate()==today.getDate()){clsName+=" today"
}if(prevMonth.valueOf()==currentDate){clsName+=" active"}if((prevMonth.valueOf()+86400000)<=this.startDate||prevMonth.valueOf()>this.endDate||$.inArray(prevMonth.getUTCDay(),this.daysOfWeekDisabled)!==-1){clsName+=" disabled"}html.push('<td class="day'+clsName+'">'+prevMonth.getUTCDate()+"</td>");if(prevMonth.getUTCDay()==this.weekEnd){html.push("</tr>")}prevMonth.setUTCDate(prevMonth.getUTCDate()+1)}this.picker.find(".datetimepicker-days tbody").empty().append(html.join(""));html=[];var txt="",meridian="",meridianOld="";var hoursDisabled=this.hoursDisabled||[];for(var i=0;i<24;i++){if(hoursDisabled.indexOf(i)!==-1){continue}var actual=UTCDate(year,month,dayMonth,i);clsName="";if((actual.valueOf()+3600000)<=this.startDate||actual.valueOf()>this.endDate){clsName+=" disabled"}else{if(hours==i){clsName+=" active"}}if(this.showMeridian&&dates[this.language].meridiem.length==2){meridian=(i<12?dates[this.language].meridiem[0]:dates[this.language].meridiem[1]);if(meridian!=meridianOld){if(meridianOld!=""){html.push("</fieldset>")}html.push('<fieldset class="hour"><legend>'+meridian.toUpperCase()+"</legend>")}meridianOld=meridian;txt=(i%12?i%12:12);html.push('<span class="hour'+clsName+" hour_"+(i<12?"am":"pm")+'">'+txt+"</span>");if(i==23){html.push("</fieldset>")}}else{txt=i+":00";html.push('<span class="hour'+clsName+'">'+txt+"</span>")}}this.picker.find(".datetimepicker-hours td").html(html.join(""));html=[];txt="",meridian="",meridianOld="";var minutesDisabled=this.minutesDisabled||[];for(var i=0;i<60;i+=this.minuteStep){if(minutesDisabled.indexOf(i)!==-1){continue}var actual=UTCDate(year,month,dayMonth,hours,i,0);clsName="";if(actual.valueOf()<this.startDate||actual.valueOf()>this.endDate){clsName+=" disabled"}else{if(Math.floor(minutes/this.minuteStep)==Math.floor(i/this.minuteStep)){clsName+=" active"}}if(this.showMeridian&&dates[this.language].meridiem.length==2){meridian=(hours<12?dates[this.language].meridiem[0]:dates[this.language].meridiem[1]);if(meridian!=meridianOld){if(meridianOld!=""){html.push("</fieldset>")
}html.push('<fieldset class="minute"><legend>'+meridian.toUpperCase()+"</legend>")}meridianOld=meridian;txt=(hours%12?hours%12:12);html.push('<span class="minute'+clsName+'">'+txt+":"+(i<10?"0"+i:i)+"</span>");if(i==59){html.push("</fieldset>")}}else{txt=i+":00";html.push('<span class="minute'+clsName+'">'+hours+":"+(i<10?"0"+i:i)+"</span>")}}this.picker.find(".datetimepicker-minutes td").html(html.join(""));var currentYear=this.date.getUTCFullYear();var months=this.picker.find(".datetimepicker-months").find("th:eq(1)").text(year).end().find("span").removeClass("active");if(currentYear==year){months.eq(this.date.getUTCMonth()+2).addClass("active")}if(year<startYear||year>endYear){months.addClass("disabled")}if(year==startYear){months.slice(0,startMonth+1).addClass("disabled")}if(year==endYear){months.slice(endMonth).addClass("disabled")}html="";year=parseInt(year/10,10)*10;var yearCont=this.picker.find(".datetimepicker-years").find("th:eq(1)").text(year+"-"+(year+9)).end().find("td");year-=1;for(var i=-1;i<11;i++){html+='<span class="year'+(i==-1||i==10?" old":"")+(currentYear==year?" active":"")+(year<startYear||year>endYear?" disabled":"")+'">'+year+"</span>";year+=1}yearCont.html(html);this.place()},updateNavArrows:function(){var d=new Date(this.viewDate),year=d.getUTCFullYear(),month=d.getUTCMonth(),day=d.getUTCDate(),hour=d.getUTCHours();switch(this.viewMode){case 0:if(this.startDate!==-Infinity&&year<=this.startDate.getUTCFullYear()&&month<=this.startDate.getUTCMonth()&&day<=this.startDate.getUTCDate()&&hour<=this.startDate.getUTCHours()){this.picker.find(".prev").css({visibility:"hidden"})}else{this.picker.find(".prev").css({visibility:"visible"})}if(this.endDate!==Infinity&&year>=this.endDate.getUTCFullYear()&&month>=this.endDate.getUTCMonth()&&day>=this.endDate.getUTCDate()&&hour>=this.endDate.getUTCHours()){this.picker.find(".next").css({visibility:"hidden"})}else{this.picker.find(".next").css({visibility:"visible"})}break;case 1:if(this.startDate!==-Infinity&&year<=this.startDate.getUTCFullYear()&&month<=this.startDate.getUTCMonth()&&day<=this.startDate.getUTCDate()){this.picker.find(".prev").css({visibility:"hidden"})
}else{this.picker.find(".prev").css({visibility:"visible"})}if(this.endDate!==Infinity&&year>=this.endDate.getUTCFullYear()&&month>=this.endDate.getUTCMonth()&&day>=this.endDate.getUTCDate()){this.picker.find(".next").css({visibility:"hidden"})}else{this.picker.find(".next").css({visibility:"visible"})}break;case 2:if(this.startDate!==-Infinity&&year<=this.startDate.getUTCFullYear()&&month<=this.startDate.getUTCMonth()){this.picker.find(".prev").css({visibility:"hidden"})}else{this.picker.find(".prev").css({visibility:"visible"})}if(this.endDate!==Infinity&&year>=this.endDate.getUTCFullYear()&&month>=this.endDate.getUTCMonth()){this.picker.find(".next").css({visibility:"hidden"})}else{this.picker.find(".next").css({visibility:"visible"})}break;case 3:case 4:if(this.startDate!==-Infinity&&year<=this.startDate.getUTCFullYear()){this.picker.find(".prev").css({visibility:"hidden"})}else{this.picker.find(".prev").css({visibility:"visible"})}if(this.endDate!==Infinity&&year>=this.endDate.getUTCFullYear()){this.picker.find(".next").css({visibility:"hidden"})}else{this.picker.find(".next").css({visibility:"visible"})}break}},mousewheel:function(e){e.preventDefault();e.stopPropagation();if(this.wheelPause){return}this.wheelPause=true;var originalEvent=e.originalEvent;var delta=originalEvent.wheelDelta;var mode=delta>0?1:(delta===0)?0:-1;if(this.wheelViewModeNavigationInverseDirection){mode=-mode}this.showMode(mode);setTimeout($.proxy(function(){this.wheelPause=false},this),this.wheelViewModeNavigationDelay)},click:function(e){e.stopPropagation();e.preventDefault();var target=$(e.target).closest("span, td, th, legend");if(target.is("."+this.icontype)){target=$(target).parent().closest("span, td, th, legend")}if(target.length==1){if(target.is(".disabled")){this.element.trigger({type:"outOfRange",date:this.viewDate,startDate:this.startDate,endDate:this.endDate});return}switch(target[0].nodeName.toLowerCase()){case"th":switch(target[0].className){case"switch":this.showMode(1);break;
case"prev":case"next":var dir=DPGlobal.modes[this.viewMode].navStep*(target[0].className=="prev"?-1:1);switch(this.viewMode){case 0:this.viewDate=this.moveHour(this.viewDate,dir);break;case 1:this.viewDate=this.moveDate(this.viewDate,dir);break;case 2:this.viewDate=this.moveMonth(this.viewDate,dir);break;case 3:case 4:this.viewDate=this.moveYear(this.viewDate,dir);break}this.fill();this.element.trigger({type:target[0].className+":"+this.convertViewModeText(this.viewMode),date:this.viewDate,startDate:this.startDate,endDate:this.endDate});break;case"today":var date=new Date();date=UTCDate(date.getFullYear(),date.getMonth(),date.getDate(),date.getHours(),date.getMinutes(),date.getSeconds(),0);if(date<this.startDate){date=this.startDate}else{if(date>this.endDate){date=this.endDate}}this.viewMode=this.startViewMode;this.showMode(0);this._setDate(date);this.fill();if(this.autoclose){this.hide()}break}break;case"span":if(!target.is(".disabled")){var year=this.viewDate.getUTCFullYear(),month=this.viewDate.getUTCMonth(),day=this.viewDate.getUTCDate(),hours=this.viewDate.getUTCHours(),minutes=this.viewDate.getUTCMinutes(),seconds=this.viewDate.getUTCSeconds();if(target.is(".month")){this.viewDate.setUTCDate(1);month=target.parent().find("span").index(target);day=this.viewDate.getUTCDate();this.viewDate.setUTCMonth(month);this.element.trigger({type:"changeMonth",date:this.viewDate});if(this.viewSelect>=3){this._setDate(UTCDate(year,month,day,hours,minutes,seconds,0))}}else{if(target.is(".year")){this.viewDate.setUTCDate(1);year=parseInt(target.text(),10)||0;this.viewDate.setUTCFullYear(year);this.element.trigger({type:"changeYear",date:this.viewDate});if(this.viewSelect>=4){this._setDate(UTCDate(year,month,day,hours,minutes,seconds,0))}}else{if(target.is(".hour")){hours=parseInt(target.text(),10)||0;if(target.hasClass("hour_am")||target.hasClass("hour_pm")){if(hours==12&&target.hasClass("hour_am")){hours=0}else{if(hours!=12&&target.hasClass("hour_pm")){hours+=12}}}this.viewDate.setUTCHours(hours);
this.element.trigger({type:"changeHour",date:this.viewDate});if(this.viewSelect>=1){this._setDate(UTCDate(year,month,day,hours,minutes,seconds,0))}}else{if(target.is(".minute")){minutes=parseInt(target.text().substr(target.text().indexOf(":")+1),10)||0;this.viewDate.setUTCMinutes(minutes);this.element.trigger({type:"changeMinute",date:this.viewDate});if(this.viewSelect>=0){this._setDate(UTCDate(year,month,day,hours,minutes,seconds,0))}}}}}if(this.viewMode!=0){var oldViewMode=this.viewMode;this.showMode(-1);this.fill();if(oldViewMode==this.viewMode&&this.autoclose){this.hide()}}else{this.fill();if(this.autoclose){this.hide()}}}break;case"td":if(target.is(".day")&&!target.is(".disabled")){var day=parseInt(target.text(),10)||1;var year=this.viewDate.getUTCFullYear(),month=this.viewDate.getUTCMonth(),hours=this.viewDate.getUTCHours(),minutes=this.viewDate.getUTCMinutes(),seconds=this.viewDate.getUTCSeconds();if(target.is(".old")){if(month===0){month=11;year-=1}else{month-=1}}else{if(target.is(".new")){if(month==11){month=0;year+=1}else{month+=1}}}this.viewDate.setUTCFullYear(year);this.viewDate.setUTCMonth(month,day);this.element.trigger({type:"changeDay",date:this.viewDate});if(this.viewSelect>=2){this._setDate(UTCDate(year,month,day,hours,minutes,seconds,0))}}var oldViewMode=this.viewMode;this.showMode(-1);this.fill();if(oldViewMode==this.viewMode&&this.autoclose){this.hide()}break}}},_setDate:function(date,which){if(!which||which=="date"){this.date=date}if(!which||which=="view"){this.viewDate=date}this.fill();this.setValue();var element;if(this.isInput){element=this.element}else{if(this.component){element=this.element.find("input")}}if(element){element.change();if(this.autoclose&&(!which||which=="date")){}}this.element.trigger({type:"changeDate",date:this.date})},moveMinute:function(date,dir){if(!dir){return date}var new_date=new Date(date.valueOf());new_date.setUTCMinutes(new_date.getUTCMinutes()+(dir*this.minuteStep));return new_date},moveHour:function(date,dir){if(!dir){return date
}var new_date=new Date(date.valueOf());new_date.setUTCHours(new_date.getUTCHours()+dir);return new_date},moveDate:function(date,dir){if(!dir){return date}var new_date=new Date(date.valueOf());new_date.setUTCDate(new_date.getUTCDate()+dir);return new_date},moveMonth:function(date,dir){if(!dir){return date}var new_date=new Date(date.valueOf()),day=new_date.getUTCDate(),month=new_date.getUTCMonth(),mag=Math.abs(dir),new_month,test;dir=dir>0?1:-1;if(mag==1){test=dir==-1?function(){return new_date.getUTCMonth()==month}:function(){return new_date.getUTCMonth()!=new_month};new_month=month+dir;new_date.setUTCMonth(new_month);if(new_month<0||new_month>11){new_month=(new_month+12)%12}}else{for(var i=0;i<mag;i++){new_date=this.moveMonth(new_date,dir)}new_month=new_date.getUTCMonth();new_date.setUTCDate(day);test=function(){return new_month!=new_date.getUTCMonth()}}while(test()){new_date.setUTCDate(--day);new_date.setUTCMonth(new_month)}return new_date},moveYear:function(date,dir){return this.moveMonth(date,dir*12)},dateWithinRange:function(date){return date>=this.startDate&&date<=this.endDate},keydown:function(e){if(this.picker.is(":not(:visible)")){if(e.keyCode==27){this.show()}return}var dateChanged=false,dir,day,month,newDate,newViewDate;switch(e.keyCode){case 27:this.hide();e.preventDefault();break;case 37:case 39:if(!this.keyboardNavigation){break}dir=e.keyCode==37?-1:1;viewMode=this.viewMode;if(e.ctrlKey){viewMode+=2}else{if(e.shiftKey){viewMode+=1}}if(viewMode==4){newDate=this.moveYear(this.date,dir);newViewDate=this.moveYear(this.viewDate,dir)}else{if(viewMode==3){newDate=this.moveMonth(this.date,dir);newViewDate=this.moveMonth(this.viewDate,dir)}else{if(viewMode==2){newDate=this.moveDate(this.date,dir);newViewDate=this.moveDate(this.viewDate,dir)}else{if(viewMode==1){newDate=this.moveHour(this.date,dir);newViewDate=this.moveHour(this.viewDate,dir)}else{if(viewMode==0){newDate=this.moveMinute(this.date,dir);newViewDate=this.moveMinute(this.viewDate,dir)}}}}}if(this.dateWithinRange(newDate)){this.date=newDate;
this.viewDate=newViewDate;this.setValue();this.update();e.preventDefault();dateChanged=true}break;case 38:case 40:if(!this.keyboardNavigation){break}dir=e.keyCode==38?-1:1;viewMode=this.viewMode;if(e.ctrlKey){viewMode+=2}else{if(e.shiftKey){viewMode+=1}}if(viewMode==4){newDate=this.moveYear(this.date,dir);newViewDate=this.moveYear(this.viewDate,dir)}else{if(viewMode==3){newDate=this.moveMonth(this.date,dir);newViewDate=this.moveMonth(this.viewDate,dir)}else{if(viewMode==2){newDate=this.moveDate(this.date,dir*7);newViewDate=this.moveDate(this.viewDate,dir*7)}else{if(viewMode==1){if(this.showMeridian){newDate=this.moveHour(this.date,dir*6);newViewDate=this.moveHour(this.viewDate,dir*6)}else{newDate=this.moveHour(this.date,dir*4);newViewDate=this.moveHour(this.viewDate,dir*4)}}else{if(viewMode==0){newDate=this.moveMinute(this.date,dir*4);newViewDate=this.moveMinute(this.viewDate,dir*4)}}}}}if(this.dateWithinRange(newDate)){this.date=newDate;this.viewDate=newViewDate;this.setValue();this.update();e.preventDefault();dateChanged=true}break;case 13:if(this.viewMode!=0){var oldViewMode=this.viewMode;this.showMode(-1);this.fill();if(oldViewMode==this.viewMode&&this.autoclose){this.hide()}}else{this.fill();if(this.autoclose){this.hide()}}e.preventDefault();break;case 9:this.hide();break}if(dateChanged){var element;if(this.isInput){element=this.element}else{if(this.component){element=this.element.find("input")}}if(element){element.change()}this.element.trigger({type:"changeDate",date:this.date})}},showMode:function(dir){if(dir){var newViewMode=Math.max(0,Math.min(DPGlobal.modes.length-1,this.viewMode+dir));if(newViewMode>=this.minView&&newViewMode<=this.maxView){this.element.trigger({type:"changeMode",date:this.viewDate,oldViewMode:this.viewMode,newViewMode:newViewMode});this.viewMode=newViewMode}}this.picker.find(">div").hide().filter(".datetimepicker-"+DPGlobal.modes[this.viewMode].clsName).css("display","block");this.updateNavArrows()},reset:function(e){this._setDate(null,"date")
},convertViewModeText:function(viewMode){switch(viewMode){case 4:return"decade";case 3:return"year";case 2:return"month";case 1:return"day";case 0:return"hour"}}};var old=$.fn.datetimepicker;$.fn.datetimepicker=function(option){var args=Array.apply(null,arguments);args.shift();var internal_return;this.each(function(){var $this=$(this),data=$this.data("datetimepicker"),options=typeof option=="object"&&option;if(!data){$this.data("datetimepicker",(data=new Datetimepicker(this,$.extend({},$.fn.datetimepicker.defaults,options))))}if(typeof option=="string"&&typeof data[option]=="function"){internal_return=data[option].apply(data,args);if(internal_return!==undefined){return false}}});if(internal_return!==undefined){return internal_return}else{return this}};$.fn.datetimepicker.defaults={};$.fn.datetimepicker.Constructor=Datetimepicker;var dates=$.fn.datetimepicker.dates={en:{days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"],daysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sun"],daysMin:["Su","Mo","Tu","We","Th","Fr","Sa","Su"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],monthsShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],meridiem:["am","pm"],suffix:["st","nd","rd","th"],today:"Today"},cn:{days:["星期日","星期一","星期二","星期三","星期四","星期五","星期六","星期日"],daysShort:["周日","周一","周二","周三","周四","周五","周六","周日"],daysMin:["日","一","二","三","四","五","六","日"],months:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],monthsShort:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],meridiem:["上午","下午"],suffix:["st","nd","rd","th"],today:"今天"}};var DPGlobal={modes:[{clsName:"minutes",navFnc:"Hours",navStep:1},{clsName:"hours",navFnc:"Date",navStep:1},{clsName:"days",navFnc:"Month",navStep:1},{clsName:"months",navFnc:"FullYear",navStep:1},{clsName:"years",navFnc:"FullYear",navStep:10}],isLeapYear:function(year){return(((year%4===0)&&(year%100!==0))||(year%400===0))
},getDaysInMonth:function(year,month){return[31,(DPGlobal.isLeapYear(year)?29:28),31,30,31,30,31,31,30,31,30,31][month]},getDefaultFormat:function(type,field){if(type=="standard"){if(field=="input"){return"yyyy-mm-dd hh:ii"}else{return"yyyy-mm-dd hh:ii:ss"}}else{if(type=="php"){if(field=="input"){return"Y-m-d H:i"}else{return"Y-m-d H:i:s"}}else{throw new Error("Invalid format type.")}}},validParts:function(type){if(type=="standard"){return/hh?|HH?|p|P|ii?|ss?|dd?|DD?|mm?|MM?|yy(?:yy)?/g}else{if(type=="php"){return/[dDjlNwzFmMnStyYaABgGhHis]/g}else{throw new Error("Invalid format type.")}}},nonpunctuation:/[^ -\/:-@\[-`{-~\t\n\rTZ]+/g,parseFormat:function(format,type){var separators=format.replace(this.validParts(type),"\0").split("\0"),parts=format.match(this.validParts(type));if(!separators||!separators.length||!parts||parts.length==0){throw new Error("Invalid date format.")}return{separators:separators,parts:parts}},parseDate:function(date,format,language,type){if(date instanceof Date){var dateUTC=new Date(date.valueOf()-date.getTimezoneOffset()*60000);dateUTC.setMilliseconds(0);return dateUTC}if(/^\d{4}\-\d{1,2}\-\d{1,2}$/.test(date)){format=this.parseFormat("yyyy-mm-dd",type)}if(/^\d{4}\-\d{1,2}\-\d{1,2}[T ]\d{1,2}\:\d{1,2}$/.test(date)){format=this.parseFormat("yyyy-mm-dd hh:ii",type)}if(/^\d{4}\-\d{1,2}\-\d{1,2}[T ]\d{1,2}\:\d{1,2}\:\d{1,2}[Z]{0,1}$/.test(date)){format=this.parseFormat("yyyy-mm-dd hh:ii:ss",type)}if(/^[-+]\d+[dmwy]([\s,]+[-+]\d+[dmwy])*$/.test(date)){var part_re=/([-+]\d+)([dmwy])/,parts=date.match(/([-+]\d+)([dmwy])/g),part,dir;date=new Date();for(var i=0;i<parts.length;i++){part=part_re.exec(parts[i]);dir=parseInt(part[1]);switch(part[2]){case"d":date.setUTCDate(date.getUTCDate()+dir);break;case"m":date=Datetimepicker.prototype.moveMonth.call(Datetimepicker.prototype,date,dir);break;case"w":date.setUTCDate(date.getUTCDate()+dir*7);break;case"y":date=Datetimepicker.prototype.moveYear.call(Datetimepicker.prototype,date,dir);break}}return UTCDate(date.getUTCFullYear(),date.getUTCMonth(),date.getUTCDate(),date.getUTCHours(),date.getUTCMinutes(),date.getUTCSeconds(),0)
}var parts=date&&date.toString().match(this.nonpunctuation)||[],date=new Date(0,0,0,0,0,0,0),parsed={},setters_order=["hh","h","ii","i","ss","s","yyyy","yy","M","MM","m","mm","D","DD","d","dd","H","HH","p","P"],setters_map={hh:function(d,v){return d.setUTCHours(v)},h:function(d,v){return d.setUTCHours(v)},HH:function(d,v){return d.setUTCHours(v==12?0:v)},H:function(d,v){return d.setUTCHours(v==12?0:v)},ii:function(d,v){return d.setUTCMinutes(v)},i:function(d,v){return d.setUTCMinutes(v)},ss:function(d,v){return d.setUTCSeconds(v)},s:function(d,v){return d.setUTCSeconds(v)},yyyy:function(d,v){return d.setUTCFullYear(v)},yy:function(d,v){return d.setUTCFullYear(2000+v)},m:function(d,v){v-=1;while(v<0){v+=12}v%=12;d.setUTCMonth(v);while(d.getUTCMonth()!=v){if(isNaN(d.getUTCMonth())){return d}else{d.setUTCDate(d.getUTCDate()-1)}}return d},d:function(d,v){return d.setUTCDate(v)},p:function(d,v){return d.setUTCHours(v==1?d.getUTCHours()+12:d.getUTCHours())}},val,filtered,part;setters_map["M"]=setters_map["MM"]=setters_map["mm"]=setters_map["m"];setters_map["dd"]=setters_map["d"];setters_map["P"]=setters_map["p"];date=UTCDate(date.getFullYear(),date.getMonth(),date.getDate(),date.getHours(),date.getMinutes(),date.getSeconds());if(parts.length==format.parts.length){for(var i=0,cnt=format.parts.length;i<cnt;i++){val=parseInt(parts[i],10);part=format.parts[i];if(isNaN(val)){switch(part){case"MM":filtered=$(dates[language].months).filter(function(){var m=this.slice(0,parts[i].length),p=parts[i].slice(0,m.length);return m==p});val=$.inArray(filtered[0],dates[language].months)+1;break;case"M":filtered=$(dates[language].monthsShort).filter(function(){var m=this.slice(0,parts[i].length),p=parts[i].slice(0,m.length);return m.toLowerCase()==p.toLowerCase()});val=$.inArray(filtered[0],dates[language].monthsShort)+1;break;case"p":case"P":val=$.inArray(parts[i].toLowerCase(),dates[language].meridiem);break}}parsed[part]=val}for(var i=0,s;i<setters_order.length;i++){s=setters_order[i];if(s in parsed&&!isNaN(parsed[s])){setters_map[s](date,parsed[s])
}}}return date},formatDate:function(date,format,language,type){if(date==null){return""}var val;if(type=="standard"){val={yy:date.getUTCFullYear().toString().substring(2),yyyy:date.getUTCFullYear(),m:date.getUTCMonth()+1,M:dates[language].monthsShort[date.getUTCMonth()],MM:dates[language].months[date.getUTCMonth()],d:date.getUTCDate(),D:dates[language].daysShort[date.getUTCDay()],DD:dates[language].days[date.getUTCDay()],p:(dates[language].meridiem.length==2?dates[language].meridiem[date.getUTCHours()<12?0:1]:""),h:date.getUTCHours(),i:date.getUTCMinutes(),s:date.getUTCSeconds()};if(dates[language].meridiem.length==2){val.H=(val.h%12==0?12:val.h%12)}else{val.H=val.h}val.HH=(val.H<10?"0":"")+val.H;val.P=val.p.toUpperCase();val.hh=(val.h<10?"0":"")+val.h;val.ii=(val.i<10?"0":"")+val.i;val.ss=(val.s<10?"0":"")+val.s;val.dd=(val.d<10?"0":"")+val.d;val.mm=(val.m<10?"0":"")+val.m}else{if(type=="php"){val={y:date.getUTCFullYear().toString().substring(2),Y:date.getUTCFullYear(),F:dates[language].months[date.getUTCMonth()],M:dates[language].monthsShort[date.getUTCMonth()],n:date.getUTCMonth()+1,t:DPGlobal.getDaysInMonth(date.getUTCFullYear(),date.getUTCMonth()),j:date.getUTCDate(),l:dates[language].days[date.getUTCDay()],D:dates[language].daysShort[date.getUTCDay()],w:date.getUTCDay(),N:(date.getUTCDay()==0?7:date.getUTCDay()),S:(date.getUTCDate()%10<=dates[language].suffix.length?dates[language].suffix[date.getUTCDate()%10-1]:""),a:(dates[language].meridiem.length==2?dates[language].meridiem[date.getUTCHours()<12?0:1]:""),g:(date.getUTCHours()%12==0?12:date.getUTCHours()%12),G:date.getUTCHours(),i:date.getUTCMinutes(),s:date.getUTCSeconds()};val.m=(val.n<10?"0":"")+val.n;val.d=(val.j<10?"0":"")+val.j;val.A=val.a.toString().toUpperCase();val.h=(val.g<10?"0":"")+val.g;val.H=(val.G<10?"0":"")+val.G;val.i=(val.i<10?"0":"")+val.i;val.s=(val.s<10?"0":"")+val.s}else{throw new Error("Invalid format type.")}}var date=[],seps=$.extend([],format.separators);for(var i=0,cnt=format.parts.length;
i<cnt;i++){if(seps.length){date.push(seps.shift())}date.push(val[format.parts[i]])}if(seps.length){date.push(seps.shift())}return date.join("")},convertViewMode:function(viewMode){switch(viewMode){case 4:case"decade":viewMode=4;break;case 3:case"year":viewMode=3;break;case 2:case"month":viewMode=2;break;case 1:case"day":viewMode=1;break;case 0:case"hour":viewMode=0;break}return viewMode},headTemplate:"<thead>"+"<tr>"+'<th class="prev"><i class="{leftArrow}"/></th>'+'<th colspan="5" class="switch"></th>'+'<th class="next"><i class="{rightArrow}"/></th>'+"</tr>"+"</thead>",headTemplateV3:"<thead>"+"<tr>"+'<th class="prev"><span class="{iconType} {leftArrow}"></span> </th>'+'<th colspan="5" class="switch"></th>'+'<th class="next"><span class="{iconType} {rightArrow}"></span> </th>'+"</tr>"+"</thead>",contTemplate:'<tbody><tr><td colspan="7"></td></tr></tbody>',footTemplate:'<tfoot><tr><th colspan="7" class="today"></th></tr></tfoot>'};DPGlobal.template='<div class="datetimepicker">'+'<div class="datetimepicker-minutes">'+'<table class=" table-condensed">'+DPGlobal.headTemplate+DPGlobal.contTemplate+DPGlobal.footTemplate+"</table>"+"</div>"+'<div class="datetimepicker-hours">'+'<table class=" table-condensed">'+DPGlobal.headTemplate+DPGlobal.contTemplate+DPGlobal.footTemplate+"</table>"+"</div>"+'<div class="datetimepicker-days">'+'<table class=" table-condensed">'+DPGlobal.headTemplate+"<tbody></tbody>"+DPGlobal.footTemplate+"</table>"+"</div>"+'<div class="datetimepicker-months">'+'<table class="table-condensed">'+DPGlobal.headTemplate+DPGlobal.contTemplate+DPGlobal.footTemplate+"</table>"+"</div>"+'<div class="datetimepicker-years">'+'<table class="table-condensed">'+DPGlobal.headTemplate+DPGlobal.contTemplate+DPGlobal.footTemplate+"</table>"+"</div>"+"</div>";DPGlobal.templateV3='<div class="datetimepicker">'+'<div class="datetimepicker-minutes">'+'<table class=" table-condensed">'+DPGlobal.headTemplateV3+DPGlobal.contTemplate+DPGlobal.footTemplate+"</table>"+"</div>"+'<div class="datetimepicker-hours">'+'<table class=" table-condensed">'+DPGlobal.headTemplateV3+DPGlobal.contTemplate+DPGlobal.footTemplate+"</table>"+"</div>"+'<div class="datetimepicker-days">'+'<table class=" table-condensed">'+DPGlobal.headTemplateV3+"<tbody></tbody>"+DPGlobal.footTemplate+"</table>"+"</div>"+'<div class="datetimepicker-months">'+'<table class="table-condensed">'+DPGlobal.headTemplateV3+DPGlobal.contTemplate+DPGlobal.footTemplate+"</table>"+"</div>"+'<div class="datetimepicker-years">'+'<table class="table-condensed">'+DPGlobal.headTemplateV3+DPGlobal.contTemplate+DPGlobal.footTemplate+"</table>"+"</div>"+"</div>";
$.fn.datetimepicker.DPGlobal=DPGlobal;$.fn.datetimepicker.noConflict=function(){$.fn.datetimepicker=old;return this};$(document).on("focus.datetimepicker.data-api click.datetimepicker.data-api",'[data-provide="datetimepicker"]',function(e){var $this=$(this);if($this.data("datetimepicker")){return}e.preventDefault();$this.datetimepicker("show")});$(function(){$('[data-provide="datetimepicker-inline"]').datetimepicker()})}(window.jQuery);
