/**
 * plugin.js
 *
 * Copyright, Moxiecode Systems AB
 * Released under LGPL License.
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/*jshint unused:false */
/*global tinymce:true */

/**
 * Example plugin that adds a toolbar button and menu item.
 */
tinymce.PluginManager.add('codelight', function(editor, url) {
	// Add a button that opens a window
	editor.addButton('codelight', {
		text: '',
		icon: 'spellchecker',
		tooltip: '代码高亮',
		onclick: function() {
			// Open window
			editor.windowManager.open({
				title: '代码高亮',
				body: [
                    {type: 'textbox',name: 'highlightcode',multiline: true,id:"codelight",spellcheck: false,minWidth: 600,minHeight: 300},
				
                    {type: 'listbox',name: 'classname',label: '代码类型',
                    	'values': [
                    	{text: 'PHP代码', value: 'php'},
                    	{text: 'HTML代码', value: 'php'}
                    	]
                    	},
                    	
				],
				onsubmit: function(e) {
					// Insert content when the window form is submitted
					editor.insertContent('<pre><code data-language="'+e.data.classname+'">' + $('#codelight').text(e.data.highlightcode).html() + '</code></pre><p></p>');
				}
			});
		}
	});

	// Adds a menu item to the tools menu
	editor.addMenuItem('codelight', {
		text: 'codelight',
		context: 'tools',
		onclick: function() {
			// Open window with a specific url
			editor.windowManager.open({
				title: 'TinyMCE site',
				url: url + '/dialog.html',
				width: 600,
				height: 400,
				buttons: [
					{
						text: 'Insert',
						onclick: function() {
							// Top most window object
							var win = editor.windowManager.getWindows()[0];

							// Insert the contents of the dialog.html textarea into the editor
							editor.insertContent(win.getContentWindow().document.getElementById('content').value);

							// Close the window
							win.close();
						}
					},

					{text: 'Close', onclick: 'close'}
				]
			});
		}
	});
});