/**
 * plugin.js
 *
 * Copyright, Moxiecode Systems AB
 * Released under LGPL License.
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/*global tinymce:true */

tinymce.PluginManager.add('emoticons', function(editor, url) {
	var emoticons = [
		["emot01", "emot02", "emot03", "emot04", "emot05", "emot06", "emot07", "emot42", "emot41", "emot40"],
		["emot08", "emot09", "emot10", "emot11", "emot12", "emot13", "emot14", "emot39", "emot38", "emot37"],
		["emot15", "emot16", "emot17", "emot18", "emot19", "emot20", "emot21", "emot36", "emot35", "emot34"],
		["emot22", "emot23", "emot24", "emot25", "emot26", "emot27", "emot28", "emot33", "emot32", "emot31"],
		["emot29", "emot30"]
	];

	function getHtml() {
		var emoticonsHtml;

		emoticonsHtml = '<table role="list" class="mce-grid">';

		tinymce.each(emoticons, function(row) {
			emoticonsHtml += '<tr>';

			tinymce.each(row, function(icon) {
				var emoticonUrl = url + '/emot1/' + icon + '.gif';

				emoticonsHtml += '<td><a href="#" data-mce-url="' + emoticonUrl + '" data-mce-alt="' + icon + '" tabindex="-1" ' +
					'role="option" aria-label="' + icon + '"><img src="' +
					emoticonUrl + '" style="width: 50px; height: 50px" role="presentation" /></a></td>';
			});

			emoticonsHtml += '</tr>';
		});

		emoticonsHtml += '</table>';

		return emoticonsHtml;
	}

	editor.addButton('emoticons', {
		type: 'panelbutton',
		panel: {
			role: 'application',
			autohide: true,
			html: getHtml,
			onclick: function(e) {
				var linkElm = editor.dom.getParent(e.target, 'a');

				if (linkElm) {
					editor.insertContent(
						'<img src="' + linkElm.getAttribute('data-mce-url') + '" alt="' + linkElm.getAttribute('data-mce-alt') + '" />'
					);

					this.hide();
				}
			}
		},
		tooltip: 'Emoticons'
	});
});
