-- --------------------------------------------------
-- 文件名: yixun.sql 
-- YiXunCMS数据库安装文件
-- 作者： 易迅软件
-- --------------------------------------------------

# --------------------------------------------------------
# 表的结构 yx_column,该表用于文章栏目
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_column;
CREATE TABLE yx_column (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  pid SMALLINT(5) UNSIGNED NOT NULL DEFAUlT 0,
  path VARCHAR(100) NOT NULL DEFAULT '',
  title VARCHAR(100) NOT NULL DEFAULT '',
  description VARCHAR(200) NOT NULL default '',
  audit SMALLINT(1) UNSIGNED NOT NULL DEFAULT '1',
  ord SMALLINT(3) UNSIGNED NOT NULL DEFAULT 0,
  display SMALLINT(3) UNSIGNED NOT NULL DEFAULT 1,
  PRIMARY KEY (id),
  INDEX column_pid(pid),
  INDEX column_path(path),
  INDEX column_audit(audit),
  INDEX column_ord(ord),
  INDEX column_display(display)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_article,该表用于文章
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_article;
CREATE TABLE yx_article (
  id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  title VARCHAR(100) NOT NULL DEFAULT '',
  summary VARCHAR(500) NOT NULL DEFAULT '',
  posttime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  uid INT(11) UNSIGNED NOT NULL DEFAULT 0,
  comefrom VARCHAR(50) NOT NULL DEFAULT '',
  content TEXT DEFAULT NULL,
  keyword VARCHAR(200) NOT NULL DEFAULT '',
  pid SMALLINT(5) UNSIGNED NOT NULL DEFAULT 0,
  audit SMALLINT(1) UNSIGNED NOT NULL DEFAULT '0',
  recommend SMALLINT(1) UNSIGNED NOT NULL DEFAULT '0',
  allow SMALLINT(1) UNSIGNED NOT NULL DEFAULT '1',
  views SMALLINT(5) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY  (id),
  INDEX article_title(title),
  INDEX article_uid(uid),
  INDEX article_pid(pid),
  INDEX article_audit(audit),
  INDEX article_recommend(recommend),
  INDEX article_allow(allow),
  INDEX article_keyword(keyword)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_notice,该表用于公告
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_notice;
CREATE TABLE yx_notice (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  title VARCHAR(80) NOT NULL DEFAULT '',
  color CHAR(6) NOT NULL DEFAULT '000000',
  starttime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  endtime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  content TEXT DEFAULT NULL,
  display SMALLINT(1) UNSIGNED NOT NULL DEFAULT '1',
  ord SMALLINT(3) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY  (id),
  INDEX notice_starttime(starttime),
  INDEX notice_endtime(endtime),
  INDEX notice_display(display),
  INDEX notice_ord(ord)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_play,该表用于幻灯播放
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_play;
CREATE TABLE yx_play (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  aid INT(11) UNSIGNED NOT NULL DEFAULT 0,
  title VARCHAR(80) NOT NULL DEFAULT '',
  pic CHAR(24) NOT NULL DEFAULT '',
  starttime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  endtime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  display SMALLINT(1) UNSIGNED NOT NULL DEFAULT '1',
  ord SMALLINT(3) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (id),
  INDEX play_aid(aid),
  INDEX play_starttime(starttime),
  INDEX play_endtime(endtime),
  INDEX play_ord(ord),
  INDEX play_display(display)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_flink,该表用于友情链接
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_flink;
CREATE TABLE yx_flink (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  webname VARCHAR(30) NOT NULL DEFAULT '',
  url VARCHAR(60) NOT NULL DEFAULT '',
  logo VARCHAR(60) NOT NULL DEFAULT '',
  rname VARCHAR(30) NOT NULL DEFAULT '',
  email VARCHAR(50) NOT NULL DEFAULT '',
  dtime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  msg VARCHAR(200) NOT NULL DEFAULT '',
  list SMALLINT(1) UNSIGNED NOT NULL DEFAULT '0',
  audit SMALLINT(1) UNSIGNED NOT NULL DEFAULT 0,
  ord SMALLINT(3) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY  (id),
  INDEX flink_list(list),
  INDEX flink_audit(audit),
  INDEX flink_ord(ord)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_phcolumn,该表用于产品栏目
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_phcolumn;
CREATE TABLE yx_phcolumn (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  pid SMALLINT(5) UNSIGNED NOT NULL DEFAUlT 0,
  path VARCHAR(100) NOT NULL DEFAULT '',
  title VARCHAR(100) NOT NULL DEFAULT '',
  description VARCHAR(200) NOT NULL default '',
  audit SMALLINT(1) UNSIGNED NOT NULL DEFAULT '1',
  ord SMALLINT(3) UNSIGNED NOT NULL DEFAULT 0,
  display SMALLINT(3) UNSIGNED NOT NULL DEFAULT 1,
  PRIMARY KEY  (id),
  INDEX phcolumn_pid(pid),
  INDEX phcolumn_path(path),
  INDEX phcolumn_audit(audit),
  INDEX phcolumn_ord(ord),
  INDEX phcolumn_display(display)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_photo,该表用于产品
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_photo;
CREATE TABLE yx_photo (
  id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  pid SMALLINT(5) UNSIGNED NOT NULL DEFAULT 0,
  uid INT(11) UNSIGNED NOT NULL DEFAULT 0,
  title VARCHAR(100) NOT NULL DEFAULT '',
  pic CHAR(24) NOT NULL DEFAULT '',
  pnum VARCHAR(20) NOT NULL DEFAULT '',
  spec VARCHAR(50) NOT NULL DEFAULT '',
  unit VARCHAR(10) NOT NULL DEFAULT '',
  price DECIMAL(8,2) NOT NULL DEFAULT 0,
  recommend SMALLINT(1) UNSIGNED NOT NULL DEFAULT 0,
  top SMALLINT(1) UNSIGNED NOT NULL DEFAULT 0,
  audit SMALLINT(1) UNSIGNED NOT NULL DEFAULT 0,
  content text DEFAULT NULL,
  views SMALLINT(5) NOT NULL DEFAULT 0,
  posttime INT(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (id),
  INDEX photo_title(title),
  INDEX photo_pid(pid),
  INDEX photo_uid(uid),
  INDEX photo_recommend(recommend),
  INDEX photo_top(top)
)DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_job,该表用于招聘
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_job;
CREATE TABLE yx_job (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  title VARCHAR(50) NOT NULL DEFAULT '',
  address VARCHAR(50) NOT NULL DEFAULT '',
  treatment DECIMAL(8,2) NOT NULL DEFAULT 0.00,
  number SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0',
  starttime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  endtime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  content TEXT DEFAULT NULL,
  PRIMARY KEY (id)
)DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_dow,该表用于资源下载
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_dow;
CREATE TABLE yx_dow (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  title VARCHAR(50) NOT NULL DEFAULT '',
  url VARCHAR(50) NOT NULL DEFAULT '',
  postttime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  content TEXT DEFAULT NULL,
  PRIMARY KEY (id)
)DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_votemain,该表用于投票主题
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_votemain;
CREATE TABLE yx_votemain (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  title VARCHAR(100) NOT NULL DEFAULT '',
  audit SMALLINT(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (id)
)DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_voteitem,该表用于投票选项
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_voteitem;
CREATE TABLE yx_voteitem (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  pid SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0',
  item VARCHAR(100) NOT NULL DEFAULT '',
  vcount SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
)DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_about,该表用于单页关于我们
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_about;
CREATE TABLE yx_about (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  title VARCHAR(100) NOT NULL DEFAULT '',
  content TEXT DEFAULT NULL,
  audit SMALLINT(1) UNSIGNED NOT NULL DEFAULT '1',
  ord SMALLINT(3) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (id)
)DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_fun,该表用于扩展
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_fun;
CREATE TABLE yx_fun (
  id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  title VARCHAR(100) NOT NULL DEFAULT '',
  content TEXT DEFAULT NULL,
  audit SMALLINT(1) UNSIGNED NOT NULL DEFAULT '1',
  ord SMALLINT(3) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (id)
)DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_board该表用于留言
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_board;
CREATE TABLE yx_board (
  id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  uid INT(11) UNSIGNED NOT NULL DEFAULT 0,
  postttime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  backttime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  content TEXT DEFAULT NULL,
  backcontent TEXT DEFAULT NULL,
  audit SMALLINT(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (id)
)DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_group该表用于用户组
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_group;
CREATE TABLE yx_group (
  id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  groupname VARCHAR(20) NOT NULL DEFAULT '',
  description VARCHAR(200) NOT NULL DEFAULT '',
  useradmin TINYINT(1) NOT NULL DEFAULT 0,
  webadmin TINYINT(1) NOT NULL DEFAULT 0,
  articleadmin TINYINT(1) NOT NULL DEFAULT 0,
  sendcomment TINYINT(1) NOT NULL DEFAULT 0,
  photoadmin TINYINT(1) NOT NULL DEFAULT 0,
  jobadmin TINYINT(1) NOT NULL DEFAULT 0,
  dowadmin TINYINT(1) NOT NULL DEFAULT 0,
  voteadmin TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY  (id)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_user该表用于用户
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_user;
CREATE TABLE yx_user (
  id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  gid SMALLINT(4)  UNSIGNED NOT NULL,
  username VARCHAR(20) NOT NULL DEFAULT '',
  userpwd VARCHAR(40) NOT NULL DEFAULT '',
  email VARCHAR(60) NOT NULL DEFAULT '',
  regtime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  sex SMALLINT(3)  NOT NULL DEFAULT 0,
  disable SMALLINT(3) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY  (id),
  INDEX user_gid(gid),
  INDEX user_username(username),
  INDEX user_userpwd(userpwd),
  INDEX user_disable(disable)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_comment该表用于评论
# --------------------------------------------------------

DROP TABLE IF EXISTS yx_comment;
CREATE TABLE yx_comment (
  id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  uid INT(11) UNSIGNED NOT NULL DEFAULT '0',
  aid INT(11) UNSIGNED NOT NULL DEFAULT '0',
  ptime INT(10) UNSIGNED NOT NULL DEFAULT '0',
  content TEXT DEFAULT NULL,
  PRIMARY KEY  (id),
  INDEX comment_uid(uid),
  INDEX comment_aid(aid)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# 安装时插入两个默认组
INSERT INTO yx_group(id,groupname,description, useradmin, webadmin,articleadmin,sendcomment,photoadmin,jobadmin,dowadmin,voteadmin) VALUES(NULL,'超级管理员','超级管理员用户组，该组的用户具有全部的权限','1', '1','1', '1','1', '1','1','1');

INSERT INTO yx_group(id,groupname,description, useradmin, webadmin,articleadmin,sendcomment,photoadmin,jobadmin,dowadmin,voteadmin) VALUES(NULL,'普通会员','新注册用户默认属于该组，只具有发评论和留言的权限','0', '0','0', '1','0', '0','0','0');

#安装时插入企业新闻栏目
INSERT INTO yx_column(id,pid,path,title,description,audit,ord,display) VALUES(NULL,'0','0','企业新闻', '发布企业新扯','0', '0','1');

#安装时插入扩展栏目
INSERT INTO yx_fun(id,title,content,audit,ord) VALUES(NULL,'首页联系方式','请在后台扩展中修改','1', '0');

#安装时插入单页关于我们
INSERT INTO yx_about(id,title,content,audit,ord) VALUES(NULL,'企业简介','请在后台单页中修改','1', '0');
INSERT INTO yx_about(id,title,content,audit,ord) VALUES(NULL,'联系我们','请在后台单页中修改','1', '0');

#安装时插入LOGO
INSERT INTO yx_flink(id,webname,url,logo,rname,email,dtime,msg,list,audit,ord) VALUES(NULL,'易迅软件','http://www.yixun-bs.com','yixun.gif','易迅','1652368686@qq.com',UNIX_TIMESTAMP(),'易迅软件','1','1','0');