DROP TABLE IF EXISTS `saxue_article`;
CREATE TABLE IF NOT EXISTS `saxue_article` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `catid` smallint(4) unsigned NOT NULL default '0',
  `lang` varchar(5) NOT NULL default '',
  `title` varchar(100) NOT NULL,
  `thumb` varchar(100) NOT NULL default '',
  `intro` varchar(255) NOT NULL default '',
  `url` varchar(100) NOT NULL,
  `display` tinyint(1) unsigned NOT NULL default '1',
  `iswap` tinyint(1) unsigned NOT NULL default '1',
  `istop` tinyint(1) unsigned NOT NULL default '0',
  `islink` tinyint(1) unsigned NOT NULL default '0',
  `addtime` int(10) unsigned NOT NULL default '0',
  `updatetime` int(10) unsigned NOT NULL default '0',
  `views` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `list` (`catid`,`lang`,`display`,`istop`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=42 ;

DROP TABLE IF EXISTS `saxue_article_data`;
CREATE TABLE IF NOT EXISTS `saxue_article_data` (
  `id` mediumint(8) unsigned NOT NULL default '0',
  `content` mediumtext NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `saxue_banner`;
CREATE TABLE IF NOT EXISTS `saxue_banner` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `title` varchar(20) NOT NULL default '',
  `type` tinyint(1) unsigned NOT NULL default '0',
  `width` smallint(4) unsigned NOT NULL default '0',
  `height` smallint(4) unsigned NOT NULL default '0',
  `pics` tinyint(2) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS `saxue_banner_pic`;
CREATE TABLE IF NOT EXISTS `saxue_banner_pic` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `bid` smallint(4) unsigned NOT NULL default '0',
  `url` varchar(100) NOT NULL default '',
  `title` varchar(20) NOT NULL default '',
  `link` varchar(100) NOT NULL default '#',
  `listorder` tinyint(2) unsigned NOT NULL default '0',
  `status` tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

DROP TABLE IF EXISTS `saxue_column`;
CREATE TABLE IF NOT EXISTS `saxue_column` (
  `catid` smallint(4) unsigned NOT NULL auto_increment COMMENT '栏目编号',
  `modid` smallint(4) unsigned NOT NULL default '0' COMMENT '模块ID',
  `catname` varchar(30) NOT NULL COMMENT '栏目名称',
  `catdir` varchar(30) NOT NULL COMMENT '栏目目录',
  `pid` smallint(5) unsigned NOT NULL default '0' COMMENT '父栏目',
  `arrpid` varchar(255) NOT NULL COMMENT '父栏目列',
  `child` tinyint(1) unsigned NOT NULL default '0' COMMENT '子栏目',
  `arrchild` varchar(255) NOT NULL COMMENT '子栏目列',
  `listorder` smallint(4) unsigned NOT NULL default '0' COMMENT '排序',
  `ismenu` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否链接，1是0否',
  `image` varchar(100) NOT NULL default '' COMMENT '栏目图片',
  `custom` varchar(100) NOT NULL COMMENT '自定义文件',
  `url` varchar(100) NOT NULL COMMENT 'URL',
  `display` tinyint(1) unsigned NOT NULL default '0' COMMENT '显示模式，1栏目首页0栏目列表',
  `setting` text NOT NULL COMMENT '扩展设置',
  `langset` text NOT NULL COMMENT '多语言显示设置',
  `seo` text NOT NULL COMMENT 'SEO设置',
  PRIMARY KEY  (`catid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=38 ;

DROP TABLE IF EXISTS `saxue_feedback`;
CREATE TABLE IF NOT EXISTS `saxue_feedback` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `catid` smallint(4) unsigned NOT NULL default '0',
  `lang` varchar(5) NOT NULL default '',
  `name` varchar(30) NOT NULL default '',
  `tel` varchar(20) NOT NULL default '',
  `email` varchar(30) NOT NULL default '',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `addtime` int(10) unsigned NOT NULL default '0',
  `isread` tinyint(1) unsigned NOT NULL default '0',
  `reply` text NOT NULL,
  `updatetime` int(10) unsigned NOT NULL default '0',
  `display` tinyint(1) unsigned NOT NULL default '0',
  `iswap` tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `list` (`catid`,`lang`,`display`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

DROP TABLE IF EXISTS `saxue_job`;
CREATE TABLE IF NOT EXISTS `saxue_job` (
  `id` mediumint(8) NOT NULL auto_increment,
  `catid` smallint(4) unsigned NOT NULL default '0',
  `lang` varchar(5) NOT NULL default '',
  `title` varchar(50) NOT NULL,
  `count` smallint(4) unsigned NOT NULL default '0',
  `place` varchar(20) NOT NULL default '',
  `deal` varchar(20) NOT NULL default '',
  `content` text NOT NULL,
  `lifedays` smallint(4) unsigned NOT NULL default '0',
  `url` varchar(100) NOT NULL default '',
  `addtime` int(10) unsigned NOT NULL default '0',
  `updatetime` int(10) unsigned NOT NULL default '0',
  `display` tinyint(1) unsigned NOT NULL default '1',
  `iswap` tinyint(1) unsigned NOT NULL default '1',
  `istop` tinyint(1) unsigned NOT NULL default '0',
  `islink` tinyint(1) unsigned NOT NULL default '0',
  `views` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `list` (`catid`,`lang`,`display`,`istop`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

DROP TABLE IF EXISTS `saxue_lang`;
CREATE TABLE IF NOT EXISTS `saxue_lang` (
  `id` mediumint(8) unsigned NOT NULL auto_increment COMMENT '编号',
  `title` varchar(20) NOT NULL default '' COMMENT '语言项名称',
  `name` varchar(30) NOT NULL default '' COMMENT '标识',
  `setting` text NOT NULL COMMENT '设置',
  `issystem` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否系统',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(1, '上一页', 'prepage', 'a:2:{s:2:"zh";s:9:"上一页";s:2:"en";s:3:"‹";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(2, '下一页', 'nextpage', 'a:2:{s:2:"zh";s:9:"下一页";s:2:"en";s:3:"›";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(3, '首页', 'firstpage', 'a:2:{s:2:"zh";s:6:"首页";s:2:"en";s:2:"«";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(4, '尾页', 'lastpage', 'a:2:{s:2:"zh";s:6:"尾页";s:2:"en";s:2:"»";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(5, '前几页', 'pregrouppage', 'a:2:{s:2:"zh";s:8:"第%s页";s:2:"en";s:6:"No. %s";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(6, '后几页', 'nextgrouppage', 'a:2:{s:2:"zh";s:8:"第%s页";s:2:"en";s:6:"No. %s";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(7, '总记录页数', 'totalpage', 'a:2:{s:2:"zh";s:22:"共%s条记录，%s页";s:2:"en";s:26:"Total %s records, %s pages";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(8, '留言回复标题', 'feedback_title', 'a:2:{s:2:"zh";s:12:"留言回复";s:2:"en";s:13:"Message Reply";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(9, '留言回复格式', 'feedback_content', 'a:2:{s:2:"zh";s:72:"%s，您好<br><br>您的留言：<br>%s<br><br>管理员回复：<br>%s";s:2:"en";s:70:"Hello, %s<br><br>Your message:<br>%s<br><br>Administrator reply:<br>%s";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(10, '搜索最少字符', 'minsearchlen', 'a:2:{s:2:"zh";s:55:"对不起，搜索关键字请不要少于 %s 个字符";s:2:"en";s:46:"Sorry, search keywords at least  %s characters";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(11, '搜索最少间隔', 'minsearchtime', 'a:2:{s:2:"zh";s:58:"对不起，两次搜索的间隔时间不得少于 %s 秒";s:2:"en";s:49:"Sorry, search again intervals at least %s seconds";}', 1);
INSERT INTO `saxue_lang` (`id`, `title`, `name`, `setting`, `issystem`) VALUES(12, '模块关闭', 'moduleclose', 'a:2:{s:2:"zh";s:27:"模块不存在或已关闭";s:2:"en";s:44:"The module does not exist or has been closed";}', 1);

DROP TABLE IF EXISTS `saxue_module`;
CREATE TABLE IF NOT EXISTS `saxue_module` (
  `id` smallint(4) unsigned NOT NULL auto_increment COMMENT '编号',
  `name` varchar(10) NOT NULL default '' COMMENT '模型名称',
  `type` tinyint(1) unsigned NOT NULL default '0' COMMENT '类型，0单页内容，1列表，2列表+内容',
  `status` tinyint(1) unsigned NOT NULL default '1' COMMENT '状态，0禁用，1启用',
  `issystem` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否系统模型，1是0否',
  `moddir` varchar(20) NOT NULL default '' COMMENT '模块目录',
  `tablename` varchar(20) NOT NULL default '' COMMENT '数据表名，不带前缀',
  `issearch` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否允许搜索',
  `searchfield` varchar(20) NOT NULL default 'title' COMMENT '搜索字段',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

INSERT INTO `saxue_module` (`id`, `name`, `type`, `status`, `issystem`, `moddir`, `tablename`, `issearch`, `searchfield`) VALUES(1, '单页模块', 0, 1, 1, 'page', 'page', 0, 'title');
INSERT INTO `saxue_module` (`id`, `name`, `type`, `status`, `issystem`, `moddir`, `tablename`, `issearch`, `searchfield`) VALUES(2, '文章模块', 2, 1, 1, 'article', 'article', 1, 'title');
INSERT INTO `saxue_module` (`id`, `name`, `type`, `status`, `issystem`, `moddir`, `tablename`, `issearch`, `searchfield`) VALUES(3, '产品模块', 2, 1, 1, 'product', 'product', 1, 'title');
INSERT INTO `saxue_module` (`id`, `name`, `type`, `status`, `issystem`, `moddir`, `tablename`, `issearch`, `searchfield`) VALUES(4, '招聘模块', 2, 1, 1, 'job', 'job', 1, 'title');
INSERT INTO `saxue_module` (`id`, `name`, `type`, `status`, `issystem`, `moddir`, `tablename`, `issearch`, `searchfield`) VALUES(5, '留言反馈', 1, 1, 1, 'feedback', 'feedback', 0, '');

DROP TABLE IF EXISTS `saxue_page`;
CREATE TABLE IF NOT EXISTS `saxue_page` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `catid` smallint(4) unsigned NOT NULL default '0',
  `lang` varchar(5) NOT NULL default '',
  `title` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `addtime` int(10) unsigned NOT NULL default '0',
  `updatetime` int(10) unsigned NOT NULL default '0',
  `display` tinyint(1) unsigned NOT NULL default '1',
  `iswap` tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `page` (`catid`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

DROP TABLE IF EXISTS `saxue_product`;
CREATE TABLE IF NOT EXISTS `saxue_product` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `catid` smallint(4) unsigned NOT NULL default '0',
  `lang` varchar(5) NOT NULL default '',
  `title` varchar(100) NOT NULL,
  `thumb` varchar(100) NOT NULL default '',
  `intro` varchar(255) NOT NULL default '',
  `url` varchar(100) NOT NULL,
  `display` tinyint(1) unsigned NOT NULL default '1',
  `iswap` tinyint(1) unsigned NOT NULL default '1',
  `istop` tinyint(1) unsigned NOT NULL default '0',
  `islink` tinyint(1) unsigned NOT NULL default '0',
  `addtime` int(10) unsigned NOT NULL default '0',
  `updatetime` int(10) unsigned NOT NULL default '0',
  `views` mediumint(8) unsigned NOT NULL default '0',
  `buylink` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `list` (`catid`,`lang`,`display`,`istop`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

DROP TABLE IF EXISTS `saxue_product_data`;
CREATE TABLE IF NOT EXISTS `saxue_product_data` (
  `id` mediumint(8) unsigned NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `pics` text NOT NULL,
  `expand` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `saxue_product_expand`;
CREATE TABLE IF NOT EXISTS `saxue_product_expand` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `catid` smallint(4) unsigned NOT NULL default '0',
  `listorder` smallint(4) unsigned NOT NULL,
  `name` varchar(30) NOT NULL default '',
  `lang` varchar(5) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

DROP TABLE IF EXISTS `saxue_search`;
CREATE TABLE IF NOT EXISTS `saxue_search` (
  `searchid` int(11) unsigned NOT NULL auto_increment,
  `searchtime` int(10) unsigned NOT NULL default '0',
  `searchtimes` int(10) unsigned NOT NULL default '1',
  `lang` varchar(5) NOT NULL default '',
  `hashid` varchar(32) NOT NULL default '0',
  `modid` smallint(4) unsigned NOT NULL default '0',
  `catid` smallint(4) unsigned NOT NULL default '0',
  `keywords` varchar(60) NOT NULL default '',
  `results` int(11) unsigned NOT NULL default '0',
  `ids` text NOT NULL,
  PRIMARY KEY  (`searchid`),
  UNIQUE KEY `hashid` (`hashid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS `saxue_system_admin`;
CREATE TABLE IF NOT EXISTS `saxue_system_admin` (
  `id` smallint(5) NOT NULL auto_increment,
  `account` varchar(20) NOT NULL,
  `password` char(32) NOT NULL,
  `role` smallint(4) unsigned NOT NULL default '0',
  `status` tinyint(1) unsigned NOT NULL default '0',
  `isfounder` tinyint(1) unsigned NOT NULL default '0',
  `lasttime` int(10) unsigned NOT NULL default '0',
  `lastip` char(15) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `saxue_system_admin` (`id`, `account`, `password`, `role`, `status`, `isfounder`, `lasttime`, `lastip`) VALUES(1, 'admin', 'e967f2635adb106b3aed9dbb56df2250', 0, 1, 1, 1411135072, '122.231.157.140');

DROP TABLE IF EXISTS `saxue_system_adminmenu`;
CREATE TABLE IF NOT EXISTS `saxue_system_adminmenu` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `pid` smallint(5) unsigned NOT NULL default '0',
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `level` tinyint(1) unsigned NOT NULL default '1',
  `node` varchar(20) NOT NULL default '',
  `caption` varchar(30) NOT NULL default '',
  `command` varchar(100) NOT NULL default '',
  `display` tinyint(1) unsigned NOT NULL default '1',
  `issystem` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=45 ;

INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(1, 0, 1, 1, 'system', '系统管理', '', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(7, 1, 11, 2, 'systemset', '系统设置', '', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(8, 1, 12, 2, 'cache', '缓存更新', '', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(9, 1, 13, 2, 'database', '数据库维护', '', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(10, 7, 111, 3, 'configs', '系统定义', 'configs.php?gname=system&define=1', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(11, 7, 113, 3, 'admins', '后台管理员', 'admins.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(12, 7, 114, 3, 'roles', '角色权限组', 'roles.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(13, 8, 121, 3, 'cleancache', '清理区块缓存', 'cleancache.php?target=block', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(14, 8, 122, 3, 'cleancache', '清理网页缓存', 'cleancache.php?target=html', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(15, 8, 123, 3, 'cleancache', '清理编译缓存', 'cleancache.php?target=compiled', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(16, 9, 131, 3, 'dbmanage', '数据库备份', 'dbmanage.php?option=export', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(17, 9, 132, 3, 'dbmanage', '数据库恢复', 'dbmanage.php?option=import', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(18, 9, 133, 3, 'dboptimize', '数据库优化', 'dboptimize.php?option=optimize', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(19, 9, 134, 3, 'dboptimize', '数据库修复', 'dboptimize.php?option=repair', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(20, 9, 135, 3, 'dbquery', '数据库升级', 'dbquery.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(21, 7, 112, 3, 'configs', '系统参数设置', 'configs.php?gname=system', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(22, 38, 821, 3, 'blocks', '自定义区块', 'blocks.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(23, 7, 116, 3, 'language', '多语言配置', 'language.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(24, 0, 2, 1, 'contmanage', '内容管理', '', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(25, 24, 22, 2, 'contset', '内容设置', '', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(26, 25, 221, 3, 'column', '栏目管理', 'column.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(27, 25, 222, 3, 'module', '内容模块', 'module.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(28, 25, 223, 3, 'urlrule', '模块URL规则', 'urlrule.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(29, 0, 8, 1, 'extend', '扩展功能', '', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(30, 24, 21, 2, 'contman', '内容管理', '', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(31, 30, 211, 3, 'content', '栏目内容管理', 'content.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(32, 30, 212, 3, 'attachs', '附件管理', 'attachs.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(33, 30, 213, 3, 'urlupdate', '批量更新URL', 'urlupdate.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(34, 25, 224, 3, 'configs', '参数设置', 'configs.php?gname=content', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(38, 29, 82, 2, 'others', '其他', '', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(39, 38, 822, 3, 'lang', '自定义语言包', 'lang.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(40, 38, 823, 3, 'banner', '网站Banner设置', 'banner.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(41, 30, 211, 3, 'search', '内容搜索管理', 'search.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(42, 29, 80, 2, 'plugins', '应用', '', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(43, 42, 801, 3, 'cloudaddons', '应用中心', 'cloudaddons.php', 1, 1);
INSERT INTO `saxue_system_adminmenu` (`id`, `pid`, `listorder`, `level`, `node`, `caption`, `command`, `display`, `issystem`) VALUES(44, 42, 802, 3, 'plugin', '我的应用', 'plugin.php', 1, 1);

DROP TABLE IF EXISTS `saxue_system_blocks`;
CREATE TABLE IF NOT EXISTS `saxue_system_blocks` (
  `bid` smallint(4) unsigned NOT NULL auto_increment,
  `blockname` varchar(50) NOT NULL default '',
  `filename` varchar(50) NOT NULL default '',
  `classname` varchar(50) NOT NULL default '',
  `title` text NOT NULL,
  `description` text NOT NULL,
  `content` mediumtext NOT NULL,
  `vars` text NOT NULL,
  `template` varchar(50) NOT NULL default '',
  `cachetime` int(11) NOT NULL default '0',
  `contenttype` tinyint(3) NOT NULL default '0',
  `custom` tinyint(1) unsigned NOT NULL default '0',
  `canedit` tinyint(1) unsigned NOT NULL default '0',
  `hasvars` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS `saxue_system_configs`;
CREATE TABLE IF NOT EXISTS `saxue_system_configs` (
  `cid` int(10) unsigned NOT NULL auto_increment,
  `gname` varchar(20) NOT NULL default 'system',
  `cname` varchar(30) NOT NULL default '',
  `ctitle` varchar(50) NOT NULL default '',
  `cvalue` text NOT NULL,
  `cdescription` text NOT NULL,
  `cdefine` tinyint(1) NOT NULL default '0',
  `ctype` tinyint(1) NOT NULL default '0',
  `options` text NOT NULL,
  `catorder` int(10) NOT NULL default '0',
  `catname` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`cid`),
  UNIQUE KEY `group` (`gname`,`cname`),
  KEY `catorder` (`catorder`),
  KEY `cdefine` (`cdefine`),
  KEY `catname` (`catname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=75 ;

INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(1, 'system', 'SAXUE_URL', '网站地址', 'http://corp.saxue.com', '虚拟路径（URL），后面不带斜线', 1, 1, '', 1, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(2, 'system', 'SAXUE_SITE_NAME', '网站名称', 'SaxuePower', '', 1, 1, '', 2, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(3, 'system', 'SAXUE_ADMIN_DIR', '后台目录', 'admin', '默认为空时是admin目录，为了后台安全建议修改目录', 1, 1, '', 3, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(4, 'system', 'SAXUE_SKIN_SERVERSET', '网站风格文件地址', '', '', 1, 1, '', 4, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(5, 'system', 'SAXUE_DB_TYPE', '数据库类型', 'mysql', '目前只支持mysql', 1, 7, 'a:1:{s:5:"mysql";s:5:"Mysql";}', 5, '数据库配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(6, 'system', 'SAXUE_DB_CHARSET', '数据库编码', 'utf8', '', 1, 7, 'a:6:{s:4:"utf8";s:4:"utf8";s:3:"gbk";s:3:"gbk";s:6:"gb2312";s:6:"gb2312";s:4:"big5";s:4:"big5";s:6:"latin1";s:6:"latin1";s:7:"default";s:7:"default";}', 6, '数据库配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(7, 'system', 'SAXUE_DB_HOST', '数据库服务器', 'localhost', '', 1, 1, '', 7, '数据库配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(8, 'system', 'SAXUE_DB_USER', '数据库用户名', '', '', 1, 1, '', 8, '数据库配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(9, 'system', 'SAXUE_DB_PASS', '数据库密码', '', '留空表示不修改密码', 1, 5, '', 9, '数据库配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(10, 'system', 'SAXUE_DB_NAME', '数据库名', 'saxuepower', '', 1, 1, '', 10, '数据库配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(11, 'system', 'SAXUE_DB_PREFIX', '数据表前缀', 'saxue', '', 1, 1, '', 11, '数据库配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(12, 'system', 'SAXUE_DB_PCONNECT', '是否使用持久连接', '0', '', 1, 9, 'a:2:{i:0;s:3:"否";i:1;s:3:"是";}', 12, '数据库配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(13, 'system', 'SAXUE_IS_OPEN', '网站是否开放', '1', '', 1, 7, 'a:3:{i:1;s:12:"网站开放";i:0;s:12:"网站关闭";i:2;s:27:"开放但禁止登录发表";}', 13, '显示控制');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(14, 'system', 'SAXUE_CLOSE_INFO', '网站关闭时提示', '网站维护中，请稍后访问......', '', 1, 2, '', 14, '显示控制');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(15, 'system', 'SAXUE_PROXY_DENIED', '是否允许代理访问', '1', '', 1, 9, 'a:2:{i:1;s:3:"是";i:0;s:3:"否";}', 15, '显示控制');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(18, 'system', 'SAXUE_MAX_PAGES', '列表最大页数', '', '0表示不限制页数', 1, 3, '', 18, '显示控制');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(19, 'system', 'SAXUE_ERROR_MODE', 'PHP错误显示模式', '0', '', 1, 7, 'a:3:{i:0;s:15:"不显示错误";i:1;s:15:"仅显示错误";i:2;s:21:"显示错误和提示";}', 19, '显示控制');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(20, 'system', 'SAXUE_DEBUG_MODE', '开启DEBUG模式', '0', '', 1, 9, 'a:2:{i:0;s:3:"否";i:1;s:3:"是";}', 20, '显示控制');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(21, 'system', 'SAXUE_COMPRESS_MODE', '网页压缩模式', '0', '高度压缩对代码规范要求很严格，如果高度压缩状态页面不正常请选择普通压缩', 1, 7, 'a:3:{i:0;s:9:"不压缩";i:1;s:12:"普通压缩";i:2;s:12:"高度压缩";}', 21, '显示控制');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(22, 'system', 'SAXUE_SESSION_EXPRIE', 'session保持时间', '', '单位为“秒”,设成“0”表示用系统默认参数', 1, 3, '', 23, '编译缓存设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(23, 'system', 'SAXUE_SESSION_STORAGE', 'session保存方式', 'file', '', 1, 7, 'a:2:{s:2:"db";s:9:"数据库";s:4:"file";s:6:"文件";}', 24, '编译缓存设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(24, 'system', 'SAXUE_SESSION_SAVEPATH', 'session保存路径', '', '只有在session文件方式保存时有效', 1, 1, '', 25, '编译缓存设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(25, 'system', 'SAXUE_COOKIE_DOMAIN', 'cookie的有效域名', '', '当适用多个子域名时候为了cookie同步，建议这里设置成主域名，如abc.com。留空则使用系统默认值', 1, 1, '', 4, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(26, 'system', 'SAXUE_ENABLE_CACHE', '是否启用缓存', '0', '', 1, 9, 'a:2:{i:1;s:3:"是";i:0;s:3:"否";}', 27, '编译缓存设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(27, 'system', 'SAXUE_CACHE_LIFETIME', '默认缓存时间', '3600', '单位为“秒”', 1, 3, '', 28, '编译缓存设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(28, 'system', 'SAXUE_CACHE_DIR', '网页缓存路径', 'cache', '支持三种写法：1、只填目录名（指网站数据目录下的子目录名），如： cahce ；2、使用完整路径，如： D:/web/cache ；3、使用Memcached，格式为 memcached://服务地址:端口号，如：memcached://127.0.0.1:11211', 1, 1, '支持三种写法：1、只填目录名（指网站跟目录下的子目录名），如： cahce ；2、使用完整路径，如： D:/web/cache ；3、使用Memcached，格式为 memcached://服务地址:端口号，如：memcached://127.0.0.1:11211', 29, '编译缓存设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(29, 'system', 'SAXUE_COMPILED_DIR', '编译文件保存路径', 'compiled', '可使用 dirname 这样的相对路径，或者 /path/dirname 这样的绝对路径', 1, 1, '', 30, '编译缓存设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(30, 'system', 'SAXUE_USE_GZIP', 'GZIP压缩', '0', '压缩输出有利于提高浏览速度', 1, 9, 'a:2:{i:1;s:3:"是";i:0;s:3:"否";}', 31, '编译缓存设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(31, 'system', 'SAXUE_ATTACHS_PATH', '系统附件目录', '', '', 1, 1, '', 32, '附件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(32, 'system', 'SAXUE_ATTACHS_URL', '系统附件访问URL', '', '对应保存目录的url，最后不带斜杠，如果留空则系统自动判断', 1, 1, '', 33, '附件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(33, 'system', 'SAXUE_ATTACHS_FTP', '远程FTP上传附件', '0', '', 1, 9, 'a:2:{i:0;s:6:"关闭";i:1;s:6:"开启";}', 34, '附件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(34, 'system', 'SAXUE_ATTACHS_FTPURL', 'FTP服务器', '', '格式：ftp://username:password@ftp.saxue.com:21', 1, 1, '', 35, '附件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(35, 'system', 'SAXUE_CHECK_ROLE', '开启后台权限检查', '1', '', 1, 9, 'a:2:{i:1;s:3:"是";i:0;s:3:"否";}', 22, '显示控制');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(36, 'system', 'mailtype', '邮件发送方式', '2', '', 0, 7, 'a:4:{i:0;s:21:"不发送任何邮件";i:1;s:49:"通过 PHP 函数及 UNIX sendmail 发送(推荐)";i:2;s:62:"通过 SOCKET 连接 SMTP 服务器发送(支持 ESMTP 验证)";i:3;s:73:"通过 PHP 函数 SMTP 发送 Email(仅 win32 下有效, 不支持 ESMTP)";}', 51, '邮件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(37, 'system', 'maildelimiter', '邮件头的分隔符', '1', '', 0, 7, 'a:2:{i:0;s:25:"使用 LF 作为分隔符";i:1;s:27:"使用 CRLF 作为分隔符";}', 52, '邮件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(38, 'system', 'mailserver', 'SMTP 服务器', 'smtp.qq.com', '如：smtp.saxue.com', 0, 1, '', 53, '邮件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(39, 'system', 'mailport', 'SMTP 端口', '25', '默认不需修改', 0, 3, '', 54, '邮件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(40, 'system', 'mailauth', '是否需要 AUTH LOGIN 验证', '1', '', 0, 9, 'a:2:{i:1;s:3:"是";i:0;s:3:"否";}', 55, '邮件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(41, 'system', 'mailfrom', '发信人地址', '', '如果需要验证,必须为本服务器地址。地址写法可以是 webmaster@saxue.com 或者 SaxueCMS <webmaster@saxue.com>', 0, 1, '', 56, '邮件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(42, 'system', 'mailuser', '验证用户名', '', 'SMTP 邮件服务器用户名(如：webmaster@saxue.com)', 0, 1, '', 57, '邮件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(43, 'system', 'mailpassword', '验证密码', '', 'SMTP 邮件服务器密码', 0, 1, '', 58, '邮件设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(46, 'system', 'SAXUE_LANGUAGE_TYPE', '多语言切换模式', '0', '子域名模式：en.domain.com，更改切换模式后请更新语言设置缓存', 1, 7, 'a:2:{i:0;s:6:"cookie";i:1;s:9:"子域名";}', 4, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(47, 'content', 'maxfilesize', '允许上传最大文件', '200', '单位：K', 0, 4, '', 101, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(49, 'content', 'maxitem', '产品最多允许上传图片数', '3', '', 0, 3, '', 102, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(55, 'content', 'allowmessage', '是否允许留言', '1', '', 0, 7, 'a:2:{i:1;s:6:"允许";i:0;s:6:"禁止";}', 111, '留言配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(52, 'content', 'allowviewmsg', '前台浏览留言', '1', '', 0, 7, 'a:2:{i:1;s:6:"开启";i:0;s:6:"关闭";}', 112, '留言配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(53, 'content', 'msgdispaly', '留言默认状态', '1', '', 0, 7, 'a:2:{i:1;s:6:"显示";i:0;s:6:"隐藏";}', 113, '留言配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(56, 'content', 'minsearchlen', '搜索关键字最少长度', '0', '', 0, 3, '', 121, '搜索配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(57, 'content', 'maxsearchres', '最大搜索结果数', '0', '', 0, 3, '', 122, '搜索配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(58, 'content', 'minsearchtime', '两次搜索间隔时间', '0', '', 0, 3, '', 123, '搜索配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(59, 'content', 'searchcache', '搜索缓存时间', '36000', '秒', 0, 3, '', 124, '搜索配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(60, 'content', 'searchpnum', '默认搜索每页显示', '10', '', 0, 3, '', 125, '搜索配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(61, 'system', 'SAXUE_LICENSE', '授权码', '', '', 1, 2, '', 4, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(62, 'system', 'SAXUE_TEL', '客服电话', '0573-88888888', '', 1, 1, '', 4, '常规设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(63, 'system', 'SAXUE_EMAIL', '客服邮箱', '888888@qq.com', '', 1, 1, '', 4, '常规设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(64, 'system', 'SAXUE_FAX', '传真号码', '0573-88888881', '', 1, 1, '', 4, '常规设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(65, 'system', 'SAXUE_QQ', '客服QQ', '888888', '', 1, 1, '', 4, '常规设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(66, 'system', 'SAXUE_BEIAN', 'ICP备案证书号', 'ICP备案号', '', 1, 1, '', 4, '常规设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(67, 'system', 'SAXUE_TONGJI', '统计代码', '', '', 1, 2, '', 4, '常规设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(68, 'system', 'SAXUE_EXP1', '扩展常量1', '400-8888-888', '常量名：saxue_exp1', 1, 1, '', 4, '常规设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(69, 'system', 'SAXUE_EXP2', '扩展常量2', '', '常量名：saxue_exp1', 1, 1, '', 4, '常规设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(70, 'system', 'SAXUE_EXP3', '扩展常量3', '', '常量名：saxue_exp3', 1, 1, '', 4, '常规设置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(71, 'content', 'news_catid', '新闻主栏目ID', '2', '同一模块可应用于多个不同类型栏目，为了方便模版调用，建议填写对应模块主要栏目ID，也可以直接在模版写栏目ID，下同', 0, 3, '', 103, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(72, 'content', 'product_catid', '产品主栏目ID', '3', '', 0, 3, '', 104, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(73, 'content', 'job_catid', '招聘主栏目ID', '20', '', 0, 3, '', 105, '基本配置');
INSERT INTO `saxue_system_configs` (`cid`, `gname`, `cname`, `ctitle`, `cvalue`, `cdescription`, `cdefine`, `ctype`, `options`, `catorder`, `catname`) VALUES(74, 'content', 'feedback_catid', '留言主栏目ID', '37', '', 0, 3, '', 106, '基本配置');

DROP TABLE IF EXISTS `saxue_system_language`;
CREATE TABLE IF NOT EXISTS `saxue_system_language` (
  `id` tinyint(2) unsigned NOT NULL auto_increment COMMENT '编号',
  `name` varchar(20) NOT NULL default '' COMMENT '显示名称',
  `lang` varchar(5) NOT NULL default '' COMMENT '英文标识',
  `sitename` varchar(100) NOT NULL default '' COMMENT '网站名称',
  `display` tinyint(1) unsigned NOT NULL default '1' COMMENT '是否显示',
  `issystem` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否系统语言',
  `isdefault` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否默认语言',
  `listorder` tinyint(2) unsigned NOT NULL default '0' COMMENT '排序',
  `theme` varchar(20) NOT NULL default '' COMMENT '模版目录',
  `skin` varchar(20) NOT NULL default '' COMMENT '风格目录',
  `seo` text NOT NULL COMMENT 'SEO设置',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `lang` (`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO `saxue_system_language` (`id`, `name`, `lang`, `sitename`, `display`, `issystem`, `isdefault`, `listorder`, `theme`, `skin`, `seo`) VALUES(1, '简体中文', 'zh', 'SaxuePower', 1, 1, 1, 1, 'zh', 'zh', 'a:3:{s:10:"meta_title";s:33:"多语言企业网站管理系统";s:13:"meta_keywords";s:33:"多语言企业网站管理系统";s:16:"meta_description";s:33:"多语言企业网站管理系统";}');
INSERT INTO `saxue_system_language` (`id`, `name`, `lang`, `sitename`, `display`, `issystem`, `isdefault`, `listorder`, `theme`, `skin`, `seo`) VALUES(2, 'ENGLISH', 'en', 'SaxuePower', 1, 0, 0, 2, 'en', 'en', 'a:3:{s:10:"meta_title";s:51:"Multi language enterprise website management system";s:13:"meta_keywords";s:51:"Multi language enterprise website management system";s:16:"meta_description";s:51:"Multi language enterprise website management system";}');

DROP TABLE IF EXISTS `saxue_system_roles`;
CREATE TABLE IF NOT EXISTS `saxue_system_roles` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `rolename` varchar(30) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL default '1',
  `note` varchar(200) NOT NULL,
  `power` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_system_session`;
CREATE TABLE IF NOT EXISTS `saxue_system_session` (
  `sess_id` varchar(32) NOT NULL default '',
  `sess_updated` int(11) unsigned NOT NULL default '0',
  `sess_data` text NOT NULL,
  PRIMARY KEY  (`sess_id`),
  KEY `sess_updated` (`sess_updated`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `saxue_urlrule`;
CREATE TABLE IF NOT EXISTS `saxue_urlrule` (
  `id` smallint(4) unsigned NOT NULL auto_increment COMMENT '编号',
  `modid` smallint(4) unsigned NOT NULL default '0' COMMENT '模块ID',
  `name` varchar(20) NOT NULL default '' COMMENT '规则名称',
  `type` varchar(10) NOT NULL default '' COMMENT '类型，show内容页，list列表页',
  `urlrule` varchar(255) NOT NULL default '' COMMENT 'URL规则',
  `example` varchar(255) NOT NULL default '' COMMENT 'URL示例',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

INSERT INTO `saxue_urlrule` (`id`, `modid`, `name`, `type`, `urlrule`, `example`) VALUES(1, 0, '动态URL', 'list', 'content.php?catid=<{$catid}>&page=<{$page}>|content.php?catid=<{$catid}>', 'content.php?catid=1&page=1');
INSERT INTO `saxue_urlrule` (`id`, `modid`, `name`, `type`, `urlrule`, `example`) VALUES(2, 0, '伪静态', 'list', '<{$catdir}>/<{$page}>/|<{$catdir}>/', 'news/1/');
INSERT INTO `saxue_urlrule` (`id`, `modid`, `name`, `type`, `urlrule`, `example`) VALUES(3, 0, '伪静态带父目录', 'list', '<{$parentdir}><{$catdir}>/<{$page}>/|<{$parentdir}><{$catdir}>/', 'news/company/1/');
INSERT INTO `saxue_urlrule` (`id`, `modid`, `name`, `type`, `urlrule`, `example`) VALUES(4, 0, '动态URL', 'show', 'content.php?catid=<{$catid}>&id=<{$id}>', 'content.php?catid=1&id=1');
INSERT INTO `saxue_urlrule` (`id`, `modid`, `name`, `type`, `urlrule`, `example`) VALUES(5, 0, '伪静态', 'show', '<{$catdir}>/<{$id}>.html', 'news/1.html');
INSERT INTO `saxue_urlrule` (`id`, `modid`, `name`, `type`, `urlrule`, `example`) VALUES(6, 0, '伪静态带父目录', 'show', '<{$parentdir}><{$catdir}>/<{$id}>.html', 'news/company/1.html');
INSERT INTO `saxue_urlrule` (`id`, `modid`, `name`, `type`, `urlrule`, `example`) VALUES(7, 1, '动态URL', 'show', 'content.php?catid=<{$catid}>', 'content.php?catid=1');
INSERT INTO `saxue_urlrule` (`id`, `modid`, `name`, `type`, `urlrule`, `example`) VALUES(8, 1, '伪静态', 'show', '<{$catdir}>.html', 'about.html');
INSERT INTO `saxue_urlrule` (`id`, `modid`, `name`, `type`, `urlrule`, `example`) VALUES(9, 1, '伪静态带父目录', 'show', '<{$parentdir}><{$catdir}>.html', 'about/page.html');

DROP TABLE IF EXISTS `saxue_plugin`;
CREATE TABLE IF NOT EXISTS `saxue_plugin` (
  `pluginid` smallint(6) unsigned NOT NULL auto_increment,
  `status` tinyint(1) unsigned NOT NULL default '0',
  `name` varchar(20) NOT NULL default '',
  `identifier` varchar(20) NOT NULL default '',
  `intro` varchar(255) NOT NULL default '',
  `dir` varchar(20) NOT NULL default '',
  `author` varchar(20) NOT NULL default '',
  `version` varchar(5) NOT NULL default '',
  `releases` int(8) unsigned NOT NULL default '0',
  `menu` text NOT NULL,
  PRIMARY KEY  (`pluginid`),
  UNIQUE KEY `identifier` (`identifier`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;