<?php
/*
 * 引用自dede
 */
/**
 * 获得文章body里的外部资源
 *
 * @access    public
 * @param     string  $body  文档内容
 * @return    string
 */
function GetCurContent($body) {
    global $k_weburl, $k_upload, $second_dir;
    $cfg_uploaddir = $cfg_image_dir;
    $body = stripslashes($body);
    $htd = new DedeHttpDown();
    $basehost = "http://" . $_SERVER["HTTP_HOST"];
    $img_array = array();
    preg_match_all("/src=[\"|'|\s]{0,}(http:\/\/([^>]*)\.(gif|jpg|png))/isU", $body, $img_array);
    $img_array = array_unique($img_array[1]);
    $imgUrl = $k_upload . date("Ym", time());
    $imgPath = KKROOT.$second_dir . $imgUrl;
    if (!is_dir($imgPath . '/')) {
        create_folder($imgPath);
    }
    foreach ($img_array as $key => $value) {
        if (preg_match("#" . $k_weburl . "#i", $value)) {
            continue;
        }
        $value = str_replace(array('"', '\''), '', $value);
        if (!preg_match("#^http:\/\/#i", $value)) {
            continue;
        }
        $htd->OpenUrl($value);
        $itype = $htd->GetHead("content-type");
        $itype = substr($value, -4, 4);
        if (!preg_match("#\.(jpg|gif|png)#i", $itype)) {
            if ($itype == 'image/gif') {
                $itype = ".gif";
            } else if ($itype == 'image/png') {
                $itype = ".png";
            } else {
                $itype = '.jpg';
            }
        }
        $rndname = date("YmdHis") . rand(100, 999);
        $tmp_name = $imgPath . '/' . $rndname . $itype;
        $new_name = $imgUrl . '/' . $rndname . $itype;
        $value = trim($value);
        $rs = $htd->SaveToBin( $tmp_name);
        if ($rs) {
            $info = '';
            $imginfos = GetImageSize( $tmp_name);
            $fsize = filesize( $tmp_name);
            $img=new image();
            $img->insert(str_replace('.','', $itype), $new_name, $imginfos[0], $imginfos[1], $fsize);
            $body = str_replace($value, $new_name, $body);
        }
    }
    $htd->Close();
    return $body;
}

/**
 *  取第一个图片为缩略图
 *
 * @access    public
 * @param     string  $body  文档内容
 * @return    string
 */
function GetDDImgFromBody($body) {
    $litpic = '';
    // echo stripslashes($body);
    preg_match_all("/(src)=[\"|'| ]{0,}([^>]*\.(gif|jpg|bmp|png))/isU", stripslashes($body), $img_array);
    $img_array = array_unique($img_array[2]);
    if (count($img_array) > 0) {
        $picname = preg_replace("/[\"|'| ]{1,}/", '', $img_array[0]);
        $picname = str_replace(array('"', '\''), '', $picname);
        if (preg_match("#_lit\.#", $picname)) {
            $litpic = $picname;
        } else {
            $litpic = GetDDImage('ddfirst', $picname, 1);
        }
    }
    return $litpic;
}

/**
 *  获得缩略图
 *
 * @access    public
 * @param     string  $litpic  缩略图
 * @param     string  $picname  图片名称
 * @param     string  $isremote  是否远程
 * @return    string
 */
function GetDDImage($litpic, $picname, $isremote) {
    global $k_upload, $k_img_w, $k_img_h, $second_dir;
    $ntime = time();
    if (($litpic != 'none' || $litpic != 'ddfirst') &&
     !empty($_FILES[$litpic]['tmp_name']) && is_uploaded_file($_FILES[$litpic]['tmp_name'])) {
        //如果用户自行上传缩略图
        $istype = 0;
        $sparr = Array("image/pjpeg", "image/jpeg", "image/gif", "image/png");
        $_FILES[$litpic]['type'] = strtolower(trim($_FILES[$litpic]['type']));
        if (!in_array($_FILES[$litpic]['type'], $sparr)) {
            ShowMsg("上传的图片格式错误，请使用JPEG、GIF、PNG格式的其中一种！", "-1");
            exit();
        }
        $savepath = $k_upload . '/' . date('Ym');
        $new_file = $savepath . '/sk';
        CreateDir($savepath);
        $name = date("YmdHis") . rand(100, 999);
        $fullUrl = $savepath . '/' . $name;

        if (strtolower($_FILES[$litpic]['type']) == "image/gif") {
            $fullUrl = $fullUrl . ".gif";
        } else if (strtolower($_FILES[$litpic]['type']) == "image/png") {
            $fullUrl = $fullUrl . ".png";
        } else {
            $fullUrl = $fullUrl . ".jpg";
        }

        @move_uploaded_file($_FILES[$litpic]['tmp_name'], KKROOT . $second_dir . $fullUrl);
        $litpic = $fullUrl;
        $image = new image();
        $image->ImageResizeNew(KKROOT . $second_dir . $new_file . $name, $_FILES[$litpic]['tmp_name'], $_FILES[$litpic]['type'], $k_img_w, $k_img_h);
        return $litpic;
    } else {
        $picname = trim($picname);
        if ($isremote == 1 && preg_match("#^http:\/\/#i", $picname)) {
            $litpic = $picname;
            $ddinfos = GetRemoteImage($litpic);
            if (!is_array($ddinfos)) {
                $litpic = '';
            } else {
                $the_date = date('Ym');
                $litpic = str_replace($the_date . '/', $the_date . '/sk/', $ddinfos[0]);
                $new_file = KKROOT . $second_dir . $litpic;
                $image = new image();
                $image->ImageResizeNew($new_file, KKROOT . $ddinfos[0], $ddinfos[3], $k_img_w, $k_img_h);
            }
        } else {
            if ($litpic == 'ddfirst' && !preg_match("#^http:\/\/#i", $picname)) {
                $new_file=$k_upload.date('Ym').'/sk/'.date("YmdHis") . rand(100, 999);
                $hc=  substr($picname, -4);
                $new_file.=$hc;
                $image = new image();
                $image->ImageResizeNew(KKROOT.$second_dir.$new_file, KKROOT .$second_dir. $picname, $hc, $k_img_w, $k_img_h);
                return $new_file;
            }
            else {
                $litpic = $picname;
                return $litpic;
            }
        }
    }
    if ($litpic == 'litpic' || $litpic == 'ddfirst') $litpic = '';
    return $litpic;
}

/**
 * 获取一个远程图片
 *
 * @access    public
 * @param     string  $url  地址
 * @param     int  $uid  用户id
 * @return    array
 */
function GetRemoteImage($url) {
    global $k_upload;
    $revalues = Array();
    $ok = false;
    $htd = new DedeHttpDown();
    $htd->OpenUrl($url);
    $sparr = Array("image/pjpeg", "image/jpeg", "image/gif", "image/png", "image/xpng", "image/wbmp");
    if (!in_array($htd->GetHead("content-type"), $sparr)) {
        return '';
    } else {
        $imgUrl = $k_upload . date('Ym', time());
        $imgPath = KKROOT . $k_upload . date('Ym', time());
        create_folder($imgUrl);
        $itype = $htd->GetHead("content-type");

        if ($itype == "image/gif") {
            $itype = '.gif';
        } else if ($itype == "image/png") {
            $itype = '.png';
        } else if ($itype == "image/wbmp") {
            $itype = '.bmp';
        } else {
            $itype = '.jpg';
        }
        $rndname = date("YmdHis") . rand(100, 999);
        $rndtrueName = $imgPath . '/' . $rndname . $itype;
        $fileurl = $imgUrl . '/' . $rndname . $itype;
        $ok = $htd->SaveToBin($rndtrueName);
        if ($ok) {
            $data = GetImageSize($rndtrueName);
            $revalues[0] = $fileurl;
            $revalues[1] = $data[0];
            $revalues[2] = $data[1];
            $revalues[3] = $itype;
        }
    }
    $htd->Close();
    return ($ok ? $revalues : '');
}
