<?php
/* ===========================
 * * 文章类
 * @ by 子不语 爱不语CMS
 * @ QQ:76992327
 * @ Create:2014.04.6
 * @ Modify:2014.10.09
  ============================ */
if (!defined('KKINC')) exit('Request Error!');
class article extends parse {

    public $total = 0;
    private $aid = 0;
    private $tid = 0;

    function str_array($str) {
        $arr = parent::str_array($str);
        if ($arr['tid']) {
            $arr['where'] .= ' and `typeid`=' . $arr['tid'];
        } else if ($arr['in']) {
            $sonid = $this->get_arctype_son_sql($arr['in']);
            $arr['where'].=' and typeid  in (' . $sonid . ')';
        }
        if ($arr['notin']) {
            $sonid = $this->get_arctype_son_sql($arr['in']);
            $arr['where'].=' and typeid not in (' . $sonid . ')';
        }
        if ($arr['id']) {
            $arr['where'].=' and `id`=' . $arr['id'];
        }
        if ($arr['flag']) {
            $flags = explode(',', $arr['flag']);
            for ($i = 0; isset($flags[$i]); $i++)
                $arr['where'].= " and FIND_IN_SET('$flags[$i]',flag)>0 ";
        }
        if ($arr['shorttitle']) {
            $arr['where'].=' and `seo`=\'' . $arr['shorttitle'] . '\'';
        }
        if (!$arr['ischeck'] == 'all') {
            $arr['where'].=' and ischeck=1';
            unset($arr['ischeck']);
        }
        if ($arr['q']) {
            $arr['where'].=" and title like '%" . $arr['q'] . "%'";
            unset($arr['q']);
        }
        if (!$arr['orderby']) {
            $arr['orderby'] = 'id desc';
        }
        return $arr;
    }

    /* =========================
     * 获取文章
     * $arr  array
     * return array 
      ========================= */
    function get_list($str, $ssql = '') {
        $result = array();
        $arr = $this->str_array($str);
        if ($ssql) {
            $dsql = ' and ' . $ssql;
        }
        $sql = 'select id,typeid,title,click,startdate,litpic' . $arr['field'] . ' from `__article` ' . $arr['where'] . $dsql . ' order by ' . $arr['orderby'] . $arr['num'];
        $query = db::_query($sql);
        while ($row = db::_object($query)) {
            if ($arr['len']) {
                $row->fulltitle = $row->title;
                $row->title = cn_substr($row->title, $arr['len']);
            }
            if ($arr['deslen']) {
                $row->description = cn_substr(strip_tags($row->description), $arr['deslen']);
            }
            if ($row->keywords) {
                $row->keywords = stripslashes($row->keywords);
            }
            if ($row->description) {
                $row->description = stripslashes($row->description);
            }
            if ($row->con) {
                $row->con = strip_tags(stripslashes($row->con));
                if ($arr['deslen']) {
                    $row->con = cn_substr($row->con, $arr['deslen']);
                }
            }
            $row->arcurl = $this->get_url($row->id, $row->typeid, $row->startdate);
            $row->typename = $this->get_typename($row->typeid);
            $row->litpic = $this->replace_pic($row->litpic);
            $row->typeurl = $this->get_typeurl($row->typeid);
            $result[] = $row;
        }
        if ($arr['pg']) {
            $total = db::get_one('select count(*) from `__article` ' . $where . '', 'row');
            $this->total = $total[0];
        }
        return $result;
    }

    function get_total($str) {
        $arr = $this->str_array($str);
        $total = db::get_one('select count(*) from `__article` ' . $arr['where'] . '', 'row');
        return $this->total = $total[0];
    }

    /* =========================
     * 获取一篇文章的详细信息
     *   @param $id int  文章id
     *   return array
      ========================= */
    function get_one($aid) {
        $result = db::get_one('select a.*,t.typename from `__article` a left join `__arctype` t on a.typeid=t.id  where a.`id`=' . $aid);
        $result->arcurl = $this->get_url($result->id, $result->typeid, $result->startdate);
        $result->typeurl = $this->get_typeurl($result->typeid);        
        $result->litpic = $this->replace_pic($result->litpic);
        $result->pic = str_replace('sk/','',$result->litpic);
        $result->con = stripslashes($result->con);
        $this->set_aid($result->id);
        $this->set_tid($result->typeid);
        return $result;
    }

    function set_aid($id) {
        $this->aid = $id;
    }

    function set_tid($id) {
        $this->tid = $id;
    }

    /* =========================
     * 调用栏目URL
     *   @param $tid int  栏目tid
     *   return array
      ========================= */
    private function get_typeurl($tid) {
        $art = new arctype();
        return $art->get_url($tid);
    }

    /* =========================
     *  调用URL
     *  @param $id 文章ID
     *  @param $tid 栏目ID
     *  @param $time 添加时间
     *  @param $page 页数
     *  return string
      ========================= */
    function get_url($id, $tid, $time = 0, $page = 0) {
        global $k_weburl, $k_static, $base;
        $arctype = $base->get_arctype($tid);
        if ($k_static && $arctype['viewrule']) {
            $url = str_replace(array('{sitepath}', '{tid}', '{y}', '{m}', '{d}', '{aid}', '{page}'), array($k_weburl, $tid, date('Y', $time), date('m', $time), date('d', $time), $id, $page), strtolower($arctype['viewrule']));
            return $url;
        }
        return $k_weburl . 'view.php?aid=' . $id;
    }

    /* =========================
     * @获取导航
     * @return string
      ========================= */
    function get_position() {
        global $k_weburl;
        $l = $this->get_arctype($this->tid);
        $result = '&gt;<a href="' . $this->get_typeurl($l['id']) . '">' . $l['typename'] . '</a>';
        while (true) {
            if ($l['fid'] > 0) {
                $l = $this->get_arctype($l['fid']);
                $result = '&gt;<a href="' . $this->get_typeurl($l['id']) . '">' . $l['typename'] . '</a>' . $result;
            } else {
                break;
            }
        }
        return '<a href="' . $k_weburl . '">首页</a>' . $result;
    }

    /* =========================
     * @获取前一篇文章链接
     * @return string
      ========================= */
    function get_prev() {
        $row = db::get_one('select `id`,`title`,`typeid` from `__article` where `typeid`=' . $this->tid . ' and `id`<' . $this->aid . ' order by id desc limit 1');
        if ($row->id) {
            $row = ' <a href="' . $this->get_url($row->id, $row->typeid, $row->startdate) . '">' . $row->title . '</a>';
        } else {
            $row = ' 暂没有下篇';
        }
        return $row;
    }

    /* =========================
     * @获取后一篇文章链接
     * @return string
      ========================= */
    function get_next() {
        $row = db::get_one('select `id`,`title` from `__article` where `typeid`=' . $this->tid . ' and `id`>' . $this->aid . ' order by id asc limit 1');
        if ($row->id) {
            $row = ' <a href="' . $this->get_url($row->id, $row->typeid, $row->startdate) . '">' . $row->title . '</a>';
        } else {
            $row = ' 暂没有下篇';
        }
        return $row;
    }

    /* ===================
     * 循环获取子栏目id供sql      
     * @ id int 文章id
     * @ show int 数目
     * @ int //判断是否循环获取
      =================== */
    function get_list_like($str) {
        global $base;
        $arr = $this->str_array($str);
        if ($arr['show'] > 0 and $arr['aid'] > 0) {
            $sql = 'SELECT arc.id,arc.title,arc.shorttitle,arc.litpic,arc.typeid,arc.startdate FROM `__taglist` t LEFT JOIN `__taglist` a ON t.tagid=a.`tagid` LEFT JOIN `__article` arc ON t.`aid`=arc.`id` WHERE a.aid=' . $arr['aid'] . ' GROUP BY t.aid limit ' . $arr['show'];
            $res = db::_query($sql);
            while ($row = db::get_all($res)) {
                $get_typename = $base->get_arctype($row->typeid);
                $row->typename = $get_typename['typename'];
                $row->typeurl = $this->get_typeurl($row->typeid);
                $row->litpic = $this->replace_pic($row->litpic);
                $row->arcurl = $this->get_url($row->id, $row->typeid, $row->startdate);
                $result[] = $row;
            }
            return $result;
        }
    }

}