<?php
/* ===========================
 * * 图片操作类
 * @ by 子不语 爱不语CMS
 * @ QQ:76992327
 * @ Create:2013.10.11
  ============================ */
if (!defined('KKINC')) exit('Request Error!');
class image {
    /* =========================
     *  生成缩略图
     * @param    imagecreatefrompng
     * @param    图宽
     * @param    图高
     * @param 文件名
     *  return string
      ========================= */
    function ResizeImage($im, $maxwidth, $maxheight, $name) {
        $width = imagesx($im);
        $height = imagesy($im);
        if (($maxwidth && $width > $maxwidth) || ($maxheight && $height > $maxheight)) {
            if ($maxwidth && $width > $maxwidth) {
                $widthratio = $maxwidth / $width;
                $RESIZEWIDTH = true;
            }
            if ($maxheight && $height > $maxheight) {
                $heightratio = $maxheight / $height;
                $RESIZEHEIGHT = true;
            }
            if ($RESIZEWIDTH && $RESIZEHEIGHT) {
                if ($widthratio < $heightratio) {
                    $ratio = $widthratio;
                } else {
                    $ratio = $heightratio;
                }
            } elseif ($RESIZEWIDTH) {
                $ratio = $widthratio;
            } elseif ($RESIZEHEIGHT) {
                $ratio = $heightratio;
            }
            $newwidth = $width * $ratio;
            $newheight = $height * $ratio;
            if (function_exists("imagecopyresampled")) {

                $newim = imagecreatetruecolor($newwidth, $newheight);
                imagecopyresampled($newim, $im, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
            } else {
                $newim = imagecreate($newwidth, $newheight);
                imagecopyresized($newim, $im, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
            }
            ImageJpeg($newim, $name);
            ImageDestroy($newim);
        } else {
            ImageJpeg($im, $name);
            ImageDestroy($newim);
        }
    }

    function imagecreat($file_type, $old_name) {
        $image=array();
        switch ($file_type) {
            case "image/x-png":
            case "image/png":
            case '.png':
                $image[0] = imagecreatefrompng($old_name);
                $image[1]='png';
                break;
            case '.gif':
            case "image/gif":
                $image[0] = imagecreatefromgif($old_name);
                $image[1]='gif';
                break;
            case '.bmp':
                $image = imagecreatefromwbmp($old_name);
            case "image/pjpeg":
            case "image/jpg":
            case "image/jpeg":
            case '.jpg':
            default :
                $image[0] = imagecreatefromjpeg($old_name);
                $image[1]='jpg';
                break;
        }
        return $image;
    }

    function ImageResizeNew($new_file, $old_file, $file_type, $w, $h,$file_size=0) {
        global $second_dir;
        $images = $this->imagecreat($file_type, $old_file);
        if ($images[0]) {
            $this->ResizeImage($images[0], $w, $h, $new_file);
        }
        $wh=getimagesize($new_file);
        $this->destroy($images);
        if(!$file_size)$file_size=filesize($new_file);
        $this->insert($images[1],  str_replace(KKROOT.$second_dir, '', $new_file),$wh[0],$wh[1],$file_size);
    }

    function destroy($image) {
        imagedestroy($image);
    }

    function insert($file_ext,$save_url,$image_w,$image_h,$file_size) {
        $arr_sql = array('mediatype' => $file_ext, 'url' => $save_url, 'width' => $image_w, 'height' => $image_h, 'filesize' => $file_size, 'intime' => time());
        db::_insert('uploads', $arr_sql);
    }

}