<?php
/* ===========================
 * * 模板类
 * @ by 子不语 爱不语CMS
 * @ QQ:76992327
 * @ Create:2013.04.20
  ============================ */
if (!defined('KKINC')) exit('Request Error!');
final class template {

    public $templatePath = '';
    public $fileName = '';
    public $compiledPath = '';
    public $cacheCompiled = false;
    public $var = array();
    private $compiledName = '';

    function __construct($templatePath = '', $compiledPath = '') {
        global $k_tpl, $k_tplcache;
        $this->templatePath = $templatePath ? $templatePath : TPL . $k_tpl . DIRECTORY_SEPARATOR;
        $this->compiledPath = $compiledPath ? $compiledPath : KKROOT . '/data/compiled/f/';
        $this->cacheCompiled = $k_tplcache;
    }

    function get_compiled_name($filename) {
        // $this->compiledName = $this->compiledPath .  $this->get_filename($filename).'.php' ;
        return $this->compiledPath . $this->get_filename($filename);
    }

    function fetch($filename) {
        $tplFileName = $this->templatePath . $filename;
        if (!$filename || !$this->is_filename($tplFileName)) exit('找不到模板文件: ' . $tplFileName);

        $compiledName = $this->get_compiled_name($filename);
        if ($this->cacheCompiled || !$this->is_filename($compiledName)) {
            $tpl = $this->parse(read_file($tplFileName));
            writer_file($compiledName, $tpl);
        }
    }

    /**
     * 判断模板文件是否存在
     * @param type $filename
     */
    function is_filename($filename) {
        if (file_exists($filename)) return true;
        return false;
    }

    /**
     * 得到无后戳名的文件名称
     * @param type $filename
     * @return type
     */
    function get_filename($filename) {
        $array = explode('.', $filename);
        return $array[0] . '.php';
    }

    /*
     * 解析函数
     */
    function parse($tpl) {
        $tpl = preg_replace_callback('#{tpl\s+(.+)}#', array($this, 'replace_include'), $tpl);
        $tpl = preg_replace_callback('#{if\s+(.+?)}#', array($this, 'replace_if'), $tpl);
        $tpl = preg_replace_callback('#{elseif\s+(.+?)}#', array($this, 'replace_elseif'), $tpl);
        $tpl = preg_replace_callback('#{function=(.*?)}#', array($this, 'replace_function'), $tpl);
        $tpl = preg_replace_callback('#{v(.*?)/}#', array($this, 'replace_v'), $tpl);
        $tpl = preg_replace_callback('#\{arclist([^}]*)\}#', array($this, 'replace_arc'), $tpl);
        $tpl = preg_replace_callback('#\{list\s+([^}]*)\}#', array($this, 'replace_list'), $tpl);
        $tpl = preg_replace_callback('#\{arctype([^}]*)\}#', array($this, 'replace_art'), $tpl);
        $tpl = preg_replace_callback('#\{sql([^}]*)\}#', array($this, 'replace_sql'), $tpl);
        $tpl = preg_replace_callback('#{ad\s+([^}]*)}#', array($this, 'replace_ad'), $tpl);
        $tpl = preg_replace_callback('#{likearc\s+([^}]*)}#', array($this, 'replace_likearc'), $tpl);
        $tpl = preg_replace_callback('#\{\$([^}].*?)\}#', array($this, 'replace_var'), $tpl);
        $patterns = array(
        '/\{else\}/',
        '/\{\/if\}/',
        '/\{loop\s+(\S+)\s+(\S+)\}/',
        '/\{loop\s+(\S+)\s+(\S+)\s+(\S+)\}/',
        '/\{\/loop\}/',
        '/\{(\\$[a-zA-Z].*?)\.(a-zA-Z0-9]*)\}/',
        '/\{(\\$[a-zA-Z\-\>\x7f-\xff][a-zA-Z0-9\_\-\>\[\]\x7f-\xff]*)\}/U',
        '#{(\$\w[^}]*)}#',
        '/\{php\s+(.+)\}/',
        '#{/arctype}#',
        '#{/arclist}#',
        '#{/list}#',
        '#{pagelist\s+([^}]*)}#'
        );
        $replacements = array(
        '<?php } else { ?>',
        '<?php } ?>',
        '<?php if(is_array(\\1))  foreach(\\1 as \\2) { ?>',
        '<?php if(is_array(\\1)) foreach(\\1 as \\2 => \\3) { ?>',
        '<?php } ?>',
        '<?php echo \\1->\\2;?>',
        '<?php echo \\1;?>',
        '<?php echo \\1;?>',
        '<?php \\1?>',
        '<?php } ?>',
        '<?php } ?>',
        '<?php } ?>',
        '<?php $p=new page(); echo $p->pagelist("page=$page&total=$total&\\1"); ?>'
        );
        return preg_replace($patterns, $replacements, $tpl);
    }

    private function replace_var($str) {
        return str_replace('.', '->', '<?php echo $' . $str[1] . ';?>');
    }

    private function replace_list($str) {
        $arr = array();
        parse_str($str[1], $arr);
        if ($arr['return']) {
            return '<?php $l=new article(); $' . $arr['return'] . '=$l->get_list("pg=$page&in=$tid&' . $str[1] . '"); $total=$l->total;?>';
        }
        return '<?php $l=new article(); $c=$l->get_list("pg=$page&in=$tid&' . $str[1] . '"); $total=$l->total; ?>';
    }

    function replace_include($matches) {
        $this->fetch($matches[1]);
        $name = $this->get_filename($matches[1]);
        return "\n<?php include ('$name'); ?>\n";
    }

    function replace_if($matches) {
        $matches = str_replace('.', '->', $matches[1]);
        return '<?php if(' . $matches . ') { ?>';
    }

    function replace_elseif($matches) {
        $matches = str_replace('.', '->', $matches[1]);
        return '<?php }elseif(' . $matches . ') { ?>';
    }

    function replace_function($matches) {
        $matches = str_replace('.', '->', $matches[1]);
        return '<?php echo ' . $matches . ' ?>';
    }

    function replace_v($matches) {
        $matches = str_replace('.', '->', $matches[1]);
        $matches = str_replace('+', '.', $matches);
        return '<?php ' . $matches . ' ?>';
    }

    private function replace_arc($str) {
        $arr = array();
        parse_str($str[1], $arr);
        if ($arr['return']) {
            return '<?php $l=new article(); $' . $arr['return'] . '=$l->get_list("' . $str[1] . '"); ?>';
        }
        return '<?php $l=new article(); $c=$l->get_list("' . $str[1] . '");?>';
    }

    private function replace_likearc($str) {
        $arr = array();
        parse_str($str[1], $arr);
        if ($arr['return']) {
            return '<?php $l=new article(); $' . $arr['return'] . '=$l->get_list_like("' . $str[1] . '"); ?>';
        }
        return '<?php $l=new article(); $c=$l->get_list_like("' . $str[1] . '");?>';
    }

    private function replace_art($str) {
        $arr = array();
        parse_str($str[1], $arr);
        if ($arr['return']) {
            $return = $arr['return'];
        } else {
            $return = 't';
        }
        if ($arr['id'] > 0) {
            return '<?php $l=new arctype();  $' . $return . '=$l->get_one("' . $arr['id'] . '"); ?>';
        }
        return '<?php $l=new arctype(); $' . $return . '=$l->get_list("' . $str[1] . '"); ?>';
    }

    private function replace_pagelist($str) {
        $arr = array();
        return '<?php $p=new page(); echo $p->pagelist("page=$page&total=$total&' . $str . '"); ?>';
    }

    private function replace_sql($str) {
        $arr = array();
        parse_str($str[1], $arr);
        if (!$arr['sql']) return;
        if ($arr['return']) {
            $return = $arr['return'];
        } else {
            $return = 'oj';
        }
        if ($arr['num'] == 1) {
            return '<?php $' . $return . '=db::get_one("' . $arr['sql'] . '");  ?>';
        }
        return '<?php $kres=db::_query("' . $arr['sql'] . '"); $' . $return . '=array(); while($c=db::get_all($kres)){ $' . $return . '[]=$c;} ?>';
    }

    private function replace_ad($str) {
        $arr = array();
        parse_str($str[1], $arr);
        if ($arr['return']) {
            $return = $arr['return'];
        } else {
            $return = 'ad';
        }
        if ($arr['show'] > 0) {
            return '<?php $ads=new ad();  $' . $return . '=$ads->get_list_ad("' . $str[1] . '");?>';
        } elseif (!$arr['type']) {
            return '<?php $ads=new ad();  $' . $return . '=$ads->get_ad("' . $str[1] . '");?>';
        } else {
            return '<?php $ads=new ad(); echo $ads->get_ad("' . $str[1] . '");?>';
        }
    }

    function assign($name, $value) {
        $this->var[$name] = $value;
    }

    function compiled($compiledName) {
        extract($this->var);
        include $compiledName;
    }

    function display($filename) {
        $this->fetch($filename);
        $this->compiled($this->get_compiled_name($filename));
    }

    function save_html($file_name, $file_url) {
        $this->fetch($file_name);
        ob_start();
        $this->compiled($this->get_compiled_name($file_name));
        $con = ob_get_contents();
        writer_file($file_url, $con);
        ob_end_clean();
    }

}