<?php

class Admin extends Base {
	protected $field;
	protected $tree;

	public function __construct() {
		parent::__construct();
		$this->isAdminLogin();
		$this->field = xiaocms::load_class('field');
		$this->tree =  xiaocms::load_class('tree');
	}

    protected function isAdminLogin() {
        if (xiaocms::get_controller_id() == 'login') return false;
        if ($username = $this->session->get('user_id')) {
		    if ($username) return false;
        }
        $this->redirect(url('login'));
    }

    protected function admin_tpl($file) {
        return  XIAOCMS_ADMIN . DIRECTORY_SEPARATOR . 'template' . DIRECTORY_SEPARATOR . $file.'.tpl.php';
    }
	
}