<?php

class install extends Base{
	public function __construct() {
		if (!is_writable(DATA_DIR)) {
		    exit('data 目录没有写入权限，无法进行安装！');
		}
		if (file_exists(DATA_DIR . 'install.lock')) {
		    exit('《XiaoCms网站管理系统》安装程序已锁定。如果要重新安装，请删除<b>/data/install.lock</b>文件！');
        }
	}
	
	public function indexAction() {
	 include $this->install_tpl('1'); 
	}
	
	public function step2Action() {
		if (PHP_VERSION < '5.2.0') {
             $error = 'PHP版本低于5.2，无法进行安装！';
		}
		if (!function_exists("session_start")) {
             $error = '系统不支持session，无法进行安装！';
		}
		if (!extension_loaded('PDO')) {
             $error = '不支持PDO，无法进行安装！';
		}
		if (!extension_loaded('Pdo_SQLite')) {
             $error = '没有开启sqlite pdo扩展，无法进行安装！';
		}
		if (!function_exists('imagejpeg') || !function_exists('imagegif') || !function_exists('imagepng')) {
             $error = '不支持GD库，无法进行安装！';
		}
		if (!function_exists('json_decode')) {
             $error = '不支持JSON，无法进行安装！';
		}
		include $this->install_tpl('2');
	}
	
	public function step3Action() {
		function dexit($msg) {
                	echo '<script>alert("' . $msg . '");window.history.back();</script>';
					exit;
		}
		
		extract($this->post('data'));
		if (!preg_match('/^[a-z0-9]+$/i', $admin_pass) || strlen($admin_pass) < 5) dexit('请填写正确的后台帐号'. $admin_pass);
		if (strlen($admin_pass) < 5) dexit('后台密码最少5位');
		$dbconfig = array(
							'dbname'	=>	$dbname,
							'prefix'	=>	'xiao_',
							'charset'	=>	'utf8',
		);
		$adminconfig = array(
							'admin_name'	=>	$admin_name,
							'admin_pass'	=>	md5(md5($admin_pass)),
		);
		$dbconfig_arr = var_export($dbconfig,true);
		$adminconfig_arr = var_export($adminconfig,true);
				
		$dbconfig_txt = "<?php" . PHP_EOL . "if (!defined('IN_XIAOCMS')) exit();" . PHP_EOL . "return " . $dbconfig_arr. ";";
		if(!file_put_contents(DATA_DIR . 'config' . DIRECTORY_SEPARATOR . 'database.ini.php', $dbconfig_txt))  dexit('数据库配置文件保存失败，请检查文件权限！');

		$admin_txt = "<?php" . PHP_EOL . "if (!defined('IN_XIAOCMS')) exit();" . PHP_EOL . "return " . $adminconfig_arr. ";";
		if(!file_put_contents(DATA_DIR . 'config' . DIRECTORY_SEPARATOR . 'admin.ini.php', $admin_txt))  dexit('后台配置文件保存失败，请检查文件权限！');

        $this->db = xiaocms::load_class('Model');
		$sql      = file_get_contents(DATA_DIR . 'install/xiaocms.sql');
		$sqlarr = explode(');', $sql);
        array_pop($sqlarr);
        foreach ($sqlarr as $s) {
		    $s = $s . ');';
	    	$this->db->execute($s);
       }
		if ($import) {
		$sql  = file_get_contents(DATA_DIR . 'install/xiaocms_data.sql');
		$sqlarr = explode(');', $sql);
        array_pop($sqlarr);
        foreach ($sqlarr as $s) {
		    $s = $s . ');';
	    	$this->db->execute($s);
        }
		}
        $adminurl = $this->get_http_host() . $this->get_base_url();
        file_put_contents(DATA_DIR . 'install.lock', 'Powered by XiaoCms:'.time());
		include $this->install_tpl('3');
	} 

    protected function install_tpl($file) {
        return  XIAOCMS_PATH.'data/install'.DIRECTORY_SEPARATOR.$file.'.tpl.php';
    }
	
}