CREATE TABLE "xiao_block" (
"id" INTEGER,
"type" integer NOT NULL DEFAULT 0,
"name" varchar(50) NOT NULL DEFAULT '',
"content" text NOT NULL DEFAULT '',
PRIMARY KEY("id")
);

INSERT INTO "xiao_block" VALUES (1, 2, '幻灯图片1', 'http://demo.xiaocms.com/template/default/images/1.png');
INSERT INTO "xiao_block" VALUES (2, 2, '幻灯图片2', 'http://demo.xiaocms.com/template/default/images/2.png');
INSERT INTO "xiao_block" VALUES (3, 2, '幻灯图片3', 'http://demo.xiaocms.com/template/default/images/3.png');

CREATE TABLE "xiao_category" (
"catid" integer,
"typeid" integer NOT NULL DEFAULT 0,
"modelid" integer NOT NULL DEFAULT 0,
"parentid" integer NOT NULL DEFAULT 0,
"child" integer NOT NULL DEFAULT 0,
"childids" varchar(255) NOT NULL DEFAULT '',
"catname" varchar(30) NOT NULL DEFAULT '',
"image" varchar(100) NOT NULL DEFAULT '',
"content" text NOT NULL DEFAULT '',
"seo_title" varchar(255) NOT NULL DEFAULT '',
"seo_keywords" varchar(255) NOT NULL DEFAULT '',
"seo_description" varchar(255) NOT NULL DEFAULT '',
"catdir" varchar(30) NOT NULL DEFAULT '',
"http" varchar(255) NOT NULL DEFAULT '',
"items" integer NOT NULL DEFAULT 0,
"listorder" integer NOT NULL DEFAULT 0,
"ismenu" integer NOT NULL DEFAULT 1,
"ispost" integer NOT NULL DEFAULT 0,
"verify" integer NOT NULL DEFAULT 0,
"islook" integer NOT NULL DEFAULT 0,
"listtpl" varchar(50) NOT NULL DEFAULT '',
"showtpl" varchar(50) NOT NULL DEFAULT '',
"pagetpl" varchar(50) NOT NULL DEFAULT '',
"pagesize" integer NOT NULL DEFAULT 10,
PRIMARY KEY("catid")
);

CREATE TABLE "xiao_content" (
"id" INTEGER,
"catid" integer NOT NULL DEFAULT 0,
"modelid" integer NOT NULL DEFAULT 0,
"title" varchar(255) NOT NULL DEFAULT '',
"thumb" varchar(255) NOT NULL DEFAULT '',
"keywords" varchar(255) NOT NULL DEFAULT '',
"description" varchar(255) NOT NULL DEFAULT '',
"listorder" integer NOT NULL DEFAULT 0,
"status" integer NOT NULL DEFAULT 1,
"hits" integer NOT NULL DEFAULT 0,
"username" varchar(30) NOT NULL DEFAULT '',
"time" integer NOT NULL DEFAULT 0,
PRIMARY KEY("id")
);

CREATE TABLE "xiao_content_news" (
"id" INTEGER,
"catid" integer NOT NULL DEFAULT 0,
"content" text NOT NULL DEFAULT '',
"aaa" varchar(255) NOT NULL DEFAULT '',
PRIMARY KEY("id")
);


CREATE TABLE "xiao_content_product" (
"id" integer,
"catid" integer NOT NULL DEFAULT 0,
"content" text NOT NULL DEFAULT '',
PRIMARY KEY("id")
);

CREATE TABLE "xiao_form_comment" (
"id" integer,
"cid" integer NOT NULL DEFAULT 0,
"userid" integer NOT NULL DEFAULT 0,
"username" varchar(30) NOT NULL DEFAULT '',
"listorder" integer NOT NULL DEFAULT 0,
"status" integer NOT NULL DEFAULT 1,
"time" integer NOT NULL DEFAULT 0,
"ip" varchar(20) NOT NULL DEFAULT '',
"pinglunneirong" varchar(255) NOT NULL DEFAULT '',
PRIMARY KEY("id")
);

CREATE TABLE "xiao_form_gestbook" (
"id" integer,
"cid" integer NOT NULL DEFAULT 0,
"userid" integer NOT NULL DEFAULT 0,
"username" varchar(30) NOT NULL DEFAULT '',
"listorder" integer NOT NULL DEFAULT 0,
"status" integer NOT NULL DEFAULT 1,
"time" integer NOT NULL DEFAULT 0,
"ip" varchar(20) NOT NULL DEFAULT '',
"nindexingming" varchar(255) NOT NULL DEFAULT '',
"lianxiQQ" varchar(255) NOT NULL DEFAULT '',
"liuyanneirong" varchar(255) NOT NULL DEFAULT '',
PRIMARY KEY("id")
);

CREATE TABLE "xiao_member" (
"id" integer,
"username" varchar(30) NOT NULL DEFAULT '',
"password" varchar(32) NOT NULL DEFAULT '',
"email" varchar(100) NOT NULL DEFAULT '',
"avatar" varchar(30) NOT NULL DEFAULT '',
"modelid" integer NOT NULL DEFAULT 0,
"regdate" integer NOT NULL DEFAULT 0,
"regip" varchar(30) NOT NULL DEFAULT '',
"status" NUMERIC(3) NOT NULL DEFAULT 0,
PRIMARY KEY("id")
);

CREATE TABLE "xiao_member_geren" (
"id" integer,
PRIMARY KEY("id")
);

CREATE TABLE "xiao_model" (
"modelid" integer,
"typeid" integer NOT NULL DEFAULT 0,
"modelname" varchar(30) NOT NULL DEFAULT '',
"tablename" varchar(30) NOT NULL DEFAULT '',
"listtpl" varchar(30) NOT NULL DEFAULT '',
"showtpl" varchar(30) NOT NULL DEFAULT '',
"joinid" integer DEFAULT '',
"setting" text default '',
PRIMARY KEY("modelid")
);

INSERT INTO "xiao_model" VALUES (1, 1, '文章模型', 'content_news', 'list_news.html', 'show_news.html', 0, 'a:1:{s:7:"default";a:6:{s:5:"title";a:2:{s:4:"name";s:6:"标题";s:4:"show";s:1:"1";}s:8:"keywords";a:2:{s:4:"name";s:9:"关键字";s:4:"show";s:1:"1";}s:5:"thumb";a:2:{s:4:"name";s:9:"缩略图";s:4:"show";s:1:"1";}s:11:"description";a:2:{s:4:"name";s:6:"描述";s:4:"show";s:1:"1";}s:4:"time";a:2:{s:4:"name";s:12:"发布时间";s:4:"show";s:1:"1";}s:4:"hits";a:2:{s:4:"name";s:9:"阅读数";s:4:"show";s:1:"1";}}}');
INSERT INTO "xiao_model" VALUES (2, 1, '产品模型', 'content_product', 'list_product.html', 'show_product.html', null, 'a:1:{s:7:"default";a:6:{s:5:"title";a:2:{s:4:"name";s:6:"标题";s:4:"show";s:1:"1";}s:8:"keywords";a:2:{s:4:"name";s:9:"关键字";s:4:"show";s:1:"1";}s:5:"thumb";a:2:{s:4:"name";s:9:"缩略图";s:4:"show";s:1:"1";}s:11:"description";a:2:{s:4:"name";s:6:"描述";s:4:"show";s:1:"1";}s:4:"time";a:2:{s:4:"name";s:12:"发布时间";s:4:"show";s:1:"1";}s:4:"hits";a:2:{s:4:"name";s:9:"阅读数";s:4:"show";s:1:"1";}}}');
INSERT INTO "xiao_model" VALUES (3, 3, '在线留言', 'form_gestbook', 'list_gestbook.html', 'form.html', null, 'a:1:{s:4:"form";a:8:{s:4:"post";s:1:"0";s:3:"num";s:1:"0";s:4:"time";s:0:"";s:5:"check";s:1:"0";s:4:"code";s:1:"0";s:6:"member";s:1:"0";s:4:"show";a:3:{i:0;s:13:"nindexingming";i:1;s:8:"lianxiQQ";i:2;s:13:"liuyanneirong";}s:10:"membershow";a:3:{i:0;s:13:"nindexingming";i:1;s:8:"lianxiQQ";i:2;s:13:"liuyanneirong";}}}');
INSERT INTO "xiao_model" VALUES (4, 3, '文章评论', 'form_comment', 'list_comment.html', 'form.html', 1, 'a:1:{s:4:"form";a:8:{s:4:"post";s:1:"0";s:3:"num";s:1:"0";s:4:"time";s:0:"";s:5:"check";s:1:"0";s:4:"code";s:1:"0";s:6:"member";s:1:"0";s:4:"show";a:1:{i:0;s:14:"pinglunneirong";}s:10:"membershow";a:1:{i:0;s:14:"pinglunneirong";}}}');
INSERT INTO "xiao_model" VALUES (5, 2, '个人', 'member_geren', 'list_geren.html', 'show_geren.html', null, null);

CREATE TABLE "xiao_model_field" (
"fieldid" integer,
"modelid" integer NOT NULL DEFAULT 0,
"field" varchar(30) NOT NULL DEFAULT '',
"name" varchar(30) NOT NULL DEFAULT '',
"isshow" integer NOT NULL DEFAULT 1,
"tips" text default '',
"pattern" varchar(250) NOT NULL DEFAULT '',
"errortips" varchar(250) NOT NULL DEFAULT '',
"formtype" varchar(30) NOT NULL DEFAULT '',
"setting" text default '',
"listorder" integer NOT NULL DEFAULT 0,
"disabled" integer NOT NULL DEFAULT 0,
PRIMARY KEY("fieldid")
);

INSERT INTO "xiao_model_field" VALUES (1, 1, 'content', '内容', 1, '', '', '', 'editor', 'a:4:{s:7:"toolbar";s:1:"1";s:5:"width";s:3:"700";s:6:"height";s:3:"450";s:12:"defaultvalue";s:0:"";}', 0, 0);
INSERT INTO "xiao_model_field" VALUES (2, 2, 'content', '内容', 1, '', '', '', 'editor', 'a:5:{s:7:"toolbar";s:1:"2";s:5:"items";s:256:"''source'',''|'',''forecolor'',''bold'',''italic'',''underline'',''lineheight'',''|'',''fontname'',''fontsize'',''code'',''plainpaste'',''wordpaste'',''|'',''image'',''multiimage'',''flash'',''media'',''insertfile'',''link'',''unlink'',''|'',''justifyleft'',''justifycenter'',''justifyright'',''justifyfull''";s:5:"width";s:3:"700";s:6:"height";s:3:"450";s:12:"defaultvalue";s:190:"编辑器支持自定义啦，赶快去内容模型》产品模型》字段管理》编辑器里面看看吧&lt;br&gt;如需更多字段，请大家自己在字段管理处自行添加吧。";}', 0, 0);
INSERT INTO "xiao_model_field" VALUES (3, 3, 'nindexingming', '您的姓名', 1, '', '', '', 'input', 'a:2:{s:4:"size";s:3:"150";s:12:"defaultvalue";s:0:"";}', 0, 0);
INSERT INTO "xiao_model_field" VALUES (4, 3, 'lianxiQQ', '联系QQ', 1, '', '/^[0-9]{5,20}$/', '', 'input', 'a:2:{s:4:"size";s:3:"150";s:12:"defaultvalue";s:0:"";}', 0, 0);
INSERT INTO "xiao_model_field" VALUES (5, 3, 'liuyanneirong', '留言内容', 1, '', 1, '留言内容不能为空', 'textarea', 'a:3:{s:5:"width";s:3:"400";s:6:"height";s:2:"90";s:12:"defaultvalue";s:0:"";}', 0, 0);
INSERT INTO "xiao_model_field" VALUES (6, 4, 'pinglunneirong', '评论内容', 1, '', 1, '评论内容不能为空', 'textarea', 'a:3:{s:5:"width";s:3:"400";s:6:"height";s:2:"90";s:12:"defaultvalue";s:0:"";}', 0, 0);
INSERT INTO "xiao_model_field" VALUES (7, 1, 'aaa', 'aa', 1, '', '', '', 'checkbox', 'a:2:{s:7:"content";s:18:"a|a
b|b
c|c
d|d";s:12:"defaultvalue";s:0:"";}', 0, 0);

CREATE INDEX "xiao_category_listordercatid"
ON "xiao_category" ("listorder" ASC, "catid" ASC);

CREATE INDEX "xiao_content_catidlistordertime"
ON "xiao_content" ("catid" ASC, "listorder" ASC, "time" ASC);

CREATE INDEX "xiao_content_news_catid"
ON "xiao_content_news" ("catid" ASC);

CREATE INDEX "xiao_content_product_catid"
ON "xiao_content_product" ("catid" ASC);

CREATE INDEX "xiao_form_comment_listorder"
ON "xiao_form_comment" ("listorder" ASC);

CREATE INDEX "xiao_form_gestbook_listorder"
ON "xiao_form_gestbook" ("listorder" ASC);

CREATE UNIQUE INDEX "xiao_member_username"
ON "xiao_member" ("username" ASC);

CREATE INDEX "xiao_model_typeid"
ON "xiao_model" ("typeid" ASC);

CREATE INDEX "xiao_model_field_modelid"
ON "xiao_model_field" ("modelid" ASC);