<!DOCTYPE html>
<html>
<head>
<meta http-equiv="content-type" content="text/html;charset=UTF-8"/>
<meta name="renderer" content="webkit">
<title><?php category_name(); ?>小说_<?php category_name(); ?>小说排行榜_<?php category_name(); ?>小说完本-<?php option_info('site.name'); ?></title>
<meta name="keywords" content="<?php category_name(); ?>小说,<?php category_name(); ?>小说排行榜,<?php category_name(); ?>小说排行榜完本">
<meta name="description" content="<?php option_info('site.name'); ?>为您推荐最好看的<?php category_name(); ?>小说,打造<?php category_name(); ?>小说排行榜,您可以方便的进行<?php category_name(); ?>小说阅读和下载。">
<link rel="shortcut icon" href="/favicon.ico" />
<link href="<?php stylesheet_url('css/header.css'); ?>" rel="stylesheet">
<link href="<?php stylesheet_url('css/indexx.css'); ?>" rel="stylesheet">
<link href="<?php stylesheet_url('css/book.css'); ?>" rel="stylesheet">
</head>
<body class="page-originalCategory">
<div class="g-doc">
	<div class="g-hdw">
		<?php get_header(); ?>
	</div>
	<div class="g-bdw g-bdw-1">
		<div class="g-bd yd-grid2col-page">
			<div class="g-bdc yd-original-page">
				<div class="g-sd" data-spy="affix" data-offset-top="187">
					<div class="m-top8 m-top8-b">
						<div class="hd">
							<h3><?php echo rtrim(get_category_name(get_current_category_id()), '小说'); ?>小说点击榜</h3>
						</div>
						<div class="bd contents">
							<ol>
							<?php $books = book_get_hot(get_current_category_id(), 'month'); $books = array_slice($books, 0, 10); $count = count($books); foreach ($books as $key => $book) :?>
								<li<?php echo $key == ($count - 1) && $count >= 10 ? ' class="ll"' : ''; ?>><span<?php echo $key > 3 ? '' : ' class="top"'; ?>><?php echo ++$key; ?></span><a href="<?php book_link(); ?>" class="j-cutted" words="14" title="<?php book_name(); ?>" target="_blank"><?php book_name(); ?></a></li>
							<?php endforeach; ?>
						</ol>
					</div>
				</div>
				<div class="m-top8 m-top8-b f-mt20">
					<div class="hd">
						<h3><?php echo rtrim(get_category_name(get_current_category_id()), '小说'); ?>小说推荐</h3>
					</div>
					<div class="bd contents">
						<ol>
						<?php $books = book_get_recommend(get_current_category_id(), 'month'); $books = array_slice($books, 0, 10); $count = count($books); foreach ($books as $key => $book) :?>
							<li<?php echo $key == ($count - 1) && $count >= 10 ? ' class="ll"' : ''; ?>><span<?php echo $key > 3 ? '' : ' class="top"'; ?>><?php echo ++$key; ?></span><a href="<?php book_link(); ?>" class="j-cutted" words="14" title="<?php book_name(); ?>" target="_blank"><?php book_name(); ?></a></li>
						<?php endforeach; ?>
						</ol>
					</div>
				</div>
				</div>
				<div class="g-mn">
					<div class="g-mnc">
						<div class="yd-original-store-filter-container yd-store-filter-container ">
							<dl class="dl-horizontal">
								<dt>写作进度：</dt>
								<dd class="last">
									<ul class="list-inline">
										<?php $finished = get_query('finished', 'all'); $category_link = get_category_link(get_current_category_id()); ?>
										<li<?php echo $finished == 'all' ? ' class="active"' : ''; ?>><a href="<?php echo $category_link; ?>">全部</a></li>
										<li<?php echo $finished == 'no' ? ' class="active"' : ''; ?>><a href="<?php echo add_query_arg('finished', 'no', $category_link); ?>">连载中</a></li>
										<li<?php echo $finished == 'yes' ? ' class="active"' : ''; ?>><a href="<?php echo add_query_arg('finished', 'yes', $category_link); ?>">已完结</a></li>
									</ul>
								</dd>
							</dl>
						</div>
						<div class="yd-store-content-container">
								<table class="yd-table yd-table-striped yd-original-table yd-original-store-table ">
									<thead>
										<tr class="grad-1">
											<th width="12%" style="text-align: center">序号</th>
											<th width="42%">书名/最新章节</th>
											<th width="12%" style="text-align: center">作者</th>
											<th width="16%" style="text-align: center">进度</th>
											<th width="18%" style="text-align: center">更新时间</th>
										</tr>
									</thead>
									<tbody>
										<?php if (have_books()) : while (have_books()) : the_book(); ?>
										<tr class="<?php echo the_book_SN() & (the_book_SN() & 1) ? 'odd' : 'even'; ?><?php echo the_book_SN() == 1 ? ' first' : ''; ?><?php echo the_book_SN() == the_book_count() ? ' last' : ''; ?>">
											<td style="text-align: center"><span class="serial-number"><?php book_No(); ?></span></td>
											<td>
												<div class="book-name"><a href="<?php book_link(); ?>" target="_blank"><?php book_name(); ?></a></div>
												<div class="book-newest-chapter"><a href="<?php book_latest_chapter_link(); ?>"><?php book_latest_chapter_title(); ?></a></div>
											</td>
											<td style="text-align: center"><?php book_author(); ?></td>
											<td style="text-align: center"><?php echo book_is_finished() ? '已完结' : '连载中'; ?></td>
											<td style="text-align: center"><?php echo date('m-d G:i', get_book_latest_chapter_created()); ?></td>
										</tr>
										<?php endwhile; endif; ?>
									</tbody>
								</table>
						</div>
						<div class="m-page m-page-b">
							<span class="nums">
							<?php
								$args = array(
									'current_class' => 'j-crt',
									'current_display' => '<a class="j-crt">%cur_num%</a>',
									'hellip_display' => '</span><span class="dian">...</span><span class="nums">',
								);
								if ($finished != 'all') {
									$args['add_args'] = array('finished' => $finished);
								}
								category_paginate_links($args);
							?>
							</span>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php get_footer(); ?>
</div>
<!--[if IE 6]>
<script type="text/javascript" src="<?php active_theme_url(); ?>js/pngfix.js"></script>
<![endif]-->
</body>
</html>
