<?php
/**
 * Theme Name: 仿网易阅读主题
 * Theme URI: http://www.duguai.com/
 * Description:
 * Author: 骑驴觅驴
 * Version: 1.0
 */
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8"/>
<meta name="renderer" content="webkit">
<title><?php option_info('site.name'); ?>-无弹窗广告的小说网站</title>
<meta name="keywords" content="<?php option_info('site.keyowrds'); ?>"/>
<meta name="description" content="<?php option_info('site.intro'); ?>"/>
<link rel="shortcut icon" href="/favicon.ico" />
<link href="<?php stylesheet_url('css/header.css'); ?>" rel="stylesheet">
<link href="<?php stylesheet_url('css/indexx.css'); ?>" rel="stylesheet">
<style>
.g-bd a:hover{color:#1b77ba!important;}
</style>
</head>
<body>
<div class="g-doc">
	<?php get_header(); ?>
	<!-- 主题内容 -->
	<div class="g-bdw">
	<div class="g-bd">
		<div class="g-bdc">
			<div class="m-bookslide m-bookslide-b">
				<div class="bd">
					<div id="J_Slider02" class="slider">
						<a class="btn left-btn j-cl" href="#"></a>
						<a class="btn right-btn j-cr" href="#"></a>
						<div class="m-sliderlist m-sliderlist-b">
							<div class="j-slider" style="position:absolute;">
								<?php $books = book_get_hot(0, 'month'); $_books = array_slice($books, 0, 6);// 本月热门 ?>
								<div class="pack j-slideritem">
									<?php if (is_array($_books) && $_books) : $count = count($_books); ?>
									<ul>
										<?php foreach ($_books as $key => $book) : ?>
										<li<?php echo $key == $count - 1 ? ' class="ll"' : ''; ?>>
											<a class="img" href="<?php book_link(); ?>" target="_blank"><img width="114" height="160" src="<?php book_cover(); ?>"></a>
											<h4><a href="<?php book_link(); ?>" target="_blank" class="j-cutted" words="9"><?php book_name(); ?></a></h4>
										</li>
										<?php endforeach; ?>
									</ul>
									<?php endif; ?>
								</div>
								<?php $_books = array_slice($books, 6, 6); ?>
								<div class="pack j-slideritem">
									<?php if (is_array($_books) && $_books) : $count = count($_books); ?>
									<ul>
										<?php foreach ($_books as $key => $book) : ?>
										<li<?php echo $key == $count - 1 ? ' class="ll"' : ''; ?>>
											<a class="img" href="<?php book_link(); ?>" target="_blank"><img width="114" height="160" src="<?php book_cover(); ?>"></a>
											<h4><a href="<?php book_link(); ?>" target="_blank" class="j-cutted" words="9"><?php book_name(); ?></a></h4>
										</li>
										<?php endforeach; ?>
									</ul>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="g-bdc g-bdc-up20">
			<div class="m-newchaptab m-newchaptab-b">
				<div class="tabs grad-1">
					<ul>
						<li class="crt">最近更新</li>
					</ul>
					<div class="rs"></div>
				</div>
				 <div class="contents">
					<div class="tab-item">
						<table class="m-chaptable" id="totalworksup">
							<tbody>
								<tr style="height:26px;">
									<th class="col-left" width="">书名</th>
									<th width="205">最新章节</th>
									<th class="col-mid" width="120">作者</th>
									<th class="col-right" width="132">更新时间</th>
								</tr>
								<?php get_books('number=17&from_cache=true&orderby=last_chapter_created'); if (have_books()) : ?>
								<?php while (have_books()) : the_book(); ?>
								<tr>
									<td class="col-left"><a href="<?php book_link(); ?>" target="_blank" class="j-cutted" title="<?php book_name(); ?>"><?php book_name(); ?></a></td>
									<td class="col-ml"><a href="<?php book_latest_chapter_link(); ?>" target="_blank" class="j-cutted" title="<?php book_latest_chapter_title(); ?>"><?php echo tp_substr(get_book_latest_chapter_title(), 0, 15); ?></a></td><td class="col-mid"><a href="<?php create_url('book/search', array('s' => get_book_author())); ?>" target="_blank" title="<?php book_author(); ?>"><?php book_author(); ?></a></td>
									<td class="col-right"><?php echo date('Y-m-d H:i', get_book_latest_chapter_created()); ?></td>
								</tr>
								<?php endwhile; endif; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			<div id="J_Bang1" class="m-bang m-bang-b" style="margin:0;float:right;height:398px;">
				<div class="tabs">
					<h4 class="grad-1">推荐榜</h4>
				</div>
				<div class="contents" style="padding: 4px 15px;">
					<div class="tab-item">
						<ol id="scrankday">
						<?php $books = book_get_recommend(0, 'month'); $books = array_slice($books, 0, 10); $count = count($books); foreach ($books as $key => $book) :?>
							<li<?php echo $key == ($count - 1) && $count >= 10 ? ' class="ll"' : ''; ?>><span<?php echo $key > 3 ? '' : ' class="top"'; ?>><?php echo ++$key; ?></span><a href="<?php book_link(); ?>" class="j-cutted" words="14" title="<?php book_name(); ?>" target="_blank"><?php book_name(); ?></a></li>
						<?php endforeach; ?>
						</ol>
					</div>
				</div>
			</div>

			<div class="m-top8 m-top8-b f-mt20">
				<div class="hd">
					<h3>新书榜</h3>
				</div>
				<div class="bd contents">
					<ol id="xsrank">
					<?php $books = get_books('number=10&from_cache=false'); if (have_books()) : ?>
					<?php while (have_books()) : the_book(); ?>
						<li<?php echo the_book_SN() == 10 && $count >= 10 ? ' class="ll"' : ''; ?>><span<?php echo the_book_SN() > 3 ? '' : ' class="top"'; ?>><?php book_SN(); ?></span><a href="<?php book_link(); ?>" class="j-cutted" words="14" title="<?php book_name(); ?>" target="_blank"><?php book_name(); ?></a></li>
					<?php endwhile; endif; ?>
					</ol>
				</div>
			</div>
		</div>
		<div class="g-bdc g-bdc-up20">
			<div class="m-partnerlist m-partnerlist-2">
				<h3>友情链接</h3>
				<p class="f-cb">
				<?php get_links(); if (have_links()) : while (have_links()) : the_link(); ?>
					<a href="<?php link_url(); ?>" rel="external nofollow" target="_blank"><?php link_name(); ?></a>
				<?php endwhile; endif; ?>
				</p>
			</div>
		</div>
	</div>
	</div>
	<?php get_footer(); ?>
</div>
<?php load_scripts(); ?>
<script type="text/javascript" src="<?php active_theme_url(); ?>js/encode-utils.js"></script>
<script type="text/javascript" src="<?php active_theme_url(); ?>js/slider.js"></script>
<script type="text/javascript" src="<?php active_theme_url(); ?>js/pngfix.js"></script>
<script>
(function(){
	/*轮播*/
	$('#J_Slider02').goSlider({
		'animation' : 'slide',
		'autoDuration' : '8000',
		'showControl' : false,
		'sliderWrap' : '.j-slider',
		'sliderItem' : '.j-slideritem'
	});
	function cutWords() {
		$('.j-cutted').each(function(){
			var limit = $(this).attr('words')*1 - 1;
			var str = $(this).text();
			if(str.length > limit){
				str = $(this).text().slice(0,limit) + '...';
			}
			$(this).text(str);
		});
	}
	cutWords();

	$('#J_SearchOps').hover(function(){
		$(this).show();
	}, function(){
		$(this).hide();
	});

	function qrsearch(){
		if ($("#kw").val() == '请输入小说名...' || $("#kw").val() == '') {
			$("#kw").val('');
			$("#kw").focus();
			return false;
		}else{
			return true;
		}
	}

	var setStringHighLight = function(str,key){
		var _str = str, _key = key, _length = _key.length, _return;

		if(_str.indexOf(_key) >= 0){
			var pos = _str.indexOf(_key);
			var a = _str.slice(0,pos),
				b = _str.slice(pos,(pos+_length)),
				c = _str.slice((pos+_length)),
				_return = a + '<em>' + b + '</em>' + c;

			return _return;
		}else{
			return _str;
		}
	};

	$('#topsearch').bind('input propertychange', function() {searchBook();});

	function searchBook() {
		$("#J_SearchOps").html('').hide();
		var key = $("#topsearch").val();
		if (key != '' && key != '请输入小说名...') {
			var s_url = '<?php create_url('book/search', array('s' => '%keyword%')); ?>';
			$.ajax({
				url: s_url.replace('%keyword%', key),
				type: 'GET',
				data: {q: key, callback: 'callback'},
				cache: false,
				success: function(result){
					var _url = s_url.replace('%keyword%', key);
					var _data = jQuery.parseJSON(result);
					var innerHTML = '';
					var processedStr = '';
					if(_data.book.length > 0){
						innerHTML += '<li class="parent topli"><b class="book"></b><a href="' + _url + '" type="4">搜"<em>' + key + '</em>"小说</a></li>';
						for (var j = 0; j < _data.book.length; j++) {
							var bookName = encodeUtils.htmlEncode(_data.book[j].name);
							processedStr = setStringHighLight(bookName, key);
							if(j == _data.book.length - 1){
								innerHTML += '<li class="children children-last"><a href="' + _data.book[j].url + '" type="4">' + processedStr + '</a></li>';
							}else{
								innerHTML += '<li class="children"><a href="' + _data.book[j].url + '" type="4">' + processedStr + '</a></li>';
							}
						}
					}else{
						innerHTML += '<li class="parent topli"><b class="book"></b><a href="' + _url + '" type="4">搜"<em>' + key + '</em>"小说</a></li>';
					}
					$("#J_SearchOps").html(innerHTML).show();
				},
				error: function(xhr, status, error){
					var err = eval("(" + xhr.responseText + ")");
					alert(err.Message);
				}
			});
		}
	}
})();
</script>
</body>
</html>