/**
 * 编码工具
 */
var encodeUtils = {};
/**
 * JS编码
 */
encodeUtils.jsEncode = function (str) {
	if (stringUtils.isEmpty(str)) {
		return str;
	}
	var ret = "";
	for (var s = 0; s < str.length; s = s + 1) {
		if (stringUtils.isLetterOrDigit(str[s])) {
			ret += str[s];
		} else if (stringUtils.isWhitespace(str[s])) {
			ret += str[s];
			} else if (stringUtils.isVisible(str[s])) {
			ret += "\\" + str[s];
		} else {
			ret += str[s];
		}
	}
	return ret;
}

/**
 * HTML实体编码
 */
encodeUtils.htmlEntityEncode = function (str) {
	if (stringUtils.isEmpty(str)) {
		return str;
	}
	var ret = "";
	for (var s = 0; s < str.length; s = s + 1) {
		if (stringUtils.isLetterOrDigit(str[s])) {
			ret += str[s];
		} else if (stringUtils.isWhitespace(str[s])) {
			ret += str[s];
		} else if (stringUtils.isVisible(str[s])) {
			ret += "&#" + str[s].charCodeAt(0) + ";";
		} else {
			ret += str[s];
		}
	}
	return ret;
}
/**
 * createTextNode编码
 */
encodeUtils.htmlEncode = function (str) {
	if (stringUtils.isEmpty(str)) {
		return "";
	}
	var div = document.createElement("div");
	var text = document.createTextNode("text");
	text.data = str;
	div.appendChild(text);
	return div.innerHTML;
}

var stringUtils = {};
stringUtils.isEmpty = function (str) {
	if (str == null || str == undefined || str == "") {
		return true;
	}
	return false;
}
stringUtils.isLetterOrDigit = function (str) {
	if (str == null || str == undefined) {
		return false;
	}
	return /^[0-9a-zA-Z]*$/.test(str);
}
stringUtils.isWhitespace = function (str) {
	if (str == null || str == undefined) {
		return false;
	}
	return /^[\t\r\t\v\e ]*$/.test(str);
}

stringUtils.isVisible = function (str) {
	if (str == null || str == undefined) {
		return false;
	}
	for (var s = 0; s < str.length; s = s + 1) {
		if (str[s].charCodeAt(0) >= 32 &&  str[s].charCodeAt(0) <= 126) {
			
		} else {
			return false;
		}
	}
	return true;
}