<?php

function get_catalog()
{
	global $category;
	$html = '';
	$categories = get_categories();
	foreach ($categories as $category) {
		$html .= '<a href="' . get_category_link() . '" target="_blank">' . get_category_name() . '</a>';
	}

	if (count($categories) < 9) {
		$count = (9 - count($categories));
//var_dump($count);exit;
		for ($i = 0; $i < $count; $i++) {
			$html .= '<a href="javascript:void(0);" target="_self"></a>';
		}
	}

	return $html;
}

function get_box_one($category_id, $hidden = false)
{
	global $category, $book;
	$html = '';
	$html .= str_repeat(PHP_TAB, 5) . '<ul' . ($hidden ? ' class="hidden"' : ' class=""') . '>';
	$books = book_get_recommend($category_id, 'day');
	if (!is_array($books) || count($books) < 19) {
		return $html . '</ul>';
	}

	$book = $books[0];
	$url = get_book_link();
	$html .= '<div class="indexonell">';
	$html .= '<a href="' . $url . '"><img src="' . get_book_cover() . '"></a>';
	$html .= '<h2><a href="' . $url . '">' . get_book_name() . '</a></h2>';
	$html .= '<span>' . get_book_excerpt(0, true, 50) . '<a href="' . $url . '" class="green">阅读&gt;&gt;</a></span>';
	$html .= '</div><div class="indexonelc">';
	$book = $books[1];
	$url = get_book_link();
	$html .= '<h3><a href="' . $url . '">《' . get_book_name() . '》&nbsp;' . get_book_author() . '</a></h3>';
	$html .= '<span>' . get_book_excerpt(0, true, 50) . '<a href="' . $url . '" class="green">阅读&gt;&gt;</a></span>';
	$html .= '<ul class="clearfix">';
	for ($i = 2; $i < 10; $i++) {
		$book = $books[$i];
		$url = get_book_link();
		$html .= '<li><a href="' . get_category_link(get_book_category_id()) . '" class="i1">[' . get_category_name(get_book_category_id());
		$html .= ']</a><a href="' . $url . '" class="i2">' . get_book_name() . '</a></li>';
	}
	$html .= '</ul>';
	$book = $books[10];
	$url = get_book_link();
	$html .= '<h3><a href="' . $url . '">《' . get_book_name() . '》&nbsp;' . get_book_author() . '</a></h3>';
	$html .= '<span>' .  get_book_excerpt(0, true, 50) . '<a href="' . $url . '" class="green">阅读&gt;&gt;</a></span>';
	$html .= '<ul class="clearfix">';
	for ($i = 11; $i < 19; $i++) {
		$book = $books[$i];
		$url = get_book_link();
		$html .= '<li><a href="' . get_category_link(get_book_category_id()) . '" class="i1">[' . get_category_name(get_book_category_id());
		$html .= ']</a><a href="' . $url . '" class="i2">' . get_book_name() . '</a></li>';
	}
	$html .= '</ul></div></ul>';

	return $html;
}

function get_wrap_one($books, $hidden = ' hidden', $echo = true)
{
	if (!is_array($books)) {
		return false;
	}

	global $category, $book;
	$books = array_slice($books, 0, 12);
	$html = str_repeat(PHP_TAB, 4) . '<ul class="clearfix imgitems' . $hidden . '">' . PHP_EOL;
	foreach ($books as $book) {
		$link = get_book_link();
		$name = get_book_name();
		$cover = get_book_cover();
		$finished = book_is_finished() ? '<span class="ywjico"></span>' : '<span class="lzzico"></span>';
		$html .= str_repeat(PHP_TAB, 5) . '<li>' . PHP_EOL;
		$html .= str_repeat(PHP_TAB, 6) . '<a href="' . $link . '" class="imgcss"><img src="' . $cover . '" alt="' . $name . '"></a>' . PHP_EOL;
		$html .= str_repeat(PHP_TAB, 6) . '<h3><a href="' . $link . '" target="_blank">' . $name . '</a></h3>' . PHP_EOL;
		$html .= str_repeat(PHP_TAB, 6) . get_book_excerpt(0, true, 11, '') . PHP_EOL;
		$html .= str_repeat(PHP_TAB, 6) . $finished . PHP_EOL;
		$html .= str_repeat(PHP_TAB, 5) . '</li>' . PHP_EOL;
	}
	$html .= str_repeat(PHP_TAB, 4) . '</ul>' . PHP_EOL;

	if ($echo) {
		echo $html;
	}

	return $html;
}

function index_category_list($category_id, $index = 0)
{
	global $category, $book;
	$index = $index >= 0 && $index <= 5 ? $index : mt_rand(0, 5);
	$classes = array('', ' wrapfive', ' wrapthree', ' wrapfour', ' wrapsix', ' wrapsev');
	$class = $classes[$index];
	++$index;
	if (!$books = get_books('category=' . absint($category_id) . '&number=15&from_cache=true')) {
		return false;
	}
?>
		<div class="clearfix wraptwo<?php echo $class; ?>">
			<div class="w690">
				<div class="titone">
					<h2 id="t<?php echo $index; ?>"><a href="<?php category_link($category_id); ?>"><?php category_name($category_id); ?></a></h2>
					<span><?php $_books = array_slice($books, 0, 6); foreach ($_books as $key => $book) : ?>
					<a href="<?php book_link(); ?>"><?php book_name(); ?></a><?php echo isset($_books[++$key]) ? '|' : ''; ?>
					<?php endforeach; ?></span>
				</div>
				<ul class="clearfix imgitems imgitemstwo"><?php $_books = array_slice($books, 5, 5); foreach ($_books as $key => $book) : ?>
					<li>
						<a href="<?php book_link(); ?>" class="imgcss"><img src="<?php book_cover(); ?>" alt=""><strong><?php book_author(); ?></strong></a>
						<h3><a href="<?php book_link(); ?>"><?php book_name(); ?></a></h3>
						<?php book_excerpt(0, true, 9, ''); ?>
					</li><?php endforeach; ?>
				</ul>
				<div class="clearfix fontitems">
					<ul><?php $_books = array_slice($books, 10, 4); foreach ($_books as $key => $book) : ?>
						<li>
							<a href="<?php book_link(); ?>"><?php book_name(); ?></a>
							：<?php book_excerpt(0, true, 24, ''); ?>
						</li><?php endforeach; ?>
					</ul>
				</div>
			</div>
			<div class="w246">
				<div class="tittwo">
					<h2>热门排行</h2>
					<ul>
						<li class="cur">日</li>
						<li>周</li>
						<li>月</li>
					</ul>
				</div>
				<div class="clearfix olwrap">
					<ol><?php $books = book_get_hot($category_id, 'day'); $books = array_slice($books, 0, 10); foreach ($books as $key => $book) : ?>
						<li><a href="<?php book_link(); ?>"><?php book_name(); ?></a>：<?php book_excerpt(0, true, 10, ''); ?></li><?php endforeach; ?>
					</ol>
					<ol class="hidden"><?php $books = book_get_hot($category_id, 'week'); $books = array_slice($books, 0, 10); foreach ($books as $key => $book) : ?>
						<li><a href="<?php book_link(); ?>"><?php book_name(); ?></a>：<?php book_excerpt(0, true, 10, ''); ?></li><?php endforeach; ?>
					</ol>
					<ol class="hidden"><?php $books = book_get_hot($category_id, 'month'); $books = array_slice($books, 0, 10); foreach ($books as $key => $book) : ?>
						<li><a href="<?php book_link(); ?>"><?php book_name(); ?></a>：<?php book_excerpt(0, true, 10, ''); ?></li><?php endforeach; ?>
					</ol>
				</div>
			</div>
		</div>
		<div class="blinebgs"></div>
<?php
}

function book_new_list($echo = true)
{
	global $book;

	$html = '';
	$books = get_books('number=7');
	$book = array_shift($books);
	if ($book) {
		$html .= '<div class="cimgsfont">';
		$html .= '<a class="imgcss" href="' . get_book_link() . '"><img alt="' . get_book_name() . '" src="' . get_book_cover() . '"><i class="nbicos"></i></a>';
		$html .= '<h3><a href="' . get_book_link() . '">' . get_book_name() . '</a></h3>作者：' . get_book_author();
		$html .= '<p>' . get_book_excerpt(0, true, 30) . '</p>';
		$html .= '</div>';
	}

	if ($books) {
		$html .= '<ol class="clearfix olcrwrap bg_gray">';
		foreach ($books as $book) {
			// ' . date("n-j", get_chapter_created()) . '
			$html .= '<li><span>&nbsp;</span><a href="' . get_book_link() . '">' . get_book_name() . '</a></li>';
		}
		$html .= '</ol>';
	}

	if ($echo) {
		echo $html;
	} else {
		return $html;
	}
}

function book_may_like_index($echo = true)
{
	global $book;

	$html = '';
	$books = get_option('books.like', array());
	if (!is_array($books)) {
		return false;
	}

	$books = array_slice($books, 0, 10);

	foreach ($books as $book) {
		$html .= '<a href="' . get_book_link() . '">' . get_book_name() . '</a>';
	}

	if ($echo) {
		echo $html;
	}
	return $html;
}

function book_may_like($echo = true)
{
	global $book;

	$html = '';
	$books = get_option('books.like', array());
	if (!is_array($books)) {
		return false;
	}
	$books = array_slice($books, 0, 34);
	$_books = array_slice($books, 0, 6);
	if ($_books) {
		$html .= '<ul class="clearfix imgitems">';
		foreach ($_books as $book) {
			$html .= '<li><a href="' . get_book_link() . '" class="imgcss"><img src="' . get_book_cover() . '" alt=""><strong>' . get_book_latest_chapter_title() . '</strong></a><h3><a href="/intro/35493">' . get_book_name() . '</a></h3>' . get_book_excerpt(0, true, 25, '') . '</li>';
		}
		$html .= '</ul>';
	}

	$_books = array_slice($books, 6, 28);
	if ($_books) {
		$html .= '<ul class="hottj clearfix">';
		foreach ($_books as $book) {
			$html .= '<li><a href="' . get_category_link(get_book_category_id()) . '" class="mark">[' . get_category_name(get_book_category_id()) . ']</a><a href="' . get_book_link() . '" class="biaot">' . get_book_name() . '</a></li>';
		}
		$html .= '</ul>';
	}

	if ($echo) {
		echo $html;
	}
	return $html;
}

function book_hot_list($books, $hidden = false, $echo = true)
{
	if (!is_array($books)) {
		return false;
	}

	global $category, $book;
	$html = '';
	$html .= str_repeat(PHP_TAB, 6) . '<div' . ($hidden ? ' class="hidden"' : '') . '>';
	if (!is_array($books) || count($books) < 12) {
		return $html . '</div>';
	}

	$books = array_slice($books, 0, 12);
	$book = array_shift($books);
	$url = get_book_link();
	$name = get_book_name();
	$html .= '<div class="cimgsfont"><a class="imgcss" href="' . $url . '"><img alt="' . $name . '" src="' . get_book_cover() . '"><i class="nbicos"></i></a><h3><a href="' . $url . '">' . $name . '</a></h3>作者：' . get_book_author() . '<p>' . get_book_excerpt(0, true, 30) . '</p></div>';
	$html .= '<ol class="clearfix olcrwrap">';
	foreach ($books as $book) {
		$html .= '<li><span>' . get_book_author() . '</span><a href="' . get_book_link() . '">' . get_book_name() . '</a></li>';
	}
	$html .= '</ol></div>';

	if ($echo) {
		echo $html;
	}
	return $html;
}

function book_chapters_list($book_id = 0, $echo = true)
{
	$book_id = $book_id ? absint($book_id) : get_current_book_id();
	if (!$book_id) {
		return '';
	}

	$cache_key = CACHE_CHAPTERS . $book_id . '_chapters_list';
	if (!$data = cache_get($cache_key)) {
		$data = '';
		get_chapters('book_id=' . $book_id);
		if (have_chapters()) {
			while (have_chapters()) {
				the_chapter();
				$data .= '<li><a href="' . get_chapter_link() . '">' . get_chapter_title() . '</a>' . date("Y-n-j", get_chapter_created()) . '</li>';
			}
		}

		cache_set($cache_key, $data);
	}

	if ($echo) {
		echo $data;
	} else {
		return $data;
	}
}

function delete_book_chapters_list_cache($book_id)
{
	$cache_key = CACHE_CHAPTERS . absint($book_id) . '_chapters_list';
	cache_delete($cache_key);
}

$events = array('created_chapter', 'quick_add_chapters', 'delete_chapter', 'delete_chapters'); //, 'edited_chapter', 'update_chapters_order'
foreach ($events as $event) {
	register_event($event, 'delete_book_chapters_list_cache');
}

function category_new_book_list($echo = true)
{
	global $book;

	$html = '';
	$books = get_books('number=7');
	$_books = array_slice($books, 0, 2);
	if ($_books) {
		$html .= '<ul class="clearfix ritemone">';
		foreach ($_books as $book) {
			$html .= '<li><a href="' . get_book_link() . '"><img alt="' . get_book_name() . '" src="' . get_book_cover() . '"></a>';
			$html .= '<h3><a href="' . get_book_link() . '">' . get_book_name() . '</a></h3><p>' . get_book_excerpt(0, true, 30) . '</p></li>';
		}
		$html .= '</ul>';
	}

	$_books = array_slice($books, 2, 5);
	if ($_books) {
		$html .= '<ul class="clearfix ritemtwo">';
		foreach ($_books as $book) {
			$html .= '<li><a href="' . get_book_link() . '">' . get_book_name() . '</a></li>';
		}
		$html .= '</ul>';
	}

	if ($echo) {
		echo $html;
	} else {
		return $html;
	}
}
?>