<?php
class AccountAction extends Action{
	// 用户中心
	public function index(){
		// 没有登录
		if(!$_SESSION["ID"]){
			redirect("/Account/login.html");
			exit;
		}
		// 显示页面
		$this->display();
	}
	// 修改密码
	public function updpass(){
		// 没有登录
		if(!$_SESSION["ID"]){
			redirect("/Account/login.html");
			exit;
		}
		// 修改密码
		if($_POST){
			// 获取参数
			$oldpass = GET("oldpass");
			$newpass = GET("newpass");
			$repass = GET("repass");
			// 判断参数
			if(!$oldpass || !$newpass || !$repass){
				$this->error("每一项都必须填写!");
				exit;
			}
			if(!$newpass){
				$this->error("新密码必须填写!");
				exit;
			}
			if($newpass != $repass){
				$this->error("确认密码必须与新密码一致!");
				exit;
			}
			// 查询帐号
			$Data = M("Zh");
			$zhObj = $Data->where("zh_id = ".$_SESSION["ID"])->find();
			if($zhObj["zh_pass"] != $oldpass){
				$this->error("当前密码不正确!");
				exit;
			}
			// 修改密码
			$rel = $Data->where("zh_id = ".$_SESSION["ID"])->save(array("zh_pass"=>$newpass));
			if($rel === false){
				$this->error("修改失败!");
				exit;
			}
			unset($_SESSION["ID"]);
			unset($_SESSION["ZH"]);
			$this->success("修改成功，请重新登录!","/Account/login.html");
			exit;
		}
		// 显示页面
		$this->display();
	}
	// 我的游戏
	public function mygame(){
		// 没有登录
		if(!$_SESSION["ID"]){
			redirect("/Account/login.html");
			exit;
		}
		// 查询游戏
		$Data = M("YxRz");
		$rzList = $Data->field("yx_name,yx_jian,qf_id,qf_name,rz_date")
			->join("yeyou_yx ON yx_id = rz_yx")->join("yeyou_qf ON qf_id = rz_qf")
			->where("qf_kf > 0 AND qf_type = 1")
			->order("rz_date DESC")->limit(20)->select();
		$this->assign("rzList",$rzList);
		// 显示页面
		$this->display();
	}
	// 找回密码
	public function getmi(){
		
		import("@.iGuoji.Webgame");
		
		$Webgame = new Webgame();
		
		// 找回
		if($_POST){
			// 获取参数
			$name = ABC("name");
			$email = GET("email");
			if(!$name || !$email){
				$this->error("每一项都必须填写!");
				exit;
			}
			// 查询帐号
			$Data = M("Zh");
			$zhObj = $Data->where("zh_name = '$name'")->find();
			if(!$zhObj || $zhObj["zh_email"] != $email){
				$this->error("帐号或邮箱不正确!");
				exit;
			}
			// 发送邮件
			$Getmitime = cookie("Getmitime");
			if(time() - $Getmitime < 60){
				$this->error("一分钟内只能尝试一次找回!");
				exit;
			}
			$emailAction = new EmailAction();
			$rel = $emailAction->getmi($name,$email,$zhObj["zh_pass"]);
			cookie("Getmitime",time());
			if(!$rel){
				$this->error("找回失败，PHP模块未开启或未设置邮箱!".$rel);
				exit;
			}else{
				$this->success("找回成功，密码已经发送到您的邮箱!");
				exit;
			}
		}
		// 显示页面
		$this->display();
	}
	// 退出登录
	public function quit(){
		unset($_SESSION["ID"]);
		unset($_SESSION["ZH"]);
		redirect("/");
		exit;
	}
	// 在线登录
	public function login(){
		// 提交登录
		if($_POST){
			// 获取参数
			$name = strtolower(ABC("name",6,20));
			$pass = GET("pass");
			if(!$name || !$pass){
				$this->error("用户名或密码长度不正确!");
				exit;
			}
			// 查询帐号
			$Data = M("Zh");
			$zhObj = $Data->where("zh_name = '$name'")->find();
			if(!$zhObj){
				$this->error("该帐号不存在!");
				exit;
			}
			if($zhObj["zh_pass"] != $pass){
				$this->error("帐号或密码错误!");
				exit;
			}
			// 登录日志
			$Data = M("ZhRz");
			$rzData["rz_zh"] = $zhObj["zh_id"];
			$rzData["rz_type"] = 1001;
			$rzData["rz_ip"] = IP();
			$rzData["rz_date"] = time();
			$Data->add($rzData);
			// 登录成功
			$_SESSION["ID"] = $zhObj["zh_id"];
			$_SESSION["ZH"] = $zhObj["zh_name"];
			redirect("/");
			exit;
		}
		// 显示页面
		$this->display();
	}
	// 用户注册
	public function reg(){
		// 提交注册
		if($_POST){
			// 获取参数
			$name = strtolower(ABC("name",6,20));
			$pass = GET("pass");
			$repass = GET("repass");
			$email = GET("email");
			$xing = GET("xing");
			$sfz = GET("sfz");
			// 判断参数
			if(!$name){
				$this->error("帐号必须是6-20位字母和数字的组成!");
				exit;
			}
			if(!$pass){
				$this->error("密码必须填写!");
				exit;
			}
			if($repass != $pass){
				$this->error("确认密码必须与登录密码一致!");
				exit;
			}
			if(!$email){
				$this->error("邮箱必须填写!");
				exit;
			}
			if(!$xing){
				$this->error("真实姓名必须填写!");
				exit;
			}
			if(!$sfz){
				$this->error("证件号码必须填写!");
				exit;
			}
			// 查询帐号
			$Data = M("Zh");
			$zhObj = $Data->where("zh_name = '$name'")->find();
			if($zhObj){
				$this->error("该帐号已经存在!");
				exit;
			}
			// 添加帐号
			$Data = M("Zh");
			$zhData["zh_name"] = $name;
			$zhData["zh_pass"] = $pass;
			$zhData["zh_email"] = $email;
			$zhData["zh_xing"] = $xing;
			$zhData["zh_sfz"] = $sfz;
			$zhData["zh_ip"] = IP();
			$zhData["zh_date"] = time();
			$userID = $Data->add($zhData);
			if($userID === false){
				$this->error("注册失败!");
				exit;
			}
			// 注册成功
			$_SESSION["ID"] = $userID;
			$_SESSION["ZH"] = $name;
			redirect("/");
			exit;
		}
		// 显示页面
		$this->display();
	}
}
?>