/* 创建数据库 */
DROP DATABASE IF EXISTS webgame;
CREATE DATABASE webgame DEFAULT CHARACTER SET UTF8;
USE webgame;

/* 创建广告表 */
DROP TABLE IF EXISTS yeyou_ad;
CREATE TABLE yeyou_ad(
        ad_id INT PRIMARY KEY AUTO_INCREMENT,
        ad_idx INT,
        ad_type INT,
        ad_name VARCHAR(100),
        ad_url TEXT,
        ad_image TEXT,
        ad_date INT
) ENGINE = INNODB DEFAULT CHARSET = UTF8;

/* 创建订单表 */
DROP TABLE IF EXISTS yeyou_dd;
CREATE TABLE yeyou_dd(
        dd_id VARCHAR(50) PRIMARY KEY,
        dd_step INT,
        dd_zh INT,
        dd_yx INT,
        dd_qf INT,
        dd_fs INT,
        dd_money INT,
        dd_yb INT,
        dd_date INT
) ENGINE = INNODB DEFAULT CHARSET = UTF8;

/* 创建友链表 */
DROP TABLE IF EXISTS yeyou_lk;
CREATE TABLE yeyou_lk(
        lk_id INT PRIMARY KEY AUTO_INCREMENT,
        lk_idx INT,
        lk_text VARCHAR(100),
        lk_url TEXT,
        lk_date INT
) ENGINE = INNODB DEFAULT CHARSET = UTF8;

/* 创建游戏表 */
DROP TABLE IF EXISTS yeyou_yx;
CREATE TABLE yeyou_yx(
        yx_id INT PRIMARY KEY,
        yx_idx INT,
        yx_jian VARCHAR(30),
        yx_name VARCHAR(50),
        yx_tags VARCHAR(10),
        yx_bili INT,
        yx_danwei VARCHAR(10),
        yx_desp TEXT
) ENGINE = INNODB DEFAULT CHARSET = UTF8;

/* 创建区服表 */
DROP TABLE IF EXISTS yeyou_qf;
CREATE TABLE yeyou_qf(
        qf_id INT PRIMARY KEY,
        qf_yx INT,
        qf_kf INT,	#必要
        qf_name VARCHAR(20),
        qf_type INT,	#0:不开服	1:要开服
        qf_open INT,
        qf_date INT
) ENGINE = INNODB DEFAULT CHARSET = UTF8;

/* 创建游戏日志表 */
DROP TABLE IF EXISTS yeyou_yx_rz;
CREATE TABLE yeyou_yx_rz(
        rz_id INT PRIMARY KEY AUTO_INCREMENT,
        rz_yx INT,
        rz_qf INT,
        rz_zh INT,
        rz_ip VARCHAR(20),
        rz_date INT
) ENGINE = INNODB DEFAULT CHARSET = UTF8;

/* 创建新闻表 */
DROP TABLE IF EXISTS yeyou_xw;
CREATE TABLE yeyou_xw(
        xw_id INT PRIMARY KEY AUTO_INCREMENT,
        xw_yx INT,
        xw_type INT,
        xw_title VARCHAR(100),
        xw_content TEXT,
        xw_date INT
) ENGINE = INNODB DEFAULT CHARSET = UTF8;

/* 创建帐号表 */
DROP TABLE IF EXISTS yeyou_zh;
CREATE TABLE yeyou_zh(
        zh_id INT PRIMARY KEY AUTO_INCREMENT,
        zh_name VARCHAR(30),
        zh_pass VARCHAR(50),
        zh_email VARCHAR(60),
        zh_xing VARCHAR(10),
        zh_sfz VARCHAR(20),
        zh_ip VARCHAR(20),
        zh_date INT
) ENGINE = INNODB DEFAULT CHARSET = UTF8;