DROP TABLE IF EXISTS `retengcms_admin`;
CREATE TABLE `retengcms_admin` (
  `userid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` char(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `logintime` varchar(10) NOT NULL,
  `allowmultilogin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `roleid` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_admin_cache`;
CREATE TABLE `retengcms_admin_cache` (
  `userid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` char(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `logintime` varchar(10) NOT NULL,
  `allowmultilogin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `roleid` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MEMORY AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_appointment`;
CREATE TABLE `retengcms_appointment` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `username` varchar(40) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `appdate` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_article`;
CREATE TABLE `retengcms_article` (
  `contentid` mediumint(8) NOT NULL,
  `content` mediumtext NOT NULL,
  `editor` varchar(30) NOT NULL,
  `copyfrom` varchar(100) NOT NULL,
  `video` varchar(255) NOT NULL,
  KEY `contentid` (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_author`;
CREATE TABLE `retengcms_author` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `orderby` int(6) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_badwords`;
CREATE TABLE `retengcms_badwords` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `badwords` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_badwords` VALUES('1','');
DROP TABLE IF EXISTS `retengcms_cache`;
CREATE TABLE `retengcms_cache` (
  `name` varchar(32) NOT NULL,
  `value` mediumtext NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_category`;
CREATE TABLE `retengcms_category` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `modelid` int(6) NOT NULL,
  `parentid` int(6) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `catname` varchar(60) NOT NULL,
  `domain` varchar(100) NOT NULL,
  `image` varchar(100) NOT NULL DEFAULT 'images/image128x128.png',
  `catdir` varchar(100) NOT NULL,
  `url` varchar(100) NOT NULL,
  `setting` text NOT NULL,
  `orderby` int(6) unsigned NOT NULL,
  `ispost` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ismenu` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `m` tinyint(2) NOT NULL DEFAULT '1',
  `expand` text NOT NULL,
  `siteid` smallint(4) unsigned NOT NULL,
  `content` text,
  `navtype` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `modelid` (`modelid`,`parentid`,`type`),
  KEY `catdir` (`catdir`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_category` VALUES('3','0','0','3','友情链接','','images/image128x128.png','link','link/','','3','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('15','-1','0','2','服务项目','','images/image128x128.png','/html/fuwuxiangmu/','/html/fuwuxiangmu/','array (\n  \'catishtml\' => \'1\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_page\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','15','1','1','1','','1','','3');
REPLACE INTO `retengcms_category` VALUES('9','0','0','3','站外链接','','images/image128x128.png','workbox','','','9','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('11','0','0','3','留言管理','','images/image128x128.png','guestbook','guestbook/','','11','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('14','-1','0','2','关于我们','','images/image128x128.png','/html/guanyuwomen/','/html/guanyuwomen/','array (\n  \'catishtml\' => \'1\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_page\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','14','1','1','1','','1','','3');
REPLACE INTO `retengcms_category` VALUES('16','-1','15','2','服务流程','','images/image128x128.png','/html/fuwuliucheng/','/html/fuwuliucheng/','array (\n  \'catishtml\' => \'1\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_page\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','16','1','1','2','','1','','2');
REPLACE INTO `retengcms_category` VALUES('17','-1','15','2','售后服务','','images/image128x128.png','/html/shouhoufuwu/','/html/shouhoufuwu/','array (\n  \'catishtml\' => \'1\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_page\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','17','1','1','2','','1','','2');
REPLACE INTO `retengcms_category` VALUES('18','1','0','1','客户案例','','images/image128x128.png','/html/kehuanli/','/html/kehuanli/','array (\n  \'catishtml\' => \'1\',\n  \'ishtml\' => \'1\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_case\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','18','0','1','1','','1','','3');
REPLACE INTO `retengcms_category` VALUES('19','1','0','1','常见问题','','images/image128x128.png','/html/changjianwenti/','/html/changjianwenti/','array (\n  \'catishtml\' => \'1\',\n  \'ishtml\' => \'1\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','19','0','1','1','','1','','3');
REPLACE INTO `retengcms_category` VALUES('20','1','0','1','新闻中心','','images/image128x128.png','/html/xinwenzhongxin/','/html/xinwenzhongxin/','array (\n  \'catishtml\' => \'1\',\n  \'ishtml\' => \'1\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','20','0','1','1','','1','','3');
REPLACE INTO `retengcms_category` VALUES('21','1','20','1','公司新闻','','images/image128x128.png','/html/gongsixinwen/','/html/gongsixinwen/','array (\n  \'catishtml\' => \'1\',\n  \'ishtml\' => \'1\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','21','0','1','2','','1','','2');
REPLACE INTO `retengcms_category` VALUES('22','1','20','1','行业动态','','images/image128x128.png','/html/xingyedongtai/','/html/xingyedongtai/','array (\n  \'catishtml\' => \'1\',\n  \'ishtml\' => \'1\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','22','0','1','2','','1','','2');
REPLACE INTO `retengcms_category` VALUES('23','1','0','1','产品展示','','images/image128x128.png','/html/chanpinzhanshi/','/html/chanpinzhanshi/','array (\n  \'catishtml\' => \'1\',\n  \'ishtml\' => \'1\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_case\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','23','0','1','1','','1','','3');
REPLACE INTO `retengcms_category` VALUES('24','-1','0','2','在线留言','','images/image128x128.png','/html/zaixianliuyan/','/html/zaixianliuyan/','array (\n  \'catishtml\' => \'1\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_guestbook\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','24','1','1','1','','1','','3');
REPLACE INTO `retengcms_category` VALUES('25','-1','0','2','联系我们','','images/image128x128.png','/html/lianxiwomen/','/html/lianxiwomen/','array (\n  \'catishtml\' => \'1\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_contact\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','25','1','1','1','','1','','3');
DROP TABLE IF EXISTS `retengcms_category_roleid`;
CREATE TABLE `retengcms_category_roleid` (
  `adminid` int(8) NOT NULL,
  `catid` varchar(100) NOT NULL,
  UNIQUE KEY `roleid` (`adminid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_category_roleid` VALUES('1','22,19,20,21,30');
DROP TABLE IF EXISTS `retengcms_comment`;
CREATE TABLE `retengcms_comment` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` mediumint(8) unsigned NOT NULL,
  `contentid` mediumint(8) NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL,
  `userface` varchar(100) NOT NULL,
  `support` smallint(5) unsigned NOT NULL DEFAULT '0',
  `against` smallint(5) unsigned NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  `addtime` varchar(10) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`,`status`,`id`,`contentid`),
  KEY `status` (`status`,`contentid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_company`;
CREATE TABLE `retengcms_company` (
  `userid` mediumint(8) NOT NULL,
  `address` varchar(100) NOT NULL,
  `about` mediumtext NOT NULL,
  `busroute` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `openingtime` varchar(20) NOT NULL,
  `shenfenzheng` varchar(200) NOT NULL,
  `zhizhao` varchar(200) NOT NULL,
  `qq` varchar(20) NOT NULL,
  `pics` mediumtext NOT NULL,
  `dianhua` varchar(30) NOT NULL,
  `dizhi` varchar(200) NOT NULL,
  `lianxiren` varchar(30) NOT NULL,
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_config`;
CREATE TABLE `retengcms_config` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `groupid` smallint(6) NOT NULL DEFAULT '1',
  `varname` varchar(20) NOT NULL DEFAULT '',
  `desc` varchar(100) NOT NULL DEFAULT '',
  `alt` varchar(100) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'string',
  `value` text,
  `system` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_config` VALUES('1','1','site_name','网站名称','','string','热腾CMS（RTCMS）企业模板','1','1');
REPLACE INTO `retengcms_config` VALUES('2','1','childsite_url','网站地址','请填写完整URL地址，以\"/\"结尾','string','http://localhost/','1','1');
REPLACE INTO `retengcms_config` VALUES('3','1','tpl_name','默认模板','','string','default','1','1');
REPLACE INTO `retengcms_config` VALUES('4','1','meta_title','网站副标题','','string','ReTengCMS网站内容管理系统','1','1');
REPLACE INTO `retengcms_config` VALUES('5','1','meta_keywords','网站关键字','设置Meta标签的关键字，用英文逗号分隔','string','热腾CMS,RTCMS模板,ReTengCMS,开源,PHPCMS,PHP网站程序,CMS内容管理系统','1','1');
REPLACE INTO `retengcms_config` VALUES('6','1','meta_description','网站描述','设置Meta标签的描述信息','bstring','热腾CMS是集简单、灵活、开源几大特点的开源内容管理系统,完全符合SEO，是企业和个人建设网站的首选CMS系统。','1','1');
REPLACE INTO `retengcms_config` VALUES('7','1','separator','导航分隔符','如：网站首页 > 新闻','string','>','1','1');
REPLACE INTO `retengcms_config` VALUES('8','1','htmlext','HTML后缀','HTML后缀不要经常修改!修改后请更新内容。','string','.htm','1','1');
REPLACE INTO `retengcms_config` VALUES('9','1','iscity','只读取默认地区数据','开启后, 将自动读取默认地区数据，其他地区数据将不显示在前台。','bool','0','1','1');
REPLACE INTO `retengcms_config` VALUES('10','1','city','默认地区名','','string','615','1','1');
REPLACE INTO `retengcms_config` VALUES('11','1','map','地图精准定位','','string','120.1888,30.249800','1','1');
REPLACE INTO `retengcms_config` VALUES('12','1','ishtml','首页是否静态化','','string','0','1','1');
REPLACE INTO `retengcms_config` VALUES('13','1','copyright','版权信息','','string','CopyRight © 2014 <a href=\"http://cms.reteng.org\" target=\"_blank\" style=\"text-decoration:none;\">热腾网</a> RETENG.Org, All Rights Reserved.','1','1');
REPLACE INTO `retengcms_config` VALUES('14','1','icpno','网站ICP备案序号','','string','','1','1');
REPLACE INTO `retengcms_config` VALUES('15','1','logo','网站logo','','image','/images/logo.png','1','1');
DROP TABLE IF EXISTS `retengcms_content`;
CREATE TABLE `retengcms_content` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `modelid` int(6) NOT NULL,
  `catid` int(6) unsigned NOT NULL DEFAULT '0',
  `areaid` smallint(6) NOT NULL,
  `template` char(100) NOT NULL,
  `title` char(160) NOT NULL,
  `style` char(30) NOT NULL,
  `thumb` char(100) NOT NULL DEFAULT '',
  `keywords` char(100) NOT NULL,
  `description` char(255) NOT NULL,
  `posid` tinyint(1) NOT NULL DEFAULT '0',
  `url` char(100) NOT NULL DEFAULT 'http://',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '99',
  `point` smallint(5) NOT NULL DEFAULT '0',
  `amount` decimal(8,2) NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(80) NOT NULL,
  `inputtime` char(10) NOT NULL,
  `updatetime` char(10) NOT NULL,
  `clicks` int(5) unsigned NOT NULL DEFAULT '0',
  `comments` int(5) unsigned NOT NULL DEFAULT '0',
  `islink` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `password` varchar(32) NOT NULL,
  `expire` int(4) NOT NULL DEFAULT '0',
  `ispage` tinyint(1) NOT NULL DEFAULT '0',
  `pagecount` int(4) NOT NULL DEFAULT '5000',
  `iscomment` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `orderby` mediumint(8) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  `navtype` varchar(100) NOT NULL,
  `support` int(11) NOT NULL DEFAULT '0',
  `oppose` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `catid` (`catid`,`status`,`id`,`areaid`),
  KEY `status` (`status`,`id`),
  KEY `userid` (`userid`),
  KEY `modelid` (`modelid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_content_posid`;
CREATE TABLE `retengcms_content_posid` (
  `contentid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `posid` smallint(5) unsigned NOT NULL DEFAULT '0',
  KEY `posid` (`posid`),
  KEY `contentid` (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_copyfrom`;
CREATE TABLE `retengcms_copyfrom` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT 'http://',
  `orderby` int(6) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_copyfrom` VALUES('1','本站原创','http://','0','1');
DROP TABLE IF EXISTS `retengcms_counts`;
CREATE TABLE `retengcms_counts` (
  `id` char(32) NOT NULL DEFAULT '',
  `count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_fankui`;
CREATE TABLE `retengcms_fankui` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_guestbook`;
CREATE TABLE `retengcms_guestbook` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `title` char(200) NOT NULL,
  `email` varchar(40) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `sex` varchar(6) NOT NULL,
  `content` text NOT NULL,
  `reply` text NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(20) NOT NULL,
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `passed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL,
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  `replyer` char(20) NOT NULL,
  `replytime` int(10) unsigned NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `hidden` (`hidden`,`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_link`;
CREATE TABLE `retengcms_link` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `typeid` smallint(4) NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(80) NOT NULL,
  `logo` varchar(100) NOT NULL DEFAULT '',
  `introduce` varchar(255) NOT NULL,
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `addtime` char(10) NOT NULL,
  `isindex` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `orderby` smallint(5) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`typeid`),
  KEY `typeid` (`typeid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_link` VALUES('1','1','热腾网','http://www.reteng.org','','','','0','1357653685','1','1','1');
DROP TABLE IF EXISTS `retengcms_linktype`;
CREATE TABLE `retengcms_linktype` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `orderby` smallint(5) NOT NULL,
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `disabled` (`disabled`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_linktype` VALUES('1','友情连接','0','1','1');
DROP TABLE IF EXISTS `retengcms_log`;
CREATE TABLE `retengcms_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `admin` char(64) NOT NULL DEFAULT '',
  `method` char(10) NOT NULL DEFAULT '',
  `query` char(200) NOT NULL DEFAULT '',
  `comeurl` varchar(200) NOT NULL,
  `ip` char(15) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=348 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_log` VALUES('1','游客','GET','file=login','http://localhost/admin.php','127.0.0.1','1406724042');
REPLACE INTO `retengcms_log` VALUES('2','游客','POST','file=login','http://localhost/admin.php?file=login','127.0.0.1','1406724050');
REPLACE INTO `retengcms_log` VALUES('3','admin','GET','file=top','http://localhost/admin.php','127.0.0.1','1406724052');
REPLACE INTO `retengcms_log` VALUES('4','admin','GET','file=main','http://localhost/admin.php','127.0.0.1','1406724052');
REPLACE INTO `retengcms_log` VALUES('5','admin','GET','file=config&action=config&tab=1','http://localhost/admin.php?file=left','127.0.0.1','1406724055');
REPLACE INTO `retengcms_log` VALUES('6','admin','POST','file=config&action=config&tab=1','http://localhost/admin.php?file=config&action=config&tab=1','127.0.0.1','1406724093');
REPLACE INTO `retengcms_log` VALUES('7','admin','GET','file=config&action=config&tab=1','http://localhost/admin.php?file=left','127.0.0.1','1406724095');
REPLACE INTO `retengcms_log` VALUES('8','admin','GET','file=config&action=config&tab=1','http://localhost/admin.php?file=left&menu=system','127.0.0.1','1406724098');
REPLACE INTO `retengcms_log` VALUES('9','admin','POST','file=config&action=config&tab=1','http://localhost/admin.php?file=config&action=config&tab=1','127.0.0.1','1406724110');
REPLACE INTO `retengcms_log` VALUES('10','admin','GET','file=config&action=config&tab=1','http://localhost/admin.php?file=left&menu=system','127.0.0.1','1406724112');
REPLACE INTO `retengcms_log` VALUES('11','admin','GET','file=config&action=config_add','http://localhost/admin.php?file=config&action=config&tab=1','127.0.0.1','1406724116');
REPLACE INTO `retengcms_log` VALUES('12','admin','GET','file=config&action=config&tab=4','http://localhost/admin.php?file=left&menu=system','127.0.0.1','1406724118');
REPLACE INTO `retengcms_log` VALUES('13','admin','GET','file=config&action=config&tab=3','http://localhost/admin.php?file=left&menu=system','127.0.0.1','1406724119');
REPLACE INTO `retengcms_log` VALUES('14','admin','GET','file=module&action=manage','http://localhost/admin.php?file=left&menu=module','127.0.0.1','1406724130');
REPLACE INTO `retengcms_log` VALUES('15','admin','POST','file=module&action=delete','http://localhost/admin.php?file=module&action=manage','127.0.0.1','1406724152');
REPLACE INTO `retengcms_log` VALUES('16','admin','GET','file=module&action=manage','http://localhost/admin.php?file=left&menu=module','127.0.0.1','1406724154');
REPLACE INTO `retengcms_log` VALUES('17','admin','GET','file=top','http://localhost/admin.php','127.0.0.1','1406724156');
REPLACE INTO `retengcms_log` VALUES('18','admin','GET','file=main','http://localhost/admin.php','127.0.0.1','1406724156');
REPLACE INTO `retengcms_log` VALUES('19','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724167');
REPLACE INTO `retengcms_log` VALUES('20','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724198');
REPLACE INTO `retengcms_log` VALUES('21','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724200');
REPLACE INTO `retengcms_log` VALUES('22','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724201');
REPLACE INTO `retengcms_log` VALUES('23','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724260');
REPLACE INTO `retengcms_log` VALUES('24','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724261');
REPLACE INTO `retengcms_log` VALUES('25','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724264');
REPLACE INTO `retengcms_log` VALUES('26','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724281');
REPLACE INTO `retengcms_log` VALUES('27','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724283');
REPLACE INTO `retengcms_log` VALUES('28','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724304');
REPLACE INTO `retengcms_log` VALUES('29','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724370');
REPLACE INTO `retengcms_log` VALUES('30','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724371');
REPLACE INTO `retengcms_log` VALUES('31','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724389');
REPLACE INTO `retengcms_log` VALUES('32','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724391');
REPLACE INTO `retengcms_log` VALUES('33','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724403');
REPLACE INTO `retengcms_log` VALUES('34','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724422');
REPLACE INTO `retengcms_log` VALUES('35','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724424');
REPLACE INTO `retengcms_log` VALUES('36','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724425');
REPLACE INTO `retengcms_log` VALUES('37','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724438');
REPLACE INTO `retengcms_log` VALUES('38','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724440');
REPLACE INTO `retengcms_log` VALUES('39','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724441');
REPLACE INTO `retengcms_log` VALUES('40','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724450');
REPLACE INTO `retengcms_log` VALUES('41','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724451');
REPLACE INTO `retengcms_log` VALUES('42','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724452');
REPLACE INTO `retengcms_log` VALUES('43','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724463');
REPLACE INTO `retengcms_log` VALUES('44','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724465');
REPLACE INTO `retengcms_log` VALUES('45','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724469');
REPLACE INTO `retengcms_log` VALUES('46','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724476');
REPLACE INTO `retengcms_log` VALUES('47','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724477');
REPLACE INTO `retengcms_log` VALUES('48','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724478');
REPLACE INTO `retengcms_log` VALUES('49','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724491');
REPLACE INTO `retengcms_log` VALUES('50','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724493');
REPLACE INTO `retengcms_log` VALUES('51','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724517');
REPLACE INTO `retengcms_log` VALUES('52','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724518');
REPLACE INTO `retengcms_log` VALUES('53','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724538');
REPLACE INTO `retengcms_log` VALUES('54','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724539');
REPLACE INTO `retengcms_log` VALUES('55','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724545');
REPLACE INTO `retengcms_log` VALUES('56','admin','POST','file=category&action=add','http://localhost/admin.php?file=category&action=add','127.0.0.1','1406724552');
REPLACE INTO `retengcms_log` VALUES('57','admin','GET','file=category&action=add','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724554');
REPLACE INTO `retengcms_log` VALUES('58','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724570');
REPLACE INTO `retengcms_log` VALUES('59','admin','GET','file=category&action=edit&id=14','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724576');
REPLACE INTO `retengcms_log` VALUES('60','admin','POST','file=category&action=edit&id=14','http://localhost/admin.php?file=category&action=edit&id=14','127.0.0.1','1406724580');
REPLACE INTO `retengcms_log` VALUES('61','admin','GET','file=category&action=edit&id=14','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724581');
REPLACE INTO `retengcms_log` VALUES('62','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724584');
REPLACE INTO `retengcms_log` VALUES('63','admin','GET','file=category&action=edit&id=15','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724586');
REPLACE INTO `retengcms_log` VALUES('64','admin','POST','file=category&action=edit&id=15','http://localhost/admin.php?file=category&action=edit&id=15','127.0.0.1','1406724589');
REPLACE INTO `retengcms_log` VALUES('65','admin','GET','file=category&action=edit&id=15','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724591');
REPLACE INTO `retengcms_log` VALUES('66','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724593');
REPLACE INTO `retengcms_log` VALUES('67','admin','GET','file=category&action=edit&id=18','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724596');
REPLACE INTO `retengcms_log` VALUES('68','admin','POST','file=category&action=edit&id=18','http://localhost/admin.php?file=category&action=edit&id=18','127.0.0.1','1406724599');
REPLACE INTO `retengcms_log` VALUES('69','admin','GET','file=category&action=edit&id=18','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724600');
REPLACE INTO `retengcms_log` VALUES('70','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724602');
REPLACE INTO `retengcms_log` VALUES('71','admin','GET','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724603');
REPLACE INTO `retengcms_log` VALUES('72','admin','POST','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=edit&id=16','127.0.0.1','1406724608');
REPLACE INTO `retengcms_log` VALUES('73','admin','GET','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724609');
REPLACE INTO `retengcms_log` VALUES('74','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724610');
REPLACE INTO `retengcms_log` VALUES('75','admin','GET','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724612');
REPLACE INTO `retengcms_log` VALUES('76','admin','POST','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=edit&id=17','127.0.0.1','1406724618');
REPLACE INTO `retengcms_log` VALUES('77','admin','GET','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724619');
REPLACE INTO `retengcms_log` VALUES('78','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724621');
REPLACE INTO `retengcms_log` VALUES('79','admin','GET','file=category&action=edit&id=18','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724628');
REPLACE INTO `retengcms_log` VALUES('80','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724629');
REPLACE INTO `retengcms_log` VALUES('81','admin','GET','file=category&action=edit&id=19','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724633');
REPLACE INTO `retengcms_log` VALUES('82','admin','POST','file=category&action=edit&id=19','http://localhost/admin.php?file=category&action=edit&id=19','127.0.0.1','1406724638');
REPLACE INTO `retengcms_log` VALUES('83','admin','GET','file=category&action=edit&id=19','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724639');
REPLACE INTO `retengcms_log` VALUES('84','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724642');
REPLACE INTO `retengcms_log` VALUES('85','admin','GET','file=category&action=edit&id=20','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724645');
REPLACE INTO `retengcms_log` VALUES('86','admin','POST','file=category&action=edit&id=20','http://localhost/admin.php?file=category&action=edit&id=20','127.0.0.1','1406724648');
REPLACE INTO `retengcms_log` VALUES('87','admin','GET','file=category&action=edit&id=20','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724649');
REPLACE INTO `retengcms_log` VALUES('88','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724650');
REPLACE INTO `retengcms_log` VALUES('89','admin','GET','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724653');
REPLACE INTO `retengcms_log` VALUES('90','admin','POST','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=edit&id=21','127.0.0.1','1406724657');
REPLACE INTO `retengcms_log` VALUES('91','admin','GET','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724658');
REPLACE INTO `retengcms_log` VALUES('92','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724659');
REPLACE INTO `retengcms_log` VALUES('93','admin','GET','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724661');
REPLACE INTO `retengcms_log` VALUES('94','admin','POST','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=edit&id=22','127.0.0.1','1406724665');
REPLACE INTO `retengcms_log` VALUES('95','admin','GET','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724667');
REPLACE INTO `retengcms_log` VALUES('96','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724668');
REPLACE INTO `retengcms_log` VALUES('97','admin','GET','file=category&action=edit&id=23','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724673');
REPLACE INTO `retengcms_log` VALUES('98','admin','POST','file=category&action=edit&id=23','http://localhost/admin.php?file=category&action=edit&id=23','127.0.0.1','1406724675');
REPLACE INTO `retengcms_log` VALUES('99','admin','GET','file=category&action=edit&id=23','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724677');
REPLACE INTO `retengcms_log` VALUES('100','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724679');
REPLACE INTO `retengcms_log` VALUES('101','admin','GET','file=category&action=edit&id=24','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724681');
REPLACE INTO `retengcms_log` VALUES('102','admin','POST','file=category&action=edit&id=24','http://localhost/admin.php?file=category&action=edit&id=24','127.0.0.1','1406724686');
REPLACE INTO `retengcms_log` VALUES('103','admin','GET','file=category&action=edit&id=24','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724687');
REPLACE INTO `retengcms_log` VALUES('104','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724688');
REPLACE INTO `retengcms_log` VALUES('105','admin','GET','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724690');
REPLACE INTO `retengcms_log` VALUES('106','admin','POST','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=edit&id=25','127.0.0.1','1406724693');
REPLACE INTO `retengcms_log` VALUES('107','admin','GET','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724695');
REPLACE INTO `retengcms_log` VALUES('108','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724766');
REPLACE INTO `retengcms_log` VALUES('109','admin','GET','file=html&action=cache','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406724768');
REPLACE INTO `retengcms_log` VALUES('110','admin','GET','file=html&action=cache_template','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406724769');
REPLACE INTO `retengcms_log` VALUES('111','admin','GET','file=html&action=cache_tag','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406724769');
REPLACE INTO `retengcms_log` VALUES('112','admin','GET','file=html&action=cache','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406724770');
REPLACE INTO `retengcms_log` VALUES('113','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724788');
REPLACE INTO `retengcms_log` VALUES('114','admin','GET','file=category&action=edit&id=14','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724790');
REPLACE INTO `retengcms_log` VALUES('115','admin','POST','file=category&action=edit&id=14','http://localhost/admin.php?file=category&action=edit&id=14','127.0.0.1','1406724807');
REPLACE INTO `retengcms_log` VALUES('116','admin','GET','file=category&action=edit&id=14','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724808');
REPLACE INTO `retengcms_log` VALUES('117','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724810');
REPLACE INTO `retengcms_log` VALUES('118','admin','GET','file=category&action=edit&id=15','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724812');
REPLACE INTO `retengcms_log` VALUES('119','admin','POST','file=category&action=edit&id=15','http://localhost/admin.php?file=category&action=edit&id=15','127.0.0.1','1406724820');
REPLACE INTO `retengcms_log` VALUES('120','admin','GET','file=category&action=edit&id=15','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724821');
REPLACE INTO `retengcms_log` VALUES('121','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724823');
REPLACE INTO `retengcms_log` VALUES('122','admin','GET','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724825');
REPLACE INTO `retengcms_log` VALUES('123','admin','POST','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=edit&id=16','127.0.0.1','1406724837');
REPLACE INTO `retengcms_log` VALUES('124','admin','GET','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724838');
REPLACE INTO `retengcms_log` VALUES('125','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724840');
REPLACE INTO `retengcms_log` VALUES('126','admin','GET','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724844');
REPLACE INTO `retengcms_log` VALUES('127','admin','POST','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=edit&id=17','127.0.0.1','1406724850');
REPLACE INTO `retengcms_log` VALUES('128','admin','GET','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724851');
REPLACE INTO `retengcms_log` VALUES('129','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724853');
REPLACE INTO `retengcms_log` VALUES('130','admin','GET','file=category&action=edit&id=18','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724856');
REPLACE INTO `retengcms_log` VALUES('131','admin','POST','file=category&action=edit&id=18','http://localhost/admin.php?file=category&action=edit&id=18','127.0.0.1','1406724862');
REPLACE INTO `retengcms_log` VALUES('132','admin','GET','file=category&action=edit&id=18','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724863');
REPLACE INTO `retengcms_log` VALUES('133','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724864');
REPLACE INTO `retengcms_log` VALUES('134','admin','GET','file=category&action=edit&id=19','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724886');
REPLACE INTO `retengcms_log` VALUES('135','admin','POST','file=category&action=edit&id=19','http://localhost/admin.php?file=category&action=edit&id=19','127.0.0.1','1406724889');
REPLACE INTO `retengcms_log` VALUES('136','admin','GET','file=category&action=edit&id=19','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724891');
REPLACE INTO `retengcms_log` VALUES('137','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724892');
REPLACE INTO `retengcms_log` VALUES('138','admin','GET','file=category&action=edit&id=20','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724895');
REPLACE INTO `retengcms_log` VALUES('139','admin','POST','file=category&action=edit&id=20','http://localhost/admin.php?file=category&action=edit&id=20','127.0.0.1','1406724898');
REPLACE INTO `retengcms_log` VALUES('140','admin','GET','file=category&action=edit&id=20','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724899');
REPLACE INTO `retengcms_log` VALUES('141','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724901');
REPLACE INTO `retengcms_log` VALUES('142','admin','GET','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724905');
REPLACE INTO `retengcms_log` VALUES('143','admin','POST','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=edit&id=21','127.0.0.1','1406724910');
REPLACE INTO `retengcms_log` VALUES('144','admin','GET','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724911');
REPLACE INTO `retengcms_log` VALUES('145','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724913');
REPLACE INTO `retengcms_log` VALUES('146','admin','GET','file=category&action=edit&id=20','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724915');
REPLACE INTO `retengcms_log` VALUES('147','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724917');
REPLACE INTO `retengcms_log` VALUES('148','admin','GET','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724919');
REPLACE INTO `retengcms_log` VALUES('149','admin','POST','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=edit&id=22','127.0.0.1','1406724921');
REPLACE INTO `retengcms_log` VALUES('150','admin','GET','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724923');
REPLACE INTO `retengcms_log` VALUES('151','admin','POST','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=edit&id=22','127.0.0.1','1406724928');
REPLACE INTO `retengcms_log` VALUES('152','admin','GET','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724929');
REPLACE INTO `retengcms_log` VALUES('153','admin','POST','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=edit&id=22','127.0.0.1','1406724931');
REPLACE INTO `retengcms_log` VALUES('154','admin','GET','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724932');
REPLACE INTO `retengcms_log` VALUES('155','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724933');
REPLACE INTO `retengcms_log` VALUES('156','admin','GET','file=category&action=edit&id=23','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724936');
REPLACE INTO `retengcms_log` VALUES('157','admin','POST','file=category&action=edit&id=23','http://localhost/admin.php?file=category&action=edit&id=23','127.0.0.1','1406724941');
REPLACE INTO `retengcms_log` VALUES('158','admin','GET','file=category&action=edit&id=23','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724942');
REPLACE INTO `retengcms_log` VALUES('159','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724943');
REPLACE INTO `retengcms_log` VALUES('160','admin','GET','file=category&action=edit&id=24','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724947');
REPLACE INTO `retengcms_log` VALUES('161','admin','POST','file=category&action=edit&id=24','http://localhost/admin.php?file=category&action=edit&id=24','127.0.0.1','1406724950');
REPLACE INTO `retengcms_log` VALUES('162','admin','GET','file=category&action=edit&id=24','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724951');
REPLACE INTO `retengcms_log` VALUES('163','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724952');
REPLACE INTO `retengcms_log` VALUES('164','admin','GET','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724955');
REPLACE INTO `retengcms_log` VALUES('165','admin','POST','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=edit&id=25','127.0.0.1','1406724960');
REPLACE INTO `retengcms_log` VALUES('166','admin','GET','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724961');
REPLACE INTO `retengcms_log` VALUES('167','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724976');
REPLACE INTO `retengcms_log` VALUES('168','admin','GET','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724981');
REPLACE INTO `retengcms_log` VALUES('169','admin','POST','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=edit&id=16','127.0.0.1','1406724985');
REPLACE INTO `retengcms_log` VALUES('170','admin','GET','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724986');
REPLACE INTO `retengcms_log` VALUES('171','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724987');
REPLACE INTO `retengcms_log` VALUES('172','admin','GET','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724989');
REPLACE INTO `retengcms_log` VALUES('173','admin','POST','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=edit&id=17','127.0.0.1','1406724993');
REPLACE INTO `retengcms_log` VALUES('174','admin','GET','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406724995');
REPLACE INTO `retengcms_log` VALUES('175','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406724996');
REPLACE INTO `retengcms_log` VALUES('176','admin','GET','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406725004');
REPLACE INTO `retengcms_log` VALUES('177','admin','POST','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=edit&id=21','127.0.0.1','1406725007');
REPLACE INTO `retengcms_log` VALUES('178','admin','GET','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406725008');
REPLACE INTO `retengcms_log` VALUES('179','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406725010');
REPLACE INTO `retengcms_log` VALUES('180','admin','GET','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406725012');
REPLACE INTO `retengcms_log` VALUES('181','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406725016');
REPLACE INTO `retengcms_log` VALUES('182','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406725343');
REPLACE INTO `retengcms_log` VALUES('183','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406725425');
REPLACE INTO `retengcms_log` VALUES('184','admin','GET','file=top','http://localhost/admin.php','127.0.0.1','1406725578');
REPLACE INTO `retengcms_log` VALUES('185','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406725579');
REPLACE INTO `retengcms_log` VALUES('186','admin','GET','file=html&action=cache','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406725722');
REPLACE INTO `retengcms_log` VALUES('187','admin','GET','file=html&action=all','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406725723');
REPLACE INTO `retengcms_log` VALUES('188','admin','POST','file=html&action=all','http://localhost/admin.php?file=html&action=all','127.0.0.1','1406725724');
REPLACE INTO `retengcms_log` VALUES('189','admin','GET','file=html&action=cache&job=cache','http://localhost/admin.php?file=html&action=all','127.0.0.1','1406725724');
REPLACE INTO `retengcms_log` VALUES('190','admin','GET','file=html&action=index&job=index','http://localhost/admin.php?file=html&action=cache&job=cache','127.0.0.1','1406725725');
REPLACE INTO `retengcms_log` VALUES('191','admin','GET','file=html&action=category&do_submit=1&job=cat&catid=1','http://localhost/admin.php?file=html&action=index&job=index','127.0.0.1','1406725726');
REPLACE INTO `retengcms_log` VALUES('192','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat&catid=1','127.0.0.1','1406725727');
REPLACE INTO `retengcms_log` VALUES('193','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725727');
REPLACE INTO `retengcms_log` VALUES('194','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725727');
REPLACE INTO `retengcms_log` VALUES('195','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725727');
REPLACE INTO `retengcms_log` VALUES('196','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725728');
REPLACE INTO `retengcms_log` VALUES('197','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725728');
REPLACE INTO `retengcms_log` VALUES('198','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725728');
REPLACE INTO `retengcms_log` VALUES('199','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725728');
REPLACE INTO `retengcms_log` VALUES('200','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725729');
REPLACE INTO `retengcms_log` VALUES('201','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725729');
REPLACE INTO `retengcms_log` VALUES('202','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725729');
REPLACE INTO `retengcms_log` VALUES('203','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725729');
REPLACE INTO `retengcms_log` VALUES('204','admin','GET','file=html&action=category&do_submit=1&job=cat','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725729');
REPLACE INTO `retengcms_log` VALUES('205','admin','GET','file=html&action=content&do_submit=1&job=con&catid=1&type=all&pagesize=50','http://localhost/admin.php?file=html&action=category&do_submit=1&job=cat','127.0.0.1','1406725731');
REPLACE INTO `retengcms_log` VALUES('206','admin','GET','file=html&action=content&do_submit=1&inlink=0&count=0&pagesize=50&job=con','http://localhost/admin.php?file=html&action=content&do_submit=1&job=con&catid=1&type=all&pagesize=50','127.0.0.1','1406725731');
REPLACE INTO `retengcms_log` VALUES('207','admin','GET','file=html&action=rss&job=rss','http://localhost/admin.php?file=html&action=content&do_submit=1&inlink=0&count=0&pagesize=50&job=con','127.0.0.1','1406725733');
REPLACE INTO `retengcms_log` VALUES('208','admin','GET','file=html&action=all','http://localhost/admin.php?file=html&action=rss&job=rss','127.0.0.1','1406725734');
REPLACE INTO `retengcms_log` VALUES('209','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406725765');
REPLACE INTO `retengcms_log` VALUES('210','admin','GET','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406725773');
REPLACE INTO `retengcms_log` VALUES('211','admin','POST','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=edit&id=25','127.0.0.1','1406725782');
REPLACE INTO `retengcms_log` VALUES('212','admin','GET','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406725783');
REPLACE INTO `retengcms_log` VALUES('213','admin','GET','file=html&action=category','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406725787');
REPLACE INTO `retengcms_log` VALUES('214','admin','POST','file=html&action=category','http://localhost/admin.php?file=html&action=category','127.0.0.1','1406725789');
REPLACE INTO `retengcms_log` VALUES('215','admin','GET','file=html&action=category&do_submit=1&job=','http://localhost/admin.php?file=html&action=category','127.0.0.1','1406725790');
REPLACE INTO `retengcms_log` VALUES('216','admin','GET','file=html&action=category&do_submit=1&job=','http://localhost/admin.php?file=html&action=category&do_submit=1&job=','127.0.0.1','1406725790');
REPLACE INTO `retengcms_log` VALUES('217','admin','GET','file=html&action=category','http://localhost/admin.php?file=html&action=category&do_submit=1&job=','127.0.0.1','1406725791');
REPLACE INTO `retengcms_log` VALUES('218','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406725808');
REPLACE INTO `retengcms_log` VALUES('219','admin','GET','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406725915');
REPLACE INTO `retengcms_log` VALUES('220','admin','POST','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=edit&id=25','127.0.0.1','1406725920');
REPLACE INTO `retengcms_log` VALUES('221','admin','GET','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406725922');
REPLACE INTO `retengcms_log` VALUES('222','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406725923');
REPLACE INTO `retengcms_log` VALUES('223','admin','GET','file=category&action=edit&id=24','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406725926');
REPLACE INTO `retengcms_log` VALUES('224','admin','POST','file=category&action=edit&id=24','http://localhost/admin.php?file=category&action=edit&id=24','127.0.0.1','1406725929');
REPLACE INTO `retengcms_log` VALUES('225','admin','GET','file=category&action=edit&id=24','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406725930');
REPLACE INTO `retengcms_log` VALUES('226','admin','GET','file=module&action=manage','http://localhost/admin.php?file=left&menu=module','127.0.0.1','1406725942');
REPLACE INTO `retengcms_log` VALUES('227','admin','POST','file=module&action=disabled','http://localhost/admin.php?file=module&action=manage','127.0.0.1','1406725949');
REPLACE INTO `retengcms_log` VALUES('228','admin','GET','file=module&action=manage','http://localhost/admin.php?file=left&menu=module','127.0.0.1','1406725950');
REPLACE INTO `retengcms_log` VALUES('229','admin','GET','mod=form&file=form&action=manage','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725955');
REPLACE INTO `retengcms_log` VALUES('230','admin','GET','mod=form&file=form&action=add','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725956');
REPLACE INTO `retengcms_log` VALUES('231','admin','GET','mod=form&file=form&action=manage','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725957');
REPLACE INTO `retengcms_log` VALUES('232','admin','GET','file=module&action=manage','http://localhost/admin.php?file=left&menu=module','127.0.0.1','1406725974');
REPLACE INTO `retengcms_log` VALUES('233','admin','POST','file=module&action=disabled','http://localhost/admin.php?file=module&action=manage','127.0.0.1','1406725980');
REPLACE INTO `retengcms_log` VALUES('234','admin','GET','file=module&action=manage','http://localhost/admin.php?file=left&menu=module','127.0.0.1','1406725981');
REPLACE INTO `retengcms_log` VALUES('235','admin','GET','file=module&action=manage','http://localhost/admin.php?file=left&menu=module','127.0.0.1','1406725981');
REPLACE INTO `retengcms_log` VALUES('236','admin','GET','file=top','http://localhost/admin.php','127.0.0.1','1406725983');
REPLACE INTO `retengcms_log` VALUES('237','admin','GET','file=main','http://localhost/admin.php','127.0.0.1','1406725983');
REPLACE INTO `retengcms_log` VALUES('238','admin','GET','mod=link&file=link&action=cache','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725987');
REPLACE INTO `retengcms_log` VALUES('239','admin','GET','mod=link&file=link&action=type','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725988');
REPLACE INTO `retengcms_log` VALUES('240','admin','GET','mod=link&file=link&action=type_add','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725988');
REPLACE INTO `retengcms_log` VALUES('241','admin','GET','mod=link&file=link&action=tag','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725989');
REPLACE INTO `retengcms_log` VALUES('242','admin','GET','mod=guestbook&file=guestbook&action=manage&passed=1','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725991');
REPLACE INTO `retengcms_log` VALUES('243','admin','GET','mod=guestbook&file=guestbook&action=manage&passed=0','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725992');
REPLACE INTO `retengcms_log` VALUES('244','admin','GET','mod=workbox&file=workbox&action=workbox','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725993');
REPLACE INTO `retengcms_log` VALUES('245','admin','GET','mod=workbox&file=workbox&action=tag','http://localhost/admin.php?file=left&menu=other','127.0.0.1','1406725994');
REPLACE INTO `retengcms_log` VALUES('246','admin','GET','file=main','http://localhost/admin.php','127.0.0.1','1406725998');
REPLACE INTO `retengcms_log` VALUES('247','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726009');
REPLACE INTO `retengcms_log` VALUES('248','admin','GET','file=category&action=edit&id=14','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726011');
REPLACE INTO `retengcms_log` VALUES('249','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726015');
REPLACE INTO `retengcms_log` VALUES('250','admin','GET','file=category&action=edit&id=15','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726017');
REPLACE INTO `retengcms_log` VALUES('251','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726021');
REPLACE INTO `retengcms_log` VALUES('252','admin','GET','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726023');
REPLACE INTO `retengcms_log` VALUES('253','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726026');
REPLACE INTO `retengcms_log` VALUES('254','admin','GET','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726028');
REPLACE INTO `retengcms_log` VALUES('255','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726032');
REPLACE INTO `retengcms_log` VALUES('256','admin','GET','file=category&action=edit&id=18','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726034');
REPLACE INTO `retengcms_log` VALUES('257','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726038');
REPLACE INTO `retengcms_log` VALUES('258','admin','GET','file=category&action=edit&id=19','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726041');
REPLACE INTO `retengcms_log` VALUES('259','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726045');
REPLACE INTO `retengcms_log` VALUES('260','admin','GET','file=category&action=edit&id=20','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726049');
REPLACE INTO `retengcms_log` VALUES('261','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726054');
REPLACE INTO `retengcms_log` VALUES('262','admin','GET','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726056');
REPLACE INTO `retengcms_log` VALUES('263','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726059');
REPLACE INTO `retengcms_log` VALUES('264','admin','GET','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726060');
REPLACE INTO `retengcms_log` VALUES('265','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726063');
REPLACE INTO `retengcms_log` VALUES('266','admin','GET','file=category&action=edit&id=23','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726066');
REPLACE INTO `retengcms_log` VALUES('267','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726070');
REPLACE INTO `retengcms_log` VALUES('268','admin','GET','file=category&action=edit&id=24','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726073');
REPLACE INTO `retengcms_log` VALUES('269','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726076');
REPLACE INTO `retengcms_log` VALUES('270','admin','GET','file=category&action=edit&id=25','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406726078');
REPLACE INTO `retengcms_log` VALUES('271','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406726082');
REPLACE INTO `retengcms_log` VALUES('272','admin','GET','file=config&action=config&tab=1','http://localhost/admin.php?file=left&menu=system','127.0.0.1','1406726086');
REPLACE INTO `retengcms_log` VALUES('273','admin','GET','file=main','http://localhost/admin.php','127.0.0.1','1406726100');
REPLACE INTO `retengcms_log` VALUES('274','admin','GET','file=config&action=config&tab=1','http://localhost/admin.php?file=left&module=index','127.0.0.1','1406726101');
REPLACE INTO `retengcms_log` VALUES('275','admin','GET','file=html&action=cache','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406726110');
REPLACE INTO `retengcms_log` VALUES('276','admin','GET','file=html&action=cache_template','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406726110');
REPLACE INTO `retengcms_log` VALUES('277','admin','GET','file=html&action=cache_tag','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406726111');
REPLACE INTO `retengcms_log` VALUES('278','admin','GET','file=module&action=manage','http://localhost/admin.php?file=left&menu=module','127.0.0.1','1406726114');
REPLACE INTO `retengcms_log` VALUES('279','admin','POST','file=module&action=delete','http://localhost/admin.php?file=module&action=manage','127.0.0.1','1406726124');
REPLACE INTO `retengcms_log` VALUES('280','admin','GET','file=module&action=manage','http://localhost/admin.php?file=left&menu=module','127.0.0.1','1406726126');
REPLACE INTO `retengcms_log` VALUES('281','admin','GET','file=plugins&action=manage&actived=1','http://localhost/admin.php?file=left&menu=module','127.0.0.1','1406726130');
REPLACE INTO `retengcms_log` VALUES('282','admin','GET','file=main','http://localhost/admin.php','127.0.0.1','1406726143');
REPLACE INTO `retengcms_log` VALUES('283','admin','GET','file=html&action=cache_tag','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406726147');
REPLACE INTO `retengcms_log` VALUES('284','admin','GET','file=html&action=cache_template','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406726147');
REPLACE INTO `retengcms_log` VALUES('285','admin','GET','file=html&action=cache','http://localhost/admin.php?file=left&menu=html','127.0.0.1','1406726148');
REPLACE INTO `retengcms_log` VALUES('286','admin','GET','file=main','http://localhost/admin.php','127.0.0.1','1406726151');
REPLACE INTO `retengcms_log` VALUES('287','admin','GET','file=db&action=export','http://localhost/admin.php?file=left&module=index','127.0.0.1','1406726152');
REPLACE INTO `retengcms_log` VALUES('288','admin','GET','file=db&action=repair','http://localhost/admin.php?file=db&action=export','127.0.0.1','1406726157');
REPLACE INTO `retengcms_log` VALUES('289','admin','GET','file=db&action=export','http://localhost/admin.php?file=db&action=repair','127.0.0.1','1406726160');
REPLACE INTO `retengcms_log` VALUES('290','admin','GET','file=db&action=repair','http://localhost/admin.php?file=db&action=export','127.0.0.1','1406726162');
REPLACE INTO `retengcms_log` VALUES('291','admin','POST','file=db&action=repair','http://localhost/admin.php?file=db&action=repair','127.0.0.1','1406726164');
REPLACE INTO `retengcms_log` VALUES('292','admin','GET','file=db&action=repair','http://localhost/admin.php?file=db&action=export','127.0.0.1','1406726166');
REPLACE INTO `retengcms_log` VALUES('293','admin','POST','file=db&action=repair','http://localhost/admin.php?file=db&action=repair','127.0.0.1','1406726169');
REPLACE INTO `retengcms_log` VALUES('294','admin','GET','file=db&action=repair','http://localhost/admin.php?file=db&action=export','127.0.0.1','1406726170');
REPLACE INTO `retengcms_log` VALUES('295','admin','GET','file=db&action=export','http://localhost/admin.php?file=db&action=repair','127.0.0.1','1406726180');
REPLACE INTO `retengcms_log` VALUES('296','admin','POST','file=db&action=export','http://localhost/admin.php?file=db&action=export','127.0.0.1','1406726189');
REPLACE INTO `retengcms_log` VALUES('297','游客/Tourist','GET','file=login','http://localhost/admin.php','127.0.0.1','1406733703');
REPLACE INTO `retengcms_log` VALUES('298','游客/Tourist','POST','file=login','http://localhost/admin.php?file=login','127.0.0.1','1406733709');
REPLACE INTO `retengcms_log` VALUES('299','admin','GET','file=top','http://localhost/admin.php','127.0.0.1','1406733710');
REPLACE INTO `retengcms_log` VALUES('300','admin','GET','file=main','http://localhost/admin.php','127.0.0.1','1406733711');
REPLACE INTO `retengcms_log` VALUES('301','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733714');
REPLACE INTO `retengcms_log` VALUES('302','admin','GET','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733718');
REPLACE INTO `retengcms_log` VALUES('303','admin','POST','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=edit&id=16','127.0.0.1','1406733723');
REPLACE INTO `retengcms_log` VALUES('304','admin','GET','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733724');
REPLACE INTO `retengcms_log` VALUES('305','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733726');
REPLACE INTO `retengcms_log` VALUES('306','admin','GET','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733728');
REPLACE INTO `retengcms_log` VALUES('307','admin','POST','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=edit&id=17','127.0.0.1','1406733733');
REPLACE INTO `retengcms_log` VALUES('308','admin','GET','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733734');
REPLACE INTO `retengcms_log` VALUES('309','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733735');
REPLACE INTO `retengcms_log` VALUES('310','admin','GET','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733738');
REPLACE INTO `retengcms_log` VALUES('311','admin','POST','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=edit&id=21','127.0.0.1','1406733743');
REPLACE INTO `retengcms_log` VALUES('312','admin','GET','file=category&action=edit&id=21','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733744');
REPLACE INTO `retengcms_log` VALUES('313','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733746');
REPLACE INTO `retengcms_log` VALUES('314','admin','GET','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733751');
REPLACE INTO `retengcms_log` VALUES('315','admin','POST','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=edit&id=22','127.0.0.1','1406733755');
REPLACE INTO `retengcms_log` VALUES('316','admin','GET','file=category&action=edit&id=22','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733756');
REPLACE INTO `retengcms_log` VALUES('317','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733757');
REPLACE INTO `retengcms_log` VALUES('318','admin','GET','file=category&action=setispost&ispost=0&id=21','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733763');
REPLACE INTO `retengcms_log` VALUES('319','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733764');
REPLACE INTO `retengcms_log` VALUES('320','admin','GET','file=category&action=setispost&ispost=0&id=18','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733767');
REPLACE INTO `retengcms_log` VALUES('321','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733768');
REPLACE INTO `retengcms_log` VALUES('322','admin','GET','file=category&action=setispost&ispost=0&id=19','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733769');
REPLACE INTO `retengcms_log` VALUES('323','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733770');
REPLACE INTO `retengcms_log` VALUES('324','admin','GET','file=category&action=setispost&ispost=0&id=20','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733771');
REPLACE INTO `retengcms_log` VALUES('325','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733773');
REPLACE INTO `retengcms_log` VALUES('326','admin','GET','file=category&action=setispost&ispost=0&id=23','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733774');
REPLACE INTO `retengcms_log` VALUES('327','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733775');
REPLACE INTO `retengcms_log` VALUES('328','admin','GET','file=category&action=edit&id=14','http://localhost/admin.php?file=left&menu=content','127.0.0.1','1406733780');
REPLACE INTO `retengcms_log` VALUES('329','admin','GET','file=content&action=manage&catid=18','http://localhost/admin.php?file=left&menu=content','127.0.0.1','1406733782');
REPLACE INTO `retengcms_log` VALUES('330','admin','GET','file=content&action=manage&catid=19','http://localhost/admin.php?file=left&menu=content','127.0.0.1','1406733783');
REPLACE INTO `retengcms_log` VALUES('331','admin','GET','file=category&action=edit&id=24','http://localhost/admin.php?file=left&menu=content','127.0.0.1','1406733784');
REPLACE INTO `retengcms_log` VALUES('332','admin','GET','file=content&action=manage&catid=23','http://localhost/admin.php?file=left&menu=content','127.0.0.1','1406733785');
REPLACE INTO `retengcms_log` VALUES('333','admin','GET','file=config&action=config&tab=1','http://localhost/admin.php?file=left&menu=system','127.0.0.1','1406733786');
REPLACE INTO `retengcms_log` VALUES('334','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733800');
REPLACE INTO `retengcms_log` VALUES('335','admin','GET','file=category&action=edit&id=16','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733803');
REPLACE INTO `retengcms_log` VALUES('336','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733806');
REPLACE INTO `retengcms_log` VALUES('337','admin','GET','file=category&action=edit&id=17','http://localhost/admin.php?file=category&action=manage','127.0.0.1','1406733808');
REPLACE INTO `retengcms_log` VALUES('338','admin','GET','file=category&action=manage','http://localhost/admin.php?file=left&menu=category','127.0.0.1','1406733811');
REPLACE INTO `retengcms_log` VALUES('339','admin','GET','file=main','http://localhost/admin.php','127.0.0.1','1406733817');
REPLACE INTO `retengcms_log` VALUES('340','admin','GET','file=db&action=export','http://localhost/admin.php?file=left&module=index','127.0.0.1','1406733818');
REPLACE INTO `retengcms_log` VALUES('341','admin','GET','file=db&action=repair','http://localhost/admin.php?file=db&action=export','127.0.0.1','1406733820');
REPLACE INTO `retengcms_log` VALUES('342','admin','POST','file=db&action=repair','http://localhost/admin.php?file=db&action=repair','127.0.0.1','1406733823');
REPLACE INTO `retengcms_log` VALUES('343','admin','GET','file=db&action=repair','http://localhost/admin.php?file=db&action=export','127.0.0.1','1406733824');
REPLACE INTO `retengcms_log` VALUES('344','admin','POST','file=db&action=repair','http://localhost/admin.php?file=db&action=repair','127.0.0.1','1406733826');
REPLACE INTO `retengcms_log` VALUES('345','admin','GET','file=db&action=repair','http://localhost/admin.php?file=db&action=export','127.0.0.1','1406733827');
REPLACE INTO `retengcms_log` VALUES('346','admin','GET','file=db&action=export','http://localhost/admin.php?file=left&module=index','127.0.0.1','1406733828');
REPLACE INTO `retengcms_log` VALUES('347','admin','POST','file=db&action=export','http://localhost/admin.php?file=db&action=export','127.0.0.1','1406733830');
DROP TABLE IF EXISTS `retengcms_model`;
CREATE TABLE `retengcms_model` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `table` varchar(32) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `table` (`table`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_model` VALUES('1','文章','article','0','1','1');
DROP TABLE IF EXISTS `retengcms_model_fields`;
CREATE TABLE `retengcms_model_fields` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `form` varchar(80) NOT NULL,
  `modelid` int(6) NOT NULL,
  `name` varchar(64) NOT NULL,
  `enname` varchar(32) NOT NULL,
  `tips` varchar(80) NOT NULL,
  `unit` varchar(32) NOT NULL,
  `options` text NOT NULL,
  `default` varchar(255) NOT NULL,
  `regex` varchar(80) NOT NULL,
  `css` varchar(32) NOT NULL,
  `length` varchar(8) NOT NULL,
  `orderby` int(6) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `cantdelete` tinyint(1) NOT NULL DEFAULT '0',
  `adminonly` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `modelid` (`modelid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_model_fields` VALUES('1','title','1','文章标题','title','','','','','','','','1','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('2','style','1','字体颜色','style','','','','','','','','2','1','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('3','thumb','1','封面图片','thumb','','','','','','','','3','0','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('4','keywords','1','关键字','keywords','','','','','','','','11','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('5','selectmenu_area','1','所属地区','areaid','','','','327','','','','101','1','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('6','description','1','内容简介','description','','','','','','','','8','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('7','posid','1','推荐位','posid','','','','','','','','9','0','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('8','content','1','内容','content','','','','','','','','10','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('9','status','1','发布状态','status','','','','1','','','8','100','0','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('10','iscomment','1','评论状态','iscomment','','','','1','','','','96','0','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('11','point','1','阅读点数','point','','点','','0','','','','97','1','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('12','amount','1','阅读钱数','amount','','元','','0.0','','','','98','1','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('13','author','1','责任编辑','editor','','','选项值|选项\r\n选项值|选项','','','','30','79','0','0','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('14','copyfrom','1','稿件来源','copyfrom','','','选项值|选项\r\n选项值|选项','','','','100','80','0','0','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('15','password','1','信息删除密码','password','针对游客有效，留空为屏蔽此功能!','','','','','','98','10','1','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('16','expire','1','信息有效期','expire','0为不限!','天','','0','','','','99','1','1','2','1');
DROP TABLE IF EXISTS `retengcms_module`;
CREATE TABLE `retengcms_module` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `folder` varchar(10) NOT NULL,
  `author` varchar(60) NOT NULL,
  `site` varchar(100) NOT NULL,
  `version` varchar(10) NOT NULL,
  `tables` varchar(255) NOT NULL,
  `menu_admin` text NOT NULL,
  `menu_member` text NOT NULL,
  `agreement` mediumtext NOT NULL,
  `roleid` varchar(60) NOT NULL,
  `modelid` varchar(60) NOT NULL,
  `menu` tinyint(1) NOT NULL DEFAULT '0',
  `adminmenu` tinyint(1) NOT NULL DEFAULT '0',
  `adminonly` tinyint(1) NOT NULL DEFAULT '1',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `orderby` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `folder` (`folder`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_module` VALUES('3','友情链接','link','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_linktype,retengcms_link','?mod=link&file=link&action=cache|更新缓存\r\n?mod=link&file=link&action=type|友链类型\r\n?mod=link&file=link&action=type_add|添加类型\r\n?mod=link&file=link&action=tag|模板调用','','本软件为自由软件, 你可以自由修改并使用。','1,2','','1','0','1','0','本模块是由ReTengCMS内容管理系统开发的友情链接管理模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','5');
REPLACE INTO `retengcms_module` VALUES('9','站外链接','workbox','热腾网','http://www.reteng.org','1.0','retengcms_workbox,retengcms_tools','?mod=workbox&file=workbox&action=workbox|工具管理\r\n?mod=workbox&file=workbox&action=tag|模板调用','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','0','0','0','0','本模块可以是实现站内内容与设定的关键词相关联。从而有效的实现网站SEO外链增加！','12');
REPLACE INTO `retengcms_module` VALUES('11','留言管理','guestbook','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_guestbook','?mod=guestbook&file=guestbook&action=manage&passed=1|已审留言\r\n?mod=guestbook&file=guestbook&action=manage&passed=0|待审留言','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','','1','0','1','0','本模块是由ReTengCMS内容管理系统开发的一款留言管理模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','6');
DROP TABLE IF EXISTS `retengcms_mood`;
CREATE TABLE `retengcms_mood` (
  `contentid` mediumint(8) NOT NULL,
  `surprise` mediumint(8) NOT NULL DEFAULT '0',
  `batting` mediumint(8) NOT NULL DEFAULT '0',
  `support` mediumint(8) NOT NULL DEFAULT '0',
  `great` mediumint(8) NOT NULL DEFAULT '0',
  `anger` mediumint(8) NOT NULL DEFAULT '0',
  `funny` mediumint(8) NOT NULL DEFAULT '0',
  `nausea` mediumint(8) NOT NULL DEFAULT '0',
  `puzzled` mediumint(8) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_onlinereg`;
CREATE TABLE `retengcms_onlinereg` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_onlinereg` VALUES('1','张三');
DROP TABLE IF EXISTS `retengcms_order`;
CREATE TABLE `retengcms_order` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `sn` char(32) NOT NULL,
  `product` varchar(200) NOT NULL,
  `amount` varchar(20) NOT NULL,
  `number` varchar(20) NOT NULL,
  `payment` smallint(4) NOT NULL,
  `shipment` smallint(4) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `buyuser` varchar(60) NOT NULL,
  `buyemail` varchar(60) NOT NULL,
  `buyphone` varchar(20) NOT NULL,
  `buyaddress` varchar(200) NOT NULL,
  `buymessage` text NOT NULL,
  `receiveuser` varchar(60) NOT NULL,
  `receivephone` varchar(20) NOT NULL,
  `receiveaddress` varchar(200) NOT NULL,
  `datetime` char(10) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `userid` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sn` (`sn`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_permission`;
CREATE TABLE `retengcms_permission` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `parentid` smallint(6) NOT NULL,
  `name` varchar(60) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `roleid` varchar(80) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_permission` VALUES('1','0','系统配置','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('2','1','网站配置','1','1,2');
REPLACE INTO `retengcms_permission` VALUES('3','1','管理员','1','1');
REPLACE INTO `retengcms_permission` VALUES('4','1','数据备份','1','1');
REPLACE INTO `retengcms_permission` VALUES('5','6','级联菜单','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('6','0','栏目内容','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('7','6','栏目单页','1','1,2,3,4');
REPLACE INTO `retengcms_permission` VALUES('8','0','更新网站','1','1,2,3,4');
REPLACE INTO `retengcms_permission` VALUES('9','0','内容管理','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('10','0','模板管理','1','1,4');
REPLACE INTO `retengcms_permission` VALUES('11','10','模板方案','1','1,4');
REPLACE INTO `retengcms_permission` VALUES('12','10','内容调用','1','1,4');
REPLACE INTO `retengcms_permission` VALUES('13','0','模块插件','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('14','13','功能模块','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('15','13','插件管理','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('16','13','内容模型','1','1,2,3');
DROP TABLE IF EXISTS `retengcms_posid`;
CREATE TABLE `retengcms_posid` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `orderby` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_posid` VALUES('1','首页头条','1');
REPLACE INTO `retengcms_posid` VALUES('2','栏目页推荐','2');
REPLACE INTO `retengcms_posid` VALUES('3','内容页推荐','3');
REPLACE INTO `retengcms_posid` VALUES('4','置顶信息','4');
REPLACE INTO `retengcms_posid` VALUES('5','切换焦点图','5');
DROP TABLE IF EXISTS `retengcms_regular`;
CREATE TABLE `retengcms_regular` (
  `userid` mediumint(8) NOT NULL,
  `realname` varchar(30) NOT NULL,
  `dianhua` varchar(30) NOT NULL,
  `qq` varchar(30) NOT NULL,
  `dizhi` varchar(200) NOT NULL,
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('2','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
DROP TABLE IF EXISTS `retengcms_role`;
CREATE TABLE `retengcms_role` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `orderby` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_role` VALUES('1','超级管理员','1','1','0');
REPLACE INTO `retengcms_role` VALUES('2','网站总编','2','1','0');
REPLACE INTO `retengcms_role` VALUES('3','栏目编辑','3','1','0');
REPLACE INTO `retengcms_role` VALUES('4','美工设计师','4','1','0');
REPLACE INTO `retengcms_role` VALUES('5','会计人员','5','1','0');
DROP TABLE IF EXISTS `retengcms_server_task`;
CREATE TABLE `retengcms_server_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET gbk NOT NULL,
  `url` varchar(200) CHARACTER SET gbk NOT NULL,
  `updatetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `count` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
DROP TABLE IF EXISTS `retengcms_session`;
CREATE TABLE `retengcms_session` (
  `sessionid` char(32) NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL,
  `lastvisit` int(10) unsigned NOT NULL DEFAULT '0',
  `data` char(255) NOT NULL,
  PRIMARY KEY (`sessionid`),
  KEY `lastvisit` (`lastvisit`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_session` VALUES('45d24a3edb8f3dc96b37bb2380caf404','2','127.0.0.1','1406733828','is_admin|b:1;admin_id|i:2;');
DROP TABLE IF EXISTS `retengcms_shipment`;
CREATE TABLE `retengcms_shipment` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `desc` text NOT NULL,
  `fee` varchar(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_sitecrowd`;
CREATE TABLE `retengcms_sitecrowd` (
  `id` mediumint(4) unsigned NOT NULL AUTO_INCREMENT,
  `site_name` varchar(200) NOT NULL,
  `site_url` varchar(200) NOT NULL,
  `site_dir` varchar(30) NOT NULL,
  `issueid` text NOT NULL,
  `tlp_name` varchar(80) NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_description` varchar(255) NOT NULL,
  `seo_keywords` varchar(255) NOT NULL,
  `separator` varchar(8) NOT NULL DEFAULT '>',
  `htmlext` varchar(8) NOT NULL DEFAULT '.htm',
  `iscity` tinyint(1) NOT NULL DEFAULT '0',
  `city` mediumint(8) NOT NULL,
  `map` varchar(32) NOT NULL,
  `ishtml` tinyint(1) NOT NULL DEFAULT '0',
  `copyright` text NOT NULL,
  `icpno` varchar(32) NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_sitecrowd` VALUES('1','默认站点','http://localhost/','/','','default','网站副标题','网站关键字','网站描述','>','.htm','0','0','','0','','','1');
DROP TABLE IF EXISTS `retengcms_sitecrowdissue`;
CREATE TABLE `retengcms_sitecrowdissue` (
  `issueid` mediumint(4) unsigned NOT NULL AUTO_INCREMENT,
  `issuename` varchar(80) NOT NULL,
  `ftphost` varchar(32) NOT NULL,
  `ftpport` varchar(4) NOT NULL,
  `ftpuser` varchar(64) NOT NULL,
  `ftppwd` varchar(64) NOT NULL,
  `ftpdir` varchar(80) NOT NULL,
  `ftpssl` tinyint(1) NOT NULL DEFAULT '0',
  `ftppasv` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`issueid`),
  UNIQUE KEY `ftphost` (`ftphost`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_stepselect`;
CREATE TABLE `retengcms_stepselect` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `table` varchar(30) NOT NULL,
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `table` (`table`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_stepselect` VALUES('1','地区区域','area','0','1');
DROP TABLE IF EXISTS `retengcms_stepselect_enum`;
CREATE TABLE `retengcms_stepselect_enum` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `selectid` int(6) NOT NULL,
  `name` varchar(60) NOT NULL,
  `parentid` int(8) NOT NULL,
  `orderby` int(8) NOT NULL,
  `evalue` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `evalue` (`evalue`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_stepselect_enum` VALUES('1','1','石家庄市','0','25500','25500');
REPLACE INTO `retengcms_stepselect_enum` VALUES('2','1','鹿泉市','1','25501','25501');
REPLACE INTO `retengcms_stepselect_enum` VALUES('3','1','辛集市','1','25502','25502');
DROP TABLE IF EXISTS `retengcms_tools`;
CREATE TABLE `retengcms_tools` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `boxid` mediumint(8) NOT NULL,
  `name` varchar(100) NOT NULL,
  `style` varchar(100) NOT NULL,
  `image` varchar(100) NOT NULL,
  `url` varchar(100) NOT NULL,
  `orderby` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `boxid` (`boxid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_vipread`;
CREATE TABLE `retengcms_vipread` (
  `contentid` mediumint(8) NOT NULL,
  `userid` mediumint(8) NOT NULL,
  KEY `contentid` (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_workbox`;
CREATE TABLE `retengcms_workbox` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `inlink` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
