<?php
// +----------------------------------------------------------------------
// | YZCMS <XueHen CMS>
// +----------------------------------------------------------------------
// | Copyright (c) http://www.xuehen.org
// +----------------------------------------------------------------------
// | Author XueHen <490860758@qq.com>
// +----------------------------------------------------------------------
namespace Admin\Controller;
define('TYPE','product');

class ProductController extends BaseController {
    function index(){
		$shownum = F('HouShowNum');
		$page = isset($_GET['p']) ? $_GET['p'] : 1;
		
		$cat = M('category')->where(array('type'=>TYPE,'pid'=>0))->order('ord desc, id asc')->select();
		$this->cat = getCatSon($cat);
		
		$db = M('content');
		$count         = $db->where(array('type'=>TYPE))->count();
		$Page          = new \Think\Page($count,$shownum);
		$this->page    = $Page->show();
		$this->article = $db->where(array('type'=>TYPE))->order('ord desc, id desc')->page($page.','.$shownum)->select();
        $this->display();
    }
	
	function search(){
		
		$shownum = F('HouShowNum');
		$page = isset($_GET['p']) ? $_GET['p'] : 1;
		
		$cat = M('category')->where(array('type'=>TYPE,'pid'=>0))->order('ord desc, id asc')->select();
		$this->cat = getCatSon($cat);
		
		$db = M('content');
		if(I('catid') == 0){
			$condition = array('type'=>TYPE,'title'=>array('LIKE','%'.I('k').'%'));
		}else{
			$condition = array('type'=>TYPE,'title'=>array('LIKE','%'.I('k').'%'),'catid'=>I('catid'));
		}
		
		$count         = $db->where($condition)->count();
		$Page          = new \Think\Page($count,$shownum);
		$this->page    = $Page->show();
		$this->article = $db->where($condition)->order('ord desc, id desc')->page($page.','.$shownum)->select();
        $this->display('index');
		
	}
	
	function add(){
		$cat = M('category')->where(array('type'=>TYPE,'pid'=>0))->order('ord desc, id asc')->select();
		$this->cat = getCatSon($cat);
		$this->display();
	}
	
	function edit(){
		$id = I('id');
		if(!$id){
			$this->error('无效的参数');
			exit;
		}
		
		$db = M('content');
		$re = $db->where(array('id'=>$id))->find();
		if($re){
			$this->assign('content',$re);
			
			$cat = M('category')->where(array('type'=>TYPE,'pid'=>0))->order('ord desc, id asc')->select();
		    $this->cat = getCatSon($cat);
			
			$this->display();
		}else{
			$this->error('无效的参数');
		}
		
	}
	
	function editok(){
		if(IS_POST){
			if($_POST['title'] == ''){
				$this->error('标题不能为空');
				exit;
			}
			if($_POST['content'] == ''){
				$this->error('内容不能为空');
				exit;
			}
		}else{
			$this->error('无效的访问');
			exit;
		}
		
		//验证URL
		if(I('url')){
			$re = checkUrl('content',I('url'));
			if($re && $re != I('id')){
				$this->error('别名有重复');
				exit;
			}
		}
		
		$db = M('content');
		$_POST['type'] = TYPE;
		$_POST['time'] = strtotime($_POST['time']);

		$db->create();
		$rid = $db->save();
		if($rid){
			$this->success('修改成功！','index');
		}else{
			$this->error('修改失败！');
		}
	}
	
	function delete(){
		$id = I('id');
		if(!$id){
			$this->error('无效的参数');
			exit;
		}
		$db = M('content');
		$rid = $db->where('id = '.I('id'))->delete();
		if($rid){
			$this->success('删除成功！',U('index'));
		}else{
			$this->error('删除失败!');
		}
		
	}
	
	function catdelete(){
		$id = I('id');
		if(!$id){
			$this->error('无效的参数');
			exit;
		}
		$db = M('category');
		$rid = $db->where('id = '.I('id'))->delete();
		if($rid){
			$this->success('删除成功！',U('cat'));
		}else{
			$this->error('删除失败!');
		}
		
	}
	
	function addok(){
		if(IS_POST){
			if($_POST['title'] == ''){
				$this->error('标题不能为空');
				exit;
			}
			if($_POST['content'] == ''){
				$this->error('内容不能为空');
				exit;
			}
			if($_POST['catid'] == ''){
				$this->error('请选择分类');
				exit;
			}
		}else{
			$this->error('无效的访问');
			exit;
		}
		//验证URL
		if(I('url')){
			$re = checkUrl('content',I('url'));
			if($re){
				$this->error('别名有重复');
				exit;
			}
		}
		
		
		$db = M('content');
		$_POST['type'] = TYPE;
		$_POST['time'] = strtotime($_POST['time']);

		$db->create();
		$rid = $db->add();
		if($rid){
			$this->success('添加成功！','index');
		}else{
			$this->error('添加失败！');
		}
		
	}
	
	function cat(){
		$db = M('category');
		$cat = $db->where(array('type'=>TYPE,'pid'=>0))->order('ord desc, id asc')->select();
		$this->cat = getCatSon($cat);
		$this->display();
	}
	
	function catadd(){
		$db = M('category');
		$cat = $db->where(array('type'=>TYPE,'pid'=>0))->order('ord desc, id asc')->select();
		$this->cat = getCatSon($cat);
		$this->display();
	}
	
	function cataddok(){
		if(IS_POST){
			if($_POST['name'] == ''){
				$this->error('名称不能为空');
				exit;
			}
			if($_POST['url'] == ''){
				$this->error('别名不能为空');
				exit;
			}
		}else{
			$this->error('无效的访问');
			exit;
		}
		//验证URL
		if(I('url')){
			$re = checkUrl('category',I('url'));
			if($re){
				$this->error('别名有重复');
				exit;
			}
		}
		
		$db = M('category');
		$_POST['type'] = TYPE;
		//上级分类
		if(I('post.pid')){
			$db->where(array('id'=>I('post.pid')))->save(array('level'=>1));
		}
		$db->create();
		$rid = $db->add();
		if($rid){
			$this->success('添加成功！','cat');
		}else{
			$this->error('添加失败！');
		}
		
	}
	function catedit(){
		$id = I('id');
		if(!$id){
			$this->error('无效的参数');
			exit;
		}
		
		$db = M('category');
		$re = $db->where(array('id'=>$id))->find();
		
		if($re){
			$this->assign('content',$re);
			
			$cat = $db->where(array('type'=>TYPE,'pid'=>0))->order('ord desc, id asc')->select();
		    $cat = getCatSon($cat);
			
			foreach($cat as $k=>$v){
				if($v['id'] == $id) unset($re[$k]);
			}
			$this->cat = $cat;
			$this->display();
		}else{
			$this->error('无效的参数');
		}
	}
	
	function cateditok(){
		if(IS_POST){
			if($_POST['name'] == ''){
				$this->error('名称不能为空');
				exit;
			}
		}else{
			$this->error('无效的访问');
			exit;
		}
		//验证URL
		if(I('url')){
			$re = checkUrl('category',I('url'));
			if($re && $re != I('id')){
				$this->error('别名有重复');
				exit;
			}
		}
		$db = M('category');
		$db->create();
		$rid = $db->save();
		if($rid){
			$this->success('修改成功！',U('cat'));
		}else{
			$this->error('修改失败！');
		}	
	}
	
	
}