<?php
function sql_split($sql, $table_prefix) {
    //替换表前缀
	$sql = str_replace('{pre}', $table_prefix, $sql);
    // 修改表的字符集为utf8
    $pattern = "/TYPE=(InnoDB|MyISAM|MEMORY)( DEFAULT CHARSET=[^; ]+)?/";
    $sql = preg_replace($pattern, "ENGINE=\\1 DEFAULT CHARSET=utf8", $sql);

    // 回车转换为换行
    $sql = str_replace("\r", "\n", $sql);

    // 分割为每一条sql
    $queries = explode(";\n", trim($sql));
    unset($sql);

    $result = array();
    foreach ($queries as $key => $query) {
        $query = explode("\n", trim($query));
        // 删除空行
        $query = array_filter($query);

        $result[$key] = '';
        foreach ($query as $item) {
            $temp = substr($item, 0, 1);
            if ($temp != '#' && $temp != '-') {
                $result[$key] .= $item;
            }
        }
    }

    return $result;
}