

CREATE TABLE IF NOT EXISTS `yz_book` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `check` tinyint(4) NOT NULL DEFAULT '1',
  `pid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL,
  `web` varchar(100) NOT NULL,
  `email` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `time` int(11) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `level` tinyint(4) NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL DEFAULT 'article',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `yz_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `title` varchar(150) NOT NULL,
  `keyword` varchar(100) NOT NULL,
  `description` varchar(250) NOT NULL,
  `type` varchar(10) NOT NULL,
  `content` text NOT NULL,
  `time` int(11) NOT NULL,
  `hit` int(11) NOT NULL DEFAULT '1',
  `ord` tinyint(4) NOT NULL DEFAULT '0',
  `url` varchar(50) NOT NULL,
  `pid` int(11) NOT NULL DEFAULT '0',
  `listnum` tinyint(4) NOT NULL DEFAULT '0',
  `tmpl` varchar(50) NOT NULL,
  `level` tinyint(4) NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `yz_content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `keyword` varchar(100) NOT NULL,
  `description` varchar(250) NOT NULL,
  `catid` int(11) NOT NULL DEFAULT '0',
  `image` varchar(100) NOT NULL,
  `hit` int(11) NOT NULL DEFAULT '1',
  `content` text NOT NULL,
  `time` int(11) NOT NULL,
  `ord` tinyint(4) NOT NULL DEFAULT '0',
  `url` varchar(50) NOT NULL,
  `type` varchar(10) NOT NULL,
  `price` varchar(15) NOT NULL,
  `href` varchar(50) NOT NULL,
  `buy` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `yz_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `title` varchar(100) NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `yz_link` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL,
  `image` varchar(150) NOT NULL,
  `url` varchar(100) NOT NULL,
  `ord` tinyint(4) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态0不显示1显示',
  `rel` varchar(30) NOT NULL,
  `type` varchar(10) NOT NULL COMMENT 'link和slide',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `yz_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `user` varchar(30) NOT NULL,
  `pwd` varchar(32) NOT NULL,
  `logintime` int(11) NOT NULL,
  `loginip` varchar(15) NOT NULL,
  `num` int(11) NOT NULL DEFAULT '0',
  `lastip` varchar(15) NOT NULL,
  `lasttime` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `yz_navigation` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `url` varchar(100) NOT NULL,
  `target` varchar(20) NOT NULL,
  `ord` tinyint(4) NOT NULL DEFAULT '0',
  `pid` tinyint(4) NOT NULL COMMENT '父ID',
  `level` tinyint(4) NOT NULL COMMENT '层级水平',
  `position` varchar(10) NOT NULL COMMENT 'top顶部main主foot底部',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0隐藏 1显示',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

