
jQuery.cookie = function (key, value, options) {

    // key and value given, set cookie...
    if (arguments.length > 1 && (value === null || typeof value !== "object")) {
        options = jQuery.extend({}, options);

        if (value === null) {
            options.expires = -1;
        }

        if (typeof options.expires === 'number') {
            var days = options.expires, t = options.expires = new Date();
            t.setDate(t.getDate() + days);
        }

        return (document.cookie = [
            encodeURIComponent(key), '=',
            options.raw ? String(value) : encodeURIComponent(String(value)),
            options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE
            options.path ? '; path=' + options.path : '',
            options.domain ? '; domain=' + options.domain : '',
            options.secure ? '; secure' : ''
        ].join(''));
    }

    // key and possibly options given, get cookie...
    options = value || {};
    var result, decode = options.raw ? function (s) { return s; } : decodeURIComponent;
    return (result = new RegExp('(?:^|; )' + encodeURIComponent(key) + '=([^;]*)').exec(document.cookie)) ? decode(result[1]) : null;
};


var options = {path: '/', expires: 7};			//定义路径，过期时间为10天
var cookie_backColor = $.cookie("backColor");	//定义背景颜色值
var cookie_fontColor = $.cookie("fontColor");	//定义字体颜色值
var cookie_fontSize = $.cookie("fontSize");		//定义字体大小

//如果cookie里有背景颜色、字体颜色、字体大小，就加载相应属性。
$(function(){
	if(cookie_backColor){
		$('#main').css('background', cookie_backColor);
	}
	if(cookie_fontColor){
		$('.zw').css('color', cookie_fontColor);
	}
	if(cookie_fontSize){
		$('.zw').css('font-size', cookie_fontSize + 'px');
	}
});

//背景颜色方法
function backcolor(num){
	if(num == 1){
		$("#main").css('background','#E9FAFF');		//改变背景颜色
		$.cookie("backColor", "#e4ebf1", options);	//把背景颜色值传进"backColor"这个cookie里
	}
	if(num == 2){
		$("#main").css('background','#efefef');
		$.cookie("backColor", "#eaeaea", options);
	}
	if(num == 3){
		$("#main").css('background','#eefaee');
		$.cookie("backColor", "#eefaee", options);
	}
	if(num == 4){
		$("#main").css('background','#ffffed');
		$.cookie("backColor", "#ffffed", options);
	}
	if(num == 5){
		$("#main").css('background','#ffffff');
		$.cookie("backColor", "#ffffff", options);
	}
	if(num == 6){
		$("#main").css('background','#FCEFFF');
		$.cookie("backColor", "#FCEFFF", options);
	}
}

//字体颜色方法
function fontcolor(num){
	if(num == 1){
		$(".zw").css('color','#ff0000');		//改变字体颜色
		$.cookie("fontColor", "#ff0000", options);	//把字体颜色值传进"fontColor"这个cookie里
	}
	if(num == 2){
		$(".zw").css('color','#006600');
		$.cookie("fontColor", "#006600", options);
	}
	if(num == 3){
		$(".zw").css('color','#0000ff');
		$.cookie("fontColor", "#0000ff", options);
	}
	if(num == 4){
		$(".zw").css('color','#660000');
		$.cookie("fontColor", "#660000", options);
	}
	if(num == 5){
		$(".zw").css('color','#000000');
		$.cookie("fontColor", "#000000", options);
	}
}

//字体大小方法
function fontsize(num){
	switch(num){
		case 1:
			$(".zw").css('font-size','14px');	//改变字体大小
			$.cookie("fontSize", "14", options);	//把字体大小值传进"fontSize"这个cookie里
			break;
		case 2:
			$(".zw").css('font-size','16px');
			$.cookie("fontSize", "16", options);
			break;
		case 3:
			$(".zw").css('font-size','20px');
			$.cookie("fontSize", "20", options);
			break;
		case 4:
			$(".zw").css('font-size','24px');
			$.cookie("fontSize", "24", options);
			break;
	}
}

//恢复默认方法
function defaultCL(){
	$("#main").css('background','#f6fbfd');			//清空背景颜色
	$.cookie("backColor", null, options);	//把背景颜色空值传进"backColor"这个cookie里
	$(".zw").css('color','');			//清空字体颜色
	$.cookie("fontColor", null, options);	//把字体颜色空值传进"fontColor"这个cookie里
	$(".zw").css('font-size','');		//清空字体大小
	$.cookie("fontSize", null, options);	//把字体大小空值传进"fontSize"这个cookie里
}