$(document).ready(function() {
	$.fn.UItoTop({easingType:'easeInOutExpo'});
	
	$(".search-list-catalogs ul li:last").css("border","none");
	
	$(".tbk-frame-container").each(function() {
		var target = $(this).attr("data-url");
		var text = '<iframe src="' + target + '" rel="nofollow" width="1px" height="1px" '
			+ 'frameborder="0" scrolling="no" marginwidth="0" marginheight="0" id="tbk-iframe" class="iframe"></iframe>';
		$(this).html(text).fadeOut();
	});
	
	try{initSearchList();}catch(e){}
	try{initBrand();}catch(e){}
	
});

function initSearchList() {
	$(".search-form .btn").click(function(e){
		e.preventDefault();
		keyword = $(".search-form input[name='q']");
		if(keyword.attr("value").trim() !== "") {
			$(".search-form form").submit();
		} else {
			alert("请输入关键词");
			keyword.attr("value","").focus();
		}
	});
	
	$(".search-form input").keyup(function(e){ 
		if(e.keyCode == 13) {
			$(".search-form .btn").click();
		}
	});
	
	$(".search-main .sort-form span").each(function(){
		$(this).click(function(){
			url = $("a", this).attr("href");
			window.location = url;
		});
	});
	
	$(".search-list-main li").hover(
		function() {
			$(".buy-hover", $(this)).show();
		}, function() {
			$(".buy-hover", $(this)).hide();
		}
	);
	
	var form = $(".search-list-catalogs form,.search-list-window form");
	var hit_item = $("input[name='hit_item']", form).val();
	var li = $(".search-list-main li:first");
	var rate = $(".save",li).attr("data-rate");
	if(false && hit_item == 1 && $(".price span",li).hasClass("hidden")) {
		$.ajax({
			type : 'POST',
			url : form.attr("action") + "?t=" + new Date().getTime(),
			data : {
				item_id: li.attr("data-id"),
				rate: rate,
				_csrf_token: g.__t__
			},
			timeout : 2500,
			success : function(result) {
				if(result.success) {
					$(".price em",li).text(result.data.price);
					$(".save em",li).text(result.data.save);
					var tbk_link = $(".tbk-link:first",li).attr("href");
					tbk_link = tbk_link.replace(/\?p=\w+&/g,"?p=" + $.base64Encode(result.data.price) + "&");
					$(".tbk-link",li).attr("href", tbk_link);
				}
				
				$(".price b",li).hide();
				$(".price .hidden",li).fadeIn();
				$(".save .hidden",li).fadeIn();
			},
			error : function() {
				$(".price b",li).hide();
				$(".price span",li).fadeIn();
				$(".save span",li).fadeIn();
			}
		});
	}
	$(".price b",li).hide();
	$(".price span",li).fadeIn();
	$(".save span",li).fadeIn();
}

function initBrand() {
	$(".adv-shop-filter .filter-panel span").each(function(){
		$(this).click(function(){
			$(this).siblings("ul").toggle();
		});
	});
	
	$(".adv-shop-filter").each(function(){
		var cid = $(this).attr('data-cid');
		if(cid !== '') {
			_selectShopNavByCid(cid);
		}
	});
	
	$(".brand-cate-nav ul a").click(function(e){
		if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname){
			var $target = $(this.hash);
			$target = $target.length && $target || $('[name=' + this.hash.slice(1) +']');
			if ($target.length){
				var targetOffset = $target.offset().top;
				$('html,body').animate({scrollTop: targetOffset}, 600);
				return false;
			}
		}
	});
}

function _selectShopNavByCid(cid) {
    var isSelected = 0;
    $(".adv-shop-filter ul").each(function(){
        var t = this;
        $("li", this).each(function(){
            if ($(this).attr("cid") == cid) {
                $(this).addClass("current");
                $(t).toggle();
                isSelected = 1;
                return false;
            };
        });
        
        if (1 == isSelected) {
            return false;
        }
	});
}