<?php
/*本程式版权所有,请勿侵权!作者保留所有权利!
这是系统基本数据文件，请不要手动修改。
系统设计：胡芳强。
联系电话：15073922433
友情邮箱：hufangqiang@tom.com
This is the basic data file systems, please do not be amended lightly.
System Design: Hu Fang Qiang.
Contact Phone: 15,073,922,433;
Friend E-mail: hufangqiang@tom.com
*/
if(!defined("QIANG")){die("非法访问.Hacker Intrusion.");}
$info['title']='基于XML语言的来实现购物车的详细代码';
$info['description']='基于XML语言的来实现购物车的详细代码';
$info['keywords']='基于XML语言的来实现购物车的详细代码';
$info['filename']='/2011021405480660/2011081812513850.php';
$info['action']='action';
$info['ip']='127.0.0.1';
$info['update_time']='1';
$info['count_hits']='1';
$info['template_file']='products.html';
$info['type']='3';
$info['authore']='qq';
$info['language']='cn';
$info['body']='<p>
	购物车是电子商务网站中不可缺少的组成部分，但目前大多数购物车只能作为一个顾客选中商品的展示，客户端无法将购物车里的内容提取出来满足自己事务处理的 需要，而这一点在有些电子商务活动中很有必要。XML的出现使得网络上传输的数据变得有意义起来，我们可以根据不同的要求以不同的样式将一个购物车的内容 显示出来。</p>
<p>
	本文将详细分析一个由Java实现的基于XML的购物车。下面是一个包含了五件商品的购物车的XML内在结构：它的根元素为cart，total元素表示 购物车内的总金额，每个item元素表示一件商品，item里的子元素分别标明了该商品的具体信息，可根据实际情况添加、修改或删除。</p>
<p>
	在这里，需要建立一个表示购物车的类：XMLCart.java，它是一个JavaBean，所以它包含了一个空的构造函数。这个类包含了购物车的一些基 本功能: 生成一个空的购物车，往购物车里添加商品，删除购物车里的商品，改变购物车内商品的数量以及清空购物车等。它拥有一个全局私有变量&ldquo;private XMLDocument myCart&rdquo;，myCart用来存储购物车里的详细内容，购物车的基本功能就是对它的操作，它的类型是XMLDocument，即一个XML文档。这 样，对购物车的操作就转换成对myCart中的子元素的添加、删除，及元素值的计算、修改等。</p>
<p>
	1． 清空购物车</p>
<p>
	清空购物车即生成一个空的购物车。这里空购物车是一个含有根元素cart及其元素total的XML文档，total元素是购物车的总金额，它的初始值为0，其XML具体形式如下：</p>
<p>
	<br />
	&lt; ?xml version=&lsquo;1.0&rsquo; encoding=&lsquo;gb2312&rsquo;?&gt;<br />
	&lt; cart&gt;<br />
	&lt; total&gt;0&lt; /total&gt;<br />
	&lt; /cart&gt;</p>
<p>
	<br />
	将这个XML字符串由parseString函数转换成XMLDocument存入myCart。<br />
	其代码如下：</p>
<p>
	public void emptyCart() throws IOException,SAXException{<br />
	&nbsp;String stringCart=&ldquo;&lt; ?xml version=&lsquo;1.0&rsquo;encoding=&lsquo;gb2312&rsquo;?&gt; &rdquo;+<br />
	　 &ldquo;&lt; cart&gt;&lt; total&gt;0&lt; /total&gt;&lt; /cart&gt;&rdquo;;<br />
	　 myCart=parseString(stringCart);<br />
	&nbsp;}</p>
<p>
	<br />
	2． 添加商品</p>
<p>
	添加商品，即将传入的item元素添加到根元素cart里， 其中item里包括商品详细信息， 同时计算total的值。其代码如下：</p>
<p>
	public void addItemToCart(String stringItem)<br />
	throws IOException,SAXException{<br />
	//将item由String转换为XMLDocument<br />
	XMLDocument itemAdded=parseString(stringItem);<br />
	//取出item节点，并复制它<br />
	NodeList itemList=itemAdded.getElementsByTagName(&ldquo;item&rdquo;);<br />
	Node item=itemList.item(0);<br />
	Node cloneItem=item.cloneNode(true);<br />
	//如果购物车为空，则构造一个新的购物车<br />
	if(isCartEmpty()){<br />
	&nbsp;myCart.emptyCart();<br />
	}<br />
	//如果该商品不在购物车中，则插入该商品，并计算总金额<br />
	if(!isItemExist(item,myCart)){<br />
	//取myCart的根元素，并将复制的item节点添加到后面<br />
	Element cartRoot=myCart.getDocumentElement();<br />
	Node cartNode=cartRoot.appendChild(cloneItem);　<br />
	computeTotal();//计算总金额<br />
	&nbsp;}<br />
	&nbsp;}</p>
<p>
	3． 删除商品</p>
<p>
	删除商品，即根据商品代码将该商品的item元素</p>
<p>
	从myCart的根元素cart中删除， 并重新计算total的值：</p>
<p>
	public void moveItemFromCart(String id){<br />
	//取出以item为单位的节点集cartList以及根元素cartRoot<br />
	　 NodeList cartList=myCart.getElementsByTagName( &ldquo;item&rdquo;);<br />
	&nbsp;Element cartRoot=myCart.getDocumentElement();<br />
	　 //在cartList中查找代码为选中id的商品<br />
	&nbsp;for(int x=0;x &lt; cartList.getLength();x++){<br />
	　 Node itemNode=cartList.item(x);<br />
	　 String　idValue=itemNode.getFirstChild().<br />
	　 getFirstChild().getNodeValue();<br />
	　 //如果找到，则从cartRoot中删除该节点，并跳出循环<br />
	if(idValue.equals(id)){<br />
	　 itemNode=cartRoot.removeChild(itemNode);<br />
	　 break;<br />
	&nbsp;}<br />
	&nbsp;}<br />
	&nbsp;computeTotal();//计算总金额<br />
	&nbsp;}</p>
<p>
	&nbsp;</p>
<p>
	4． 改变商品数量</p>
<p>
	根据客户在页面上所填的数量，修改myCart中quantity， 并重新计算total:</p>
<p>
	public void addQuantityToCart(String qnty) throws<br />
	IOException,SAXException{<br />
	&nbsp;//将传过来的包含商品数量的一组XML字符串转换为XML文档<br />
	XMLDocument quantityChanged=parseString(qnty);<br />
	//取出包含新数量的quantity节点集和myCart中的quantity节点集<br />
	NodeList quantityList=quantityChanged.getElementsByTagName(&ldquo;quantity&rdquo;);<br />
	NodeList cartList=myCart.getElementsByTagName(&ldquo;quantity&rdquo;);<br />
	//循环改变商品的数量<br />
	for(int x=0;x&lt; cartList.getLength();x++){<br />
	//将新quantity的值赋给myCart中相应的quantity中去<br />
	String quantity=quantityList.item(x).getFirstChild().getNodeValue();<br />
	cartList.item(x).getFirstChild().setNodeValue(quantity);<br />
	}<br />
	computeTotal();//计算总金额<br />
	&nbsp;}</p>
<p>
	5． 计算总金额</p>
<p>
	即计算total的值，其中total=&sum;(price*quantity):</p>
<p>
	public void computeTotal(){<br />
	&nbsp;NodeList quantityList=myCart.getElementsByTagName( &ldquo;quantity&rdquo;);<br />
	&nbsp;NodeList priceList=myCart.getElementsByTagName( &ldquo;price&rdquo;);<br />
	&nbsp;float total=0;<br />
	&nbsp;//累加总金额<br />
	for(int x=0;x&lt; priceList.getLength();x++){<br />
	&nbsp;float quantity=Float.parseFloat(quantityList.item(x)<br />
	&nbsp;.getFirstChild().getNodeValue());<br />
	　 float price=Float.parseFloat(priceList.item(x).getFirstChild().getNodeValue());<br />
	&nbsp;total=total+quantity*price;<br />
	&nbsp;}<br />
	&nbsp;//将total附给myCart的total<br />
	String totalString=String.valueOf(total);</p>
';
$info['about']='http://www.laoshuge.com/web/xml/2011/0806/6563.html';
$info['submit']='提交';
$info['pathname']='/2011021405480660';
?>