<?php
/*本程式版权所有,请勿侵权!作者保留所有权利!
这是系统基本数据文件，请不要手动修改。
系统设计：胡芳强。
联系电话：15073922433
友情邮箱：hufangqiang@tom.com
This is the basic data file systems, please do not be amended lightly.
System Design: Hu Fang Qiang.
Contact Phone: 15,073,922,433;
Friend E-mail: hufangqiang@tom.com
*/
if(!defined("QIANG")){die("非法访问.Hacker Intrusion.");}
$info["title"]='varnish cache 反向代理服务器和http加速器的安装和配置';
$info["description"]='页面DESC，为搜素引擎用的';
$info["keywords"]='页面KEY，为搜素引擎用的';
$info["ip"]='222.243.66.25';
$info["update_time"]='1304508388';
$info["template_file"]='products.html';
$info["type"]='4';
$info["authore"]='qq';
$info["language"]='en';
$info["body"]='<p>
	&nbsp;</p>
<p>
	<strong>一，什么是varnish</strong></p>
<p>
	Varnish是一款高性能的开源HTTP加速器，挪威最大的在线报纸 Verdens Gang 使用3台Varnish代替了原来的12台Squid，性能比以前更好。<br />
	Varnish 的作者Poul-Henning Kamp是FreeBSD的内核开发者之一，他认为现在的计算机比起1975年已经复杂许多。在1975年时，储存媒介只有两种：内存与硬盘。但现在计算 机系统的内存除了主存外，还包括了CPU内的L1、L2，甚至有L3快取。硬盘上也有自己的快取装置，因此Squid Cache自行处理物件替换的架构不可能得知这些情况而做到最佳化，但操作系统可以得知这些情况，所以这部份的工作应该交给操作系统处理，这就是 Varnish cache设计架构。<br />
	Varnish的理念是好的，但是Varnish还没有稳定到可以完全替代Squid的程度，现在就抛弃Squid选择Varnish是不明智的。</p>
<p>
	&nbsp;</p>
<p>
	<strong>二，安装varnish</strong></p>
<p>
	<a href="http://sourceforge.net/projects/varnish/files/" target="_blank">http://sourceforge.net/projects/varnish/files/</a><br />
	tar zxvf varnish-2.1.tar.gz<br />
	cd varnish-2.1<br />
	./configure &ndash;prefix=/usr/local/varnish<br />
	make &amp;&amp; make install</p>
<p>
	<strong>三，varnish的配置文件</strong></p>
<p>
	vi /usr/local/varnish/vcl.conf</p>
<p>
	输入以下内容</p>
<div class="dp-highlighter">
	<div class="bar">
		<div class="tools">
			<a href="http://blog.51yip.com/cache/618.html#">查看</a><a href="http://blog.51yip.com/cache/618.html#">复制</a><a href="http://blog.51yip.com/cache/618.html#">打印</a><a href="http://blog.51yip.com/cache/618.html#">?</a></div>
	</div>
	<ol class="dp-c" start="1">
		<li class="alt">
			<span><span>backend&nbsp;testserver&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;backend.host&nbsp;=&nbsp;<span class="string">&quot;127.0.0.1&quot;</span><span>;&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;backend.port&nbsp;=&nbsp;<span class="string">&quot;10000&quot;</span><span>;&nbsp;&nbsp;</span></span></li>
		<li>
			<span>}&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;</span></li>
		<li>
			<span>backend&nbsp;imageserver&nbsp;{&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;backend.host&nbsp;=&nbsp;<span class="string">&quot;127.0.0.1&quot;</span><span>;&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;backend.port&nbsp;=&nbsp;<span class="string">&quot;10001&quot;</span><span>;&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>}&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>acl&nbsp;purge&nbsp;{&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;<span class="string">&quot;localhost&quot;</span><span>;&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="string">&quot;127.0.0.1&quot;</span><span>;&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="string">&quot;192.168.1.0&quot;</span><span>/24;&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>}&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>sub&nbsp;vcl_recv&nbsp;{&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(req.request&nbsp;==&nbsp;</span><span class="string">&quot;PURGE&quot;</span><span>)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(!client.ip&nbsp;~&nbsp;purge)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;error&nbsp;405&nbsp;<span class="string">&quot;Not&nbsp;allowed.&quot;</span><span>;&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;lookup;&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(req.http.host&nbsp;~&nbsp;</span><span class="string">&quot;^localhost&quot;</span><span>)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;req.backend&nbsp;=&nbsp;testserver;&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="keyword">elseif</span><span>&nbsp;(req.http.host&nbsp;~&nbsp;</span><span class="string">&quot;^127.0.0.1&quot;</span><span>)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;req.backend&nbsp;=&nbsp;imageserver;&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="keyword">else</span><span>{&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;error&nbsp;404&nbsp;<span class="string">&quot;test&nbsp;Cache&nbsp;Server&quot;</span><span>;&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(req.request&nbsp;!=&nbsp;</span><span class="string">&quot;GET&quot;</span><span>&nbsp;&amp;&amp;&nbsp;req.request&nbsp;!=&nbsp;</span><span class="string">&quot;HEAD&quot;</span><span>)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;pipe;&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(req.http.Expect)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;pipe;&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(req.http.Authenticate&nbsp;||&nbsp;req.http.Cookie&nbsp;||&nbsp;req.url&nbsp;~&nbsp;</span><span class="string">&quot;\.(php|cgi)($|\?)&quot;</span><span>)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;pass;&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(req.request&nbsp;==&nbsp;</span><span class="string">&quot;GET&quot;</span><span>&nbsp;&amp;&amp;&nbsp;req.url&nbsp;~&nbsp;</span><span class="string">&quot;\.(txt|js|jpg|gif|png|bmp|css)$&quot;</span><span>)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;lookup;&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;lookup;&nbsp;&nbsp;</span></li>
		<li>
			<span>}&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;</span></li>
		<li>
			<span>sub&nbsp;vcl_hit&nbsp;{&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(req.request&nbsp;==&nbsp;</span><span class="string">&quot;PURGE&quot;</span><span>)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;obj.ttl&nbsp;=&nbsp;0s;&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;error&nbsp;200&nbsp;<span class="string">&quot;Purged.&quot;</span><span>;&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>}&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>sub&nbsp;vcl_miss&nbsp;{&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(req.request&nbsp;==&nbsp;</span><span class="string">&quot;PURGE&quot;</span><span>)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;error&nbsp;404&nbsp;<span class="string">&quot;Not&nbsp;in&nbsp;cache.&quot;</span><span>;&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>}&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>sub&nbsp;vcl_fetch&nbsp;{&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(obj.http.Pragma&nbsp;~&nbsp;</span><span class="string">&quot;no-cache&quot;</span><span>&nbsp;||&nbsp;obj.http.Cache-Control&nbsp;~&nbsp;</span><span class="string">&quot;no-cache&quot;</span><span>&nbsp;||&nbsp;obj.http.Cache-Control&nbsp;~&nbsp;</span><span class="string">&quot;private&quot;</span><span>)&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;pass;&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(req.request&nbsp;==&nbsp;</span><span class="string">&quot;GET&quot;</span><span>&nbsp;&amp;&amp;&nbsp;req.url&nbsp;~&nbsp;</span><span class="string">&quot;\.(txt|js|jpg|gif|png|bmp|css)$&quot;</span><span>)&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;obj.ttl&nbsp;=&nbsp;3600s;&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">else</span><span>&nbsp;{&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;obj.ttl&nbsp;=&nbsp;30d;&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li>
			<span>}&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;</span></li>
		<li>
			<span>sub&nbsp;vcl_hash&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>{&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;req.hash&nbsp;+=&nbsp;req.url;&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="keyword">if</span><span>&nbsp;(req.http.host)&nbsp;&nbsp;</span></span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;req.hash&nbsp;+=&nbsp;req.http.host;&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}<span class="keyword">else</span><span>{&nbsp;&nbsp;</span></span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set&nbsp;req.hash&nbsp;+=&nbsp;server.ip;&nbsp;&nbsp;</span></li>
		<li>
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;hash;&nbsp;&nbsp;</span></li>
		<li>
			<span>}&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;</span></li>
		<li>
			<span>sub&nbsp;vcl_pipe&nbsp;{&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;pipe;&nbsp;&nbsp;</span></li>
		<li>
			<span>}&nbsp;&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;</span></li>
		<li>
			<span>sub&nbsp;vcl_pass&nbsp;{&nbsp;&nbsp;</span></li>
		<li class="alt">
			<span>&nbsp;&nbsp;&nbsp;&nbsp;pass;&nbsp;&nbsp;</span></li>
		<li>
			<span>}&nbsp;&nbsp;</span></li>
	</ol>
</div>
<p>
	简单说明一下：</p>
<p>
	<span style="color: #993300;">1，设置反向请求的IP，127.0.0.1:10000和127.0.0.1:10001</span></p>
<p>
	<span style="color: #993300;">2，允许缓存管理,localhost,127.0.0.1,192.168.0.*</span></p>
<p>
	<span style="color: #993300;">3,varnish对匹配localhost请求跳到testserver，对匹配127.0.0.1的请求跳 到imageserver，如果都没有，显示test Cache Server</span></p>
<p>
	<span style="color: #993300;">4，Varnish对HTTP协议中的GET、HEAD请求进行缓存，对POST请求透过，让其直接访问后端Web服务器。放过php，cgi不对其进行缓存，只缓存，静态文件</span></p>
<p>
	<span style="color: #993300;">5，对以.txt.js.jpg.gif.png.bmp.css结尾的URL缓存时间设置1小时，对其他的URL缓存时间设置为30天。</span></p>
<p>
	<strong>四，优化Linux内核参数</strong></p>
<p>
	vi /etc/sysctl.conf</p>
<p>
	加入</p>
<p>
	net.ipv4.tcp_fin_timeout = 30<br />
	net.ipv4.tcp_keepalive_time = 300<br />
	net.ipv4.tcp_syncookies = 1<br />
	net.ipv4.tcp_tw_reuse = 1<br />
	net.ipv4.tcp_tw_recycle = 1<br />
	net.ipv4.ip_local_port_range = 5000 &nbsp; &nbsp;65000</p>
<p>
	<span style="color: #003300;">ldconfig</span>进行重新加载</p>
<p>
	<strong>五，启动varnish和varnishncsa，并查看</strong></p>
<p>
	ulimit -SHn 51200<br />
	/usr/local/varnish/sbin/varnishd -n /var/vcache -f /usr/local/varnish/vcl.conf -a :8080 -s file,/var/vcache/varnish_cache.data,1G -g users -u zhangy -w 30000,51200,10 -T 127.0.0.1:3500 -p client_http11=on<br />
	/usr/local/varnish/bin/varnishncsa -n /var/vcache -w /var/vlogs/varnish.log &amp;</p>
<p>
	解释一下<span style="color: #003300;">8080</span>是varnish监听的端口，例如127.0.0.1:8080会反向请求127.0.0.1：10001图片服务器，<span style="color: #003300;">127.0.0.1:3500</span>这个是管理缓存的ip</p>
<p>
	[zhangy@BlackGhost ~]$ ps -e|grep varnish<br />
	3970 ?&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 00:00:00 varnishd<br />
	3971 ?&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 00:00:00 varnishd<br />
	3977 pts/0&nbsp;&nbsp;&nbsp; 00:00:00 varnishncsa</p>
<p>
	<strong>六、通过Varnish管理端口，使用正则表达式批量清除缓存：</strong></p>
<p>
	<span style="color: #993300;">1，例：清除类似http://127.0.0.1:8080/00/01的URL地址：</span></p>
<p>
	[root@BlackGhost varnish]# <span style="color: #003300;">/usr/local/varnish/bin/varnishadm -T 127.0.0.1:3500 url.purge /00/</span></p>
<p>
	<span style="color: #993300;">2，例：清除类似http://127.0.0.1:8080/00/0144的URL地址：</span></p>
<p>
	[root@BlackGhost varnish]# <span style="color: #003300;">/usr/local/varnish/bin/varnishadm -T 127.0.0.1:3500 url.purge \d*$</span></p>
<p>
	<span style="color: #993300;">3，例：清除类似http://127.0.0.1:8080/00/01/RwGowEtWvcQAAAAAAAAWHH0Rklg81.gif的url地址</span></p>
<p>
	[root@BlackGhost varnish]# <span style="color: #003300;">/usr/local/varnish/bin/varnishadm -T 127.0.0.1:3500 url.purge gif$</span></p>
<p>
	<span style="color: #993300;">4，清除所有</span></p>
<p>
	[root@BlackGhost varnish]# <span style="color: #003300;">/usr/local/varnish/bin/varnishadm -T 127.0.0.1:3500 url.purge *$</span></p>
<p>
	<span style="color: #993300;">5,怎么测试你知道有没有清除缓存</span></p>
<p>
	在地址栏输入http://127.0.0.1:8080/00/01/RwGowEtWvcQAAAAAAAAWHH0Rklg81.gif<br />
	然后涮新几次你发现以下内容</p>
<div class="wp-caption alignnone" id="attachment_650" style="width: 571px">
	<a href="http://blog.51yip.com/wp-content/uploads/2010/04/clearcache.jpg"><img alt="清缓存前" class="size-full wp-image-650" height="96" src="http://blog.51yip.com/wp-content/uploads/2010/04/clearcache.jpg" title="clearcache" width="561" /></a>
	<p class="wp-caption-text">
		清缓存前</p>
</div>
<p>
	<span style="color: #993300;">说明：请求了8次，后台请求1次，缓存7次</span></p>
<p>
	清除缓存<br />
	[root@BlackGhost varnish]# /usr/local/varnish/bin/varnishadm -T 127.0.0.1:3500 url.purge gif$</p>
<p>
	然后在请求http://127.0.0.1:8080/00/01/RwGowEtWvcQAAAAAAAAWHH0Rklg81.gif</p>
<p>
	你会发现以下内容</p>
<div class="wp-caption alignnone" id="attachment_651" style="width: 575px">
	<a href="http://blog.51yip.com/wp-content/uploads/2010/04/clearcache2.jpg"><img alt="缓存清后" class="size-full wp-image-651" height="101" src="http://blog.51yip.com/wp-content/uploads/2010/04/clearcache2.jpg" title="clearcache2" width="565" /></a>
	<p class="wp-caption-text">
		缓存清后</p>
</div>
<p>
	<span style="color: #993300;">说明：请求数变了，缓存数没变，后台请求数变了，说明刚才请缓存是有效果的。</span></p>
<p>
	<strong>七，进行缓存测试，以及部分参数说明</strong></p>
<div class="wp-caption alignnone" id="attachment_642" style="width: 310px">
	<a href="http://blog.51yip.com/wp-content/uploads/2010/04/varnish.jpg"><img alt="varnish" class="size-medium wp-image-642" height="101" src="http://blog.51yip.com/wp-content/uploads/2010/04/varnish-300x101.jpg" title="varnish" width="300" /></a>
	<p class="wp-caption-text">
		varnish</p>
</div>
<p>
	上图中199719表示用户请求数；</p>
<p>
	上图中199704表示用户请求收到数</p>
<p>
	上图中199688表示这个缓存命中次数，就是缓了多少次</p>
<p>
	上图中第一个2表示没有缓存数，第一次访问都不会被缓存的，memcache也是</p>
<p>
	上图中第二个2表示后台处理数，没缓存当然要交到后台处理</p>
';
$info["about"]='http://blog.51yip.com/cache/618.html';
$info["submit"]='提交';
$info["filename"]='/2011021405524336/2011050419262898.php';
$info["pathname"]='/2011021405524336';
?>