function addLoadEvent(func) {
	var oldonload = window.onload;
	if (typeof window.onload != 'function') {
		window.onload = func;
	} else {
		window.onload = function() {
			oldonload();
			func && func();
		}
	}
}

function addClass(element, value) {
	if (!element.className) {
		element.className = value;
	} else {
		newClassName = element.className;
		newClassName += " ";
		newClassName += value;
		element.className = newClassName;
	}
}

function removeClass(element, value) {
	var removedClass = element.className;
	var pattern = new RegExp("(^| )" + value + "( |$)");
	removedClass = removedClass.replace(pattern, "$1");
	removedClass = removedClass.replace(/ $/, "");
	element.className = removedClass;
	return true;
}

/*className */
function getElementsByClass(searchClass, node, tag) {
	var classElements = new Array();
	if (node == null) node = document;
	if (tag == null) tag = '*';
	var els = node.getElementsByTagName(tag);
	var elsLen = els.length;
	var pattern = new RegExp("(^|\\s)" + searchClass + "(\\s|$)");
	for (var i = 0,
	j = 0; i < elsLen; i++) {
		if (pattern.test(els[i].className)) {
			classElements[j] = els[i];
			j++;
		}
	}
	return classElements;
}

/*nextSibling*/
function get_nextSibling(n) {
	var y = n.nextSibling;
	while (y.nodeType != 1) {
		y = y.nextSibling;
	}
	return y;
}
/*firstChild*/
function get_firstChild(n) {
	var y = n.firstChild;
	while (y.nodeType != 1) {
		y = y.nextSibling;
	}
	return y;
}
/*lastChild*/
function get_lastChild(n) {
	var y = n.lastChild;
	while (y.nodeType != 1) {
		y = y.previousSibling;
	}
	return y;
}

/*previousSibling*/
function get_previousSibling(n) {
	var y = n.previousSibling;
	while (y.nodeType != 1) {
		y = y.previousSibling;
	}
	return y;
}

/*break ul tag*/
function breakul(ul_ID, li_num) {
	if (!document.getElementById(ul_ID)) return false;
	var divid = document.getElementById(ul_ID).parentNode;
	var sfEls = divid.getElementsByTagName("li");
	var loopCount = Math.ceil(sfEls.length / li_num) - 1;
	//ָֻʽֵֵֵ>=ֵС
	for (var less = 0; less < loopCount; less++) {
		var bod = document.createElement("ul");
		divid.appendChild(bod);
		for (var i = 0; i < li_num; i++) {
			if (sfEls[li_num] && ((less + 1) * li_num + i) < sfEls.length) {
				bod.appendChild(sfEls[li_num]);
			}
		}
	}
}

function all_func() {
	breakul('break_hangqing', 6);
	breakul('break_weihu', 6);
	breakul('break_shangjia', 5);
	tabs("car_tab_ul", "data_table", "best_car");
	tabs("car_tab_ul2", "data_table2", "best_car2");
	tabs("car_tab_ul3", "data_table3", null, true);
	tabs("sub_ul", "sub_con", null, true);
	tabs("sub_news", "sub_news_con", null, true);
	tabs("rank_newcar_tab", "rank_newcar");

}

/*==================focus=====================*/

function f_div_onclick() {
	if (!document.getElementById("focus_chart")) return false;
	var focus_box = document.getElementById("focus_chart");
	var f_p = focus_box.getElementsByTagName("p");
	var f_em = focus_box.getElementsByTagName("em");
	var f_div = focus_box.getElementsByTagName("div");
	var getc = getElementsByClass("current", focus_box, "div");
    if(!getc[0])return false;
	getc[0].style.width = getc[0].clientWidth + "px"; //load width

	for (var i = 0; i < f_em.length; i++) {

		f_div[i].onmouseover = function() {
			atuokey = true;
		}; //key
		f_div[i].onmouseout = function() {
			atuokey = false;
		}; //key	
		f_p[i].onmouseover = function() {
			bt_autokey = true;
		}; //key
		f_p[i].onmouseout = function() {
			bt_autokey = false;
		}; //key

		f_p[i].style.display = "none";
		f_p[0].style.display = "block";

		f_em[i].num = i;
		f_em[i].onclick = function() {

			var getc = getElementsByClass("current", focus_box, "div");

			if (getc[0].style.width != max_width + "px") {
				return false
			}; //unable quick click
			if (getc[0] == this.parentNode.parentNode) {
				return false
			}; //unable click current

			widthElement(getc[0].id, min_width, f_interval);
			widthElement(f_div[this.num].id, max_width, f_interval);
			removeClass(getc[0], "current");
			addClass(f_div[this.num], "current");
			focusbigimg(f_div[this.num]);

			return false;
		}

	}

	//getc[0].style.display = "block";

}

/*imgchange*/
function focusbigimg(obj) {
	var focus_box = document.getElementById("focus_chart");
	var divs = focus_box.getElementsByTagName("div");
	var ps = focus_box.getElementsByTagName("p");

	for (var i = 0; i < ps.length; i++) {
		if (divs[i] == obj) {
			ps[i].style.display = "block";
		} else {
			ps[i].style.display = "none";
		}
	}
}

/*wdith*/
function widthElement(elementID, final_width, interval) {
	if (!document.getElementById) return false;
	if (!document.getElementById(elementID)) return false;
	var elem = document.getElementById(elementID);
	if (elem.movement) {
		clearTimeout(elem.movement);
	}
	if (!elem.style.width) {
		elem.style.width = "0px";
	}
	var xpos = parseInt(elem.style.width);
	if (xpos == final_width) {
		return true;
	}
	if (xpos < final_width) {
		var dist = Math.ceil((final_width - xpos) / 3);
		xpos = xpos + dist;
	}
	if (xpos > final_width) {
		var dist = Math.ceil((xpos - final_width) / 3);
		xpos = xpos - dist;
	}
	elem.style.width = xpos + "px";
	var repeat = "widthElement('" + elementID + "'," + final_width + "," + interval + ")";
	elem.movement = setTimeout(repeat, interval);
}

/*auto*/
function focusAuto() {

	if (atuokey) {
		return false;
	} //key

	if (!document.getElementById("focus_chart")) return false;
	var focus_box = document.getElementById("focus_chart");
	var f_div = focus_box.getElementsByTagName("div");
    if(!f_div[0]) return false;
	var getc = getElementsByClass("current", focus_box, "div");
	li_active();
	//alert("sdfsaf");

	var getc = getElementsByClass("current", focus_box, "div");
	focusbigimg(getc[0]);

	function li_active() {
		//var nowID = document.getElementById("c_now");
		if (get_lastChild(focus_box).className == "current" && get_lastChild(focus_box).style.width == max_width + "px") {
			removeClass(f_div[f_div.length - 1], "current");
			addClass(f_div[0], "current");
			widthElement(f_div[f_div.length - 1].id, min_width, f_interval);
			widthElement(f_div[0].id, max_width, f_interval);
			return false;
		}
		if (getc[0].style.width == max_width + "px") {
			removeClass(getc[0], "current");
			addClass(get_nextSibling(get_nextSibling(getc[0])), "current");
			widthElement(getc[0].id, min_width, f_interval);
			widthElement(get_nextSibling(get_nextSibling(getc[0])).id, max_width, f_interval);
		}
	}
}
//addLoadEvent(focusAuto);

/*=======================dealer logo========================*/
function dealer_logo() {
	if (!document.getElementById("dealer_logo")) return false;
	var PMarquee = document.getElementById("dealer_logo");
	var lis = PMarquee.getElementsByTagName("li");
	var lisw = lis[0].clientWidth;
	var celnum = Math.floor(PMarquee.clientWidth / lisw);
	//cel mun

	var PLineCount = Math.ceil(lis.length / celnum);
	//line mun

	var copynum = (PLineCount * celnum) - lis.length;

	if (PLineCount > 1) {
		var Pjia;
		Pjia = PMarquee.innerHTML;

		for (i = 0; i < copynum + 1; i++) {

			PMarquee.innerHTML = PMarquee.innerHTML + Pjia;
			// double box
		}
		setTimeout("srun()", 1000);
		//start
	}
}
//addLoadEvent(dealer_logo);
//onload

function srun() {
	if (!document.getElementById("dealer_logo")) return false;
	var PMarquee = document.getElementById("dealer_logo");
	var lis = PMarquee.getElementsByTagName("li");
	var lisw = lis[0].clientWidth;
	var PLineHeight = lis[0].clientHeight;

	var celnum = Math.floor(PMarquee.clientWidth / lisw);
	//cel mun
	var PLineCount = Math.ceil(lis.length / celnum);
	//line mun
	PMarquee.scrollTop++;
	if (PMarquee.scrollTop == PLineCount * PLineHeight - (2 * PLineHeight)) {
		PMarquee.scrollTop = 0;
		//re
	}
	if (PMarquee.scrollTop % PLineHeight == 0) {
		setTimeout("srun()", 500);
	} else {
		setTimeout("srun()", 5);
		//one px time
	}

}

/*=======================tab=============================*/
function hide(id) {
	var Div = document.getElementById(id);
	if (Div) {
		Div.style.display = "none"
	}
}
function show(id) {
	var Div = document.getElementById(id);
	if (Div) {
		Div.style.display = "block"
	}
}

function tabsRemove(index, head, divs, div2s) {
	if (!document.getElementById(head)) return false;
	var tab_heads = document.getElementById(head);
	if (tab_heads) {
		var alis = tab_heads.getElementsByTagName("li");
		for (var i = 0; i < alis.length; i++) {
			removeClass(alis[i], "current");

			hide(divs + "_" + i);
			if (div2s) {
				hide(div2s + "_" + i)
			};

			if (i == index) {
				addClass(alis[i], "current");
			}
		}

		show(divs + "_" + index);
		if (div2s) {
			show(div2s + "_" + index)
		};
	}
}

function tabs(head, divs, div2s, over) {
	if (!document.getElementById(head)) return false;
	var tab_heads = document.getElementById(head);

	if (tab_heads) {
		var alis = tab_heads.getElementsByTagName("li");
		for (var i = 0; i < alis.length; i++) {
			alis[i].num = i;

			if (over) {
				alis[i].onmouseover = function() {
					changetab(this);
				}

			} else {
				alis[i].onclick = function() {
					if (this.className == "current" || this.className == "last current") {
						changetab(this);
						return true;
					} else {
						changetab(this);
						return false;
					}

				}
			}

			function changetab(thebox) {
				tabsRemove(thebox.num, head, divs, div2s);
			}

		}
	}
}

/*bt login*/
function bt_login_more() {
	if (!document.getElementById("bt_login_bt")) return false;
	var btli = document.getElementById("bt_login_bt");
	var btpop = document.getElementById("bt_login_pop");
	btli.onmouseover = function() {
		addClass(btpop, "pop_block")
	}
	btli.onmouseout = function() {
		removeClass(btpop, "pop_block")
	}
}

/*reset fields*/
function resetFields(whichform) {
	if (!document.getElementById("txtkeyword")) return false;
	var element = document.getElementById("txtkeyword");

	element.onfocus = function() {
		//document.charset='gb2312';
		if (this.value == this.defaultValue) {
			this.value = "";
			addClass(this, "on");
		}
	}
	element.onblur = function() {
		if (this.value == "") {
			this.value = this.defaultValue;
			removeClass(this, "on")
		}

	}
}

function prepareForms() {
	for (var i = 0; i < document.forms.length; i++) {
		var thisform = document.forms[i];
		resetFields(thisform);
	}
}

/*city pop*/
function AreasTrans(BtnChange, BtnClose, AreaList) {
	var div = document.getElementById(AreaList);
	var btn = document.getElementById(BtnChange);
	if ((div) && (btn)) {
		btn.onclick = function() {
			if (div.style.display == "none") {
				div.style.display = "block";
				btn.className = "change_btn_open";
			} else {
				div.style.display = "none";
				btn.className = "change_btn_close";
			}
		}
		var close_btn = document.getElementById(BtnClose);
		close_btn.onclick = function() {
			document.getElementById(AreaList).style.display = "none";
			btn.className = "change_btn_close";
		}
	}
}
function allcitypop() {
	AreasTrans("change_btn", "area_list_close", "area_list");
}
var settime = setInterval('focusAuto()', 3000);
var atuokey = false;
var f_interval = 30;
var min_width = 18;
var max_width = 210;

addLoadEvent(all_func)
addLoadEvent(f_div_onclick);
addLoadEvent(bt_login_more);
addLoadEvent(prepareForms);
addLoadEvent(allcitypop);