// JavaScript Document
function addLoadEvent(func) {
	if (typeof window.onload != 'function') {
		window.onload = func;
	} else {
		var oldonload = window.onload;
		window.onload = function() {
			oldonload();
			func();
		}
	}
}

function addClass(element, value) {
	if (!element.className) {
		element.className = value;
	} else {
		newClassName = element.className;
		newClassName += " ";
		newClassName += value;
		element.className = newClassName;
	}
}

function removeClass(element, value) {
	var removedClass = element.className;
	var pattern = new RegExp("(^| )" + value + "( |$)");
	removedClass = removedClass.replace(pattern, "$1");
	removedClass = removedClass.replace(/ $/, "");
	element.className = removedClass;
	return true;
}

/*className */
function getElementsByClass(searchClass, node, tag) {
	var classElements = new Array();
	if (node == null) node = document;
	if (tag == null) tag = '*';
	var els = node.getElementsByTagName(tag);
	var elsLen = els.length;
	var pattern = new RegExp("(^|\\s)" + searchClass + "(\\s|$)");
	for (var i = 0,
	j = 0; i < elsLen; i++) {
		if (pattern.test(els[i].className)) {
			classElements[j] = els[i];
			j++;
		}
	}
	return classElements;
}





function all_func() {
	
	var focusa = new focusObj('focus_chart', 3000);

}
addLoadEvent(all_func);

/*==================focus=====================*/

/*imgchange*/
function focusbigimg(obj, focus_obj) {
	var focus_box = focus_obj;
	var divs = focus_box.getElementsByTagName("div");
	var ps = focus_box.getElementsByTagName("p");

	for (var i = 0; i < ps.length; i++) {
		if (divs[i] == obj) {
			ps[i].style.display = "block";
		} else {
			ps[i].style.display = "none";
		}
	}

}



getcurrent = 0;

/*auto*/
function focusAuto(bt_autokey, focus_box, bt_max_width, bt_min_width, bt_interval) {

	if (bt_autokey) {
		return false;
	} //key
	if (!focus_box) {
		return false;
	}
	var f_div = focus_box.getElementsByTagName("div");

	var getc = getElementsByClass("current", focus_box, "div");
	li_active();

	var getc = getElementsByClass("current", focus_box, "div");
	focusbigimg(getc[0], focus_box);

	function li_active() {
		if (f_div[f_div.length - 1].className == "current" && f_div[f_div.length - 1].style.width == bt_max_width + "px") {
			removeClass(f_div[f_div.length - 1], "current");
			addClass(f_div[0], "current")
			//widthElement(f_div[f_div.length-1].id,bt_min_width,bt_interval);
			//widthElement(f_div[0].id,bt_max_width,bt_interval);
			f_div[f_div.length - 1].style.width = bt_min_width + "px";
			f_div[0].style.width = bt_max_width + "px";
			return false;
		}
		if (getc[0].style.width == bt_max_width + "px") {
			for (var i = 0; i < f_div.length; i++) {
				if (f_div[i] == getc[0]) {
					var getcurrent = i; //sub key
				}
			}
			removeClass(f_div[getcurrent], "current");
			addClass(f_div[getcurrent + 1], "current")
			//widthElement(f_div[getcurrent].id,bt_min_width,bt_interval);
			//widthElement(f_div[getcurrent+1].id,bt_max_width,bt_interval);
			f_div[getcurrent].style.width = bt_min_width + "px";
			f_div[getcurrent + 1].style.width = bt_max_width + "px";
			getcurrent = getcurrent++;
		}
	}
}
//addLoadEvent(focusAuto);

function focusObj(id, settime) {
	//役ģ
	if (!document.getElementById(id))return false;
	this.focus_box = document.getElementById(id);
	this.f_p = this.focus_box.getElementsByTagName("p");
	this.f_em = this.focus_box.getElementsByTagName("em");
	this.f_div = this.focus_box.getElementsByTagName("div");
	this.getc = getElementsByClass("current", this.focus_box, "div");
	if(Math.min(this.f_p.length, this.f_em.length, this.f_div.length) <= 1)return;

	var w_max_width = parseInt(this.focus_box.clientWidth - this.f_div.length * 18); //ʾ

	this.bt_autokey = false;
	this.bt_interval = 30;
	this.bt_min_width = 18;
	this.bt_max_width = w_max_width + 8;
	this.getc[0].style.width = w_max_width + 8 + "px"; //load width

	//Բ ڴ	
	var wbt_autokey = this.bt_autokey;
	var wfocus_box = this.focus_box;
	var wbt_max_width = this.bt_max_width;
	var wbt_min_width = this.bt_min_width;
	var wbt_interval = this.bt_interval;
	var wf_em = this.f_em;
	var wf_div = this.f_div;

	for (var i = 0; i < this.f_em.length; i++) {
		this.f_div[i].onmouseover = function() {
			wbt_autokey = true;
		}; //key
		this.f_div[i].onmouseout = function() {
			wbt_autokey = false;
		}; //key	
		this.f_p[i].onmouseover = function() {
			wbt_autokey = true;
		}; //key
		this.f_p[i].onmouseout = function() {
			wbt_autokey = false;
		}; //key  

		this.f_p[i].style.display = "none";
		this.f_p[0].style.display = "block";

		this.f_em[i].num = i; //emԪظ num 

		this.f_em[i].onclick = function() {
			var getc = getElementsByClass("current", wfocus_box, "div");
			if (getc[0].style.width != wbt_max_width + "px") {
				return false
			}; //unable quick click
			if (getc[0] == this.parentNode.parentNode) {
				return false
			}; //unable click current

			//widthElement(getc[0].id,wbt_min_width,wbt_interval);
			//widthElement(wf_div[this.num].id,wbt_max_width,wbt_interval);
			getc[0].style.width = wbt_min_width + "px";
			wf_div[this.num].style.width = wbt_max_width + "px";
			removeClass(getc[0], "current");
			addClass(wf_div[this.num], "current");
			focusbigimg(wf_div[this.num], wfocus_box);
			return false;

		};

	}
	this.bt_settime = setInterval(function() {
		focusAuto(wbt_autokey, wfocus_box, wbt_max_width, wbt_min_width, wbt_interval);
	},
	settime);

}

