(function($) {
    $.fn.tinycarousel = function(options) {
        var defaults = {
            start: 1,
            display: 1,
            axis: 'x',
            controls: true,
            pager: false,
            interval: false,
            intervaltime: 3000,
            animation: true,
            duration: 1000,
            callback: null
        };
        var options = $.extend(defaults, options);
        var oSlider = $(this);
        var oViewport = $('.viewport', oSlider);
        var oContent = $('.overview', oSlider);
        var oPages = oContent.children();
        var oBtnNext = $('.next', oSlider);
        var oBtnPrev = $('.prev', oSlider);
        var oPager = $('.pager', oSlider);
        var iPageSize,
        iSteps,
        iCurrent,
        oTimer,
        bForward = true,
        bAxis = options.axis == 'x';
        return this.each(function() {
            initialize();
        });
        function initialize() {
            iPageSize = bAxis ? $(oPages[0]).outerWidth(true) : $(oPages[0]).outerHeight(true);
            var iLeftover = Math.ceil(((bAxis ? oViewport.outerWidth() : oViewport.outerHeight()) / (iPageSize * options.display)) - 1);
            iSteps = Math.max(1, Math.ceil(oPages.length / options.display) - iLeftover);
            iCurrent = Math.min(iSteps, Math.max(1, options.start)) - 2;
            oContent.css(bAxis ? 'width': 'height', (iPageSize * oPages.length));
            move(1);
            setEvents();
			createpager();
        }
		function createpager(){
			if(Math.ceil(oPages.size()/options.display)<3) return;
			for(var i=0;i<Math.ceil(oPages.size()/options.display);i++){
				if(!i){
					oPager.append('<li><a rel="'+i+'" class="pagenum active" href="#">'+(i+1)+'</a></li>');
				}else{
					oPager.append('<li><a rel="'+i+'" class="pagenum" href="#">'+(i+1)+'</a></li>');
				}
			}			
		}
        function setEvents() {
            if (options.controls && oBtnPrev.length > 0 && oBtnNext.length > 0) {
                oBtnPrev.click(function() {
                    move( - 1);
                    return false;
                });
                oBtnNext.click(function() {
                    move(1);
                    return false;
                });

            }
            if (options.pager && oPager.length > 0) {
                oPager.click(setPager);
            }

        }
        function setButtons() {
            if (options.controls) {
                oBtnPrev.toggleClass('disable', !(iCurrent > 0));
                oBtnNext.toggleClass('disable', !(iCurrent + 1 < iSteps));
            }
            if (options.pager) {
                var oNumbers = $('.pagenum', oPager);
                oNumbers.removeClass('active');
                $(oNumbers[iCurrent]).addClass('active');
            }
        }
        function setPager(oEvent) {
            var oTarget = oEvent.target;
            if ($(oTarget).hasClass('pagenum')) {
                iCurrent = parseInt(oTarget.rel) - 1;
                move(1);
            }
            return false;
        }
        function setTimer(bReset) {
            if (options.interval && !bReset) {
                clearInterval(oTimer);
                oTimer = window.setInterval(function() {
                    bForward = iCurrent + 1 == iSteps ? false: iCurrent == 0 ? true: bForward;
                    move(bForward ? 1: -1, true);
                },
                options.intervaltime);
            }
        }
        function move(iDirection, bTimerReset) {
            if (iCurrent + iDirection > -1 && iCurrent + iDirection < iSteps) {
                iCurrent += iDirection;
                var oPosition = {};
                oPosition[bAxis ? 'left': 'top'] = -(iCurrent * (iPageSize * options.display));
                oContent.animate(oPosition, {
                    queue: false,
                    duration: options.animation ? options.duration: 0,
                    complete: function() {
                        if (typeof options.callback == 'function') options.callback.call(this, oPages[iCurrent], iCurrent);
                    }
                });
                setButtons();
                setTimer(bTimerReset);
            }
        }
    };
})(jQuery);