$(document).ready(function() {
	prettyPhoto.init();
});
prettyPhoto = {
	options: {
		animationSpeed: "fast",
		padding: 40
	},
	init: function() {
		prettyPhoto.imagesArray = [];
		$("a[rel^='prettyOverlay']").each(function() {
			prettyPhoto.imagesArray[prettyPhoto.imagesArray.length] = this;
			$(this).bind("click",
			function() {
				prettyPhoto.open(this);
				return false
			});
		});
	},
	open: function(A) {
		prettyPhoto.caller = A;
		theRel = $(A).attr("rel");
		galleryRegExp = /\[(?:.*)\]/;
		theGallery = galleryRegExp.exec(theRel);
		prettyPhoto.setCount = 0;
		prettyPhoto.setPosition = 0;
		prettyPhoto.arrayPosition = 0;
		prettyPhoto.isSet = false;
		for (i = 0; i < prettyPhoto.imagesArray.length; i++) {
			if ($(prettyPhoto.imagesArray[i]).attr("rel").indexOf(theGallery) != -1) {
				prettyPhoto.setCount++;
				if (prettyPhoto.setCount > 1) {
					prettyPhoto.isSet = true
				}
				if ($(prettyPhoto.imagesArray[i]).attr("href") == $(A).attr("href")) {
					prettyPhoto.setPosition = prettyPhoto.setCount;
					prettyPhoto.arrayPosition = i
				}
			}
		}
		prettyPhoto.buildOverlay(prettyPhoto.isSet);
		$("span.currentIndex").text(""+prettyPhoto.setPosition+"");
		$("span.totalCount").text(""+prettyPhoto.setCount+"");
		prettyPhoto.centerPicture();
		$("div.pictureHolder #fullResImage").fadeTo(prettyPhoto.options.animationSpeed, 0,
		function() {
			$(".loaderIcon").show();
			prettyPhoto.preload()
		})
	},
	next: function() {
		this._setPosition(1);
	},
	previous: function() {
		this._setPosition(-1);
	},
	checkPosition: function() {	 	
		if(prettyPhoto.setPosition == prettyPhoto.setCount){
			//$("div.pictureHolder a.next").hide();
			//$(".nextButton").hide();
		}else{
			$("div.pictureHolder a.next").show();
			$(".nextButton").show()
		}
		
		if(prettyPhoto.setPosition == 1){
			//$("div.pictureHolder a.previous").hide();
			//$(".previousButton").hide()
		}else{
			$("div.pictureHolder a.previous").show();
			$(".previousButton").show()
		}

		$("div.pictureHolder span.currentText span.currentIndex").text(""+prettyPhoto.setPosition+"");
		if ($(prettyPhoto.imagesArray[prettyPhoto.arrayPosition]).attr("title")) {
			$("div.pictureHolder .description").text($(prettyPhoto.imagesArray[prettyPhoto.arrayPosition]).attr("title"))
		} else {
			$("div.pictureHolder .description").text("")
		}
	},
	centerPicture: function() {
		var A = $("div.pictureHolder").offset();
		$("div.pictureHolder").css({
			top: A.top + prettyPhoto.getScroll() - $("div.pictureHolder").height() / 2,
			left: A.left - $("div.pictureHolder").width() / 2
		})
	},
	_setPosition : function(flag){
		if(flag < 0){
			if(prettyPhoto.arrayPosition-- == 0)prettyPhoto.arrayPosition = prettyPhoto.setCount - 1;
		}else{
			if(++prettyPhoto.arrayPosition == prettyPhoto.setCount)prettyPhoto.arrayPosition = 0;
		}
		$("div.pictureHolder #fullResImage").fadeTo(prettyPhoto.options.animationSpeed, 0,
		function() {
			$(".loaderIcon").show();
			prettyPhoto.preload(flag)
		});
		$("div.pictureHolder .hoverContainer").fadeOut(prettyPhoto.options.animationSpeed);
		$("div.pictureHolder .details").fadeOut(prettyPhoto.options.animationSpeed,
		function() {
			prettyPhoto.checkPosition()
		})
	},
	preload: function(flag) {
		var link, cuix = prettyPhoto.arrayPosition;
		while(true){
			link = $(prettyPhoto.imagesArray[prettyPhoto.arrayPosition]), test = link[0];
			while(test && (test.tagName != 'DIV' || !test.getAttribute('rev')))test = test.parentNode;
			if(!test || test.style.display != 'none'){
				prettyPhoto.setPosition = prettyPhoto.arrayPosition + 1;
				break;
			}
			if(flag < 0){
				if(prettyPhoto.arrayPosition-- == 0)prettyPhoto.arrayPosition = prettyPhoto.setCount - 1;
			}else{
				if(++prettyPhoto.arrayPosition == prettyPhoto.setCount)prettyPhoto.arrayPosition = 0;
			}
			if(prettyPhoto.arrayPosition == cuix){
				$('div.pictureHolder').hide();
				return;
			}
		}
		imgPreloader = new Image();
		imgPreloader.onerror = function() {
			prettyPhoto._setPosition(flag)
		};
		imgPreloader.onload = function() {
			$("div.pictureHolder #fullResImage").attr("src", this.src);
			if(imgPreloader.height>550){
				imgPreloader.width=550*imgPreloader.width/imgPreloader.height;
				imgPreloader.height=550;
			}
			if(imgPreloader.width > 900){
				imgPreloader.height=900*imgPreloader.height/imgPreloader.width;
				imgPreloader.width=900;
			}
			$("div.pictureHolder #fullResImage").attr("height",imgPreloader.height);
			$("div.pictureHolder #fullResImage").attr("width",imgPreloader.width);
			setTimeout("prettyPhoto.showimage(imgPreloader.width,imgPreloader.height)", 500);
		};
		(imgPreloader.src = link.attr("href")) || imgPreloader.onerror();
		$("div.pictureHolder .content").css("overflow", "hidden");
	},
	showimage: function(B, A) {
		if(B < 300)B = 300;
		prettyPhoto.checkPosition();
		$("div.pictureHolder .details").width(B);
		$("div.pictureHolder .details p.description").width(B);
		$(".currentTextHolder").width(B);
		$("div.pictureHolder .details").height($("div.pictureHolder .details").height() || 50);
		containerHeight = A + parseFloat($("div.pictureHolder .details").height()) + parseFloat($("div.pictureHolder .top").height()) + parseFloat($("div.pictureHolder .bottom").height());
		contentHeight = A + parseFloat($("div.pictureHolder .details").height()) + parseFloat($("div.pictureHolder .details").css("margin-top")) + parseFloat($("div.pictureHolder .details").css("margin-bottom"));
		containerWidth = B + parseFloat($("div.pictureHolder .content").css("padding-left")) + parseFloat($("div.pictureHolder .content").css("padding-right")) + prettyPhoto.options.padding;
		$("div.pictureHolder .content").animate({
			height: contentHeight
		},
		prettyPhoto.options.animationSpeed);
		$("div.pictureHolder").animate({
			top: prettyPhoto.getScroll() + (($(window).height() / 2) - (containerHeight / 2)),
			left: (($(window).width() / 2) - (containerWidth / 2)),
			width: containerWidth,
			height: containerHeight
		},
		prettyPhoto.options.animationSpeed,
		function() {
			prettyPhoto.shownav();
			$("#fullResImage").show();
			$("div.pictureHolder #fullResImage").fadeTo(prettyPhoto.options.animationSpeed, 1,
			function() {
				$("div.pictureHolder .hoverContainer").height(A)
			})
		})
	},
	shownav: function() {
		if (prettyPhoto.isSet) {
			$("div.pictureHolder .hoverContainer").fadeIn()
		}
		$("div.pictureHolder .details").fadeIn();
		$(".loaderIcon").hide()
	},
	buildOverlay: function() {
		backgroundDiv = "<div class='prettyPhotoOverlay'></div>";
		$("body").append(backgroundDiv);
		$("div.prettyPhotoOverlay").css("height", $(document).height());
		$(".prettyPhotoOverlay").bind("click",
		function() {
			prettyPhoto.close()
		});
				pictureHolder = '<div class="pictureHolder"><div class="top"><div class="left"></div><div class="middle"><a class="close" href="#" title="ر | CLOSE"></a></div><div class="right"></div></div><div class="content"><div class="loaderIcon"></div><div class="hoverContainer"><a class="next" href="#" onclick="this.blur()">next</a><a class="previous" href="#" onclick="this.blur()">previous</a></div><img id="fullResImage" style="display:none;" /><div class="details clearfix"><!--a class="close" href="#">Close</a--><p class="description"></p><p class="currentTextHolder"><span class="currentText">   <span class="previousButton" title="PREVIOUS">һ</span><span class="currentIndex">0</span><span class="totalCount">0</span><span class="nextButton" title="NEXT">һ</span>   </span></p></div></div><div class="bottom"><div class="left"></div><div class="middle"></div><div class="right"></div></div>'
				+'<iframe src="javascript:false" style="border:0;position:absolute; visibility:inherit;top:0px; left:0px; width:100%; height:100%; z-index:-9999; filter=\'progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=0)\';"></iframe>'
				+'</div>';
		$("body").append(pictureHolder);
		$(".pictureHolder").css({
			opacity: 0
		});
		$("a.close").bind("click",
		function() {
			prettyPhoto.close();
			return false
		});
		$(".pictureHolder .previous").bind("click",
		function() {
			prettyPhoto.previous();
			return false
		});
		$(".previousButton").bind("click",function(){prettyPhoto.previous();return false})
		$(".pictureHolder .next").bind("click",
		function() {
			prettyPhoto.next();
			return false
		});
		$(".nextButton").bind("click",function(){prettyPhoto.next();return false})
		if (!prettyPhoto.isSet) {
			$(".hoverContainer").hide();
			$(".currentTextHolder").hide()
		}
		$("div.prettyPhotoOverlay").css("opacity", 0);
		$("div.prettyPhotoOverlay").fadeTo(prettyPhoto.options.animationSpeed, 0.382,
		function() {
			$("div.pictureHolder").fadeTo(prettyPhoto.options.animationSpeed, 1,
			function() {
				$("div.pictureHolder").attr("style", "left:" + $("div.pictureHolder").css("left") + ";top:" + $("div.pictureHolder").css("top") + ";")
			})
		})
	},
	getScroll: function() {
		scrollTop = window.pageYOffset || document.documentElement.scrollTop || 0;
		return scrollTop
	},
	close: function() {
		$("div.pictureHolder").fadeTo(prettyPhoto.options.animationSpeed, 0,
		function() {
			$("div.prettyPhotoOverlay").fadeTo(prettyPhoto.options.animationSpeed, 0,
			function() {
				$("div.prettyPhotoOverlay").remove();
				$("div.pictureHolder").remove()
			})
		})
	}
};