<?php
/**
 * 开放平台操作类
 * @param 
 * @return
 * @author tuguska
 */

require_once "opent.php";

class MBApiClient
{
    /** 
     * 构造函数 
     *  
     * @access public 
     * @param mixed $wbakey 应用APP KEY 
     * @param mixed $wbskey 应用APP SECRET 
     * @param mixed $accecss_token OAuth认证返回的token 
     * @param mixed $accecss_token_secret OAuth认证返回的token secret 
     * @return void 
	 */
	public $host = 'open.t.qq.com';
    function __construct( $wbakey , $wbskey , $accecss_token , $accecss_token_secret ) 
	{
        $this->oauth = new MBOpenTOAuth( $wbakey , $wbskey , $accecss_token , $accecss_token_secret ); 
	}

	/******************
	 * 获取用户消息
     * @access public 
	*@f 分页标识（0：第一页，1：向下翻页，2向上翻页）
	*@t: 本页起始时间（第一页 0，继续：根据返回记录时间决定）
	*@n: 每次请求记录的条数（1-20条）
	*@name: 用户名 空表示本人
	 * *********************/
	public function getTimeline($p){
		if(!isset($p['name'])){
			$url = 'http://open.t.qq.com/api/statuses/home_timeline?f=1';
			$params = array(
				'format' => MB_RETURN_FORMAT,
				'pageflag' => $p['f'],
				'reqnum' => $p['n'],
				'pagetime' =>  $p['t']
			);					
		}else{
			$url = 'http://open.t.qq.com/api/statuses/user_timeline?f=1';
			$params = array(
				'format' => MB_RETURN_FORMAT,
				'pageflag' => $p['f'],
				'reqnum' => $p['n'],
				'pagetime' =>  $p['t'],
				'name' => $p['name']
			);					
		}
	 	return $this->oauth->get($url,$params); 
	}

	/******************
	 * 广播大厅消息
	*@p: 记录的起始位置（第一次请求是填0，继续请求进填上次返回的Pos）
	*@n: 每次请求记录的条数（1-20条）
	 * *********************/
	public function getPublic($p){
		$url = 'http://open.t.qq.com/api/statuses/public_timeline?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'pos' => $p['p'],
			'reqnum' => $p['n']	
		);
	 	return $this->oauth->get($url,$params); 
	}

	/******************
	*获取关于我的消息 
	*@f 分页标识（0：第一页，1：向下翻页，2向上翻页）
	*@t: 本页起始时间（第一页 0，继续：根据返回记录时间决定）
	*@n: 每次请求记录的条数（1-20条）
	*@l: 当前页最后一条记录，用用精确翻页用
	*@type : 0 提及我的, other 我发表的
	**********************/
	public function getMyTweet($p){
		$p['type']==0?$url = 'http://open.t.qq.com/api/statuses/mentions_timeline?f=1':$url = 'http://open.t.qq.com/api/statuses/broadcast_timeline?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'pageflag' => $p['f'],
			'reqnum' => $p['n'],
			'pagetime' => $p['t'],
			'lastid' => $p['l']	
		);
	 	return $this->oauth->get($url,$params); 
	}

	/******************
	*获取特别收听 
	*@f 分页标识（0：第一页，1：向下翻页，2向上翻页）
	*@t: 本页起始时间（第一页 0，继续：根据返回记录时间决定）
	*@n: 每次请求记录的条数（1-20条）
	*@ct: 内容过滤 填零表示所有类型 1-带文本 2-带链接 4图片 8-带视频 0x10-带音频 
	*@a: 权限标识 1 表示只显示我发表的
	*@type : 0x1 原创发表  0x2 转载 0x8 回复  0x10 空回 0x20  提及 0x40 点评 如需拉取多个类型请|上(0x1|0x2) 得到3，type=3即可,填零表示拉取所有类型
Accesslevel: 权限标识 1 表示只显示我发表的
	**********************/
	public function getMySpecial($p){
		$p['type']==0?$url = 'http://open.t.qq.com/api/statuses/special_timeline?f=1':$url = 'http://open.t.qq.com/api/statuses/broadcast_timeline?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'pageflag' => $p['f'],
			'reqnum' => $p['n'],
			'pagetime' => $p['t'],
			'contenttype' => $p['ct'],	
			'accesslevel' => $p['a']
		);
	 	return $this->oauth->get($url,$params); 
	}

	/******************
	*获取话题下的消息
	*@t: 话题名字
	*@f 分页标识（PageFlag = 1表示向后（下一页）查找；PageFlag = 2表示向前（上一页）查找；PageFlag = 3表示跳到最后一页  PageFlag = 4表示跳到最前一页）
	*@p: 分页标识（第一页 填空，继续翻页：根据返回的 pageinfo决定）
	*@n: 每次请求记录的条数（1-20条）
	**********************/
	public function getTopic($p){
		$url = 'http://open.t.qq.com/api/statuses/ht_timeline?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'pageflag' => $p['f'],
			'reqnum' => $p['n'],
			'httext' => $p['t'],
			'pageinfo' => $p['p']
		);
	 	return $this->oauth->get($url,$params); 
	}

	/******************
	*获取一条消息
	*@id: 微博ID
	**********************/
	public function getOne($p){
		$url = 'http://open.t.qq.com/api/t/show?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'id' => $p['id']
		);
	 	return $this->oauth->get($url,$params); 
	}

	/******************
	*发表一条消息
	*@c: 微博内容
	*@ip: 用户IP(以分析用户所在地)
	*@j: 经度（可以填空）
	*@w: 纬度（可以填空）
	*@p: 图片
	*@r: 父id
	*@u: Url:音乐地址
	*@tit Title:音乐名
	*@a Author:演唱者
	*@type: 1 发表 2 转播 3 回复 4 点评 5 发音乐微博 6 发视频微博
	**********************/
	public function postOne($p){
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'content' => $p['c'],
			'clientip' => $p['ip'],
			'jing' => $p['j'],
			'wei' => $p['w']
		);
		switch($p['type']){
			case 2:
				$url = 'http://open.t.qq.com/api/t/re_add?f=1';
				$params['reid'] = $p['r'];
				return $this->oauth->post($url,$params); 
				break;
			case 3:
				$url = 'http://open.t.qq.com/api/t/reply?f=1';
				$params['reid'] = $p['r'];
				return $this->oauth->post($url,$params); 
				break;
			case 4:
				$url = 'http://open.t.qq.com/api/t/comment?f=1';
				$params['reid'] = $p['r'];
				return $this->oauth->post($url,$params); 
				break;
			case 5:
				$url = 'http://open.t.qq.com/api/t/add_music?f=1';
				$params['url'] = $p['u'];
				$params['title'] = $p['tit'];
				$params['author'] = $p['a'];
				return $this->oauth->post($url,$params); 
				break;
			case 6:
				$url = 'http://open.t.qq.com/api/t/add_video?f=1';
				$params['url'] = $p['u'];
				return $this->oauth->post($url,$params); 
				break;
				
			default:
				if(!empty($p['p'])){
					$url = 'http://open.t.qq.com/api/t/add_pic?f=1';
					$params['pic'] = $p['p'];
					return $this->oauth->post($url,$params,true); 
				}else{
					$url = 'http://open.t.qq.com/api/t/add?f=1';
					return $this->oauth->post($url,$params); 
				}	
			break;			
		}	
	}

	/******************
	*获取视频信息
	*@u: 视频url
	**********************/
	public function getVideo($p){
		$url = 'http://open.t.qq.com/api/t/getvideoinfo?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'url' => $p['u']
		);
	 	return $this->oauth->post($url,$params); 
	}


	/******************
	*删除一条消息
	*@id: 微博ID
	**********************/
	public function delOne($p){
		$url = 'http://open.t.qq.com/api/t/del?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'id' => $p['id']
		);
	 	return $this->oauth->post($url,$params); 
	}	

	/******************
	*获取转播和点评消息列表
	*@reid：转发或者回复根结点ID；
	*@f：（根据dwTime），0：第一页，1：向下翻页，2向上翻页；
	*@t：起始时间戳，上下翻页时才有用，取第一页时忽略；
	*@tid：起始id，用于结果查询中的定位，上下翻页时才有用；
	*@n：要返回的记录的条数(1-20)；
	*@Flag:标识0 转播列表，1点评列表 2 点评与转播列表
	**********************/
	public function getReplay($p){
		$url = 'http://open.t.qq.com/api/t/re_list?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'rootid' => $p['reid'],
			'pageflag' => $p['f'],
			'reqnum' => $p['n'],
			'flag' => $p['flag']
		);
		if(isset($p['t'])){
			$params['pagetime'] = $p['t'];	
		}
		if(isset($p['tid'])){
			$params['twitterid'] = $p['tid'];	
		}
	 	return $this->oauth->get($url,$params); 	
	}

	/******************
	*获取转播数
	*@reid：转发或者回复根结点ID；
	*@f：0 获取转发计数，1点评计数 2 两者都取
	*@ids：微博ID的列表
	**********************/
	public function getReplayCount($p){
		$url = 'http://open.t.qq.com/api/t/re_count?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'ids' => $p['ids'],
			'flag' => $p['f']
		);
	 	return $this->oauth->get($url,$params); 	
	}

	/******************
	*获取当前用户的信息
	*@n:用户名 空表示本人
	**********************/
	public function getUserInfo($p=false){
		if(!$p || !$p['n']){
			$url = 'http://open.t.qq.com/api/user/info?f=1';
			$params = array(
				'format' => MB_RETURN_FORMAT
			);
		}else{
			$url = 'http://open.t.qq.com/api/user/other_info?f=1';
			$params = array(
				'format' => MB_RETURN_FORMAT,
				'name' => $p['n']
			);
		}
	 	return $this->oauth->get($url,$params); 	
	}

	/******************
	*更新用户资料
	*@p 数组,包括以下:
	*@nick: 昵称
	*@sex: 性别 0 ，1：男2：女
	*@year:出生年 1900-2010
	*@month:出生月 1-12
	*@day:出生日 1-31
	*@countrycode:国家码
	*@provincecode:地区码
	*@citycode:城市 码
	*@introduction: 个人介绍
	**********************/
	public function updateMyinfo($p){
		$url = 'http://open.t.qq.com/api/user/update?f=1';
		$p['format'] = MB_RETURN_FORMAT;
	 	return $this->oauth->post($url,$p); 	
	}	

	/******************
	*更新用户教育信息
	Feildid: 教育信息记录ID （添加feildid=1.修改填返回的ID,删除下面四个参数为空）
	Year: 入学年限
	Schoolid:学校ID
	Departmentid: 院系ID
	Level: 学历
	******************/
	public function updateMyEdu($p){
		$url = 'http://open.t.qq.com/api/user/update_edu?f=1';
		$p['format'] = MB_RETURN_FORMAT;
		return $this->oauth->post($url,$p); 	
	}


	/******************
	*更新用户头像
	*@Pic:文件域表单名 本字段不能放入到签名串中
	******************/
	public function updateUserHead($p){
		$url = 'http://open.t.qq.com/api/user/update_head?f=1';
		$p['format'] = MB_RETURN_FORMAT;
		return $this->oauth->post($url, $p, true); 	
	}	

	/******************
	*获取听众列表/偶像列表
	*@num: 请求个数(1-30)
	*@start: 起始位置
	*@n:用户名 空表示本人
	*@type: 0 听众 1 偶像
	**********************/
	public function getfans($p){
		try{
			if($p['n']  == ''){
				$p['type']?$url = 'http://open.t.qq.com/api/friends/idollist':$url = 'http://open.t.qq.com/api/friends/fanslist';
			}else{
				$p['type']?$url = 'http://open.t.qq.com/api/friends/user_idollist':$url = 'http://open.t.qq.com/api/friends/user_fanslist';
			}
			$params = array(
				'format' => MB_RETURN_FORMAT,
				'name' => $p['n'],
				'reqnum' => $p['num'],
				'startindex' => $p['start']
			);
		 	return $this->oauth->get($url,$params);
		} catch(MBException $e) {
			$ret = array("ret"=>0, "msg"=>"ok"
					, "data"=>array("timestamp"=>0, "hasnext"=>1, "info"=>array()));
			return $ret;
		}
	}

	/******************
	 *获取黑名单列表
	 *@num reqnum: 请求个数(1-30)
	 *@s Startindex: 起始位置（第一页填0，继续向下翻页：填：【reqnum*（page-1）】）
	**********************/
	public function getBlack($p){
		$url = 'http://open.t.qq.com/api/friends/blacklist';
		$parmas = array(
			'format' => MB_RETURN_FORMAT,
			'reqnum' => $p['num'],
			'startindex' => $p['s']	
		);
		return $this->oauth->get($url,$params);
	}

	/******************
	 *获取特别收听名单
	 *@num reqnum: 请求个数(1-30)
	 *@s Startindex: 起始位置（第一页填0，继续向下翻页：填：【reqnum*（page-1）】）
	 *@n Name:用户帐户名
	**********************/
	public function getSpecialList($p){
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'reqnum' => $p['num'],
			'startindex' => $p['s']	
		);
		if($p['n'] == ''){
			$url = 'http://open.t.qq.com/api/friends/speciallist';
		}else{
			$url = 'http://open.t.qq.com/api/friends/user_speciallist';
			$params['name'] = $p['n'];
		}
		return $this->oauth->get($url,$params);
	}	

	/******************
	*收听/取消收听某人
	*@n: 用户名
	*@type: 0 取消收听,1 收听 ,2 特别收听 3 取消特别收听 4 加入黑名单 5 从黑名单中删除
	**********************/	
	public function setMyidol($p){
		switch($p['type']){
			case 0:
				$url = 'http://open.t.qq.com/api/friends/del?f=1';
				break;
			case 1:
				$url = 'http://open.t.qq.com/api/friends/add?f=1';
				break;
			case 2:
				$url = 'http://open.t.qq.com/api/friends/addspecail?f=1';
				break;
			case 3:
				$url = 'http://open.t.qq.com/api/friends/delspecial?f=1';
				break;
			case 4:
				$url = 'http://open.t.qq.com/api/friends/addblacklist?f=1';
				break;
			case 5:
				$url = 'http://open.t.qq.com/api/friends/delblacklist';
				break;
		}
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'name' => $p['n']
		);
	 	return $this->oauth->post($url,$params);
	}
	
	/******************
	*检测是否我粉丝或偶像
	*@n: 其他人的帐户名列表（最多30个,逗号分隔）
	*@flag: 0 检测粉丝，1检测偶像
	**********************/	
	public function checkFriend($p){
		$url = 'http://open.t.qq.com/api/friends/check?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'names' => $p['n'],
			'flag' => $p['type']
		);
		return $this->oauth->get($url,$params);
	}

	/******************
	*发私信
	*@c: 微博内容
	*@ip: 用户IP(以分析用户所在地)
	*@j: 经度（可以填空）
	*@w: 纬度（可以填空）
	*@n: 接收方微博帐号
	**********************/
	public function postOneMail($p){
		$url = 'http://open.t.qq.com/api/private/add?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'content' => $p['c'],
			'clientip' => $p['ip'],
			'jing' => $p['j'],
			'wei' => $p['w'],
			'name' => $p['n']
			);
		return $this->oauth->post($url,$params); 
	}
	
	/******************
	*删除一封私信
	*@id: 微博ID
	**********************/
	public function delOneMail($p){
		$url = 'http://open.t.qq.com/api/private/del?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'id' => $p['id']
		);
	 	return $this->oauth->post($url,$params); 
	}
	
	/******************
	*私信收件箱和发件箱
	*@f 分页标识（0：第一页，1：向下翻页，2向上翻页）
	*@t: 本页起始时间（第一页 0，继续：根据返回记录时间决定）
	*@n: 每次请求记录的条数（1-20条）
	*@type : 0 发件箱 1 收件箱
	**********************/	
	public function getMailBox($p){
		if($p['type']){
			$url = 'http://open.t.qq.com/api/private/recv?f=1';
		}else{
			$url = 'http://open.t.qq.com/api/private/send?f=1';
		}
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'pageflag' => $p['f'],
			'pagetime' => $p['t'],
			'reqnum' => $p['n']
		);
	 	return $this->oauth->get($url,$params);		
	}	

	/******************
	*搜索
	*@k:搜索关键字
	*@n: 每页大小
	*@p: 页码
	*@type : 0 用户 1 消息 2 话题 3 标签 
	**********************/	
	public function getSearch($p){
		switch($p['type']){
			case 0:
				$url = 'http://open.t.qq.com/api/search/user?f=1';
				break;
			case 1:
				$url = 'http://open.t.qq.com/api/search/t?f=1';
				break;/*
			case 2:
				$url = 'http://open.t.qq.com/api/search/ht?f=1';
				break;*/
			case 3:
				$url = 'http://open.t.qq.com/api/search/userbytag';
				break;
			default:
				$url = 'http://open.t.qq.com/api/search/t?f=1';
				break;
		}	
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'keyword' => $p['c'],
			'pagesize' => $p['n'],
			'Page' => $p['p']
		);
	 	return $this->oauth->get($url,$params);		
	}			

	/******************
	*查看数据更新条数
	*@op :请求类型 0：只请求更新数，不清除更新数，1：请求更新数，并对更新数清零
	*@type：5 首页未读消息记数，6 @页消息记数 7 私信页消息计数 8 新增粉丝数 9 首页广播数（原创的）
	**********************/	
	public function getUpdate($p){
		$url = 'http://open.t.qq.com/api/info/update?f=1';
		if(isset($p['type'])){
			if($p['op']){
				$params = array(
					'format' => MB_RETURN_FORMAT,
					'op' => $p['op'],
					'type' => $p['type']
				);			
			}else{
				$params = array(
					'format' => MB_RETURN_FORMAT,
					'op' => $p['op']
				);			
			}
		}else{
			$params = array(
				'format' => MB_RETURN_FORMAT,
				'op' => $p['op']
			);
		}
	 	return $this->oauth->get($url,$params);		
	}	

	/******************
	*添加/删除 收藏的微博
	*@id : 微博id
	*@type：1 添加 0 删除
	**********************/	
	public function postFavMsg($p){
		if($p['type']){
			$url = 'http://open.t.qq.com/api/fav/addt?f=1';
		}else{
			$url = 'http://open.t.qq.com/api/fav/delt?f=1';
		}
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'id' => $p['id']
		);
	 	return $this->oauth->post($url,$params);		
	}

	/******************
	*添加/删除 收藏的话题
	*@id : 微博id
	*@type：1 添加 0 删除
	**********************/	
	public function postFavTopic($p){
		if($p['type']){
			$url = 'http://open.t.qq.com/api/fav/addht?f=1';
		}else{
			$url = 'http://open.t.qq.com/api/fav/delht?f=1';
		}
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'id' => $p['id']
		);
	 	return $this->oauth->post($url,$params);		
	}	

	/******************
	*获取收藏的内容
	*******话题
	n:请求数，最多15
	f:翻页标识  0：首页   1：向下翻页 2：向上翻页
	t:翻页时间戳0
	lid:翻页话题ID，第次请求时为0
	*******消息
	f 分页标识（0：第一页，1：向下翻页，2向上翻页）
	t: 本页起始时间（第一页 0，继续：根据返回记录时间决定）
	n: 每次请求记录的条数（1-20条）
	*@type 0 收藏的消息  1 收藏的话题
	**********************/	
	public function getFav($p){
		if($p['type']){
			$url = 'http://open.t.qq.com/api/fav/list_ht?f=1';
			$params = array(
				'format' => MB_RETURN_FORMAT,
				'reqnum' => $p['n'],		
				'pageflag' => $p['f'],		
				'pagetime' => $p['t'],		
				'lastid' => $p['lid']		
				);
		}else{
			$url = 'http://open.t.qq.com/api/fav/list_t?f=1';	
			$params = array(
				'format' => MB_RETURN_FORMAT,
				'reqnum' => $p['n'],		
				'pageflag' => $p['f'],		
				'pagetime' => $p['t']		
				);
		}
	 	return $this->oauth->get($url,$params);		
	}

	/******************
	*获取话题id
	*@list: 话题名字列表（abc,efg,）
	**********************/	
	public function getTopicId($p){
			$url = 'http://open.t.qq.com/api/ht/ids?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'httexts' => $p['list']
		);
	 	return $this->oauth->get($url,$params);		
	}	

	/******************
	*获取话题内容
	*@list: 话题id列表（abc,efg,）
	**********************/	
	public function getTopicList($p){
			$url = 'http://open.t.qq.com/api/ht/info?f=1';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'ids' => $p['list']
		);
	 	return $this->oauth->get($url,$params);		
	}	

	/******************
	*添加标签
	*@t: 标签内容
	**********************/	
	public function addTag($p){
		$url = 'http://open.t.qq.com/api/tag/add';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'tag' => $p['t']
		);
	 	return $this->oauth->post($url,$params);		
	}	

	/******************
	*删除标签
	*@i: 标签ID
	**********************/	
	public function delTag($p){
		$url = 'http://open.t.qq.com/api/tag/del';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'tagid' => $p['i']
		);
	 	return $this->oauth->post($url,$params);		
	}	
	

	/******************
	*话题热榜
	*@t  请求类型 1 话题名，2 搜索关键字 3 两种类型都有
	*@num Reqnum: 请求个数（最多20）
	*@p Pos :请求位置，第一次请求时填0，继续填上次返回的POS
	**********************/	
	public function htHot($p){
		$url = 'http://open.t.qq.com/api/trends/ht';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'type' => $p['t'],
			'reqnum' => $p['num'],
			'pos' => $p['p'],
		);
	 	return $this->oauth->post($url,$params);		
	}			
	
	/******************
	*转播热榜
	*@num Reqnum: 请求个数（最多20）
	*@p Pos :请求位置，第一次请求时填0，继续填上次返回的POS
	**********************/	
	public function rHot($p){
		$url = 'http://open.t.qq.com/api/trends/t';
		$params = array(
			'format' => MB_RETURN_FORMAT,
			'reqnum' => $p['num'],
			'pos' => $p['p'],
		);
	 	return $this->oauth->post($url,$params);		
	}

	/******************
	*我可能认识的人
	*@num Reqnum: 请求个数（最多20）
	*@p Pos :请求位置，第一次请求时填0，继续填上次返回的POS
	**********************/	
	public function kownPerson(){
		$url = 'http://open.t.qq.com/api/other/kownperson';
		$params = array(
			'format' => MB_RETURN_FORMAT
		);
	 	return $this->oauth->post($url,$params);		
	}	
	
	/******************
	*数组格式化输出函数
	*******************/	
	function printArr($var){
		echo '<pre>';
		print_r($var);
	}
}
?>
