<?php 

class QQOAuth {

    public $appid = '';
    public $appkey = '';

    public $_token = '';
    public $_token_secret = '';

    function __construct($appid, $appkey, $oauth_token=null, $oauth_token_secret=null) {
        $this->appid = $appid;
        $this->appkey = $appkey;
        if (!empty($oauth_token) && !empty($oauth_token_secret)) { 
            $this->_token = $oauth_token;
            $this->_token_secret = $oauth_token_secret;
        }
    }

    function getRequestToken() {
        global $_G;
        //ʱtokenĽӿڵַ
        $url    = "http://openapi.qzone.qq.com/oauth/qzoneoauth_request_token?";
        //oauth_signatureǩֵ
        $sigstr = "GET"."&".QQConnect_urlencode("http://openapi.qzone.qq.com/oauth/qzoneoauth_request_token")."&";
        //Ҫ
        $params = array();
        $params["oauth_version"]          = "1.0";
        $params["oauth_signature_method"] = "HMAC-SHA1";
        $params["oauth_timestamp"]        = $_G['timestamp'];
        $params["oauth_nonce"]            = mt_rand();
        $params["oauth_consumer_key"]     = $this->appid;
        //Բĸл
        $normalized_str = get_normalized_string($params);
        $sigstr        .= QQConnect_urlencode($normalized_str);
        //2Կ
        $key = $this->appkey."&";
        //3oauth_signatureǩֵҪȷPHP汾֧hash_hmac
        $signature = get_signature($sigstr, $key);
        //url
        $url      .= $normalized_str."&"."oauth_signature=".QQConnect_urlencode($signature);
        $request_token = file_get_contents($url);
        //ȡtoken
        if (strpos($request_token, "error_code") !== false) {
            echo '<html lang="zh-cn">';
            echo '<head>';
            echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
            echo '</head>';
            echo '<body>';
            echo "<h3>url:</h3>$url</br>";
            echo "<h3>return:</h3>$request_token</br>";
            echo "<h3>time:</h3>".date('Y-m-d H:i:s',$_G['timestamp'])."</br>";
            echo '</body>';
            echo '</html>';
            exit;
        }
        //ֵ
        $result = array();
        parse_str($request_token, $result);
        return $result;
        /*
        $_SESSION["token"]        = $result["oauth_token"];
        $_SESSION["secret"]       = $result["oauth_token_secret"];
        */
    }

    function getAuthorizeURL($oauth_token, $callback) {
        //תQQ¼ҳĽӿڵַ, Ҫ!!
        $redirect = "http://openapi.qzone.qq.com/oauth/qzoneoauth_authorize?oauth_consumer_key=".$this->appid."&";
        //URL
        $redirect .= "oauth_token=".$oauth_token."&oauth_callback=".QQConnect_urlencode($callback);
        return $redirect;
    }

    function getAccessToken($vericode) {
        global $_G, $QQsig;
        //QzoneȨ޵access_tokenĽӿڵַ, Ҫ!!
        $url    = "http://openapi.qzone.qq.com/oauth/qzoneoauth_access_token?";
       
        //oauth_signatureǩֵǩֵɷhttp://wiki.opensns.qq.com/wiki/QQ¼ǩoauth_signature˵
        //1 ǩֵԴHTTPʽ & urlencode(uri) & urlencode(a=x&b=y&...)
        $sigstr = "GET"."&".QQConnect_urlencode("http://openapi.qzone.qq.com/oauth/qzoneoauth_access_token")."&";

        //ҪҪ!!
        $params = array();
        $params["oauth_version"]          = "1.0";
        $params["oauth_signature_method"] = "HMAC-SHA1";
        $params["oauth_timestamp"]        = $_G['timestamp'];
        $params["oauth_nonce"]            = mt_rand();
        $params["oauth_consumer_key"]     = $this->appid;
        $params["oauth_token"]            = $this->_token;
        $params["oauth_vericode"]         = $vericode;

        //Բĸл
        $normalized_str = get_normalized_string($params);
        $sigstr        .= QQConnect_urlencode($normalized_str);
        //echo "sigstr = $sigstr";
        //2Կ
        $key = $this->appkey."&".$this->_token_secret;
        //3oauth_signatureǩֵҪȷPHP汾֧hash_hmac
        $signature = get_signature($sigstr, $key);
        //url
        $url      .= $normalized_str."&"."oauth_signature=".QQConnect_urlencode($signature);
        //ȡ
        $access_str = file_get_contents($url);
        //
        if (strpos($access_str, "error_code") !== false) {
            echo '<html lang="zh-cn">';
            echo '<head>';
            echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
            echo '</head>';
            echo '<body>';
            echo "<h3>signature url:</h3>$url</br>";
            echo "<h3>return:</h3>$access_str";
            echo "<h3>time:</h3>".date('Y-m-d H:i:s',$_G['timestamp'])."</br>";
            echo '</body>';
            echo '</html>';
            exit;
        }
        //ز
        $result = array();
        parse_str($access_str, $result);
        //access tokenopenid
        /*
        $_SESSION["token"]   = $result["oauth_token"];
        $_SESSION["secret"]  = $result["oauth_token_secret"]; 
        $_SESSION["openid"]  = $result["openid"];
        
        if (!is_valid_openid($this->appid, $result["openid"], $_REQUEST["timestamp"], $_REQUEST["oauth_signature"])) {
            echo '<html lang="zh-cn">';
            echo '<head>';
            echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
            echo '</head>';
            echo '<body>';
            echo "<h3>invalid openid</h3>";
            print_r($_REQUEST);
            echo "<h3>error signature:</h3>current:".$_REQUEST["oauth_signature"].'<br />right:'.$QQsig;
            echo "<h3>time:</h3>".date('Y-m-d H:i:s',$_G['timestamp'])."</br>";
            echo '</body>';
            echo '</html>';
            exit;
        }
        */
        return $result;
    }

}

class QQClient {

    public $appid = '';
    public $appkey = '';

    public $_token = '';
    public $_token_secret = '';
    public $_openid = '';

    function __construct($appid, $appkey, $oauth_token, $oauth_token_secret, $openid) {
        $this->appid = $appid;
        $this->appkey = $appkey;
        $this->token = $oauth_token;
        $this->token_secret = $oauth_token_secret;
        $this->openid = $openid;
    }

     /*
     * @brief ȡûϢ.辭URL룬ʱѭ RFC 1738
     * 
     */
    function verify_credentials()
    {
        //ȡûϢĽӿڵַ, Ҫ!!
        $url    = "http://openapi.qzone.qq.com/user/get_user_info";
        $info   = do_get($url, $this->appid, $this->appkey, $this->token, $this->token_secret, $this->openid);
        $arr = array();
        $arr = json_decode($info, true);
        return $arr;
    }

}

/**
 * @brief QQ¼жurlͳһ
 * RFC 1738 URLб
 * -_.~֮зĸַ滻ɰٷֺ(%)λʮ
 */
$QQhexchars = "0123456789ABCDEF";
$QQsig = '';
function QQConnect_urlencode($str)
{
    global $QQhexchars;
    $urlencode = "";
    $len = strlen($str);

    for($x = 0 ; $len--; $x++)
    {
        if (($str[$x] < '0' && $str[$x] != '-' && $str[$x] != '.') ||
            ($str[$x] < 'A' && $str[$x] > '9') ||
            ($str[$x] > 'Z' && $str[$x] < 'a' && $str[$x] != '_') ||
            ($str[$x] > 'z' && $str[$x] != '~')) 
        {
            $urlencode .= '%';
            $urlencode .= $QQhexchars[(ord($str[$x]) >> 4)];
            $urlencode .= $QQhexchars[(ord($str[$x]) & 15)];
        }
        else
        {
            $urlencode .= $str[$x];
        }
    }

    return $urlencode;
}

function QQConnect_urldecode($str)
{
    global $QQhexchars;
    $urldecode = "";
    $len = strlen($str);

    for ($x = 0; $x < $len; $x++)
    {
        if ($str[$x] == '%' && ($len - $x) > 2
            && (strpos($QQhexchars, $str[$x+1]) !== false) && (strpos($QQhexchars, $str[$x+2]) !== false))
        {
            $tmp = $str[$x+1].$str[$x+2];
            $urldecode .= chr(hexdec($tmp));
            $x += 2;
        }
        else
        {
            $urldecode .= $str[$x];
        } 
    }

    return $urldecode;
}

/**
 * @brief Բֵ
 *
 * @param $params б
 *
 * @return &ӵkey-valueԣkey1=value1&key2=value2...)
 */
function get_normalized_string($params)
{
    ksort($params);
    $normalized = array();
    foreach($params as $key => $val)
    {
        $normalized[] = $key."=".$val;
    }

    return implode("&", $normalized);
}

/**
 * @brief ʹHMAC-SHA1㷨oauth_signatureǩֵ 
 *
 * @param $key  Կ
 * @param $str  Դ
 *
 * @return ǩֵ
 */

function get_signature($str, $key)
{
    $signature = "";
    if (function_exists('hash_hmac'))
    {
        $signature = base64_encode(hash_hmac("sha1", $str, $key, true));
    }
    else
    {
        $blocksize	= 64;
        $hashfunc	= 'sha1';
        if (strlen($key) > $blocksize)
        {
            $key = pack('H*', $hashfunc($key));
        }
        $key	= str_pad($key,$blocksize,chr(0x00));
        $ipad	= str_repeat(chr(0x36),$blocksize);
        $opad	= str_repeat(chr(0x5c),$blocksize);
        $hmac 	= pack(
            'H*',$hashfunc(
                ($key^$opad).pack(
                    'H*',$hashfunc(
                        ($key^$ipad).$str
                    )
                )
            )
        );
        $signature = base64_encode($hmac);
    }

    return $signature;
} 

/**
 * @brief ַURL룬ѭrfc1738 urlencode
 *
 * @param $params
 *
 * @return URLַ
 */
function get_urlencode_string($params)
{
    ksort($params);
    $normalized = array();
    foreach($params as $key => $val)
    {
        $normalized[] = $key."=".QQConnect_urlencode($val);
    }

    return implode("&", $normalized);
}

/**
 * @brief openidǷϷ
 *
 * @param $appkey  appkey
 * @param $openid  ûQQһһӦ
 * @param $timestampʱ
 * @param $sigǩֵ
 *
 * @return true or false
 */
function is_valid_openid($appkey, $openid, $timestamp, $sig) {
    global $QQsig;
    $str = $openid . $timestamp;
    $QQsig = get_signature($str, $appkey);
    return $sig == $QQsig; 
}

/**
 * @brief Get󶼿ʹ
 *
 * @param $url
 * @param $appid
 * @param $appkey
 * @param $access_token
 * @param $access_token_secret
 * @param $openid
 *
 * @return true or false
 */
function do_get($url, $appid, $appkey, $access_token, $access_token_secret, $openid) {
    global $_G;
    $sigstr = "GET"."&".QQConnect_urlencode($url)."&";

    //Ҫ, Ҫ!!
    $params = $_GET;
    $params["oauth_version"]          = "1.0";
    $params["oauth_signature_method"] = "HMAC-SHA1";
    $params["oauth_timestamp"]        = $_G['timestamp'];
    $params["oauth_nonce"]            = mt_rand();
    $params["oauth_consumer_key"]     = $appid;
    $params["oauth_token"]            = $access_token;
    $params["openid"]                 = $openid;
    unset($params["oauth_signature"]);

    //ĸл
    $normalized_str = get_normalized_string($params);
    $sigstr        .= QQConnect_urlencode($normalized_str);

    //ǩ,ȷphp汾֧hash_hmac
    $key = $appkey."&".$access_token_secret;
    $signature = get_signature($sigstr, $key);
    $url      .= "?".$normalized_str."&"."oauth_signature=".QQConnect_urlencode($signature);

    //echo "$url\n";
    return file_get_contents($url);
}

/**
 * @brief multi-part post 󶼿ʹ
 *
 * @param $url
 * @param $appid
 * @param $appkey
 * @param $access_token
 * @param $access_token_secret
 * @param $openid
 *
 */
function do_multi_post($url, $appid, $appkey, $access_token, $access_token_secret, $openid) {
    global $_G;
    //ǩ.Դ:[GET|POST]&uri&ĸ
    $sigstr = "POST"."&"."$url"."&";

    //Ҫ,Ҫ!!
    $params = $_POST;
    $params["oauth_version"]          = "1.0";
    $params["oauth_signature_method"] = "HMAC-SHA1";
    $params["oauth_timestamp"]        = $_G['timestamp'];
    $params["oauth_nonce"]            = mt_rand();
    $params["oauth_consumer_key"]     = $appid;
    $params["oauth_token"]            = $access_token;
    $params["openid"]                 = $openid;
    unset($params["oauth_signature"]);


    //ȡϴͼƬϢ
    foreach ($_FILES as $filename => $filevalue)
    {
        if ($filevalue["error"] != UPLOAD_ERR_OK)
        {
            //echo "upload file error $filevalue['error']\n";
            //exit;
        } 
        $params[$filename] = file_get_contents($filevalue["tmp_name"]);
    }

    //Բĸл
    $sigstr .= get_normalized_string($params);

    //ǩ,Ҫȷphp汾֧hash_hmac
    $key = $appkey."&".$access_token_secret;
    $signature = get_signature($sigstr, $key);
    $params["oauth_signature"] = $signature; 

    //ϴͼƬ
    foreach ($_FILES as $filename => $filevalue)
    {
        $tmpfile = dirname($filevalue["tmp_name"])."/".$filevalue["name"];
        move_uploaded_file($filevalue["tmp_name"], $tmpfile);
        $params[$filename] = "@$tmpfile";
    }

    /*
    echo "len: ".strlen($sigstr)."\n";
    echo "sig: $sigstr\n";
    echo "key: $appkey&\n";
    */

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 
    curl_setopt($ch, CURLOPT_POST, TRUE); 
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params); 
    curl_setopt($ch, CURLOPT_URL, $url);
    $ret = curl_exec($ch);
    //$httpinfo = curl_getinfo($ch);
    //print_r($httpinfo);

    curl_close($ch);
    //ɾϴʱļ
    unlink($tmpfile);
    return $ret;

}


/**
 * @brief post 󶼿ʹ
 *
 * @param $url
 * @param $appid
 * @param $appkey
 * @param $access_token
 * @param $access_token_secret
 * @param $openid
 *
 */
function do_post($url, $appid, $appkey, $access_token, $access_token_secret, $openid) {
    global $_G;
    //ǩ.Դ:[GET|POST]&uri&ĸ
    $sigstr = "POST"."&".QQConnect_urlencode($url)."&";

    //Ҫ,Ҫ!!
    $params = $_POST;
    $params["oauth_version"]          = "1.0";
    $params["oauth_signature_method"] = "HMAC-SHA1";
    $params["oauth_timestamp"]        = $_G['timestamp'];
    $params["oauth_nonce"]            = mt_rand();
    $params["oauth_consumer_key"]     = $appid;
    $params["oauth_token"]            = $access_token;
    $params["openid"]                 = $openid;
    unset($params["oauth_signature"]);

    //Բĸл
    $sigstr .= QQConnect_urlencode(get_normalized_string($params));

    //ǩ,Ҫȷphp汾֧hash_hmac
    $key = $appkey."&".$access_token_secret;
    $signature = get_signature($sigstr, $key); 
    $params["oauth_signature"] = $signature; 

    $postdata = get_urlencode_string($params);

    //echo "$sigstr******\n";
    //echo "$postdata\n";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 
    curl_setopt($ch, CURLOPT_POST, TRUE); 
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata); 
    curl_setopt($ch, CURLOPT_URL, $url);
    $ret = curl_exec($ch);

    curl_close($ch);
    return $ret;

}