<?php
/**
 * KindEditor PHP
 * 
 * PHPʾ򣬽鲻ҪֱʵĿʹá
 * ȷֱʹñʹ֮ǰϸȷذȫá
 * 
 */

require_once 'JSON.php';
 
$php_path = dirname(__FILE__) . '/';
$php_url = dirname($_SERVER['PHP_SELF']) . '/';

//Ŀ¼·ָ· /var/www/attached/
$root_path = $php_path . '../attached/';
//Ŀ¼URLָ· http://www.yoursite.com/attached/
$root_url = $php_url . '../attached/';
//ͼƬչ
$ext_arr = array('gif', 'jpg', 'jpeg', 'png', 'bmp');

//pathø·URL
if (empty($_GET['path'])) {
	$current_path = realpath($root_path) . '/';
	$current_url = $root_url;
	$current_dir_path = '';
	$moveup_dir_path = '';
} else {
	$current_path = realpath($root_path) . '/' . $_GET['path'];
	$current_url = $root_url . $_GET['path'];
	$current_dir_path = $_GET['path'];
	$moveup_dir_path = preg_replace('/(.*?)[^\/]+\/$/', '$1', $current_dir_path);
}
//ʽname or size or type
$order = empty($_GET['order']) ? 'name' : strtolower($_GET['order']);

//ʹ..ƶһĿ¼
if (preg_match('/\.\./', $current_path)) {
	echo 'Access is not allowed.';
	exit;
}
//һַ/
if (!preg_match('/\/$/', $current_path)) {
	echo 'Parameter is not valid.';
	exit;
}
//Ŀ¼ڻĿ¼
if (!file_exists($current_path) || !is_dir($current_path)) {
	echo 'Directory does not exist.';
	exit;
}

//Ŀ¼ȡļϢ
$file_list = array();
if ($handle = opendir($current_path)) {
	$i = 0;
	while (false !== ($filename = readdir($handle))) {
		if ($filename{0} == '.') continue;
		$file = $current_path . $filename;
		if (is_dir($file)) {
			$file_list[$i]['is_dir'] = true; //Ƿļ
			$file_list[$i]['has_file'] = (count(scandir($file)) > 2); //ļǷļ
			$file_list[$i]['filesize'] = 0; //ļС
			$file_list[$i]['is_photo'] = false; //ǷͼƬ
			$file_list[$i]['filetype'] = ''; //ļչж
		} else {
			$file_list[$i]['is_dir'] = false;
			$file_list[$i]['has_file'] = false;
			$file_list[$i]['filesize'] = filesize($file);
			$file_list[$i]['dir_path'] = '';
			$file_ext = strtolower(array_pop(explode('.', trim($file))));
			$file_list[$i]['is_photo'] = in_array($file_ext, $ext_arr);
			$file_list[$i]['filetype'] = $file_ext;
		}
		$file_list[$i]['filename'] = $filename; //ļչ
		$file_list[$i]['datetime'] = date('Y-m-d H:i:s', filemtime($file)); //ļ޸ʱ
		$i++;
	}
	closedir($handle);
}

//
function cmp_func($a, $b) {
	global $order;
	if ($a['is_dir'] && !$b['is_dir']) {
		return -1;
	} else if (!$a['is_dir'] && $b['is_dir']) {
		return 1;
	} else {
		if ($order == 'size') {
			if ($a['filesize'] > $b['filesize']) {
				return 1;
			} else if ($a['filesize'] < $b['filesize']) {
				return -1;
			} else {
				return 0;
			}
		} else if ($order == 'type') {
			return strcmp($a['filetype'], $b['filetype']);
		} else {
			return strcmp($a['filename'], $b['filename']);
		}
	}
}
usort($file_list, 'cmp_func');

$result = array();
//ڸĿ¼һĿ¼
$result['moveup_dir_path'] = $moveup_dir_path;
//ڸĿ¼ĵǰĿ¼
$result['current_dir_path'] = $current_dir_path;
//ǰĿ¼URL
$result['current_url'] = $current_url;
//ļ
$result['total_count'] = count($file_list);
//ļб
$result['file_list'] = $file_list;

//JSONַ
header('Content-type: application/json; charset=UTF-8');
$json = new Services_JSON();
echo $json->encode($result);
?>
