<?php
// ̨
class AccessAction extends BaseAction {
	protected function _initializeMore() {
		$this -> obj = M('access');
	}
	public function defaults() {
		$pid = intval(R('id'));
		$page = intval(R('page', 'get'));
		$page = max($page, 1);
		$pageSize = 20;
		$this -> assign('pid', $pid);
		$this -> assign('data', $this -> obj -> getList($page, $pageSize, 'pid=' . $pid, array('orderid', 'ismenu DESC', 'id')));
		$this -> assign('pages', $this -> obj -> pages());
		$this -> display('access');
	}
	public function add() {
		if ($this -> isSubmit) {
			if ($this -> obj -> save()) {
				$this -> showMsg(L('OPERATE_SUCCESS'));
			} else {
				$msg = $this -> obj -> error ? $this -> obj -> error : L('OPERATE_FAIL');
				$this -> showMsg($msg);
			}
		}
		$pid = intval(R('id'));
		$this -> assign('data', array('id' => 0, 'pid' => $pid, 'name' => '', 'control' => '', 'action' => '', 'description' => '', 'ismenu' => 0, 'target' => 'right', 'iscustom' => '', 'roleids' => array(), 'isparent' => 0));
		$this -> assign('parents', $this -> obj -> getList('', 0, 'pid=0', 'orderid,id'));
		$this -> assign('isparent', 0);
		$this -> assign('role', Cache :: read('role', '', 0, 'Data'));
		$this -> display('access');
	}
	public function edit() {
		if ($this -> isSubmit) {
			if ($this -> obj -> save()) {
				$this -> showMsg(L('OPERATE_SUCCESS'), $this -> forward);
			} else {
				$msg = $this -> obj -> error ? $this -> obj -> error : L('OPERATE_FAIL');
				$this -> showMsg($msg);
			}
		}
		$id = intval(R('id'));
		$data = $this -> obj -> find($id);
		$data['roleids'] = explode(',', $data['roleids']);
		if ($data['pid'] == 0) {
			$data['isparent'] = $this -> obj -> where("pid=$id") -> count();
		} else $data['isparent'] = 0;
		$this -> assign('data', $data);
		$this -> assign('parents', $this -> obj -> getList('', 0, 'pid=0', 'orderid,id'));
		$this -> assign('role', Cache :: read('role', '', 0, 'Data'));
		$this -> display('access');
	}
	public function del() {
		$id = intval(R('id'));
		$this -> obj -> where("pid=$id") -> delete(); //ɾӽڵ
		$msg = $this -> obj -> delete($id) ? L('OPERATE_SUCCESS') : L('OPERATE_FAIL'); //ɾǰڵ
		$this -> showMsg($msg);
	}
	public function order() {
		$selarray = explode(',', $_POST['selids']);
		foreach($selarray as $id) {
			$this -> obj -> where("id=$id") -> create(array('orderid' => $_POST['orderid'][$id])) -> update();
		}
		$this -> showMsg(L('OPERATE_SUCCESS'), $_SERVER['HTTP_REFERER']);
	}
	// 
	public function __destruct() {
		M('access') -> cache();
	}
}
