<?php
// Welcome to use Jxcms OOP PHP Framework
class AttachmentAction extends BaseAction {
	public function config() {
		$id = intval(R('id'));
		$module = M('module') -> find($id);
		$configObj = M('config');
		if ($this -> isSubmit) {
			$config = R('info', 'post');
			$default = R('default', 'post'); //Ĭ,:ѡûйѡֵ,ָͨ key1=value1|key2=value2
			if (!empty($default)) {
				$tmp = explode('|', $default);
				foreach($tmp as $tmp1) {
					$tmp2 = explode('=', $tmp1);
					if (!isset($config[$tmp2[0]])) $config[$tmp2[0]] = $tmp2[1];
				}
			}
			$config['uploadmaxsize'] = $config['uploadmaxsize'] * 1000;
			if ($configObj -> save($config, $module['name'])) {
				$this -> showMsg(L('OPERATE_SUCCESS'));
			} else {
				$msg = $configObj -> error ? $configObj -> error : L('OPERATE_FAIL');
				$this -> showMsg($msg);
			}
		}
		$data = $configObj -> get($module['name']);
		$data['uploadmaxsize'] = $data['uploadmaxsize'] / 1000;
		$fonts = array();
		foreach(glob('statics/mark/*.ttf') as $tmp) {
			$fonts[] = basename($tmp);
		}
		$this -> assign('module', $module);
		$this -> assign('data', $data);
		$this -> assign('fonts', $fonts);
		$this -> display($module['name'] . '_config');
	}
	public function defaults() {
		switch (R('type')) {
			case 'hour':
				$where = 'uploadtime>=' . (TIME - 3600);
				break;
			case 'day':
				$where = 'uploadtime>=' . (TIME - 86400);
				break;
			case 'month':
				$where = 'uploadtime>=' . (TIME - 2592000);
				break;
			case 'fmonth':
				$where = 'uploadtime<' . (TIME - 2592000);
				break;
			case 'fyear':
				$where = 'uploadtime<' . (TIME - 946080000);
				break;
			default:
				$where = '';
				break;
		}
		if (R('field')) {
			$order = R('order')?strtoupper(R('order')):'DESC';
			$order = R('field') . ' ' . $order;
		} else $order = 'orderid ASC, aid DESC';
		$attachmentObj = M('attachment');
		if(C('deltime', 0, 'attachment')){
			$tmp = TIME - C('deltime', 0, 'attachment') * 60;
			$attachmentObj -> del(array('contentid=0', 'uploadtime<' . $tmp));
		}
		$page = intval(R('page'));
		$pageSize = 20;
		$this -> assign('page', $page);
		$this -> assign('data', $attachmentObj -> getList($page, $pageSize, $where, $order));
		$this -> assign('pages', $attachmentObj -> pages());
		$this -> assign('startNo', $attachmentObj -> startNo);
		$this -> assign('order', strtoupper(R('order'))=='DESC'?'ASC':'DESC');
		$this -> assign('orderurl', '?' . del_query_string('order|field'));
		$this -> display('attachment');
	}
	public function del(){
		$selids = R('selids');
		if (!empty($selids)) {
			M('attachment') -> del(is_numeric($selids)?'aid='.intval($selids):'aid IN ('.$selids.')');
			$this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
		} else $this -> showMsg(L('NOPARAM'));
	}
}
