<?php
// Ŀ
class CategoryAction extends BaseAction {
	protected function _initializeMore() {
		$this -> obj = M('category');
	}
	public function defaults() {
		$page = intval(R('page'));
		$pid = intval(R('pid'));
		$this -> assign('pid', $pid);
		$this -> assign('category', Cache :: read('category'));
		$this -> assign('data', $this -> obj -> getList($page, 20, 'pid='.$pid, 'orderid,catid'));
		$this -> assign('pages', $this -> obj -> pages());
		$this -> assign('module', get_module());
		$this -> display('category');
	}
	public function add() {
		$type = intval(R('type'));
		$pid = intval(R('pid'));
		$moduleid = intval(R('moduleid'));
		if ($this -> isSubmit) {
			if (!$type) {
				$info = R('info', 'post');
				$num = 0;
				foreach($info as $data) {
					if ($data['name']) {
						$addData = array('catid' => $this -> obj -> getId('catid'), 'moduleid' => $moduleid, 'type' => $type, 'pid' => $pid);
						$data = array_merge($data, $addData);
						$data = $this -> checkDir($data);
						$this -> obj -> create($data) -> add();
						$num++;
					}
				}
				if ($num) {
					$msg = sprintf(L('CATEGORY_ADD_SUCCESS'), $num);
					$url = "?c=category&a=add&pid={$pid}&type={$type}";
				}
			} else {
				$this -> obj -> create();
				$this -> obj -> catid = $this -> obj -> getId('catid');
				if ($type === 1)$this -> obj -> data = $this -> checkDir($this -> obj -> data);
				if ($this -> obj -> add()) {
					$msg = L('OPERATE_SUCCESS');
					$url = "?c=category&a=add&pid={$pid}&type={$type}";
				}
			}
			if (empty($msg)) {
				$msg = L('OPERATE_FAIL');
				$url = 'back';
			}
			$this -> showMsg($msg, $url);
		}
		$module = get_module();
		$step = intval(R('step'));
		if ($step == 2) { // 2,ĿϢ
			if (!$type) {
				$addnum = intval(R('addnum'));
				if ($addnum < 1) $addnum = 5;
				$this -> assign('addnum', $addnum);
				$this -> assign('module', $module[$moduleid]); //ѡĳһģ
			}
		} else { // 1,ѡҪӵĿ͡ϼĿϢ
			$step = 1; //$stepΪ1
			$this -> assign('module', $module); //ȫģ
			if ($pid) {
				$category = Cache :: read('category', $pid);
				$moduleid = $category['moduleid'];
			} else $moduleid = 0;
			$this -> assign('moduleid', $moduleid);
		}
		$this -> assign('step', $step);
		$this -> assign('pid', $pid);
		$this -> assign('type', $type);
		$this -> display('category');
	}
	public function edit() {
		$catid = intval(R('catid'));
		if ($this -> isSubmit) {
			$this -> obj -> create();
			if ($this -> obj -> type < 2)$this -> obj -> data = $this -> checkDir($this -> obj -> data);
			if (empty($this -> obj -> data['istransfer'])) {
				$this -> obj -> data['istransfer'] = 0;
			}
			$category = Cache :: read('category', $catid);
			if ($category['dir']) {
				$oldDir = JXCMS_ROOT . C('htmldir') . $category['dir'];
				if (is_dir($oldDir)) {
					if ($this -> obj -> pid) {
						$category = Cache :: read('category', $this -> obj -> pid);
						$newDir = C('htmldir') . $category['dir'] . '/' . $this -> obj -> dir;
					} else $newDir = JXCMS_ROOT . C('htmldir') . $this -> obj -> dir;
					rename($oldDir, $newDir);
					if ($this -> obj -> type == 1) {
						$oldFile = $oldDir . C('htmlext');
						if (is_file($oldFile)) rename($oldFile, $newDir . C('htmlext'));
					}
				}
			}
			if ($this -> obj -> update()) {
				$msg = L('OPERATE_SUCCESS');
				$url = $this -> forward;
			} else {
				$msg = L('OPERATE_FAIL');
				$url = 'back';
			}
			$this -> showMsg($msg, $url);
		}
		$style = array();
		foreach(glob(JXCMS_ROOT . 'templates/*', GLOB_ONLYDIR) as $subdir) {
			$tpldir = substr(strrchr($subdir, '/'), 1);
			$tpldir == 'admin' or $style[] = $tpldir;
		}
		$this -> assign('data', $this -> obj -> find($catid));
		$this -> assign('style', $style);
		$this -> assign('module', get_module());
		$this -> display('category');
	}
	public function del() {
		$msg = $this -> obj -> del()?L('OPERATE_SUCCESS'):L('OPERATE_FAIL');
		$this -> showMsg($msg, $this -> referer);
	}
	public function order() {
		$selarray = explode(',', $_POST['selids']);
		foreach($selarray as $catid) {
			$this -> obj -> where('catid=' . $catid) -> create(array('orderid' => $_POST['orderid'][$catid])) -> update();
		}
		$this -> showMsg(L('OPERATE_SUCCESS'), $_SERVER['HTTP_REFERER']);
	}
	private function checkDir($data) {
		$data['dir'] = trim($data['dir']);
		if (empty($data['dir'])) $data['dir'] = $data['catid'];
		if (!preg_match("/^[a-z0-9-]{1,150}$/i", $data['dir'])) $this -> showMsg(L('DIR_ERROR'));
		if ($this -> obj -> where(array('pid=' . $data['pid'], 'dir=' . $data['dir'], 'catid!=' . $data['catid'])) -> find()) {
			$this -> showMsg(L('DIR_IS_EXIST'));
		}
		return $data;
	}
	// 
	public function __destruct() {
		$this -> obj -> cache();
	}
}
